/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/
#include <QFile>

#include "MenuBar.h"
#include "Util.h"
#include "Projection.h"

//===================================================================================
void ZeroOneActionGroup::addAction(QAction *act)
{
	lsactions.append(act);
	connect(act, SIGNAL(triggered(bool)),
            	this,  SLOT(slot_actionTrigerred(bool)));
}
//------------------------------------------------------------------
void ZeroOneActionGroup::slot_actionTrigerred(bool b)
{
	QAction *act = (QAction *) sender();
	setCheckedAction(act, b);
}	
//------------------------------------------------------------------
void ZeroOneActionGroup::setCheckedAction(QAction *act, bool b)
{
	for (int i=0; i<lsactions.size(); i++) {
		if (lsactions.at(i)== act) {
			lsactions.at(i)->setChecked(b);
		}
		else {
			lsactions.at(i)->setChecked(false);
		}
	}
	if (b)
		emit triggered( act );
	else
		emit triggered( NULL );
}

//===================================================================================
MenuBar::MenuBar(QWidget *parent)
    : QMenuBar(parent)
{
    //-------------------------------------
    // Menu + Actions
    //-------------------------------------
    menuFile = new QMenu(tr("Fichier"));
        acFile_Open = addAction(menuFile,
        			tr("Ouvrir"), tr("Ctrl+O"),
                    tr("Ouvrir un fichier GRIB"), "img/fileopen.png");
        acFile_Close = addAction(menuFile,
        			tr("Fermer"), tr("Ctrl+W"),
                    tr("Fermer"), "img/fileclose.png");
        menuFile->addSeparator();
        acFile_Load_GRIB = addAction(menuFile,
        			tr("Téléchargement GRIB"), tr("Ctrl+D"),
                    tr("Téléchargement"), "img/network.png");
        acFile_GribServerStatus = addAction(menuFile,
        			tr("Statut du serveur GRIB"), tr("Ctrl+R"),
                    tr("Statut du serveur de fichiers GRIB"), "img/connect_no.png");
        
        acFile_Load_IAC = addAction(menuFile,
        	tr("IAC fleetcode NOAA"), tr("Ctrl+L"),
			tr("Téléchargement du fichier IAC fleetcode NOAA courant - Analyse ou prévision +24h - Europe"), "");
        
        menuFile->addSeparator();
        acFile_Info_GRIB = addAction(menuFile,
        			tr("Informations sur le fichier"), tr("Ctrl+I"),
                    tr("Informations sur le fichier GRIB"), "img/info.png");
        menuFile->addSeparator();
        acFile_Quit = addAction(menuFile,
                    tr("Quitter"), tr("Ctrl+Q"),
                    tr("Bye"), "img/exit.png");
    addMenu(menuFile);
    
    //-------------------------------------
    menuGrib = new QMenu(tr("Données GRIB"));

		acView_GroupColorMap = new ZeroOneActionGroup(menuGrib);
			acView_WindColors = addActionCheck(menuGrib, tr("Carte du vent"), "", "");
			acView_RainColors = addActionCheck(menuGrib, tr("Carte des précipitations"),"","");
			acView_CloudColors = addActionCheck(menuGrib, tr("Couverture nuageuse"), "","");
			acView_HumidColors = addActionCheck(menuGrib, tr("Carte de l'humidité relative"),"","");
			acView_TempColors = addActionCheck(menuGrib, tr("Carte de la température"),"","");
			acView_TempPotColors = addActionCheck(menuGrib, tr("Carte de la température potentielle"),"","");
			//acView_DewpointColors = addActionCheck(menuGrib, tr("Carte du point de rosée"),"","");
			acView_DeltaDewpointColors = addActionCheck(menuGrib, tr("Ecart température-point de rosée"), "", "");
			acView_SnowCateg = addActionCheck(menuGrib, tr("Neige (chute possible)"), "", "");
			acView_SnowDepth = addActionCheck(menuGrib, tr("Neige (épaisseur)"), "", "");
			acView_FrzRainCateg = addActionCheck(menuGrib, tr("Pluie verglaçante (chute possible)"), "", "");
			acView_CAPEsfc = addActionCheck(menuGrib, tr("CAPE (surface)"), "", "");
			acView_GroupColorMap->addAction(acView_WindColors);
			acView_GroupColorMap->addAction(acView_RainColors);
			acView_GroupColorMap->addAction(acView_CloudColors);
			acView_GroupColorMap->addAction(acView_HumidColors);
			acView_GroupColorMap->addAction(acView_TempColors);
			acView_GroupColorMap->addAction(acView_TempPotColors);
			//acView_GroupColorMap->addAction(acView_DewpointColors);
			acView_GroupColorMap->addAction(acView_DeltaDewpointColors);
			acView_GroupColorMap->addAction(acView_SnowCateg);
			acView_GroupColorMap->addAction(acView_SnowDepth);
			acView_GroupColorMap->addAction(acView_FrzRainCateg);
			acView_GroupColorMap->addAction(acView_CAPEsfc);

        //-------------------------------- 
        menuGrib->addSeparator();        
        acView_DuplicateFirstCumulativeRecord = addActionCheck(menuGrib,
        			tr("Dupliquer le 1er enregistrement cumulé"), "",
                    "");
        acView_InterpolateValues = addActionCheck(menuGrib,
        			tr("Interpolation numérique des valeurs"), "",
                    "");
                    
        acView_ColorMapSmooth = addActionCheck(menuGrib,
        			tr("Dégradés de couleurs"), tr("Ctrl+F"),
                    "");
        //-------------------------------- 
        menuGrib->addSeparator();
        acView_WindArrow = addActionCheck(menuGrib, tr("Flèches du vent"), "",
                    tr("Afficher les flèches de direction du vent"));
        acView_Barbules = addActionCheck(menuGrib, tr("Barbules"), "",
                    tr("Afficher les barbules sur les flèches de vent"));
        acView_WindArrowsOnGribGrid = addActionCheck(menuGrib,
        			tr("Flèches du vent sur la grille Grib"), "",
                    "");
        //-------------------------------- 
        menuGrib->addSeparator();
        acView_TemperatureLabels = addActionCheck(menuGrib,
        			tr("Température"), tr("Ctrl+T"),
                    "");
        //-------------------------------- 
        menuGrib->addSeparator();
		menuIsobars = new QMenu(tr("Isobares"));
	        acView_Isobars = addActionCheck(menuIsobars, tr("Afficher les isobares"), "",
                            "");
            menuIsobarsStep = new QMenu(tr("Espacement (hPa)"));
            acView_GroupIsobarsStep = new QActionGroup(menuIsobarsStep);
                acView_IsobarsStep1 = addActionCheck(menuIsobarsStep, tr("1"), "", tr("Espacement des isobares"));
                acView_IsobarsStep2 = addActionCheck(menuIsobarsStep, tr("2"), "", tr("Espacement des isobares"));
                acView_IsobarsStep3 = addActionCheck(menuIsobarsStep, tr("3"), "", tr("Espacement des isobares"));
                acView_IsobarsStep4 = addActionCheck(menuIsobarsStep, tr("4"), "", tr("Espacement des isobares"));
                acView_IsobarsStep5 = addActionCheck(menuIsobarsStep, tr("5"), "", tr("Espacement des isobares"));
                acView_IsobarsStep6 = addActionCheck(menuIsobarsStep, tr("6"), "", tr("Espacement des isobares"));
                acView_IsobarsStep8 = addActionCheck(menuIsobarsStep, tr("8"), "", tr("Espacement des isobares"));
                acView_IsobarsStep10 = addActionCheck(menuIsobarsStep, tr("10"), "", tr("Espacement des isobares"));
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep1);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep2);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep3);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep4);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep5);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep6);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep8);
                acView_GroupIsobarsStep->addAction(acView_IsobarsStep10);
            menuIsobars->addMenu(menuIsobarsStep);
        acView_IsobarsLabels = addActionCheck(menuIsobars, tr("Etiquettes des isobares"), "",
                            tr("Afficher les étiquettes des isobares"));
        acView_PressureMinMax = addActionCheck(menuIsobars, tr("Pression Mini(L) Maxi(H)"), "",
                            tr("Afficher les points de pression mini et maxi"));
		menuGrib->addMenu(menuIsobars);
        //--------------------------------
		menuIsotherms0 = new QMenu(tr("Isothermes 0°C"));
        acView_Isotherms0 = addActionCheck(menuIsotherms0, tr("Isothermes 0°C"), "",
                            tr("Afficher les isothermes 0°C"));
            menuIsotherms0Step = new QMenu(tr("Espacement (m)"));
            acView_GroupIsotherms0Step    = new QActionGroup(menuIsotherms0Step);
                acView_Isotherms0Step10   = addActionCheck(menuIsotherms0Step, tr("10"), "", tr("Espacement des isothermes 0°C"));
                acView_Isotherms0Step20   = addActionCheck(menuIsotherms0Step, tr("20"), "", tr("Espacement des isothermes 0°C"));
                acView_Isotherms0Step50   = addActionCheck(menuIsotherms0Step, tr("50"), "", tr("Espacement des isothermes 0°C"));
                acView_Isotherms0Step100  = addActionCheck(menuIsotherms0Step, tr("100"), "", tr("Espacement des isothermes 0°C"));
                acView_Isotherms0Step200  = addActionCheck(menuIsotherms0Step, tr("200"), "", tr("Espacement des isothermes 0°C"));
                acView_Isotherms0Step500  = addActionCheck(menuIsotherms0Step, tr("500"), "", tr("Espacement des isothermes 0°C"));
                acView_Isotherms0Step1000 = addActionCheck(menuIsotherms0Step, tr("1000"), "", tr("Espacement des isothermes 0°C"));
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step10);
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step20);
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step50);
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step100);
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step200);
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step500);
                acView_GroupIsotherms0Step->addAction(acView_Isotherms0Step1000);
            menuIsotherms0->addMenu(menuIsotherms0Step);
        acView_Isotherms0Labels = addActionCheck(menuIsotherms0,
        					tr("Etiquettes des isothermes 0°C"), "",
                            tr("Afficher les étiquettes des isothermes 0°C"));
		menuGrib->addMenu(menuIsotherms0);
        //--------------------------------------------------------------------------
        menuGrib->addSeparator();
        acView_GribGrid = addActionCheck(menuGrib, tr("Afficher la grille GRIB"), "",
                            tr("Montrer les positions des données du fichier GRIB"));
        
        ac_CreateAnimation = addAction(menuGrib,
        			tr("Créer une animation"), tr("Ctrl+A"),
                    tr("Créer une animation avec les données GRIB"), "img/anim.png");
    
    addMenu(menuGrib);
    
    //-------------------------------------
    menuMap = new QMenu(tr("Planisphère"));
		QMenu *menuQuality = new QMenu(tr("Qualité de la carte"));
        acMap_GroupQuality = new QActionGroup(menuQuality);
            acMap_Quality1 = addActionCheck(menuQuality, tr("Résolution 1 (25 km)"), "", tr("Niveau de détail de la carte"));
            acMap_Quality2 = addActionCheck(menuQuality, tr("Résolution 2 (5 km)"), "", tr("Niveau de détail de la carte"));
            acMap_Quality3 = addActionCheck(menuQuality, tr("Résolution 3 (1 km)"), "", tr("Niveau de détail de la carte"));
            acMap_Quality4 = addActionCheck(menuQuality, tr("Résolution 4 (200 m)"), "", tr("Niveau de détail de la carte"));
            acMap_Quality5 = addActionCheck(menuQuality, tr("Résolution 5 (100 m)"), "", tr("Niveau de détail de la carte"));
            acMap_GroupQuality->addAction(acMap_Quality1);
            acMap_GroupQuality->addAction(acMap_Quality2);
            acMap_GroupQuality->addAction(acMap_Quality3);
            acMap_GroupQuality->addAction(acMap_Quality4);
            acMap_GroupQuality->addAction(acMap_Quality5);
		menuMap->addMenu(menuQuality);
        
		QMenu *menuProjection = new QMenu(tr("Projection"));
        acMap_GroupProjection = new QActionGroup(menuProjection);
            acMap_PROJ_ZYGRIB = addActionCheck(menuProjection, tr("ZyGrib"), "", "");
            acMap_PROJ_MERCATOR = addActionCheck(menuProjection, tr("Mercator"), "", "");
            acMap_PROJ_MILLER = addActionCheck(menuProjection, tr("Miller"), "", "");
            acMap_PROJ_CENTRAL_CYL = addActionCheck(menuProjection, tr("Centrale Cylindrique"), "", "");
            acMap_PROJ_EQU_CYL = addActionCheck(menuProjection, tr("Cylindrique Egale"), "", "");
            acMap_GroupProjection->addAction(acMap_PROJ_ZYGRIB);
            acMap_GroupProjection->addAction(acMap_PROJ_MERCATOR);
            acMap_GroupProjection->addAction(acMap_PROJ_MILLER);
            acMap_GroupProjection->addAction(acMap_PROJ_CENTRAL_CYL);
            acMap_GroupProjection->addAction(acMap_PROJ_EQU_CYL);
		menuMap->addMenu(menuProjection);
        
	menuMap->addSeparator();
        acMap_Orthodromie = addActionCheck(menuMap, tr("Distance orthodromique"), "", "");
        acMap_LonLatGrid = addActionCheck(menuMap, tr("Grille longitudes-latitudes"), "", "");
        
     menuMap->addSeparator();
        acMap_CountriesBorders = addActionCheck(menuMap, tr("Frontières"), "", tr("Afficher les frontières"));
        acMap_Rivers = addActionCheck(menuMap, tr("Rivières"), "", tr("Afficher les rivières"));
        acMap_CountriesNames = addActionCheck(menuMap, tr("Noms des pays"), "", tr("Afficher les noms des pays"));
        
        QMenu *menuCitiesNames = new QMenu(tr("Nom des villes"));
        acMap_GroupCitiesNames = new QActionGroup(menuMap);
            acMap_CitiesNames0 = addActionCheck(menuCitiesNames, tr("Aucun"), "", "");
            acMap_CitiesNames1 = addActionCheck(menuCitiesNames, tr("Niveau 1"), "", "");
            acMap_CitiesNames2 = addActionCheck(menuCitiesNames, tr("Niveau 2"), "", "");
            acMap_CitiesNames3 = addActionCheck(menuCitiesNames, tr("Niveau 3"), "", "");
            acMap_CitiesNames4 = addActionCheck(menuCitiesNames, tr("Niveau 4"), "", "");
            acMap_GroupCitiesNames->addAction(acMap_CitiesNames0);
            acMap_GroupCitiesNames->addAction(acMap_CitiesNames1);
            acMap_GroupCitiesNames->addAction(acMap_CitiesNames2);
            acMap_GroupCitiesNames->addAction(acMap_CitiesNames3);
            acMap_GroupCitiesNames->addAction(acMap_CitiesNames4);
            menuMap->addMenu(menuCitiesNames);
        
        acMap_ShowPOIs = addActionCheck(menuMap, tr("Points d'intérêt"), "", tr("Afficher les Points d'intérêt"));
        
        menuMap->addSeparator();
        acMap_Zoom_In = addAction(menuMap,
        				tr("Augmenter l'échelle de la carte"), tr("+"),
                        tr("Augmenter l'échelle de la carte"), "img/viewmag+.png");
        acMap_Zoom_Out = addAction(menuMap,
        				tr("Diminuer l'échelle de la carte"), tr("-"),
                        tr("Diminuer l'échelle de la carte"), "img/viewmag-.png");
        acMap_Zoom_Sel = addAction(menuMap,
                        tr("Zoom (sélection ou fichier Grib)"), tr("Ctrl+Z"),
                        tr("Zoomer sur la zone sélectionnée ou sur la surface du fichier Grib"),
                        "img/viewmagfit.png");
        acMap_Zoom_All = addAction(menuMap,
        				tr("Afficher la carte entière"), tr("Ctrl+M"),
                        tr("Afficher la carte entière"), "img/viewmag1.png");
        menuMap->addSeparator();
        acMap_Go_Left = addAction(menuMap,
        				tr("Vers la gauche"), tr("LEFT"),
                        tr("Déplacement"), "img/back.png");
        acMap_Go_Right = addAction(menuMap,
        				tr("Vers la droite"), tr("RIGHT"),
                        tr("Déplacement"), "img/forward.png");
        acMap_Go_Up   = addAction(menuMap,
        				tr("Vers le haut"), tr("UP"),
                        tr("Déplacement"), "img/up.png");
        acMap_Go_Down = addAction(menuMap,
        				tr("Vers le bas"), tr("DOWN"),
                        tr("Déplacement"), "img/down.png");
    
    addMenu(menuMap);
    
    //-------------------------------------
    menuOptions = new QMenu(tr("Options"));
        acOptions_Proxy = addAction(menuOptions, tr("Proxy Internet"),"","","");
        acOptions_AngleConverter = addAction(menuOptions,
        				tr("Convertisseur d'angles"), "", "","");
        acOptions_Units = addAction(menuOptions,
        				tr("Unités"), tr("Ctrl+U"), "","");
        acOptions_GraphicsParams = addAction(menuOptions,
						tr("Paramètres graphiques"), tr("Ctrl+G"), "","");
        
        QMenu *menuLanguage = new QMenu( ("Language"));
            acOptions_GroupLanguage = new QActionGroup(menuLanguage);
                acOptions_Lang_fr = addActionCheck(menuLanguage, ("French"), "", "");
                acOptions_Lang_en = addActionCheck(menuLanguage, ("English"), "", "");
                acOptions_GroupLanguage->addAction(acOptions_Lang_fr);
                acOptions_GroupLanguage->addAction(acOptions_Lang_en);

                acOptions_Lang_de = NULL;
                if (QFile::exists("tr/zyGrib_de.qm")) {
	                acOptions_Lang_de = addActionCheck(menuLanguage, ("German"), "", "");
                	acOptions_GroupLanguage->addAction(acOptions_Lang_de);
				}
                acOptions_Lang_ru = NULL;
                if (QFile::exists("tr/zyGrib_ru.qm")) {
    	            acOptions_Lang_ru = addActionCheck(menuLanguage, ("Russian"), "", "");
                	acOptions_GroupLanguage->addAction(acOptions_Lang_ru);
				}
                acOptions_Lang_pl = NULL;
                if (QFile::exists("tr/zyGrib_pl.qm")) {
    	            acOptions_Lang_pl = addActionCheck(menuLanguage, ("Polish"), "", "");
                	acOptions_GroupLanguage->addAction(acOptions_Lang_pl);
				}
                acOptions_Lang_pt = NULL;
                if (QFile::exists("tr/zyGrib_pt.qm")) {
    	            acOptions_Lang_pt = addActionCheck(menuLanguage, ("Portuguese"), "", "");
                	acOptions_GroupLanguage->addAction(acOptions_Lang_pt);
				}
                acOptions_Lang_es = NULL;
                if (QFile::exists("tr/zyGrib_es.qm")) {
    	            acOptions_Lang_es = addActionCheck(menuLanguage, ("Spanish"), "", "");
                	acOptions_GroupLanguage->addAction(acOptions_Lang_es);
				}
                acOptions_Lang_it = NULL;
                if (QFile::exists("tr/zyGrib_it.qm")) {
    	            acOptions_Lang_it = addActionCheck(menuLanguage, ("Italian"), "", "");
                	acOptions_GroupLanguage->addAction(acOptions_Lang_it);
				}
        menuOptions->addMenu(menuLanguage);
    
    addMenu(menuOptions);
    
    //-------------------------------------
    menuHelp = new QMenu(tr("Aide"));
        acHelp_Help = addAction(menuHelp,
        				tr("Aide"), tr("Ctrl+H"),
        				"","img/help.png");
        acHelp_APropos = addAction(menuHelp, tr("A propos de zyGrib"),"","","");
        acHelp_AProposQT = addAction(menuHelp, tr("A propos de QT"),"","","");
    addMenu(menuHelp);
    
    //-------------------------------------
    // Autres objets de l'interface
    //-------------------------------------
    acDatesGrib_prev = addAction( NULL,
            tr("Prévision précédente [page préc]"),tr("PgUp"),"","img/1leftarrow.png");
    acDatesGrib_next = addAction( NULL,
            tr("Prévision suivante [page suiv]"),tr("PgDown"),"","img/1rightarrow.png");
    
    cbDatesGrib = new QComboBox();
    cbDatesGrib->setSizeAdjustPolicy(QComboBox::AdjustToContents);
    
    QFontInfo finfo = cbDatesGrib->fontInfo();
    QFont font("", finfo.pointSize(), QFont::Normal, false);
    font.setStyleHint(QFont::TypeWriter);
    font.setStretch(QFont::SemiCondensed);
    cbDatesGrib->setFont(font);
}



//---------------------------------------------------------
// Menu popup : bouton droit de la souris
//---------------------------------------------------------
QMenu * MenuBar::createPopupBtRight(QWidget *parent)
{
	QMenu *popup = new QMenu(parent);
	
	ac_OpenMeteotable = addAction(popup, tr("Météotable"),"","","");
	ac_CreatePOI = addAction(popup, tr("Marquer un Point d'Intérêt"),"","","");

	return popup;
}

//===================================================================================
QAction* MenuBar::addAction(QWidget *menu,
                    QString title, QString shortcut, QString statustip,
                    QString iconFileName)
{
    QAction *action;
    action = new QAction(title, menu);
    action->setShortcut  (shortcut);
    action->setShortcutContext (Qt::ApplicationShortcut);
    action->setStatusTip (statustip);
    if (iconFileName != "")
        action->setIcon(QIcon(iconFileName));
    if (menu != NULL)
        menu->addAction(action);
    return action;
}
//-------------------------------------------------
QAction* MenuBar::addActionCheck(QWidget *menu,
                    QString title, QString shortcut, QString statustip,
                    QString iconFileName)
{
    QAction *action;
    action = addAction(menu, title, shortcut, statustip, iconFileName);
    action->setCheckable  (true);
    return action;
}

//-------------------------------------------------
void MenuBar::setProjection(int idproj)
{
	switch (idproj)
	{
        case Projection::PROJ_MERCATOR :
    		acMap_PROJ_MERCATOR->setChecked(true);  break;
        case Projection::PROJ_MILLER :
    		acMap_PROJ_MILLER->setChecked(true);    break;
        case Projection::PROJ_CENTRAL_CYL :
    		acMap_PROJ_CENTRAL_CYL->setChecked(true); break;
        case Projection::PROJ_EQU_CYL :
    		acMap_PROJ_EQU_CYL->setChecked(true);   break;
        case Projection::PROJ_ZYGRIB :
		    acMap_PROJ_ZYGRIB->setChecked(true);    break;
	}
}

//-------------------------------------------------
void MenuBar::setQuality(int q) {
    switch (q) {
        case 0: acMap_Quality1->setChecked(true); break;
        case 1: acMap_Quality2->setChecked(true); break;
        case 2: acMap_Quality3->setChecked(true); break;
        case 3: acMap_Quality4->setChecked(true); break;
        case 4: acMap_Quality5->setChecked(true); break;
    }
}
//-------------------------------------------------
void MenuBar::setIsobarsStep(int step) {
    switch (step) {
        case 1: acView_IsobarsStep1->setChecked(true); break;
        case 2: acView_IsobarsStep2->setChecked(true); break;
        case 3: acView_IsobarsStep3->setChecked(true); break;
        case 4: acView_IsobarsStep4->setChecked(true); break;
        case 5: acView_IsobarsStep5->setChecked(true); break;
        case 6: acView_IsobarsStep6->setChecked(true); break;
        case 8: acView_IsobarsStep8->setChecked(true); break;
        case 10: acView_IsobarsStep10->setChecked(true); break;
    }
}
//-------------------------------------------------
void MenuBar::setIsotherms0Step(int step) {
    switch (step) {
        case 10: acView_Isotherms0Step10->setChecked(true); break;
        case 20: acView_Isotherms0Step20->setChecked(true); break;
        case 50: acView_Isotherms0Step50->setChecked(true); break;
        case 100: acView_Isotherms0Step100->setChecked(true); break;
        case 200: acView_Isotherms0Step200->setChecked(true); break;
        case 500: acView_Isotherms0Step500->setChecked(true); break;
        case 1000: acView_Isotherms0Step1000->setChecked(true); break;
    }
}
//-------------------------------------------------
void MenuBar::setCitiesNamesLevel(int level) {
    switch (level) {
        case 0: acMap_CitiesNames0->setChecked(true); break;
        case 1: acMap_CitiesNames1->setChecked(true); break;
        case 2: acMap_CitiesNames2->setChecked(true); break;
        case 3: acMap_CitiesNames3->setChecked(true); break;
        case 4: acMap_CitiesNames4->setChecked(true); break;
    }
}

//------------------------------------------------------------
// Génère la liste des dates des Records du fichier GRIB
void MenuBar::updateListeDates(std::set<time_t> *setDates, time_t currentDate)
{
    listGribDates.clear();
    // Construit un vector à partir du set (plus pratique)
    std::set<time_t>::iterator its;
    for (its=setDates->begin(); its!=setDates->end(); its++) {
        listGribDates.push_back(*its);
    }

    // Met à jour les item du QComboBox
    while (cbDatesGrib->count() > 0) {
        cbDatesGrib->removeItem(0);
    }
    std::vector<time_t>::iterator it;
    for (it=listGribDates.begin(); it!=listGribDates.end(); it++) {
        time_t tps = *it;
        QString str = Util::formatDateTimeLong(tps);
        //printf("%s\n", qPrintable(str));
        cbDatesGrib->addItem(str);
    }
    // Positionne sur la date courante
	QString strCurrentDate = Util::formatDateTimeLong(currentDate);
    cbDatesGrib->setCurrentIndex(cbDatesGrib->findText(strCurrentDate));
}
//------------------------------------------------------------
time_t  MenuBar::getDateGribById(int id)
{
    if (listGribDates.size() > (uint)id)
        return listGribDates[id];
    else
        return (time_t)0;
}









