/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#include <QMessageBox>
#include <cmath>
#include <cassert>

#include <QPainter>
#include <QColorDialog>
#include <QFontDialog>

#include "DialogGraphicsParams.h"
#include "Util.h"

//===========================================================================
// DialogGraphicsParams
//===========================================================================
DialogGraphicsParams::DialogGraphicsParams()
		 : QDialog()
{
	setupUi(this);
	initInterface();
    
    connect(btCancel, SIGNAL(clicked()), this, SLOT(slotBtCancel()));
    connect(btOK, SIGNAL(clicked()), this, SLOT(slotBtOK()));
}

//-------------------------------------------------------------------------------
void DialogGraphicsParams::slotBtOK()
{
	Util::setSetting("seaColor", inputSeaColor->getColor());
	Util::setSetting("landColor", inputLandColor->getColor());
	Util::setSetting("backgroundColor", inputBgColor->getColor());
	
	Util::setSetting("seaBordersLineWidth", inputSeaBordersLine->getLineWidth());
	Util::setSetting("seaBordersLineColor", inputSeaBordersLine->getLineColor());
	Util::setSetting("boundariesLineWidth", inputBoundariesLine->getLineWidth());
	Util::setSetting("boundariesLineColor", inputBoundariesLine->getLineColor());
	Util::setSetting("riversLineWidth",   inputRiversLine->getLineWidth());
	Util::setSetting("riversLineColor",   inputRiversLine->getLineColor());
	Util::setSetting("isobarsLineWidth",  inputIsobarsLine->getLineWidth());
	Util::setSetting("isobarsLineColor",  inputIsobarsLine->getLineColor());
	Util::setSetting("isotherms0LineWidth",  inputIsotherms0Line->getLineWidth());
	Util::setSetting("isotherms0LineColor",  inputIsotherms0Line->getLineColor());
	
	Util::setSetting("cloudsColorMode", inputCloudsColorMode->itemData(inputCloudsColorMode->currentIndex()).toString());
    
    accept();
}
//-------------------------------------------------------------------------------
void DialogGraphicsParams::slotBtCancel()
{
    reject();
}

//=============================================================================
// GUI
//=============================================================================
void DialogGraphicsParams::initInterface()
{
	inputBgColor->setColor(Util::getSetting("backgroundColor", QColor(0,0,45)).value<QColor>());
	inputBgColor->setDefaultColor(QColor(0,0,45));

	inputSeaColor->setColor(Util::getSetting("seaColor", QColor(50,50,150)).value<QColor>());
	inputSeaColor->setDefaultColor(QColor(50,50,150));
	
	inputLandColor->setColor(Util::getSetting("landColor", QColor(200,200,120)).value<QColor>());
	inputLandColor->setDefaultColor(QColor(200,200,120));
	
	inputSeaBordersLine->setValues (
				Util::getSetting("seaBordersLineWidth", 1.8).toDouble(),
				Util::getSetting("seaBordersLineColor", QColor(40,45,30)).value<QColor>(),
				1.6,  QColor(40,45,30) );
	inputBoundariesLine->setValues (
				Util::getSetting("boundariesLineWidth", 1.4).toDouble(),
				Util::getSetting("boundariesLineColor", QColor(40,40,40)).value<QColor>(),
				1.4,  QColor(40,40,40) );
	inputRiversLine->setValues (
				Util::getSetting("riversLineWidth", 1.0).toDouble(),
				Util::getSetting("riversLineColor", QColor(50,50,150)).value<QColor>(),
				1.0,  QColor(50,50,150) );
	inputIsobarsLine->setValues (
				Util::getSetting("isobarsLineWidth", 2.0).toDouble(),
				Util::getSetting("isobarsLineColor", QColor(80,80,80)).value<QColor>(),
				2.0,  QColor(80,80,80) );
	inputIsotherms0Line->setValues (
				Util::getSetting("isotherms0LineWidth", 1.6).toDouble(),
				Util::getSetting("isotherms0LineColor", QColor(200,120,100)).value<QColor>(),
				1.6,  QColor(200,120,100) );

	inputCloudsColorMode->addItem (tr("100 % -> blanc"), "white");
	inputCloudsColorMode->addItem (tr("100 % -> foncé"), "black");
	inputCloudsColorMode->setCurrentIndex (
			inputCloudsColorMode->findData (
					Util::getSetting("cloudsColorMode", "white").toString() ));
}











