// **********************************************************************
//
// Copyright (c) 2003-2011 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

#ifndef OBSERVERS_H
#define OBSERVERS_H

#include <Ice/Ice.h>
#include <IceUtil/IceUtil.h>
#include <IceStorm/Election.h>
#include <IceStorm/Replica.h>

namespace IceStorm
{
class Instance;
typedef IceUtil::Handle<Instance> InstancePtr;
class TraceLevels;
typedef IceUtil::Handle<TraceLevels> TraceLevelsPtr;
}

namespace IceStormElection
{

class AMICall : virtual public IceUtil::Shared,
                virtual public IceUtil::Monitor<IceUtil::Mutex>
{
public:

    AMICall();

    void response();
    void exception(const IceUtil::Exception& e);
    void waitResponse();

private:
    bool _response;
    std::auto_ptr<IceUtil::Exception> _ex;
};
typedef IceUtil::Handle<AMICall> AMICallPtr;

class Observers : public IceUtil::Shared, public IceUtil::Mutex
{
public:
    Observers(const IceStorm::InstancePtr&);

    void setMajority(unsigned int);

    // Check that we have enough nodes for replication.
    bool check();
    void clear();

    void init(const std::set<IceStormElection::GroupNodeInfo>&, const LogUpdate&, const TopicContentSeq&);
    void createTopic(const LogUpdate&, const std::string&);
    void destroyTopic(const LogUpdate&, const std::string&);
    void addSubscriber(const LogUpdate&, const std::string&, const IceStorm::SubscriberRecord&);
    void removeSubscriber(const LogUpdate&, const std::string&, const Ice::IdentitySeq&);
    void getReapedSlaves(std::vector<int>&);

private:

    void wait(const std::string&);

    const IceStorm::TraceLevelsPtr _traceLevels;
    unsigned int _majority;
    struct ObserverInfo
    {
        ObserverInfo(int i, const ReplicaObserverPrx& o) :
            id(i), observer(o) {}
        int id;
        ReplicaObserverPrx observer;
        AMICallPtr call;
    };
    std::vector<ObserverInfo> _observers;
    IceUtil::Mutex _reapedMutex;
    std::vector<int> _reaped;
};
typedef IceUtil::Handle<Observers> ObserversPtr;

}

#endif // OBSERVERS_H
