/*
 * Copyright (c) 2001-2008 XORP, Inc.
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/mld6igmp_base.cc,v 1.37 2008/07/23 05:12:05 pavlin Exp $"


#include "mld6igmp_base.hh"


XrlMld6igmpTargetBase::XrlMld6igmpTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlMld6igmpTargetBase::~XrlMld6igmpTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlMld6igmpTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_cli_processor_0_1_process_command(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "cli_processor/0.1/process_command");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string ret_processor_name;
    string ret_cli_term_name;
    uint32_t ret_cli_session_id;
    string ret_command_output;
    try {
	XrlCmdError e = cli_processor_0_1_process_command(
	    xa_inputs.get_string("processor_name"),
	    xa_inputs.get_string("cli_term_name"),
	    xa_inputs.get_uint32("cli_session_id"),
	    xa_inputs.get_string("command_name"),
	    xa_inputs.get_string("command_args"),
	    ret_processor_name,
	    ret_cli_term_name,
	    ret_cli_session_id,
	    ret_command_output);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "cli_processor/0.1/process_command", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ret_processor_name", ret_processor_name);
	pxa_outputs->add("ret_cli_term_name", ret_cli_term_name);
	pxa_outputs->add("ret_cli_session_id", ret_cli_session_id);
	pxa_outputs->add("ret_command_output", ret_command_output);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_raw_packet4_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 10) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(10), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_client_0_1_recv(
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_ipv4("src_address"),
	    xa_inputs.get_ipv4("dst_address"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_int32("ip_ttl"),
	    xa_inputs.get_int32("ip_tos"),
	    xa_inputs.get_bool("ip_router_alert"),
	    xa_inputs.get_bool("ip_internet_control"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_raw_packet6_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 12) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(12), XORP_UINT_CAST(xa_inputs.size()), "raw_packet6_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet6_client_0_1_recv(
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_ipv6("src_address"),
	    xa_inputs.get_ipv6("dst_address"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_int32("ip_ttl"),
	    xa_inputs.get_int32("ip_tos"),
	    xa_inputs.get_bool("ip_router_alert"),
	    xa_inputs.get_bool("ip_internet_control"),
	    xa_inputs.get_list("ext_headers_type"),
	    xa_inputs.get_list("ext_headers_payload"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet6_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/enable_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_enable_vif(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/enable_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/start_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_start_vif(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/start_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/stop_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_stop_vif(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/stop_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/enable_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_enable_all_vifs(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/enable_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/start_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_start_all_vifs();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/start_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/stop_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_stop_all_vifs();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/stop_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_mld6igmp(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/enable_mld6igmp");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_enable_mld6igmp(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/enable_mld6igmp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_mld6igmp(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/start_mld6igmp");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_start_mld6igmp();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/start_mld6igmp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_mld6igmp(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/stop_mld6igmp");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_stop_mld6igmp();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/stop_mld6igmp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/enable_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_enable_cli(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/enable_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/start_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_start_cli();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/start_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/stop_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_stop_cli();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/stop_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_proto_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/get_vif_proto_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t proto_version;
    try {
	XrlCmdError e = mld6igmp_0_1_get_vif_proto_version(
	    xa_inputs.get_string("vif_name"),
	    proto_version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/get_vif_proto_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("proto_version", proto_version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_proto_version(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/set_vif_proto_version");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_set_vif_proto_version(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("proto_version"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/set_vif_proto_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_proto_version(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/reset_vif_proto_version");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_reset_vif_proto_version(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/reset_vif_proto_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_ip_router_alert_option_check(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/get_vif_ip_router_alert_option_check");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = mld6igmp_0_1_get_vif_ip_router_alert_option_check(
	    xa_inputs.get_string("vif_name"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/get_vif_ip_router_alert_option_check", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_ip_router_alert_option_check(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/set_vif_ip_router_alert_option_check");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_set_vif_ip_router_alert_option_check(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/set_vif_ip_router_alert_option_check", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_ip_router_alert_option_check(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/reset_vif_ip_router_alert_option_check");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_reset_vif_ip_router_alert_option_check(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/reset_vif_ip_router_alert_option_check", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_query_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/get_vif_query_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_sec;
    uint32_t interval_usec;
    try {
	XrlCmdError e = mld6igmp_0_1_get_vif_query_interval(
	    xa_inputs.get_string("vif_name"),
	    interval_sec,
	    interval_usec);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/get_vif_query_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_sec", interval_sec);
	pxa_outputs->add("interval_usec", interval_usec);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_query_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/set_vif_query_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_set_vif_query_interval(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("interval_sec"),
	    xa_inputs.get_uint32("interval_usec"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/set_vif_query_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_query_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/reset_vif_query_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_reset_vif_query_interval(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/reset_vif_query_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_query_last_member_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/get_vif_query_last_member_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_sec;
    uint32_t interval_usec;
    try {
	XrlCmdError e = mld6igmp_0_1_get_vif_query_last_member_interval(
	    xa_inputs.get_string("vif_name"),
	    interval_sec,
	    interval_usec);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/get_vif_query_last_member_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_sec", interval_sec);
	pxa_outputs->add("interval_usec", interval_usec);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_query_last_member_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/set_vif_query_last_member_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_set_vif_query_last_member_interval(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("interval_sec"),
	    xa_inputs.get_uint32("interval_usec"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/set_vif_query_last_member_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_query_last_member_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/reset_vif_query_last_member_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_reset_vif_query_last_member_interval(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/reset_vif_query_last_member_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_query_response_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/get_vif_query_response_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_sec;
    uint32_t interval_usec;
    try {
	XrlCmdError e = mld6igmp_0_1_get_vif_query_response_interval(
	    xa_inputs.get_string("vif_name"),
	    interval_sec,
	    interval_usec);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/get_vif_query_response_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_sec", interval_sec);
	pxa_outputs->add("interval_usec", interval_usec);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_query_response_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/set_vif_query_response_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_set_vif_query_response_interval(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("interval_sec"),
	    xa_inputs.get_uint32("interval_usec"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/set_vif_query_response_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_query_response_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/reset_vif_query_response_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_reset_vif_query_response_interval(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/reset_vif_query_response_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_robust_count(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/get_vif_robust_count");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t robust_count;
    try {
	XrlCmdError e = mld6igmp_0_1_get_vif_robust_count(
	    xa_inputs.get_string("vif_name"),
	    robust_count);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/get_vif_robust_count", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("robust_count", robust_count);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_robust_count(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/set_vif_robust_count");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_set_vif_robust_count(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("robust_count"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/set_vif_robust_count", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_robust_count(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/reset_vif_robust_count");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_reset_vif_robust_count(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/reset_vif_robust_count", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_log_trace_all(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/log_trace_all");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_log_trace_all(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/log_trace_all", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_add_protocol4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/add_protocol4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_add_protocol4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("protocol_name"),
	    xa_inputs.get_uint32("protocol_id"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("vif_index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/add_protocol4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_add_protocol6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/add_protocol6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_add_protocol6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("protocol_name"),
	    xa_inputs.get_uint32("protocol_id"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("vif_index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/add_protocol6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_delete_protocol4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/delete_protocol4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_delete_protocol4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("protocol_name"),
	    xa_inputs.get_uint32("protocol_id"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("vif_index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/delete_protocol4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMld6igmpTargetBase::handle_mld6igmp_0_1_delete_protocol6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "mld6igmp/0.1/delete_protocol6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mld6igmp_0_1_delete_protocol6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("protocol_name"),
	    xa_inputs.get_uint32("protocol_id"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("vif_index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mld6igmp/0.1/delete_protocol6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

void
XrlMld6igmpTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlMld6igmpTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlMld6igmpTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlMld6igmpTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlMld6igmpTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("cli_processor/0.1/process_command",
	    callback(this, &XrlMld6igmpTargetBase::handle_cli_processor_0_1_process_command)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "cli_processor/0.1/process_command");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlMld6igmpTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlMld6igmpTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("raw_packet4_client/0.1/recv",
	    callback(this, &XrlMld6igmpTargetBase::handle_raw_packet4_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "raw_packet4_client/0.1/recv");
	}
	if (_cmds->add_handler("raw_packet6_client/0.1/recv",
	    callback(this, &XrlMld6igmpTargetBase::handle_raw_packet6_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "raw_packet6_client/0.1/recv");
	}
	if (_cmds->add_handler("mld6igmp/0.1/enable_vif",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/enable_vif");
	}
	if (_cmds->add_handler("mld6igmp/0.1/start_vif",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/start_vif");
	}
	if (_cmds->add_handler("mld6igmp/0.1/stop_vif",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/stop_vif");
	}
	if (_cmds->add_handler("mld6igmp/0.1/enable_all_vifs",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/enable_all_vifs");
	}
	if (_cmds->add_handler("mld6igmp/0.1/start_all_vifs",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/start_all_vifs");
	}
	if (_cmds->add_handler("mld6igmp/0.1/stop_all_vifs",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/stop_all_vifs");
	}
	if (_cmds->add_handler("mld6igmp/0.1/enable_mld6igmp",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_mld6igmp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/enable_mld6igmp");
	}
	if (_cmds->add_handler("mld6igmp/0.1/start_mld6igmp",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_mld6igmp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/start_mld6igmp");
	}
	if (_cmds->add_handler("mld6igmp/0.1/stop_mld6igmp",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_mld6igmp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/stop_mld6igmp");
	}
	if (_cmds->add_handler("mld6igmp/0.1/enable_cli",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_enable_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/enable_cli");
	}
	if (_cmds->add_handler("mld6igmp/0.1/start_cli",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_start_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/start_cli");
	}
	if (_cmds->add_handler("mld6igmp/0.1/stop_cli",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_stop_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/stop_cli");
	}
	if (_cmds->add_handler("mld6igmp/0.1/get_vif_proto_version",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_proto_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/get_vif_proto_version");
	}
	if (_cmds->add_handler("mld6igmp/0.1/set_vif_proto_version",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_proto_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/set_vif_proto_version");
	}
	if (_cmds->add_handler("mld6igmp/0.1/reset_vif_proto_version",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_proto_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/reset_vif_proto_version");
	}
	if (_cmds->add_handler("mld6igmp/0.1/get_vif_ip_router_alert_option_check",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_ip_router_alert_option_check)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/get_vif_ip_router_alert_option_check");
	}
	if (_cmds->add_handler("mld6igmp/0.1/set_vif_ip_router_alert_option_check",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_ip_router_alert_option_check)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/set_vif_ip_router_alert_option_check");
	}
	if (_cmds->add_handler("mld6igmp/0.1/reset_vif_ip_router_alert_option_check",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_ip_router_alert_option_check)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/reset_vif_ip_router_alert_option_check");
	}
	if (_cmds->add_handler("mld6igmp/0.1/get_vif_query_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_query_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/get_vif_query_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/set_vif_query_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_query_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/set_vif_query_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/reset_vif_query_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_query_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/reset_vif_query_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/get_vif_query_last_member_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_query_last_member_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/get_vif_query_last_member_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/set_vif_query_last_member_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_query_last_member_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/set_vif_query_last_member_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/reset_vif_query_last_member_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_query_last_member_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/reset_vif_query_last_member_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/get_vif_query_response_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_query_response_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/get_vif_query_response_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/set_vif_query_response_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_query_response_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/set_vif_query_response_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/reset_vif_query_response_interval",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_query_response_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/reset_vif_query_response_interval");
	}
	if (_cmds->add_handler("mld6igmp/0.1/get_vif_robust_count",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_get_vif_robust_count)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/get_vif_robust_count");
	}
	if (_cmds->add_handler("mld6igmp/0.1/set_vif_robust_count",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_set_vif_robust_count)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/set_vif_robust_count");
	}
	if (_cmds->add_handler("mld6igmp/0.1/reset_vif_robust_count",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_reset_vif_robust_count)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/reset_vif_robust_count");
	}
	if (_cmds->add_handler("mld6igmp/0.1/log_trace_all",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_log_trace_all)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/log_trace_all");
	}
	if (_cmds->add_handler("mld6igmp/0.1/add_protocol4",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_add_protocol4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/add_protocol4");
	}
	if (_cmds->add_handler("mld6igmp/0.1/add_protocol6",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_add_protocol6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/add_protocol6");
	}
	if (_cmds->add_handler("mld6igmp/0.1/delete_protocol4",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_delete_protocol4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/delete_protocol4");
	}
	if (_cmds->add_handler("mld6igmp/0.1/delete_protocol6",
	    callback(this, &XrlMld6igmpTargetBase::handle_mld6igmp_0_1_delete_protocol6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mld6igmp", "mld6igmp/0.1/delete_protocol6");
	}
	_cmds->finalize();
}

void
XrlMld6igmpTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("cli_processor/0.1/process_command");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("raw_packet4_client/0.1/recv");
	_cmds->remove_handler("raw_packet6_client/0.1/recv");
	_cmds->remove_handler("mld6igmp/0.1/enable_vif");
	_cmds->remove_handler("mld6igmp/0.1/start_vif");
	_cmds->remove_handler("mld6igmp/0.1/stop_vif");
	_cmds->remove_handler("mld6igmp/0.1/enable_all_vifs");
	_cmds->remove_handler("mld6igmp/0.1/start_all_vifs");
	_cmds->remove_handler("mld6igmp/0.1/stop_all_vifs");
	_cmds->remove_handler("mld6igmp/0.1/enable_mld6igmp");
	_cmds->remove_handler("mld6igmp/0.1/start_mld6igmp");
	_cmds->remove_handler("mld6igmp/0.1/stop_mld6igmp");
	_cmds->remove_handler("mld6igmp/0.1/enable_cli");
	_cmds->remove_handler("mld6igmp/0.1/start_cli");
	_cmds->remove_handler("mld6igmp/0.1/stop_cli");
	_cmds->remove_handler("mld6igmp/0.1/get_vif_proto_version");
	_cmds->remove_handler("mld6igmp/0.1/set_vif_proto_version");
	_cmds->remove_handler("mld6igmp/0.1/reset_vif_proto_version");
	_cmds->remove_handler("mld6igmp/0.1/get_vif_ip_router_alert_option_check");
	_cmds->remove_handler("mld6igmp/0.1/set_vif_ip_router_alert_option_check");
	_cmds->remove_handler("mld6igmp/0.1/reset_vif_ip_router_alert_option_check");
	_cmds->remove_handler("mld6igmp/0.1/get_vif_query_interval");
	_cmds->remove_handler("mld6igmp/0.1/set_vif_query_interval");
	_cmds->remove_handler("mld6igmp/0.1/reset_vif_query_interval");
	_cmds->remove_handler("mld6igmp/0.1/get_vif_query_last_member_interval");
	_cmds->remove_handler("mld6igmp/0.1/set_vif_query_last_member_interval");
	_cmds->remove_handler("mld6igmp/0.1/reset_vif_query_last_member_interval");
	_cmds->remove_handler("mld6igmp/0.1/get_vif_query_response_interval");
	_cmds->remove_handler("mld6igmp/0.1/set_vif_query_response_interval");
	_cmds->remove_handler("mld6igmp/0.1/reset_vif_query_response_interval");
	_cmds->remove_handler("mld6igmp/0.1/get_vif_robust_count");
	_cmds->remove_handler("mld6igmp/0.1/set_vif_robust_count");
	_cmds->remove_handler("mld6igmp/0.1/reset_vif_robust_count");
	_cmds->remove_handler("mld6igmp/0.1/log_trace_all");
	_cmds->remove_handler("mld6igmp/0.1/add_protocol4");
	_cmds->remove_handler("mld6igmp/0.1/add_protocol6");
	_cmds->remove_handler("mld6igmp/0.1/delete_protocol4");
	_cmds->remove_handler("mld6igmp/0.1/delete_protocol6");
}
