/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	__XFPRINT_SHEETS_PAGE_H__
#define	__XFPRINT_SHEETS_PAGE_H__

#include <gtk/gtk.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C"
{
#endif                          /* !__cplusplus */

#define SHEETS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_CAST(obj, sheets_page_get_type(), SheetsPage)
#define SHEETS_PAGE_CLASS(klass)					\
	G_TYPE_CHECK_CLASS_CAST(klass, sheets_page_get_type(), SheetsPage)
#define SHEETS_IS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, sheets_page_get_type())

  typedef struct _SheetsPage SheetsPage;
  typedef struct _SheetsPageClass SheetsPageClass;

  struct _SheetsPage
  {
    GtkTable table;

    GtkWidget *landscape;
    GtkWidget *portrait;
    GtkWidget *fillcols;
    GtkWidget *fillrows;
    GtkWidget *cols;
    GtkWidget *rows;
    GtkWidget *papersize;
    GtkWidget *borders;
    GtkWidget *reverse;
  };

  struct _SheetsPageClass
  {
    GtkTableClass parent_class;
  };

  extern GtkType sheets_page_get_type (void);
  extern GtkWidget *sheets_page_new (void);
  extern void sheets_page_set_settings (SheetsPage *, const XfprintSettingsSheets *);
  extern void sheets_page_get_settings (SheetsPage *, XfprintSettingsSheets *);

#ifdef	__cplusplus
}
#endif                          /* !__cplusplus */

#endif                          /* !__XFPRINT_SHEETS_PAGE_H__ */
