/*
 *  ghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_CONTEXT_H__
#define __GHAL_CONTEXT_H__

#if !defined(GHAL_IN_GHAL_H) && !defined(GHAL_COMPILATION)
#error "Do not include ghal-context.h directly.  Instead use <ghal/ghal.h>"
#endif

#include <dbus/dbus-glib.h>
#include <ghal/ghal-device.h>

#define GHAL_TYPE_CONTEXT     (ghal_context_get_type())
#define GHAL_CONTEXT(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), GHAL_TYPE_CONTEXT, GHalContext))
#define GHAL_IS_CONTEXT(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GHAL_TYPE_CONTEXT))

G_BEGIN_DECLS

typedef struct _GHalContext           GHalContext;
typedef struct _GHalContextClass      GHalContextClass;
typedef struct _GHalContextPrivate    GHalContextPrivate;

struct _GHalContext
{
    GObject parent;
    
    /*< private >*/
    GHalContextPrivate *priv;
};

struct _GHalContextClass
{
    GObjectClass parent;
    
    /*< signals >*/    
    void (*device_added)(GHalContext *context,
                         GHalDevice *device);
    void (*device_removed)(GHalContext *context,
                           GHalDevice *device);
};

GType ghal_context_get_type() G_GNUC_CONST;

GHalContext *ghal_context_get(DBusGConnection *dbus_connection,
                              GError **error);

GHalDevice *ghal_context_get_device_for_udi(GHalContext *context,
                                            const gchar *udi);

GList *ghal_context_get_all_devices(GHalContext *context,
                                    GError **error);

gboolean ghal_context_device_exists(GHalContext *context,
                                    const gchar *udi,
                                    GError **error);

GList *ghal_context_find_device_by_capability(GHalContext *context,
                                              const gchar *capability,
                                              GError **error);

G_END_DECLS

#endif  /* __GHAL_CONTEXT_H__ */
