/*
 * radio plugin for Xfce4.
 *
 * Copyright 2006-2009 Stefan Ott, All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFCE4_RADIO_H
#define _XFCE4_RADIO_H

#include <gtk/gtk.h>
#include <glib.h>
#include <fcntl.h>

#include <sys/ioctl.h>
#include <linux/videodev.h>

#include <libxfce4panel/xfce-panel-plugin.h>

#define FREQ_MIN		8750
#define FREQ_MAX		10800
#define FREQ_INIT		10795
#define FREQ_STEP		10

#define MAX_LABEL_LENGTH	7
#define MAX_DEVICE_NAME_LENGTH	32
#define MAX_COMMAND_LENGTH	512

#define COLOR_SIGNAL_LOW	"#ff0000"
#define COLOR_SIGNAL_MED	"#ffff00"
#define COLOR_SIGNAL_HIGH	"#00ff00"

#define BORDER 8

#define DEFAULT_NAME "unnamed"
#define PRESET_NAMES "preset_names"
#define PRESET_FREQS "preset_freqs"

const char RADIO_CONFIG[] = "xfce4/panel/radio.rc";

typedef enum {
	CHANGE_FREQ,
	CHANGE_PRESET
} mouse_scroll_reaction;

struct radio_preset_st {
	int			freq;
	gchar			*name;
	struct radio_preset_st*	next;
};

typedef struct radio_preset_st radio_preset;

typedef struct {
	GtkWidget*		outer_box;
	GtkWidget*		box;
	GtkWidget*		ebox;
	GtkWidget*		label;
	GtkWidget*		signal_bar;
	GtkWidget*		signal_image;
	GtkTooltips*		tooltips;
	gint			orientation;

	gint			signal_timeout_id;
	gint			radio_timeout_id;

	gboolean		on;
	gboolean		show_label;
	gboolean		show_signal;
	gboolean		show_label_when_off;
	gboolean		resolve_presets_in_label;
	gboolean		show_signal_graphical;
	gboolean		auto_update_display;
	gint			freq;
	char			device [MAX_DEVICE_NAME_LENGTH];
	char			startup_command [MAX_COMMAND_LENGTH];
	char			shutdown_command [MAX_COMMAND_LENGTH];
	GtkListStore*		presets;
	mouse_scroll_reaction	scroll;

	// this seems to be card specific and we can't seem to get the maximum
	// possible value for a given card from v4l
	double			max_signal_strength;

	XfcePanelPlugin		*plugin;
} radio_gui;

static void read_config (XfcePanelPlugin *, radio_gui *);
static void write_config (radio_gui *i, gboolean);
#endif
