/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class VectorField
extends Drawable
implements Computable {
    public static final int ARROWS = 0;
    public static final int LINES = 1;
    public static final int CLAMPED_VECTORS = 2;
    public static final int SCALED_LINES = 3;
    public static final int SCALED_VECTORS = 4;
    private int style;
    private Function xFunc;
    private Function yFunc;
    private Color graphColor = Color.lightGray;
    private boolean changed;
    private transient int[][] data;
    private int pixelSpacing = 30;

    public VectorField() {
        this(null, null, 0);
    }

    public VectorField(Function function, Function function2) {
        this(function, function2, 0);
    }

    public VectorField(Function function, Function function2, int n) {
        if (function != null && function.getArity() != 2 || function2 != null && function2.getArity() != 2) {
            throw new IllegalArgumentException("Internal Error:  The functions that define a vector must be functions of two variables.");
        }
        this.xFunc = function;
        this.yFunc = function2;
        this.style = n;
        this.changed = true;
    }

    public void setColor(Color color) {
        if (color != null & (color.equals(this.graphColor) ^ true)) {
            this.graphColor = color;
            this.needsRedraw();
        }
    }

    public Color getColor() {
        return this.graphColor;
    }

    public synchronized void setFunctions(Function function, Function function2) {
        this.setXFunction(function);
        this.setYFunction(function2);
    }

    public synchronized void setXFunction(Function function) {
        if (function != null && function.getArity() != 2) {
            throw new IllegalArgumentException("Internal Error:  VectorField can only use functions of two variables.");
        }
        if (function != this.xFunc) {
            this.xFunc = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public synchronized void setYFunction(Function function) {
        if (function != null && function.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  VectorField can only use functions of two variables.");
        }
        if (function != this.yFunc) {
            this.yFunc = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public Function getXFunction() {
        return this.xFunc;
    }

    public Function getYFunction() {
        return this.yFunc;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        if (this.style != n) {
            this.style = n;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public int getPixelSpacing() {
        return this.pixelSpacing;
    }

    public void setPixelSpacing(int n) {
        if (n < 5) {
            n = 5;
        } else if (n > 200) {
            n = 200;
        }
        if (n != this.pixelSpacing) {
            this.pixelSpacing = n;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public synchronized void compute() {
        this.setup();
        this.needsRedraw();
        this.changed = false;
    }

    public synchronized void draw(Graphics graphics, boolean bl) {
        if (this.changed || bl || this.data == null) {
            this.setup();
            this.changed = false;
        }
        if (this.data == null) {
            return;
        }
        graphics.setColor(this.graphColor);
        boolean bl2 = this.style == 0 || this.style == 2 || this.style == 4;
        int n = 0;
        while (n < this.data.length) {
            int[] nArray = this.data[n];
            if (nArray[0] != Integer.MIN_VALUE) {
                graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[3]);
                if (bl2 && nArray[4] != Integer.MIN_VALUE) {
                    graphics.drawLine(nArray[2], nArray[3], nArray[4], nArray[5]);
                    graphics.drawLine(nArray[2], nArray[3], nArray[6], nArray[7]);
                }
            }
            ++n;
        }
    }

    private void setup() {
        if (this.xFunc == null || this.yFunc == null || this.coords == null) {
            this.data = null;
            return;
        }
        boolean bl = this.style == 0 || this.style == 2 || this.style == 4;
        double[] dArray = new double[2];
        int n = this.coords.getWidth() / this.pixelSpacing + 2;
        int n2 = this.coords.getHeight() / this.pixelSpacing + 2;
        double d = (double)this.pixelSpacing * this.coords.getPixelWidth();
        double d2 = (double)this.pixelSpacing * this.coords.getPixelHeight();
        double d3 = (this.coords.getXmax() + this.coords.getXmin() - (double)n * d) / 2.0;
        double d4 = (this.coords.getYmax() + this.coords.getYmin() - (double)n2 * d2) / 2.0;
        this.data = new int[n * n2][bl ? 8 : 4];
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        double d5 = this.coords.getPixelWidth();
        double d6 = this.coords.getPixelHeight();
        double d7 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            double d8;
            dArray[0] = d8 = d3 + (double)n3 * d;
            int n4 = 0;
            while (n4 < n2) {
                double d9;
                dArray[1] = d9 = d4 + (double)n4 * d2;
                dArray2[n3][n4] = this.xFunc.getVal(dArray);
                dArray3[n3][n4] = this.yFunc.getVal(dArray);
                if (!(Double.isNaN(dArray2[n3][n4]) || Double.isNaN(dArray3[n3][n4]) || Double.isInfinite(dArray2[n3][n4]) || Double.isInfinite(dArray3[n3][n4]))) {
                    dArray2[n3][n4] = dArray2[n3][n4] / d5;
                    dArray3[n3][n4] = -dArray3[n3][n4] / d6;
                    double d10 = dArray2[n3][n4] * dArray2[n3][n4] + dArray3[n3][n4] * dArray3[n3][n4];
                    if (d10 > d7) {
                        d7 = d10;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        d7 = Math.sqrt(d7);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            double d11 = d3 + (double)n6 * d;
            int n7 = this.coords.xToPixel(d11);
            int n8 = 0;
            while (n8 < n2) {
                double d12 = d4 + (double)n8 * d2;
                int n9 = this.coords.yToPixel(d12);
                int[] nArray = this.data[n5];
                ++n5;
                if (Double.isNaN(dArray2[n6][n8]) || Double.isNaN(dArray3[n6][n8]) || Double.isInfinite(dArray2[n6][n8]) || Double.isInfinite(dArray3[n6][n8])) {
                    nArray[n6] = Integer.MIN_VALUE;
                } else {
                    double d13 = Math.sqrt(dArray2[n6][n8] * dArray2[n6][n8] + dArray3[n6][n8] * dArray3[n6][n8]);
                    if (d13 < 1.0E-15 || d7 == 0.0 && (this.style == 3 || this.style == 4)) {
                        nArray[0] = nArray[2] = n7;
                        nArray[1] = nArray[3] = n9;
                        if (bl) {
                            nArray[4] = Integer.MIN_VALUE;
                        }
                    } else {
                        boolean bl2 = false;
                        switch (this.style) {
                            case 0: {
                                double d14 = 0.8 * (double)this.pixelSpacing * dArray2[n6][n8] / d13;
                                double d15 = 0.8 * (double)this.pixelSpacing * dArray3[n6][n8] / d13;
                                nArray[0] = n7;
                                nArray[1] = n9;
                                nArray[2] = (int)((double)n7 + d14);
                                nArray[3] = (int)((double)n9 + d15);
                                break;
                            }
                            case 1: {
                                double d14 = 0.8 * (double)this.pixelSpacing * dArray2[n6][n8] / d13 / 2.0;
                                double d15 = 0.8 * (double)this.pixelSpacing * dArray3[n6][n8] / d13 / 2.0;
                                nArray[0] = (int)((double)n7 - d14);
                                nArray[1] = (int)((double)n9 - d15);
                                nArray[2] = (int)((double)n7 + d14);
                                nArray[3] = (int)((double)n9 + d15);
                                break;
                            }
                            case 2: {
                                double d16 = d13;
                                if (d16 > 0.9 * (double)this.pixelSpacing) {
                                    d16 = 0.9 * (double)this.pixelSpacing;
                                    bl2 = true;
                                }
                                double d14 = dArray2[n6][n8] / d13 * d16;
                                double d15 = dArray3[n6][n8] / d13 * d16;
                                nArray[0] = n7;
                                nArray[1] = n9;
                                nArray[2] = (int)((double)n7 + d14);
                                nArray[3] = (int)((double)n9 + d15);
                                break;
                            }
                            case 3: {
                                double d16 = d13 / d7 * (double)this.pixelSpacing;
                                double d14 = dArray2[n6][n8] / d13 * d16 / 2.0;
                                double d15 = dArray3[n6][n8] / d13 * d16 / 2.0;
                                nArray[0] = (int)((double)n7 - d14);
                                nArray[1] = (int)((double)n9 - d15);
                                nArray[2] = (int)((double)n7 + d14);
                                nArray[3] = (int)((double)n9 + d15);
                                break;
                            }
                            case 4: {
                                double d16 = d13 / d7 * (double)this.pixelSpacing;
                                double d14 = dArray2[n6][n8] / d13 * d16;
                                double d15 = dArray3[n6][n8] / d13 * d16;
                                nArray[0] = n7;
                                nArray[1] = n9;
                                nArray[2] = (int)((double)n7 + d14);
                                nArray[3] = (int)((double)n9 + d15);
                                break;
                            }
                        }
                        if (bl) {
                            int n10 = (nArray[2] - nArray[0]) / 5;
                            int n11 = (nArray[3] - nArray[1]) / 5;
                            if (bl2 || n10 == 0 && n11 == 0) {
                                nArray[4] = Integer.MIN_VALUE;
                            } else {
                                nArray[4] = nArray[2] + n11 - n10;
                                nArray[5] = nArray[3] - n10 - n11;
                                nArray[6] = nArray[2] - n10 - n11;
                                nArray[7] = nArray[3] + n10 - n11;
                            }
                        }
                    }
                }
                ++n8;
            }
            ++n6;
        }
    }
}

