/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public abstract class TTFInput {
    private Stack filePosStack = new Stack();
    private int tempFlags;

    public abstract void seek(long var1) throws IOException;

    abstract long getPointer() throws IOException;

    public void pushPos() throws IOException {
        this.filePosStack.push(new Long(this.getPointer()));
    }

    public void popPos() throws IOException {
        this.seek((Long)this.filePosStack.pop());
    }

    public abstract int readRawByte() throws IOException;

    public abstract int readByte() throws IOException;

    public abstract short readShort() throws IOException;

    public abstract int readUShort() throws IOException;

    public abstract long readULong() throws IOException;

    public abstract int readLong() throws IOException;

    public abstract byte readChar() throws IOException;

    public final short readFWord() throws IOException {
        return this.readShort();
    }

    public final int readUFWord() throws IOException {
        return this.readUShort();
    }

    public final double readFixed() throws IOException {
        short s2 = this.readShort();
        short s3 = this.readShort();
        return (double)s2 + (double)s3 / 16384.0;
    }

    public final double readF2Dot14() throws IOException {
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = n3 + ((n2 & 0x3F) << 8);
        int n5 = n2 >> 6;
        if (n5 >= 2) {
            n5 -= 4;
        }
        return (double)n5 + (double)n4 / 16384.0;
    }

    public final void checkShortZero() throws IOException {
        if (this.readShort() != 0) {
            System.err.println("Reserved bit should be 0.");
        }
    }

    public static final boolean checkZeroBit(int n2, int n3, String string) throws IOException {
        if (TTFInput.flagBit(n2, n3)) {
            System.err.println("Reserved bit " + n3 + " in " + string + " not 0.");
            return false;
        }
        return true;
    }

    public void readUShortFlags() throws IOException {
        this.tempFlags = this.readUShort();
    }

    public void readByteFlags() throws IOException {
        this.tempFlags = this.readByte();
    }

    public boolean flagBit(int n2) {
        return TTFInput.flagBit(this.tempFlags, n2);
    }

    public static boolean flagBit(int n2, int n3) {
        return (n2 & 1 << n3) > 0;
    }

    public abstract void readFully(byte[] var1) throws IOException;

    public int[] readFFFFTerminatedUShortArray() throws IOException {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n2 = -1;
        do {
            n2 = this.readUShort();
            linkedList.add(new Integer(n2));
        } while (n2 != 65535);
        int[] nArray = new int[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            nArray[n3++] = (Integer)iterator.next();
        }
        return nArray;
    }

    public int[] readUShortArray(int n2) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.readUShort();
        }
        return nArray;
    }

    public short[] readShortArray(int n2) throws IOException {
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = this.readShort();
        }
        return sArray;
    }
}

