/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.MainPanel;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class MainApplet
extends JApplet
implements ComponentListener {
    MainPanel mainPanel = null;
    MainPanel Language = null;
    MainPanel Translation = null;
    static String[] tools = new String[]{"TOOL_CURSOR", "TOOL_ROTATOR", "TOOL_ERASOR", "TOOL_DIALOG", "TOOL_EDIT", "TOOL_SETATOM", "TOOL_SINGLE", "TOOL_DOUBLE", "TOOL_TRIPLE", "TOOL_ZERO", "TOOL_INCLINED", "TOOL_DECLINED", "TOOL_UNKNOWN", "TOOL_CHARGE", "TOOL_UNDO", "TOOL_REDO", "TOOL_TEMPLATE", "TOOL_CUT", "TOOL_COPY", "TOOL_PASTE"};
    static String[] menus = new String[]{"MENU_BLOCK", "MENU_SELECT", "MENU_TRANSFORM", "MENU_ZOOM", "MENU_SHOW", "MENU_HYDROGEN", "MENU_STEREO", "MENU_HELP"};
    public boolean[] selected_tools;
    public boolean[] selected_menus;
    public static Properties translation = new Properties();
    public String Correct_answer = "";
    public String feedback = "";
    public boolean continu = true;
    public String replytext = "";
    public String Student_answer = "";
    public String language;
    public int typeset = 0;
    public String plain_formula_ca = "";
    public String html_formula_ca = "";
    public String latex_formula_ca = "";
    public String plain_formula_sa = "";
    public String html_formula_sa = "";
    public String latex_formula_sa = "";
    static int N = Molecule.ELEMENTS.length;
    public int[] charge_ca;
    public int[] radical_ca;
    public int[] charge_sa;
    public int[] radical_sa;
    public String[] elements_ca;
    public String[] elements_sa;
    public int[] hydro_ca;
    public int[] hydro_sa;
    double weight_ca = 0.0;
    double weight_sa = 0.0;
    String html_smiles_ca = "";
    String html_smiles_sa = "";
    public int num_sa = 0;
    public int num_ca = 0;
    public int bond_sa = 0;
    public int bond_ca = 0;
    public String[] my_atoms;
    public boolean ViewH;
    public boolean ViewC;
    public static String[] templateURL;

    public void init() {
        templateURL = this.GetTemplateURL();
        this.ViewH = this.ViewHydrogen();
        this.ViewC = this.ViewCarbon();
        this.selected_tools = this.getTools();
        this.selected_menus = this.getMenus();
        this.my_atoms = this.GetMyAtoms();
        this.language = this.getLanguage();
        translation = this.loadProperties(this.language);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new MainPanel(null, false, true, null, this.language, translation, this.selected_tools, this.selected_menus, this.my_atoms, this.ViewH, this.ViewC);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        Molecule mol = this.ParseParams();
        if (mol != null) {
            this.mainPanel.SetMolecule(mol);
        }
        this.addComponentListener(this);
        this.GetFile();
        this.repaint(1000L);
    }

    public static byte[] loadURL(URL url) throws IOException {
        int n;
        int bufSize = 2048;
        byte[] buf = new byte[bufSize];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        while ((n = in.read(buf)) > 0) {
            bout.write(buf, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public static String loadFile(String fname) throws IOException {
        byte[] bytes = MainApplet.loadURL(new URL("file:" + fname));
        return new String(bytes);
    }

    public static String load(String fileOrURL) throws IOException {
        try {
            URL url = new URL(fileOrURL);
            return new String(MainApplet.loadURL(url));
        }
        catch (Exception e) {
            return MainApplet.loadFile(fileOrURL);
        }
    }

    public String[] GetTemplateURL() {
        String parm = this.getParameter("template1");
        if (parm != null && parm.length() != 0) {
            int p = 0;
            while (parm != null && parm.length() != 0) {
                parm = this.getParameter("template" + ++p);
            }
            String[] templateURL = new String[p - 1];
            for (int s = 1; s < p; ++s) {
                templateURL[s - 1] = parm = this.getParameter("template" + s);
            }
            return templateURL;
        }
        return null;
    }

    public void GetFile() {
        block9: {
            String filename = this.getParameter("file");
            if (filename != null) {
                try {
                    String showfile = this.getParameter("showfile");
                    if (showfile.equalsIgnoreCase("yes") || showfile.equals("1")) {
                        String DemoMol = MainApplet.load(filename).toString();
                        if (DemoMol.indexOf("WIMSchem!") != -1 && DemoMol.indexOf("!FIN") != -1) {
                            this.AppendMoleculeNative(DemoMol);
                        } else if (DemoMol.indexOf("molfile") != -1) {
                            this.AppendMoleculeMDLMol(DemoMol);
                        } else {
                            System.out.println("Unknown filetype or corrupt file " + filename + "\n" + DemoMol);
                        }
                        break block9;
                    }
                    this.Correct_answer = MainApplet.load(filename).toString();
                    this.GetQuestion(this.Correct_answer);
                }
                catch (Exception e) {
                    System.out.println("Could not load " + filename);
                    this.continu = false;
                }
            } else {
                System.out.println("param \"file\" is empty\nWill not use fileloading");
            }
        }
    }

    public String getLanguage() {
        String param = this.getParameter("language");
        param = param != null ? param.toLowerCase() : "en";
        return param;
    }

    public Boolean ViewHydrogen() {
        String param = this.getParameter("show_hydrogen");
        boolean h = true;
        if (param != null && ((param = param.toLowerCase()).equals("0") || param.equals("no"))) {
            h = false;
        }
        System.out.println("viewH=" + h + " param=" + param);
        return h;
    }

    public Boolean ViewCarbon() {
        String param = this.getParameter("show_carbon");
        boolean c = true;
        if (param != null && ((param = param.toLowerCase()).equals("0") || param.equals("no"))) {
            c = false;
        }
        System.out.println("viewC=" + c + " param=" + param);
        return c;
    }

    public String[] GetMyAtoms() {
        String param = this.getParameter("atoms");
        if (param != null) {
            System.out.println("found Atoms: " + param);
            this.my_atoms = this.AtomString2AtomArray(param);
            return this.my_atoms;
        }
        return null;
    }

    public String[] AtomString2AtomArray(String t) {
        StringTokenizer q;
        if (t.indexOf(",") != -1) {
            q = new StringTokenizer(t, ",");
        } else if (t.indexOf(":") != -1) {
            q = new StringTokenizer(t, ":");
        } else if (t.indexOf(";") != -1) {
            q = new StringTokenizer(t, ";");
        } else if (t.indexOf(" ") > 2) {
            q = new StringTokenizer(t, " ");
        } else {
            return null;
        }
        int max = q.countTokens();
        if (max > 50) {
            max = 50;
        }
        String[] tmp = new String[max];
        String s = "";
        for (int p = 0; p < max; ++p) {
            s = q.nextToken();
            if (s.length() != 1 && s.length() != 2) continue;
            tmp[p] = s;
        }
        return tmp;
    }

    public boolean[] getMenus() {
        this.selected_menus = new boolean[8];
        for (int p = 0; p < 8; ++p) {
            String param = this.getParameter(menus[p]);
            if (param != null) {
                if (param.equalsIgnoreCase("yes") || param.equals("1")) {
                    this.selected_menus[p] = true;
                    continue;
                }
                this.selected_menus[p] = false;
                continue;
            }
            this.selected_menus[p] = true;
        }
        return this.selected_menus;
    }

    public boolean[] getTools() {
        this.selected_tools = new boolean[20];
        for (int p = 0; p < 20; ++p) {
            String param = this.getParameter(tools[p]);
            if (param != null) {
                if (param.equalsIgnoreCase("yes") || param.equals("1")) {
                    this.selected_tools[p] = true;
                    continue;
                }
                this.selected_tools[p] = false;
                continue;
            }
            this.selected_tools[p] = true;
        }
        return this.selected_tools;
    }

    public Properties loadProperties(String lang) {
        translation = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream("/lang/WIMSchemProperties_" + lang + ".properties");
            translation.load(in);
            in.close();
            return translation;
        }
        catch (Exception e) {
            System.out.println("error reading /lang/WIMSchemProperties_" + lang + ".properties\n" + e);
            return null;
        }
    }

    public String getAppletInfo() {
        return translation.getProperty("WIMSchem_Applet_Description");
    }

    private Molecule ParseParams() {
        try {
            String str = this.getParameter("nlines");
            if (str == null) {
                return null;
            }
            int nlines = Integer.valueOf(str);
            if (nlines < 3 || nlines > 10000) {
                return null;
            }
            StringBuffer buff = new StringBuffer();
            for (int n = 1; n <= nlines; ++n) {
                str = this.getParameter("line" + n);
                if (str == null) {
                    return null;
                }
                for (int i = 0; i < str.length() && str.charAt(i) == '_'; ++i) {
                    str = str.substring(0, i) + " " + str.substring(i + 1);
                }
                buff.append(str + "\n");
            }
            Molecule mol = MoleculeStream.ReadNative(new BufferedReader(new StringReader(buff.toString())));
            if (mol.NumAtoms() > 0) {
                return mol;
            }
            return null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, translation.getProperty("Unable_to_parse_parameter_molecule") + e.getMessage(), "zog", 0);
            return null;
        }
    }

    public boolean SetMoleculeNative(String Source) {
        try {
            Molecule mol = MoleculeStream.ReadNative(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.SetMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("error" + e);
            return false;
        }
    }

    public boolean SetMoleculeMDLMol(String Source) {
        try {
            Molecule mol = MoleculeStream.ReadMDLMOL(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.SetMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("error" + e);
            return false;
        }
    }

    public boolean AppendMoleculeNative(String Source) {
        try {
            Molecule mol = MoleculeStream.ReadNative(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.AddMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("error" + e);
            return false;
        }
    }

    public boolean AppendMoleculeMDLMol(String Source) {
        try {
            Molecule mol = MoleculeStream.ReadMDLMOL(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.AddMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("error" + e);
            return false;
        }
    }

    public String GetMoleculeNative() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.WriteNative(bw, this.mainPanel.MolData());
            return sw.toString();
        }
        catch (IOException e) {
            System.out.println("error" + e);
            return null;
        }
    }

    public String GetMoleculeMDLMol() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.WriteMDLMOL(bw, this.mainPanel.MolData());
            return sw.toString();
        }
        catch (IOException e) {
            System.out.println("error" + e);
            return null;
        }
    }

    public void GetQuestion(String i) {
        this.feedback = "";
        if (i.indexOf("WIMSchem!") != -1 && i.indexOf("!FIN") != -1) {
            System.out.println("Native fileformat detected");
            Molecule elmol = new Molecule();
            try {
                elmol = MoleculeStream.ReadNative(new BufferedReader(new StringReader(i.toString())));
                System.out.println("Native stringfile converted to molecule");
            }
            catch (IOException e) {
                System.out.println("error" + e);
                this.continu = false;
            }
            try {
                this.Correct_answer = MoleculeStream.Molecule2String(elmol);
                this.continu = true;
            }
            catch (IOException e) {
                System.out.println("error" + e + "trouble with converting native molecule to string:" + i);
                this.continu = false;
            }
        } else if (i.indexOf("molfile") != -1) {
            System.out.println("molfile detected");
            Molecule mdmol = new Molecule();
            try {
                mdmol = MoleculeStream.ReadMDLMOL(new BufferedReader(new StringReader(i.toString())));
                System.out.println("MDMOL file converted to molecule");
            }
            catch (IOException e) {
                System.out.println("error" + e);
                this.continu = false;
            }
            try {
                this.Correct_answer = MoleculeStream.Molecule2String(mdmol);
                this.continu = true;
            }
            catch (IOException e) {
                System.out.println("error" + e + "trouble with converting molecule to string:" + i);
                this.continu = false;
            }
        } else if (this.Correct_answer.length() == 0) {
            this.feedback = translation.getProperty("empy_string_question");
            this.continu = false;
        } else {
            this.feedback = translation.getProperty("invalid_question");
            this.continu = false;
        }
    }

    public String ReadApplet() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.WriteNative(bw, this.mainPanel.MolData());
            this.Correct_answer = sw.toString();
            this.Correct_answer = this.Correct_answer.replaceAll(" ", "");
            if (this.Correct_answer.indexOf("WIMSchem!") != -1 || this.Correct_answer.indexOf("!FIN") != -1) {
                if (this.Correct_answer.length() < 22) {
                    this.feedback = translation.getProperty("empty_answer");
                    this.continu = false;
                }
            } else {
                this.continu = false;
                this.feedback = translation.getProperty("no_sketchfile_answer");
            }
        }
        catch (IOException e) {
            System.out.println("error" + e);
            this.continu = false;
            this.feedback = translation.getProperty("no_sketchfile_answer");
        }
        this.AnalyseMolecule(this.Correct_answer, false);
        this.html_smiles_ca = MoleculeStream.GetSmiles(this.mainPanel.MolData());
        return this.weight_ca + "\n" + this.plain_formula_ca + "\n" + this.html_formula_ca + "\n" + this.html_smiles_ca + "\n" + this.latex_formula_ca;
    }

    public String CompareNative() {
        System.out.println("entering function CompareNative()");
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.WriteNative(bw, this.mainPanel.MolData());
            this.Student_answer = sw.toString();
            this.Student_answer = this.Student_answer.replaceAll(" ", "");
            System.out.println("Student answer is:" + this.Student_answer);
            if (this.Student_answer.indexOf("WIMSchem!") != -1 || this.Student_answer.indexOf("!FIN") != -1) {
                if (this.Student_answer.length() < 22) {
                    this.feedback = translation.getProperty("empty_answer");
                    this.continu = false;
                }
            } else {
                this.continu = false;
                this.feedback = translation.getProperty("no_sketchfile_answer");
            }
        }
        catch (IOException e) {
            System.out.println("error" + e);
            this.continu = false;
            this.feedback = translation.getProperty("no_sketchfile_answer");
        }
        if (this.continu) {
            this.feedback = "";
            this.num_sa = 0;
            this.num_ca = 0;
            this.bond_sa = 0;
            this.bond_ca = 0;
            this.weight_sa = 0.0;
            this.weight_ca = 0.0;
            this.AnalyseMolecule(this.Student_answer, true);
            this.AnalyseMolecule(this.Correct_answer, false);
            double score = this.getScore();
            this.html_smiles_sa = MoleculeStream.GetSmiles(this.mainPanel.MolData());
            try {
                this.html_smiles_ca = MoleculeStream.GetSmiles(MoleculeStream.ReadNative(new BufferedReader(new StringReader(this.Correct_answer))));
            }
            catch (IOException e) {
                System.out.println("error" + e);
            }
            return score + "\n" + this.weight_sa + "\n" + this.weight_ca + "\n" + this.plain_formula_sa + "\n" + this.plain_formula_ca + "\n" + this.html_formula_sa + "\n" + this.html_formula_ca + "\n" + this.html_smiles_sa + "\n" + this.html_smiles_ca + "\n" + this.latex_formula_sa + "\n" + this.latex_formula_ca + "\n" + this.feedback + "\n@" + this.Student_answer + "\n@" + this.Correct_answer;
        }
        return "error\n" + this.feedback;
    }

    public void AnalyseMolecule(String S, boolean whatisit) {
        String sign;
        int p;
        if (whatisit) {
            System.out.println("analysing student reply");
        } else {
            System.out.println("analysing correct answer");
        }
        String[] s = S.split("\n");
        int s1 = s[0].indexOf(40);
        int s2 = s[0].indexOf(44);
        int s3 = s[0].indexOf(41);
        int n_s = Integer.parseInt(s[0].substring(s1 + 1, s2).trim());
        int b_s = Integer.parseInt(s[0].substring(s2 + 1, s3).trim());
        String[] E_s = new String[n_s];
        int[] H_s = new int[n_s];
        int[] C_s = new int[n_s];
        int[] R_s = new int[n_s];
        int[] this_A = new int[N];
        int[] this_C = new int[N];
        int[] this_R = new int[N];
        int[] this_H = new int[N];
        String plainformula = "";
        String htmlformula = "";
        String latexformula = "";
        String R_plain = "";
        String R_html = "";
        String R_latex = "";
        String C_plain = "";
        String C_html = "";
        String C_latex = "";
        double weight_s = 0.0;
        int r = 0;
        for (p = 0; p < n_s; ++p) {
            String[] atom = s[p + 1].split("[\\=\\,\\;]");
            E_s[p] = atom[0];
            r = 0;
            for (int n = 0; n < N; ++n) {
                if (!atom[0].equals(Molecule.ELEMENTS[n])) continue;
                weight_s += Molecule.WEIGHTS[n];
                int n2 = n;
                this_A[n2] = this_A[n2] + 1;
                r = n;
                n = N;
            }
            C_s[p] = Integer.parseInt(atom[3]);
            this_C[r] = C_s[p];
            R_s[p] = Integer.parseInt(atom[4]);
            this_R[p] = R_s[p];
            if (atom[5].indexOf("i") != -1) {
                atom[5] = atom[5].replaceAll("i", "");
                H_s[p] = Integer.parseInt(atom[5]);
                this_H[r] = H_s[p];
                this_A[1] = this_A[1] + H_s[p];
            } else {
                atom[5] = atom[5].replaceAll("e", "");
                H_s[p] = Integer.parseInt(atom[5]);
                this_H[r] = H_s[p];
                this_A[1] = this_A[1] + H_s[p];
            }
            weight_s += (double)H_s[p];
        }
        if (this_A[6] != 0) {
            if (this_R[6] != 0) {
                R_plain = "\u2022";
                R_latex = "^{^{\\cdot}}";
                R_html = "<sup>&cdot;</sup>";
            }
            if (this_C[6] != 0) {
                if (this_C[6] > 0) {
                    sign = "+";
                } else {
                    sign = "-";
                    this_C[6] = Math.abs(this_C[6]);
                }
                C_plain = this_C[6] + sign;
                C_latex = "^{" + this_C[6] + sign + "}";
                C_html = "<sup><small>" + this_C[6] + sign + "</small></sup>";
            }
            if (this_A[6] == 1) {
                plainformula = "C" + C_plain + R_plain + " ";
                htmlformula = "<font size=+1><tt>C" + C_html + R_html + "</tt></font>";
                latexformula = "\\Bf{C" + C_latex + R_latex + "}";
            } else {
                plainformula = "C" + C_plain + R_plain + this_A[6];
                htmlformula = "<font size=+1><tt>C" + C_html + R_html + "</tt></font><sub><small>" + this_A[6] + "</small></sub>";
                latexformula = "\\Bf{C" + C_latex + R_latex + "}_{" + this_A[6] + "}";
            }
        }
        for (p = 0; p < N; ++p) {
            if (p == 6) {
                p = 7;
            }
            if (this_A[p] == 0) continue;
            R_plain = "";
            R_html = "";
            R_latex = "";
            C_plain = "";
            C_html = "";
            C_latex = "";
            sign = "";
            if (this_R[p] != 0) {
                R_plain = this_R[p] + "\u2022";
                R_latex = "^{^{" + this_R[p] + "\\cdot}}";
                R_html = "<sup><sup>" + this_R[p] + "&cdot;</sup></sup>";
            }
            if (this_C[p] != 0) {
                if (this_C[p] > 0) {
                    sign = "+";
                } else {
                    sign = "-";
                    this_C[p] = -1 * this_C[p];
                }
                C_plain = this_C[p] + sign;
                C_latex = "^{" + this_C[p] + sign + "}";
                C_html = "<sup><small>" + this_C[p] + sign + "</small></sup>";
            }
            if (this_A[p] == 1) {
                plainformula = plainformula + " " + Molecule.ELEMENTS[p] + "" + C_plain + "" + R_plain;
                htmlformula = htmlformula + " <font size=+1><tt>" + Molecule.ELEMENTS[p] + C_html + R_html + "</tt></font>";
                latexformula = latexformula + "\\,\\Bf{" + Molecule.ELEMENTS[p] + C_latex + R_latex + "}";
                continue;
            }
            plainformula = plainformula + " " + Molecule.ELEMENTS[p] + "" + C_plain + "" + R_plain + "" + this_A[p];
            htmlformula = htmlformula + " <font size=+1><tt>" + Molecule.ELEMENTS[p] + C_html + R_html + "</tt></font><sub><small>" + this_A[p] + "</small></sub>";
            latexformula = latexformula + "\\,\\Bf{" + Molecule.ELEMENTS[p] + C_latex + R_latex + "}_{" + this_A[p] + "}";
        }
        if (whatisit) {
            this.elements_sa = E_s;
            this.hydro_sa = H_s;
            this.charge_sa = C_s;
            this.radical_sa = R_s;
            this.weight_sa = weight_s;
            this.plain_formula_sa = plainformula;
            this.html_formula_sa = htmlformula;
            this.latex_formula_sa = latexformula;
            this.num_sa = n_s;
            this.bond_sa = b_s;
        } else {
            this.elements_ca = E_s;
            this.hydro_ca = H_s;
            this.charge_ca = C_s;
            this.radical_ca = R_s;
            this.weight_ca = weight_s;
            this.plain_formula_ca = plainformula;
            this.html_formula_ca = htmlformula;
            this.latex_formula_ca = latexformula;
            this.num_ca = n_s;
            this.bond_ca = b_s;
        }
    }

    public double getScore() {
        System.out.println("entering function getScore()");
        int hit = 0;
        String tmp_remark = "";
        boolean[] done = new boolean[this.num_sa];
        double finalscore = 0.0;
        for (int p = 0; p < this.num_sa; ++p) {
            done[p] = true;
        }
        if (this.num_ca == this.num_sa && this.bond_ca == this.bond_sa) {
            block1: for (int c = 0; c < this.num_ca; ++c) {
                for (int s = 0; s < this.num_sa; ++s) {
                    if (!done[s]) continue;
                    if (this.elements_ca[c].equals(this.elements_sa[s]) && this.charge_ca[c] == this.charge_sa[s] && this.radical_ca[c] == this.radical_sa[s] && this.hydro_ca[c] == this.hydro_sa[s]) {
                        done[s] = false;
                        ++hit;
                        s = this.num_sa;
                        continue block1;
                    }
                    if (!this.elements_ca[c].equals(this.elements_sa[s])) continue;
                    if (this.charge_ca[c] != this.charge_sa[s]) {
                        tmp_remark = "wrong_charge " + this.elements_ca[c] + "=" + this.charge_ca[c] + ",";
                    }
                    if (this.radical_ca[c] != this.radical_sa[s]) {
                        tmp_remark = "wrong_radical " + this.elements_ca[c] + "=" + this.radical_ca[c] + ",";
                    }
                    if (this.hydro_ca[c] == this.hydro_sa[s]) continue;
                    tmp_remark = "wrong_amount_hydrogen " + this.elements_ca[c] + "=" + this.hydro_ca[c] + ",";
                }
            }
        }
        this.feedback = this.feedback + tmp_remark;
        finalscore = this.num_ca > this.num_sa ? (double)(10 * hit / this.num_ca) : (double)(10 * hit / this.num_sa);
        System.out.println("finalscore=" + finalscore);
        return finalscore;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.mainPanel.ScaleToFit();
        this.mainPanel.repaint();
    }
}

