/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    private int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    private int[] downsampleRemainders;

    VolumeFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
    }

    boolean readVolumeParameters() {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces);
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    boolean readVolumeData(boolean bl) {
        if (!this.gotoAndReadVoxelData(bl)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
        }
        return true;
    }

    protected int readVolumetricHeader() {
        try {
            int n;
            this.readTitleLines();
            Logger.info(this.jvxlFileHeaderBuffer.toString());
            this.readAtomCountAndOrigin();
            if (this.atomCount == Integer.MIN_VALUE) {
                return 0;
            }
            Logger.info("voxel grid origin:" + this.volumetricOrigin);
            int n2 = this.params.downsampleFactor;
            boolean bl = this.canDownsample && n2 > 0;
            for (n = 0; n < 3; ++n) {
                this.readVoxelVector(n);
            }
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info("downsample factor = " + n2);
                for (n = 0; n < 3; ++n) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    this.volumetricVectors[n].scale(n2);
                    Logger.info("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]);
                }
            }
            for (n = 0; n < 3; ++n) {
                this.line = this.voxelCounts[n] + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
                Logger.info("voxel grid count/vector:" + this.line);
                if (this.isAngstroms) continue;
                this.volumetricVectors[n].scale(0.5291772f);
            }
            JvxlReader.jvxlReadAtoms(this.br, this.jvxlFileHeaderBuffer, this.atomCount, this.volumeData);
            return this.readExtraLine();
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return 0;
        }
    }

    protected void readTitleLines() throws Exception {
    }

    protected String skipComments(boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while ((this.line = this.br.readLine()) != null && (bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            stringBuffer.append(this.line).append('\n');
        }
        return stringBuffer.toString();
    }

    protected void readAtomCountAndOrigin() throws Exception {
    }

    protected void readVoxelVector(int n) throws Exception {
        this.line = this.br.readLine();
        Vector3f vector3f = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseInt(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        vector3f.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
    }

    protected int readExtraLine() throws Exception {
        if (!this.negativeAtomCount) {
            return 1;
        }
        this.line = this.br.readLine();
        Logger.info("Reading extra CUBE information line: " + this.line);
        return this.parseInt(this.line);
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        boolean bl2;
        this.next[0] = 0;
        int n = this.params.downsampleFactor;
        boolean bl3 = bl2 = this.canDownsample && n > 0;
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
        if (this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            this.voxelData = null;
        } else {
            this.voxelData = new float[this.nPointsX][][];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (bl2) {
                n2 = n - 1;
                n4 = this.nPointsZ * n + this.downsampleRemainders[2];
                n3 = this.downsampleRemainders[2] + (n - 1) * n4;
                n4 = this.downsampleRemainders[1] * n4 + (n - 1) * n4 * (this.nPointsY * n + this.downsampleRemainders[1]);
            }
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        fArray[k] = this.getNextVoxelValue();
                        if (!bl2) continue;
                        this.skipVoxels(n2);
                    }
                    if (!bl2) continue;
                    this.skipVoxels(n3);
                }
                if (!bl2) continue;
                this.skipVoxels(n4);
            }
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    private void skipVoxels(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BitSet getVoxelBitSet(int n) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n;
            for (n = 1; n < this.params.fileIndex; ++n) {
                this.nextVoxel();
            }
            f = this.nextVoxel();
            for (n = this.params.fileIndex; n < this.nSurfaces; ++n) {
                this.nextVoxel();
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    protected float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while ((this.line = this.br.readLine()) != null && Float.isNaN(f = this.parseFloat(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
            this.nBytes += this.line.length() + 1;
        }
        return f;
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    protected void skipData(int n) throws Exception {
        for (int i = 0; i < n; i += this.countData(this.line)) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            while (n2 < n3 && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                ++n2;
            }
            if (n2 < n3) {
                ++n;
            }
            while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '\t') {
                ++n2;
            }
        }
        return n;
    }
}

