/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.ConnectDialog;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class Database {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    final ImageIcon connectedIcon = new ImageIcon(this.getClass().getResource("/images/database32.gif"));
    private static final ImageIcon dbErrorIcon = null;

    Database(SharpTools sharp) {
        this.sharp = sharp;
        this.table = sharp.getTable();
        this.tableModel = sharp.getTableModel();
    }

    public void connectDb() {
        Object dbUsername = null;
        Object dbPassword = null;
        Object dbUrl = null;
        Object dbDriver = null;
        String dbTable = null;
        Object connectName = null;
        boolean newConnection = false;
        StringBuffer textBuf = new StringBuffer();
        ConnectDialog connectDialog = new ConnectDialog(this.sharp);
        connectDialog.setVisible(true);
        if (connectDialog.isCancelled()) {
            return;
        }
        Connection dbConnection = connectDialog.getConnection();
        try {
            DatabaseMetaData dma = dbConnection.getMetaData();
            SharpOptionPane.showMessageDialog(this.sharp, "Connected to database " + dma.getDatabaseProductName() + " v" + dma.getDatabaseProductVersion() + "\nusing driver " + dma.getDriverName() + " v" + dma.getDriverVersion(), "Connected", 1, this.connectedIcon);
            if (dbTable == null || dbTable.equals("")) {
                dbTable = this.selectDbTable(dma);
            }
            if (dbTable == null) {
                return;
            }
            Statement stmt = dbConnection.createStatement();
            ResultSet dbResults = stmt.executeQuery("SELECT * FROM " + dbTable);
            String warnings = this.checkForWarning(dbConnection.getWarnings());
            if (warnings != null && !warnings.equals("")) {
                SharpOptionPane.showMessageDialog(this.sharp, warnings, "Warning", 1, this.connectedIcon);
            }
            ResultSetMetaData rsmd = dbResults.getMetaData();
            int numCols = rsmd.getColumnCount();
            for (int i = 1; i <= numCols; ++i) {
                if (i != 1) {
                    textBuf.append("\t");
                }
                textBuf.append(rsmd.getColumnLabel(i));
            }
            textBuf.append("\n");
            while (dbResults.next()) {
                for (int j = 1; j <= numCols; ++j) {
                    if (j != 1) {
                        textBuf.append("\t");
                    }
                    textBuf.append(dbResults.getString(j));
                }
                textBuf.append("\n");
            }
            String text = textBuf.toString();
            CellPoint size = SharpTableModel.getSize(text);
            this.sharp.newTableModel(size.getRow(), size.getCol());
            this.tableModel = this.sharp.getTableModel();
            this.tableModel.fromString(text, 0, 0, new CellRange(1, size.getRow(), 1, size.getCol()));
            this.sharp.setTitle(dbTable + " - Sharp Tools Spreadsheet");
            dbResults.close();
            stmt.close();
        }
        catch (SQLException e) {
            SharpOptionPane.showMessageDialog(this.sharp, "Unable to get data from the database.\n" + e.toString(), "ERROR", 1, dbErrorIcon);
            return;
        }
    }

    private String checkForWarning(SQLWarning warn) throws SQLException {
        StringBuffer textBuf = new StringBuffer();
        if (warn != null) {
            textBuf.append("Warning:\n\n");
            while (warn != null) {
                textBuf.append("Message:  " + warn.getMessage() + "\n");
                textBuf.append("SQLState: " + warn.getSQLState() + "\n");
                textBuf.append("Vendor:   " + warn.getErrorCode() + "\n");
                warn = warn.getNextWarning();
            }
        }
        return textBuf.toString();
    }

    private String selectDbTable(DatabaseMetaData dma) throws SQLException {
        ResultSet dbResults = dma.getTables(null, null, "%", null);
        Vector<String> vec = new Vector<String>();
        while (dbResults.next()) {
            vec.addElement(dbResults.getString(3));
        }
        if (vec.size() == 0) {
            SharpOptionPane.showMessageDialog(this.sharp, "This database has no tables defined.", "Empty Database", 2);
            return null;
        }
        Object[] possibleValues = new Object[vec.size()];
        vec.copyInto(possibleValues);
        Object selectedValue = SharpOptionPane.showInputDialog(this.sharp, "Please select the table you wish to load: ", "Select Table", 0, this.connectedIcon, possibleValues, possibleValues[0]);
        if (selectedValue == null) {
            return null;
        }
        return selectedValue.toString();
    }
}

