/********************************************************************
 * globaldefs.h: Stuff that's needed by all objects
 *
 * This work is licensed under a Creative Commons Attribution-Share Alike 3.0
 * United States License. See http://creativecommons.org/licenses/by-sa/3.0/us/
 * for details.
 *
 * This file is part of thinkfan. See thinkfan.c for further info.
 * ******************************************************************/
#ifndef GLOBALDEFS_H
#define GLOBALDEFS_H

#define _GNU_SOURCE

#include <string.h>
#include <stdlib.h>
#include <limits.h>

#define VERSION "0.6.5"

#define ERR_T_GET     	-1
#define ERR_FAN_INIT   	-2
#define ERR_CONF_NOFILE	-3
#define ERR_CONF_LOST	-4
#define ERR_CONF_RELOAD	-5
#define ERR_PIDFILE	   	-6
#define RV_PIDFILE		-4

#define PID_FILE "/var/run/thinkfan.pid"
#define IBM_TEMP "/proc/acpi/ibm/thermal"
#define IBM_FAN "/proc/acpi/ibm/fan"

// Stolen from the gurus
#define likely(x)       __builtin_expect((x),1)
#define unlikely(x)     __builtin_expect((x),0)

typedef struct {
	int level; // this is the fan speed level.
	int low;   // lower temperature for stepping down to previous level.
	int high;  // upper temperature determines when to step to the next level.
} thm_tuple;

typedef struct {
	thm_tuple *items;
	int max_idx;
	char **sensors;
	int sensor_count;
	char *fan;
	int (*get_temp)();
	void (*setfan)();
	void (*confirm_fan)();
	int (*init_fan)();
	void (*uninit_fan)();
} tf_config;

tf_config *config;
int quiet, nodaemon, errcnt, resume_is_safe;
unsigned int chk_sanity, cur_lvl, watchdog_timeout;
char *config_file, *prefix;
float bias_level, depulse_tmp;
char *oldpwm; // old contents of pwm*_enable, used for uninit_fan
struct timespec *depulse;
#define DEPULSE_MIN_LVL 1
#define DEPULSE_MAX_LVL 4

#endif
