/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-handle-list-editor.h:
 * A widget to create and edit a handle list of a single handle type.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_HANDLE_LIST_EDITOR_H__
#define __TI_HANDLE_LIST_EDITOR_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include "handle-mapper.h"

typedef struct _TIHandleListEditor TIHandleListEditor;
typedef struct _TIHandleListEditorClass TIHandleListEditorClass;

/* Type macros */
#define TI_TYPE_HANDLE_LIST_EDITOR               ti_handle_list_editor_get_type()
#define TI_HANDLE_LIST_EDITOR(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_HANDLE_LIST_EDITOR, TIHandleListEditor))
#define TI_HANDLE_LIST_EDITOR_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_HANDLE_LIST_EDITOR, TIHandleListEditorClass))
#define TI_IS_HANDLE_LIST_EDITOR(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_HANDLE_LIST_EDITOR))
#define TI_IS_HANDLE_LIST_EDITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_HANDLE_LIST_EDITOR))
#define TI_HANDLE_LIST_EDITOR_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_HANDLE_LIST_EDITOR, TIHandleListEditorClass))

struct _TIHandleListEditor {
    GtkHBox parent;
};

GType ti_handle_list_editor_get_type (void);

/**
 * Creates a new TIHandleList widget
 */
GtkWidget *ti_handle_list_editor_new (TIHandleMapper *handle_mapper);

/**
 * Set the handle list
 *
 * @param handles An array of guint or NULL, to clear the list.
 */
void ti_handle_list_editor_set (TIHandleListEditor *handle_list_editor, GArray *handles);

/**
 * Get the handle list
 *
 * @return handles An array of guint. Must be freed after use.
 */
GArray *ti_handle_list_editor_get (TIHandleListEditor *handle_list_editor);

#endif /* __TI_HANDLE_LIST_EDITOR_H__ */
