#include "extensions.h"

#include <telepathy-glib/channel.h>
#include <telepathy-glib/connection.h>
#include <telepathy-glib/proxy-subclass.h>

static void _ti_ext_register_dbus_glib_marshallers (void);

/* include auto-generated stubs for client-specific code */
#include "_gen/signals-marshal.h"
#include "_gen/cli-channel-body.h"
#include "_gen/cli-connection-body.h"
#include "_gen/register-dbus-glib-marshallers-body.h"

static gpointer
ti_cli_once (gpointer data)
{
  _ti_ext_register_dbus_glib_marshallers ();

  tp_connection_init_known_interfaces ();
  tp_channel_init_known_interfaces ();

  tp_proxy_or_subclass_hook_on_interface_add (TP_TYPE_CONNECTION,
      ti_cli_connection_add_signals);

  tp_proxy_or_subclass_hook_on_interface_add (TP_TYPE_CHANNEL,
      ti_cli_channel_add_signals);

  return NULL;
}

void
ti_cli_init (void)
{
  static GOnce once = G_ONCE_INIT;

  g_once (&once, ti_cli_once, NULL);
}
