# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: generates naive cgi search form for search of sisu database (pgsql sqlite)

=end
module  SiSU_CGI_pgsql                                                            #% database building documents
  require_relative 'sysenv'                             # sysenv.rb
  require_relative 'cgi_sql_common'                     # cgi_sql_common.rb
    include SiSU_CGI_sql
  class SiSU_search_pgsql < SiSU_CGI_common
    def initialize(opt,webserv)
      @opt,@webserv=opt,webserv
      @env=SiSU_Env::Info_env.new('',opt)
      @sys=SiSU_Env::System_call.new
      @image_src="#{@env.url.webserv_cgi}/_sisu/image_sys"
      @common=SiSU_CGI_sql::SiSU_CGI_common.new(@webserv,@opt,@image_src,@env)
      @db=SiSU_Env::Info_db.new
      @cgi_file_name="#{Db[:name_prefix_db]}by_#{opt.dir_structure_by}_pgsql.cgi"
    end
    def pgsql
      serve=[]
      if @sys.psql
        available_db_table=`psql --list`                            # system call requires psql
        available_db=available_db_table.scan(/(#{Db[:name_prefix]}\S+)/) if not available_db_table.nil?
        if available_db \
        and available_db.class==Array
          available_db.flatten.each do |x|
            serve << x.gsub(/#{Db[:name_prefix]}(\S+)/,'\1')
          end
        else put "WARNING: no postgresql database available, (have you created one?)"
        end
        serve.sort!
        f1,f2,f3='','',''
        serve.each do |x|
          f1 << %{              <option value="#{Db[:name_prefix]}#{x}">#{x}</option>\n} unless x =~/apache|sisu\/image/ #check
        end
        f2 <<  %{          selected_db=case cgi['db']\n}
        serve.each do |x|
          f2 << %{          when /#{Db[:name_prefix]}#{x}/;        '<option value="#{Db[:name_prefix]}#{x}">#{x}</option>'\n} unless x =~/apache|sisu\/image/ #check
        end
      end
      f2 << "          end\n"
      if FileTest.writable?('.')
        output=File.open(@cgi_file_name,'w')
        output << header0 << header1 << header_desc << header2 << f1 << buttons1 << buttons1_pgsql << buttons2 << search_request << search_statement << search_statement_common << search_query1 << @common.pages << search_query2 << @common.tail << @common.main1 << f2 << dbi_connect << @common.main2 << @common.dir_structure << @common.main3
        a=%{        generated sisu_pgsql.cgi,
            BASED ON ALREADY EXISTING directories that could potentially be used to populate postgresql db, (-D)
        }
        SiSU_Screen::Ansi.new(@opt.cmd,a).print_grey
        c=case @webserv
        when /pwd/; ''
        else "if necessary make the directory /usr/lib/cgi-bin :
                  sudo cp -vi #{Dir.pwd}/#{@cgi_file_name} /usr/lib/cgi-bin/.
                  sudo chmod -v 755 /usr/lib/cgi-bin/#{@cgi_file_name}
                  sudo ln -s /usr/lib/cgi-bin/#{@cgi_file_name} /usr/lib/cgi-bin/sisu_pgsql.cgi
                  (copy #{@cgi_file_name} to your cgi directory) set file permissions to 755, and make symbolic link to sisu_pgsql.cgi"
        end
        a=%{#{c}
                  #{@env.webserv_base_cgi}/cgi-bin/sisu_pgsql.cgi
        }
        SiSU_Screen::Ansi.new(@opt.cmd,a).warn
        a="postgresql db used for present directory: #{@db.psql.db}"
        b="\n\t(to create and populate postgresql database see 'man sisu' and in particular the -D flag)\n\t[the database to be used for this directory (#{@db.psql.db}) will have to be created manually if it does not exist,\n\tsee 'sisu --help sql'\n\tif you have permission to create databases:\n\t'sisu -d --createdb'\n\tor using postgresql tools directly:\n\t'createdb #{@db.psql.db}'\n\tfor a list of existing databases try 'psql --list']"
        SiSU_Screen::Ansi.new(@opt.cmd,a,b).txt_cyan
      else puts 'failed in attempt to write #{@cgi_file_name} to present directory,  is directory writable?'
      end
    end
    def header0
      <<-WOK_SQL
#!/usr/bin/env ruby
=begin
#{about}
 * Description: generates naive cgi search form for search of sisu database (pgsql)
#{gpl}
=end
      require 'cgi'
      require 'fcgi'
      require 'dbi'
      @version='sisu_pgsql'
      @image_src="#{@env.url.webserv_cgi}/_sisu/image_sys"
      @hosturl_db="#{@env.url.webserv_base_cgi}"
      @hosturl_files="#{@env.url.webserv_files_from_db}"
      @port="#{@db.psql.port}"
      @db_name_prefix="#{Db[:name_prefix]}"
      user='#{@env.user}'  # check user name for access to pg database: '#{@env.user}'
      WOK_SQL
    end
    def search_statement
      <<-'WOK_SQL'
      class Dbi_search_string
        def initialize(l,t,q,cse=false)
          @l,@t,@q,@c=l,t,q,cse
        end
        def string
          search={ :search => [], :flag => false }
          if @t =~/\S+/ or @q =~/\S+/
            if @t =~/\S+/;     unescaped_search=CGI.unescape(@t)
            elsif @q =~/\S+/;  unescaped_search=CGI.unescape(@q)
            end
            search_construct=[]
            if @c
              unescaped_search.gsub!(/\s*(AND|OR)\s*/,"' \) \\1 #{@l}~\( '")
              unescaped_search.gsub!(/(.+)/,"#{@l}~\( '\\1' \)")
            else
              unescaped_search.gsub!(/\s*(AND|OR)\s*/,"' \) \\1 #{@l}~*\( '")
              unescaped_search.gsub!(/(.+)/,"#{@l}~*\( '\\1' \)")
            end
            search_construct << unescaped_search
            search_construct=search_construct.join(' ')
            search[:search]                    << search_construct
            search[:flag]=true
            search
          end
          search
        end
      end
      WOK_SQL
    end
    def search_query1
      <<-'WOK_SQL'
          @search_text,@search_endnotes='',''
          search[:text].flatten.each {|x| @search_text << "#{x} AND " }
          @search_text=@search_text.gsub!(/AND\s+$/m,'') #watch
          @search_text.gsub!(/(doc_objects\.clean~[*]?\(\s*'[^']+'\s*\)\s+(?:(?:AND|OR)\s+doc_objects\.clean~[*]?\(\s*'[^']+'\s*\))+)/,'(\1)')
          search[:endnotes].flatten.each {|x| @search_endnotes << "#{x} AND " }
          @search_endnotes=@search_endnotes.gsub!(/AND\s+$/m,'') #watch
          @search_endnotes.gsub!(/(endnotes\.clean~\(\s*'[^']+'\s*\)\s+(?:(?:AND|OR)\s+endnotes\.clean~\(\s*'[^']+'\s*\))+)/,'(\1)')
        end
      WOK_SQL
    end
    def search_query2
      <<-'WOK_SQL'
        def sql_select_body
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:body]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, metadata_and_text.notes_suffix, doc_objects.body, doc_objects.seg, doc_objects.ocn, metadata_and_text.tid FROM doc_objects, metadata_and_text WHERE (#{@search_text}) AND doc_objects.metadata_tid = metadata_and_text.tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, doc_objects.ocn}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:body] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_endnotes
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:endnotes]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, endnotes.body, endnotes.nr, endnotes.ocn, endnotes.metadata_tid FROM metadata_and_text, endnotes WHERE (#{@search_endnotes}) AND metadata_and_text.tid = endnotes.metadata_tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, endnotes.nr}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:endnotes] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_body_format
          %{<font color="#666666" size="2">#{sql_select_body}</font>}
        end
        def sql_select_endnotes_format
          %{<font color="#666666" size="2">#{sql_select_endnotes}</font>}
        end
        def contents
          @conn.select_all(sql_select_body)
        end
        def endnotes
          @conn.select_all(sql_select_endnotes)
        end
      end
      WOK_SQL
    end
    def buttons1_pgsql
      <<-'WOK_SQL'
        <input type="checkbox" name="casesense" #{@checked_case}> case sensitive
      WOK_SQL
    end
    def dbi_connect
      <<-'WOK_SQL'
          dbi="dbi:Pg:database=#{@db};port=#{@port}"
          @conn=DBI.connect(dbi,user)
      WOK_SQL
    end
  end
end
__END__
