# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_insertions
  class Insertions
    def initialize(md,data)
      @md,@data=md,data
    end
    def output_filetypes_in_cmd(cmd_shortcut,source=nil) #make list of file types in shortcut command (as configured), e.g. when sisu -3 is used
      cf_defaults=SiSU_Env::Info_processing_flag.new
      cmd_list=case cmd_shortcut.inspect
      when /0/; cf_defaults.cf_0
      when /1/; cf_defaults.cf_1
      when /2/; cf_defaults.cf_2
      when /3/; cf_defaults.cf_3
      when /4/; cf_defaults.cf_4
      when /5/; cf_defaults.cf_5
      end
      file_type_names={}
      file_type_names[:gen],file_type_names[:src]=[],[]
      file_type_names[:gen] <<= if cmd_list =~ /y/; 'sisu_manifest.html'
      end
      file_type_names[:gen] <<= if cmd_list =~ /h/; ['toc.html', 'doc.html']
      end
      file_type_names[:gen] <<= if cmd_list =~ /e/; ['.epub']
      end
      file_type_names[:gen] <<= if cmd_list =~ /p/; ['landscape.pdf', 'portrait.pdf']
      end
      file_type_names[:gen] <<= if cmd_list =~ /o/; 'opendocument.odt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /b/; 'scroll.xhtml'
      end
      file_type_names[:gen] <<= if cmd_list =~ /x/; 'sax.xml'
      end
      file_type_names[:gen] <<= if cmd_list =~ /X/; 'dom.xml'
      end
      file_type_names[:gen] <<= if cmd_list =~ /a/; 'plain.txt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /g/; 'wiki.txt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /w/; 'concordance.html'
      end
      file_type_names[:gen] <<= if cmd_list =~ /N/; 'digest.txt'
      end
      file_type_names[:src] <<= if source and cmd_shortcut =~ /s/; source
      end
      file_type_names[:src] <<= if cmd_shortcut =~ /S/; "#{source}.zip"
      end
      file_type_names[:gen]=file_type_names[:gen].flatten
      file_type_names[:src]=file_type_names[:src].flatten
      file_type_names
    end
    def expand_insertions?
      data=@data
      tuned_file,tuned_file_tmp=[],[]
      data.each do |para|
        if para !~/^%+\s/ \
        and para =~/\{(?:~\^\s+)?(.+?)\s\[(?:\d(?:[sS]*))\]\}(?:\.\.\/\S+?\/|\S+?\.ss[tm]\b)/
          txt,cmd,source,url_dir,note,manifest=nil,nil,nil,nil,nil,nil
          @u=SiSU_Env::Info_env.new.url
          if defined? @u.remote
            if para =~/(.+?)\{(.+?)\s\[(\d[sS]*)\]\}((\S+?)\.ss[tm]\b)(.*)/m
              pre,txt,cmd,source,url_dir,note="#{$1.strip} ",$2,$3,$4,$5,$6
            elsif para =~/\{(.+?)\s\[(\d[sS]*)\]\}((\S+?)\.ss[tm]\b)(.*)/
              pre,txt,cmd,source,url_dir,note='',$1,$2,$3,$4,$5
            end
            manifest="#{pre}{#{txt} }#{@u.remote}/#{url_dir}/toc.html#{note}\n\n"
          else
            puts "error, does currently support relative paths (reltive paths were removed, as had problems for citation, and was not suited to all output types should possibly reconsider) #{__FILE__} #{__LINE__}"
            if para =~/\{(?:~\^\s+)?(.+?)\s\[(\d[sS]*)\]\}\.\.\/(\S+?)\/(\s+#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]})?/
              txt,cmd,url_dir,note=$1,$2,$3,$4
              manifest="{ #{txt} }../#{url_dir}/toc.html#{note}\n\n"
            end
          end
          tuned_file_tmp << manifest
          output_filetypes=output_filetypes_in_cmd(cmd,source)
          output_filetypes[:gen].each do |o_f|
            describe = case o_f
            when /sisu_manifest.html/; '~^ document manifest'
            when /toc.html/;           ' html, segmented text'
            when /doc.html/;           ' html, scroll, document in one'
            when /\.epub/;             ' epub'
            when /landscape.pdf/;      ' pdf, landscape'
            when /portrait.pdf/;       ' pdf, portrait'
            when /opendocument.odt/;   ' odf:odt, open document text'
            when /scroll.xhtml/;       ' xhtml scroll'
            when /sax.xml/;            ' xml, sax'
            when /dom.xml/;            ' xml, dom'
            when /plain.txt/;          ' plain text utf-8'
            #when /manpage.1/;          ' man, 1'
            when /wiki.txt/;           ' wiki text'
            when /concordance.html/;   ' concordance'
            when /digest.txt/;         ' dcc, document content certificate (digests)'
            else nil
            end
            if describe
              tuned_file_tmp << if @u.remote #to double space <:br> at beginning of entry
                if describe =~/epub/
                  "#{Mx[:nbsp]*4} { #{describe} }#{@u.remote}/epub/#{url_dir}#{o_f} "
                elsif describe =~/^~\^ /
                  "#{Mx[:nbsp]*4} {#{describe} }#{@u.remote}/#{url_dir}/#{o_f} "
                else "#{Mx[:nbsp]*4} { #{describe} }#{@u.remote}/#{url_dir}/#{o_f} "
                end
              else
                if describe =~/epub/
                  "#{Mx[:nbsp]*4} { #{describe} }../epub/#{url_dir}#{o_f} "
                elsif describe =~/^~\^ /
                  "#{Mx[:nbsp]*4} {#{describe} }../#{url_dir}/#{o_f} "
                else "#{Mx[:nbsp]*4} { #{describe} }../#{url_dir}/#{o_f} "
                end
              end
            end
          end
          output_filetypes[:src].each do |o_f|
            describe=case o_f
            when /#{source}\.zip/;     ' markup source (zipped) pod'
            when /#{source}/;          ' markup source text'
            else nil
            end
            if describe
              tuned_file_tmp << if @u.remote
                x=if describe =~/zip/
                  "#{Mx[:nbsp]*4} {#{describe} }#{@u.src_pod}/#{o_f} "
                else "#{Mx[:nbsp]*4} {#{describe} }#{@u.src_txt}/#{o_f} "
                end
              else
                x=if describe =~/zip/
                  "#{Mx[:nbsp]*4} { #{describe} }../pod/#{o_f} "
                else "#{Mx[:nbsp]*4} { #{describe} }../zip/#{o_f} "
                end
              end
            end
          end
          tuned_file << 'group{' << tuned_file_tmp.join("\n") << '}group'
          tuned_file_tmp=[]
        else tuned_file << para
        end
      end
      tuned_file
    end
  end
end
__END__
