# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_character_check
  class Check
    def initialize(data)
      @data=data
      @comment='%'
      @endnote_array=[]
    end
    def character_check_and_oldstyle_endnote_array
      require 'iconv'
      data=@data
      @tuned_file,@endnote_array=[],[]
      endnote_no=1
      data.each do |dob|
        unless dob.is =='table'
          dob.obj.strip!
          dob.obj.gsub!(/^[{~}]\s*$/,'')
          dob.obj.gsub!(/~#\s*/,"#{Mx[:pa_non_object_no_heading]}")
          dob.obj.gsub!(/-#\s*/,"#{Mx[:pa_non_object_dummy_heading]}")
          dob.obj.gsub!(/(#{Mx[:en_a_o]})\s*\s+/,'\1 '); dob.obj.gsub!(/(~\{\s*)\s+/,'\1 ')
          dob.obj.gsub!(/ \/\//,"#{Mx[:br_line]}")
          dob.obj.gsub!(/<br>/,"#{Mx[:br_line]}")                              #needed by xml, xhtml etc.
          dob.obj.gsub!(/\t/,' ')
          dob.obj.gsub!(/\342\200\231/u,"'") #if dob =~/’/  #Avoid #&lsquo; &rsquo; #&ldquo; &rdquo;
          dob.obj.gsub!(/�/u,' ')                                              #watch, replace with char code
          dob.obj.gsub!(/·/u,'*')
          dob.obj.gsub!(/\\copy(?:right)?\b/,'&#169;')
          dob.obj.gsub!(/\\trademark\b|\\tm\b/,'&#174;')
          dob.obj=dob.obj + "\n"
          unless dob.is =~/^code/
            case dob.obj
            when /\^~/                                     #% Note must do this first (earlier loop) and then enter gathered data into ~^\d+
              sub_dob=dob.obj.dup
              @endnote_array << sub_dob.gsub!(/\n/,'').gsub!(/\^~\s+(.+)\s*/,%{#{Mx[:en_a_o]}#{endnote_no} \\1 #{Mx[:en_a_c]}}).strip
              endnote_no+=1
              dob=nil if dob.obj =~/\^~ .+/                #watch, removes 'binary' endnote now in endnote array for later insertion
            end
          end
        end
        @tuned_file << dob unless dob.nil?
      end
      @tuned_file=@tuned_file.flatten.compact
      [@tuned_file,@endnote_array]
    end
  end
end
__END__
