=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Document skin used for Free as in Freedom
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
  class Skin
    #% promo
    def promo_promo
      ['sisu_icon','sisu','sisu_search_libre','open_society','fsf','ruby']
    end
    ##% home
    #def home_index
    #end
    #def home_toc
    #end
    ##% path
    #def path_root                                                                     # the only parameter that cannot be changed here
    #  './sisu/'
    #end
    #def path_rel
    #  '../'
    #end
    #% url
    def url_home
      'http://www.gnu.org'
    end
    def url_site                                                                     # used in pdf header
      'http://www.gnu.org'
    end
    def url_txt                                                                      # text to go with url usually stripped url
      'www.gnu.org'
    end
    def url_home_url
      '../index.html'
    end
    #def url_root_http
      #root server path info, used in document information
    #end
    #% color
    def color_band1
      '"#cccccc"'
      #'"#000070"'
    end
    #% txt
    def txt_hp
      'Free as in Freedom'
    end
    def txt_home                                                                     # this should be the name of the site eg. Lex Mercatoria or if you prefer to see a url the url in text form copy & ...
      #"www.jus.uio.no/sisu/"
      'Free as in Freedom'
    end
    #% icon
    def icon_home_button
      'free_as_in_freedom.png'
    end
    def icon_home_banner
      icon_home_button
    end
    #% banner
    def banner_home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#cccccc"><a href="#{url_site}/">#{png_home}</a></td></tr></table>\n}
    end
    def banner_home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#cccccc"><a href="#{url_site}/" target="_top">#{png_home}</a>#{table_close}</td><td width="60%"><center><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{table_close}</center></center></td><td width="20%">&nbsp;#{table_close}}
    end
    def banner_band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#cccccc"><a href="#{url_site}/" target="_top">#{png_home}</a>#{table_close}}
    end
    def banner_home_guide
    end
    #% credits
    def insert_levitating_gnu #used locally this skin only
      %{<center><a href="http://www.fsf.org/"><img border="0" height="133" width="135" src="#{url_path_image_base}/levitating_gnu.png" alt="RMS/FSF - Levitating Gnu --&gt;" /></a></center>}
    end
    def credits_splash
      %{<center><table summary="credits" align="center"bgcolor="#ffffff"><tr><td><font color="#666666">#{insert_levitating_gnu}</font></center></td></tr></table></center>}
    end
  end
  class TeX
    def header_center
      "\\chead{\\href{#{@vz.url_site}/}{www.jus.uio.no/sisu/}}"
    end
    def home_url
      "\\href{#{@vz.url_site}/}{www.gnu.org}"
    end
    def home
      "\\href{#{@vz.url_site}/}{GNU - Free Software Foundation}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
end
