# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: texinfo processing

=end
module SiSU_TexInfo
  require "#{SiSU_lib}/html"
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  #include Stamp ... needed removed arbitrarily 2005w05/1 (warnings about undefined flags)
  require "#{SiSU_lib}/texinfo_format"
  include SiSU_Texinfo_format
  @tex_file=[]
  @@tex_backslash="\\\\"
  @@tabular="{tabular}"
  @@table_pagebreak_counter,@@tex_endnote_call_counter,@@tex_table_flag,@@tex_counter,@@tex_column,@@tex_columns,@@counting=0,0,0,0,0,0,0
  @@column_instruct,@@tex_line_mode,@@tex_word_mode,@@start_table,@@line_mode='','','','',''
  @@n,@@copyright,@@tableheader=nil,nil,nil
  @@tex_col_w=[]
  @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
  class Source #Songsheet
    include SiSU_Param
    include SiSU_Viz
    include SiSU_TexInfo
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      @st={ 'tex'=>{} }
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def directories
      begin
        case @opt.fns
        when /\.(?:-|ssm\.)?sst$/
          Dir.mkdir(@env.path.output) unless FileTest.directory?("#{@env.path.output}")
          Dir.mkdir(@env.path.texi) unless FileTest.directory?(@env.path.tex)
          @@filename_texinfo=File.new(%{#{@env.path.texi}/#{@opt.fnb}.texinfo},'w+')
        end
      rescue; STDERR.puts SiSU_Screen::Ansi.new(@opt.cmd,$!,$@).rescue
      ensure
      end
    end
    def read
      songsheet
    end
    def songsheet
      begin
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'TexInfo')
        tell.green_title_hi unless @opt.cmd =~/q/
        data=IO.readlines(@opt.fns,'')
        @md=SiSU_Param::Parameters.new(@opt).get
        puts "\t#{@@cX.grey}TexInfo#{@@cX.off}"
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        directories
        @marshalfile=my_make.marshal_meta
        if FileTest.file?(@marshalfile)==true
          File.open(@marshalfile) { |f| @@tuned_file=Marshal.load(f)}
          tell.meta_verse_skipped unless @opt.cmd =~/q/
        else
          tex_array=IO.readlines(@opt.fns,'')
          SiSU_Metaverse.songsheet(tex_array)
        end
        tex_array=@@tuned_file
        Texinfo_make.new(tex_array,@md).songsheet
        tex_array=''
        @@filename_texinfo=nil
      rescue; STDERR.puts SiSU_Screen::Ansi.new(@opt.cmd,$!,$@).rescue
      ensure
        @@filename_texinfo.close if @@filename_texinfo
      end
    end
  end
  class Texinfo_make
    include SiSU_Param
    include SiSU_Texinfo_format
    @@tex_1='(?:.+?)+~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    @@dp=nil
    def initialize(data,md)
      @data,@md=data,md #fns
      @env=SiSU_Env::Info_env.new(@md.fns)
      @st={ 'tex'=>{} }
      #@tex=SiSU_Texinfo_format::Texinfo.new
      @vz=SiSU_Env::Get_init.instance.skin
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def songsheet
      begin
        @data=pre
        @data=endnote
        @data=markup
        @data=tail
        output
        makeinfo
      rescue; STDERR.puts SiSU_Screen::Ansi.new(@md.cmd,$!,$@).rescue
      ensure
      end
    end
    def pre
      @tex_file=[]
      data=@data
      data.each do |para|
        # DEBUG 2003w16 this is a kludge, because i could not get parameters
        # from param, Sort out ... revert to more elegant solution
        if para =~ /#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c/u
          @@flag['tables']='y' # KLUDGE get from param
        end
        para.gsub!(/<:p[bn]>/,'')
        para.gsub!(/(^|#{Mx[:gl_c]}|\s)\{(.+?)\}((?:https?|file):\/\/\S+)/,'\1(\2 [linked to:] \3)')
        txt_obj={:txt =>para}
        do_mono=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
        @tex_file << do_mono.spec_char
      end
      data=@tex_file.delete_if {|x| x =~ /^0(?:\\)+~/m}
      data=@tex_file # ...
    end
    def endnote
      data=@data
      @tex_file=[]
      data.each do |para|
        # BUG bug -> have problems with endnotes in headers
        if para =~ /#{Mx[:en_a_o]}\d+\s+/ #if para =~ /<!e\s+/ # watch
          para.gsub!(/\s*#{Mx[:en_a_o]}(?:\d+)\s+(.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/m,' @footnote{ \1} ')
        elsif para =~ /#{Mx[:en_a_o]}\*+\s+/ #if para =~ /<!e\s+/ # watch
          para.gsub!(/\s*#{Mx[:en_a_o]}(\*+)\s+(?:.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}#{Mx[:en_a_c]}/m,' @footnote{ \1} ')
        end
        @tex_file << para
      end
      @tex_file
    end
    def poem
      data=@data
      @tex_file=[]
      @@counting=0
      data.each do |para|
        if para =~ /#{Mx[:gr_o]}code#{Mx[:gr_c]}/
          @@flag['code']=true
          @@counting=1
        end
        if para =~ /#{Mx[:gr_o]}verse#{Mx[:gr_c]}/
          @@flag['poem']=1
        end
        if @@flag['code']
          if @@flag['code'] \
          and para =~ /#{Mx[:gr_o]}code[-_](?:end|close)#{Mx[:gr_c]}/ #watch change not tested 200501
            @@flag['code']=false
          end
          if @@flag['code'] \
          and para =~ /\S/
            sub_array=para.dup
            @@line_mode=sub_array.scan(/.+/)
            Tune.code_lines(@@line_mode)
            para=@@line_mode.join
          end
        elsif @@flag['poem']==1
          if @@flag['poem']==1 \
          and para =~ /#{Mx[:gr_o]}verse[-_](?:end|close)#{Mx[:gr_c]}/ #watch change not tested 200501
            @@flag['poem']=0
          end
          if @@flag['poem']==1 \
          and para =~ /\S/
            sub_array=para.dup
            @@line_mode=sub_array.scan(/.+/)
            Tune.code_lines(@@line_mode)
            para=@@line_mode.join
          end
        end
        @tex_file << para
      end
    end
    def code_lines
      data=@data
      data.each do |line|
        if line =~ /\S/ \
        and line !~ /#{Mx[:gr_o]}(code|verse).+/
          if @@flag['code']
            line.gsub!(/^\s*(.+)/m, "\\noindent \\marginpar\[left-text\]{\\begin{tiny}#{@@counting}\\end{tiny}}\\1\\")
            @@counting+=1 if @@flag['code']
          else line.gsub!(/(.+)/m,'\noindent\1')
          end
        end
      end
    end
    def tables
      data=@data
      @tex_file=[]
      @@tableheader=0
      data.each do |para|
        if para =~ /#{Mx[:tc_p]}|#{Mx[:gr_o]}T/ui
          txt_obj={:txt =>para}
          do_mono=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
          para=do_mono.longtable # using longtable latex package
        end
        @tex_file << para
      end
    end
    def markup
      data=@data
      @tex_file=[]
      @row_break='\\\\\\'
      @break_page="#@row_break\n#@row_break \n"
      md={}
      txt_obj={:txt =>''}
      @tex_file << SiSU_Texinfo_format::Texinfo.new(@md,txt_obj).head
      txt_obj={:txt =>@md.title}
      mono=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
      @tex_file << mono.topnode
      texinfo_menu=[]
      n_menu,n_submenu=0,0
      @submenu,@subsubmenu={},{}
      data.each do |para|
        para.gsub!(/\s*<:name#example>\s*/,' ')
        para.gsub!(/#{Mx[:id_o]}~0;0:0;x\d+#{Mx[:id_c]}/,'') # if book index? remove
        if para =~ /^#{Mx[:lv_o]}[1-3]:\S*?#{Mx[:lv_c]}\s*(.+?)\s*$/
          txt_obj={:txt =>$1}
          toc=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
          texinfo_menu << toc.menu
        elsif para =~ /^#{Mx[:lv_o]}[4-6]:\S*?#{Mx[:lv_c]}\s*(.+?)\s*$/
          txt_obj={:txt =>$1}
          toc=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
          texinfo_menu << toc.menu
          case para
          when /^#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}\s*(.+?)\s*$/
            n_menu+=1
            @submenu[n_menu]=[]
          when /^#{Mx[:lv_o]}5:\S+?#{Mx[:lv_c]}\s*(.+?)\s*$/
            n_submenu+=1
            @subsubmenu[n_menu]=[]
            @submenu[n_menu] << toc.menu
          when /^#{Mx[:lv_o]}6:\S+?#{Mx[:lv_c]}\s*(.+?)\s*$/
            n_submenu+=1
            @subsubmenu[n_submenu]=[]
            @subsubmenu[n_submenu] << toc.menu
          end
        else
          #para.gsub!(/\s*(?:<:?br>|<br \/>)\s*/,"\n#@row_break ")
          para.gsub!(/\s*(?:<:?br>|<br \/>)\s*/,"\n\n")
        end
      end
      texinfo_menu.compact!
      texinfo_menu << "* Dublin Core::"
      @tex_file << texinfo_menu
      @tex_file << "* Index::\n" +
        "@end menu\n\n" +
        "@c %% 5\n\n"
      n_menu,n_submenu=0,0
      @@do_submenu,@@do_subsubmenu=1,1
      data.each do |para|
        txt_obj={:txt =>para}
        mono=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
        case para
        when /^#{Mx[:lv_o]}1:/; mono.level1
        when /^#{Mx[:lv_o]}2:/; mono.level2
        when /^#{Mx[:lv_o]}3:/; mono.level3
        when /^#{Mx[:lv_o]}4:/;
          mono.level4
          n_menu+=1
          @@do_submenu,@@do_subsubmenu=1,1
        when /^#{Mx[:lv_o]}5:/;
          n_submenu+=1
          @@do_subsubmenu=1
          if @@do_submenu==1
            txt_obj={:txt =>@submenu[n_menu]}
            menu=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
            para="#{menu.submenu}#{mono.level5}"
            @@do_submenu=0
          else mono.level5
          end
        when /^#{Mx[:lv_o]}6:/;
          if @@do_submenu==1
            txt_obj={:txt =>@submenu[n_menu]}
            menu=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
            para="#{menu.subsubmenu}#{mono.level6}"
            @@do_subsubmenu=0
          else
            mono.level6
          end
        #  when /^<!i1!>/
        #    mono.indent1
        #  when /^<!i2!>/
        #    mono.indent2
        #  when /<!:\s+/
        #    mono.graphics
        #  when /^\s*<!image\s+/
        #    mono.image
        #  when /\}image/
        #    mono.png
        #  when /\}http/
        #    mono.http
        else
          if para !~/\S/
            para=nil
          else
            para.gsub!(/#{Mx[:id_o]}\\~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,'<\1>')
            para
          end
        end
        #%case with endnotes
        para.gsub!(/\s*[0-8]\\+(\S+)?\s+/,' ') if para
        @tex_file << para if para
      end
      data=@tex_file
    end
    def numbering
      data=@data
      data=Texinfo_make.new(data,@md).number_titles
      #TOGGLE to SWITCH PARAGRAPH NUMBERING (ON & OFF)
      data=Texinfo_make.new(data,@md).number_paras \
        if @md.fns !~ /\.e[pdr]00/ \
        and @md.markup !~ /not_to/i
    end
    def number_titles
      data=@data
      @tex_file=[]
      input=%{#{@md.markup}}[/(num_top\s*=\s*(\d?))?/m,2] # else default usually 4  # this was a bit of a trick required to pass nil to input if nothing matched... #puts input
      #input=/(num_top\s*=\s*(\d?))?/m.match(@md[:markup]) [2] # else default usually 4  # this was a bit of a trick required to pass nil to input if nothing matched... #puts input
      num_top=input.to_i
      t_no1=0;  t_no2=0;  t_no3=0;  t_no4=0;
      no1=num_top; no2=(num_top + 1); no3=(num_top + 2);  no4=(num_top + 3);
      data.each do |para|
        if @md.markup =~ /num_top/i \
        and para !~ /#{Rx[:meta]}/
          if para =~ /^[1-6]\\+(?:~\S+)?\s*<!h-.+?-!>/ \
          and para !~ /<:\d-endnotes>/
            header=para[/<!h-(.+?)-!>/m, 1].gsub!(/-/m,'.')
            para.gsub!(/^(?:[1-6]\\+(?:~\S+)|<:([12356]|4-.+?-)>)\s*<!h-.+?-!>/,
              "\\1 #{header} ")
          end
        elsif para =~ /<!h!>|<!h\d!>|<!h.+?!>|<!!h.+?!>/
          if para =~ /<!h-.+?-!>/
            para.gsub!(/<!h-(.+?)-!>/,'\1 ')
          end
        end
        @tex_file << para
      end
      data=@tex_file
    end
    def number_paras
      data=@data
      @tex_file=[]
      paranumber=0
      data.each do |para|
        if para =~/#{Mx[:id_o]}\\~(\d+);\w\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/ \
        and para !~ /#{Mx[:br_eof]}/
          parablock,paranum=/(.+?)#{Mx[:id_o]}\\~(\d+);\w\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/im.match(para)[1,2]
          do_duo=SiSU_Texinfo_format::DuoTex.new(parablock,paranum) ###is BUG
          para=do_duo.paraNum if parablock
        end
        @tex_file << para
      end
      data=@tex_file
    end
    def tail
      data=@data
      txt_obj={:txt =>''}
      tex=SiSU_Texinfo_format::Texinfo.new(@md,txt_obj)
      data << tex.dublincore
      data << tex.tail
    end
    def output
      data=@data
      data.compact!
      data.each {|para| (@@filename_texinfo.puts para,"\n") if para}
      @@filename_texinfo.close
    end
    def makeinfo
      if @md.fns =~/\.(?:-|ssm\.)?sst$/
        m=/(.+?)\.([_-]?sst)$/.match(@md.fns)
        fnb,sfx=m[1],m[2]
        pwd=Dir.pwd
        case sfx
        when /(?:-|ssm\.)?sst$/
          @env=SiSU_Env::Info_env.new(@md.fns,@md.cmd)
          Dir.chdir(@env.path.texi)
          texinfo=SiSU_Env::System_call.new("#{fnb}.texinfo")
          texinfo.makeinfo
        end
        Dir.chdir(pwd)
      end
    end
  end
end
__END__
