# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: document digests (md5|sha256) and structure processing

=end
module SiSU_Digest_view
  require "#{SiSU_lib}/particulars"
  require "#{SiSU_lib}/i18n"
  pwd=Dir.pwd
  class Source
    @@dg=nil
    def initialize(opt)
      @opt=opt
      @fnb=@opt.fnb
      @@endnotes_para=[]
      @@dg=nil
      @dg=@@dg ||=SiSU_Env::Info_env.new.digest.type
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
    end
    def read
      begin
        @env,@md,@dal_array=@particulars.env,@particulars.md,@particulars.dal_array
        tool=if @opt.cmd =~/[MVv]/; "#{@env.program.text_editor} #{@env.path.output_tell}/#{@md.fnb}/#{@md.fn[:digest]}"
        else ''
        end
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"Document #@dg Digests",tool)
        tell.green_hi_blue unless @opt.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output_tell}/#{@md.fnb}/#{@md.fn[:digest]}")
        tell.flow if @opt.cmd =~/[MV]/
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        SiSU_Digest_view::Source::Scroll.new(@particulars).songsheet
        SiSU_Env::Info_skin.new(@md).select
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      @@dl=nil
      @@ds={}
      @@description,@@ds[:digests],@@ds[:tree],@@ds[:summary],@@sc_info=[],[],[],[],[]
      def initialize(particulars) #data='',md='')
        @particulars=particulars
        @data,@env,@md=@particulars.dal_array,@particulars.env,@particulars.md
        SiSU_Env::SiSU_file.new(@md).mkdir
        @@dg ||=@env.digest.type
        @@dl ||=@env.digest.length
        @dg,@dl=@@dg,@@dl
        l=SiSU_Env::Standardise_language.new.file_to_language(@md.fns)
        @language=l[:l]
        @tr=SiSU_Translate::Source.new(@md,@language)
      end
      def songsheet
      #source parser, based on dal creation - dal parser ...
        @@description,@@ds[:digests],@@ds[:tree],@@ds[:summary],@@sc_info=[],[],[],[],[]
        message_digest
        dal_structure
        supplementary
        output
      end
      def description(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@description << f << e
      end
      def digests(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@ds[:digests] << f << e
      end
      def dal_structure_tree(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@ds[:tree] << f << e
      end
      def dal_structure_summary(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@ds[:summary] << f << e
      end
      def rcinfo(f,e='')
        puts f + e.to_s if @md.cmd =~/V/
        @@sc_info << f << e
      end
      def output
        filename_digest=SiSU_Env::SiSU_file.new(@md,@md.fn[:digest]).mkfile
        filename_digest << @@description.join << @@ds[:digests].join << @@ds[:tree].join << @@ds[:summary].join << @@sc_info.join
      end
      def rgx_txt(txt)
        txt=txt.gsub(/([()])/,"\\\\\\1")
      end
      def message_digest
      #there will be a docbook mapping header, fairly complex variations
        data=@data
        sys=SiSU_Env::System_call.new
        l=Hash.new(0)
        @p=[]
        @g,@v,@r='','',''
        data.each do |para|
          x=nil
          y,para_endnotes=[],[]
          if para =~/#{Mx[:id_o]}~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)#{Mx[:id_c]}#{Mx[:id_o]}([0-9a-f]{#@dl}):([0-9a-f]{#@dl})#{Mx[:id_c]}/
            ocn,h1,h2,d_clean,d_all=$1,$2,$3,$4,$5
            @ocn=ocn unless ocn.to_i == 0
            para.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'<b>\1</b>')
            para.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'<i>\1</i>')
            para.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'<u>\1</u>')
            if para=~/#{Mx[:en_a_o]}[\d*+]+.+?#{Mx[:id_o]}[0-9a-f]{#@dl}#{Mx[:id_c]}#{Mx[:en_a_c]}/
              para_endnotes << para.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+).+?#{Mx[:id_o]}([0-9a-f]{#@dl})#{Mx[:id_c]}(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/)
            end
            ima=[]
            if para !~/^%+\s/ \
            and para =~/(?:^|[^_\\])#{Mx[:lnk_o]}(\S+\.(png|jpg|gif))\s.+?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\/\/\S+|image)/
              images=para.scan(/(?:^|[^_\\])#{Mx[:lnk_o]}(\S+\.(?:png|jpg|gif))\s.+?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\/\/\S+|image)/).flatten
            else image=nil
            end
            x=case para
            when /^#{Mx[:meta_o]}title#{Mx[:meta_c]}/
              "\n" + '  '*0 +'@' + '  '*9
            when /^#{Mx[:meta_o]}subtitle#{Mx[:meta_c]}/
              "\n" + '  '*1 +'@' + '  '*8
            when /^#{Mx[:lv_o]}1:/
              "\n" + '  '*2 +':A ' + '  '*6 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^#{Mx[:lv_o]}2:/
              "\n" + '  '*3 +':B ' + '  '*5 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^#{Mx[:lv_o]}3:/
              "\n" + '  '*4 +':C ' + '  '*4 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^#{Mx[:lv_o]}4:/
              "\n" + '  '*5 +'1' + '  '*4 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^#{Mx[:lv_o]}5:/
              "\n" + '  '*6 +'2' + '  '*3 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            when /^#{Mx[:lv_o]}6:/
              "\n" + '  '*7 +'3' + '  '*2 +'- ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
            else
              if para =~/MD5\(\S+?\.sst\)=\s*<u>([0-9a-f]{#@dl})<\/u>/                                        #watch
                @n,@s=/MD5\((\S+?\.sst)\)=\s*<u>([0-9a-f]{#@dl})<\/u>/.match(para)[1,2]
              end
              x=unless ocn =~ /^0$/
                if images \
                and images.length > 0 # then get path of image & produce digest
                  @image_name,@image_dgst,@img=[],[],[]
                  images.each do |i|
                    image_source=if FileTest.file?("#{@env.path.image_source_local_tex}/#{i}")
                      @env.path.image_source_local_tex
                    elsif FileTest.file?("#{@env.path.image_source_remote_tex}/#{i}")
                      @env.path.image_source_remote_tex
                    elsif FileTest.file?("#{@env.path.image_source_tex}/#{i}")
                      @env.path.image_source_tex
                    else
                      tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:", %{"#{i}" missing}, "search locations: #{@env.path.image_source_local_tex}, #{@env.path.image_source_remote_tex} and #{@env.path.image_source_tex}")
                      tell.error2 unless @md.cmd =~/q/
                      nil
                    end
                    @img << /\S+\.(png|jpg|gif)/.match(i)[1]
                    not_found_msg='image not found'
                    if image_source
                      para_image = image_source + '/' + i
                      @image_name << i
                      @image_dgst << if @dg =~/^sha(?:2|256)$/; sys.sha256(para_image)
                      else                                      sys.md5(para_image)
                      end
                    else
                      @image_name << '  '*16 + i + ' [image missing]'
                      @image_dgst << ''
                      @image_dgst[1]=not_found_msg + ' '*(32-not_found_msg.length)
                    end
                  end
                  line= "\n" + '  '*9 + ' - ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all + "\n"
                  line_image=[]
                  c=0
                  @image_name.each do |ok|
                    line_image << %{                     #{@img[c]}       #{@image_dgst[c][1]}                                  #{@image_name[c]}}
                    c +=1
                  end
                  line=line + line_image.join("\n")
                else "\n" + '  '*9 + ' - ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all
                end
              else
                prefix=''
                metad=[@tr.full_title,@tr.author,@tr.translator,@tr.illustrator,@tr.prepared_by,@tr.digitized_by,@tr.description,@tr.subject,@tr.abstract,@tr.publisher,@tr.contributor,@tr.date_created,@tr.date_issued,@tr.date_available,@tr.date_modified,@tr.date_valid,@tr.date,@tr.type,@tr.format,@tr.rights,@tr.identifier,@tr.source,@tr.language,@tr.language_original,@tr.relation,@tr.coverage,@tr.keywords,@tr.comments,@tr.cls_loc,@tr.cls_dewey,@tr.cls_gutenberg,@tr.cls_isbn,@tr.prefix_a,@tr.prefix_b,@tr.sourcefile,@tr.sourcefile_digest,@tr.last_generated,@tr.sisu_version,@tr.ruby_version,@tr.sc_number,@tr.sc_date,'Skin_Digest: ','Generated by: ','Ruby version: ']
                metad.each do |n|
                  m=rgx_txt(n)
                  if m=~/\S+/ \
                  and para=~/^#{m}:/
                    x,o=0,18
                    while x < 2; o = o + 2
                      x=o - n.length
                    end
                    space=' '*x
                    prefix="#{n.downcase}#{space}"
                    break
                  else prefix='  '*9
                  end
                end
                m_title=rgx_txt(@tr.full_title)
                m_author=rgx_txt(@tr.author)
                m_sourcefile_digest=rgx_txt(@tr.sourcefile_digest)
                m_sisu_version=rgx_txt(@tr.sisu_version)
                m_last_generated=rgx_txt(@tr.last_generated)
                m_ruby_version=rgx_txt(@tr.ruby_version)
                case para
                when /#{m_title}: /
                  @t=/#{m_title}: (.+?)#{Mx[:id_o]}~\d;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}[0-9a-f]{#@dl}:[0-9a-f]{#@dl}#{Mx[:id_c]}/.match(para)[1].gsub(/<\/?u>/,'').strip
                when /#{m_author}: /
                  @c=/#{m_author}: (.+?)#{Mx[:id_o]}~\d;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}[0-9a-f]{#@dl}:[0-9a-f]{#@dl}#{Mx[:id_c]}/.match(para)[1].gsub(/<\/?u>/,'').strip
                when /#{m_sourcefile_digest}.+?<u>/                                        #watch
                  dgst_extra="\n" + ' '*21 +'source' +' '*4 + @md.dgst[1] + ' '*34 + @md.fns
                when /Skin_Digest: /
                  dgst_extra="\n" + ' '*21 + 'skin' +' '*6 + @md.dgst_skin[1] + ' '*34 + /(skin_\S+?\.rb)/.match(@md.dgst_skin[0])[1]
                when /#{m_sisu_version}: /
                  @v=/#{m_sisu_version}: (.+?)#{Mx[:id_o]}~\d;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}[0-9a-f]{#@dl}:[0-9a-f]{#@dl}#{Mx[:id_c]}/.match(para)[1].gsub(/<\/?u>/,'').strip
                when /#{m_last_generated}: /
                  @g=/#{m_last_generated}: (.+?)#{Mx[:id_o]}~\d;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}[0-9a-f]{#@dl}:[0-9a-f]{#@dl}#{Mx[:id_c]}/.match(para)[1].gsub(/<\/?u>/,'').strip
 #                                                   'doc last generated'
                when /#{m_ruby_version}: /
                  @r=/#{m_ruby_version}: (.+?)#{Mx[:id_o]}~\d;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}[0-9a-f]{#@dl}:[0-9a-f]{#@dl}#{Mx[:id_c]}/.match(para)[1].gsub(/<\/?u>/,'').strip
                end
                dgst_extra ||=''
                "\n" + prefix +' - ' + ocn + ' '*(10-ocn.length) + d_clean + ' ' + d_all + dgst_extra + "\n"
              end
            end
            para_endnotes[0].each { |e| y << "\n" + ' '*(28-e[0].length) + "[#{e[0].to_s}] #{e[1].to_s}" } if para_endnotes[0]
            if y; digests(x,y)
            else  digests(x)
            end
          end
        end
        manifest="#{@env.url.root}/#{@md.fnb}/sisu_manifest.html"
        a=%{level (if any),      ocn:      digest clean (no markup/notes),  digest all (includes markup & endnotes)\n                       [endnote number] endnote digest clean\n}
        description("#@t\n")
        description("#@c\n")
        description("#{@md.fns}\n")
        description("----------------------------------------------\n")
        description("SiSU Document Content Certificate (Digest/DCC)\n")
        description("----------------------------------------------\n")
        description("                               #@dg digests\n")
        description("------------\n")
        description("Sourcefile digest:             #@s\n")
        description("  source filename:             #@n\n")
        description("available outputs:             #{manifest}\n")
        description("  time generated:                #@g\n")
        description("  SiSU version used:             #@v\n")
        description("  Ruby version used:             #@r\n")
        description("------------\n")
        description("Document Digest Tree (from dal):\n")
        description(a)
        #digests("------------\n")
        #digests("#@v\n")
        #digests("#@g\n")
        #digests("#@r\n")
      end
      def dal_structure
      #there will be a docubook mapping header, fairly complex variations
        data=@data
        l=Hash.new(0)
        dal_structure_tree("------------\n")
        dal_structure_tree("document structure[*]\n")
        ocn,endnotes=nil,nil
        data.each do |para|
          x=case para
          when /^#{Mx[:meta_o]}/; l[0] +=1
            if para =~/^#{Mx[:meta_o]}title#{Mx[:meta_c]}/; '' #'  '*0 +'@ == headers' + "\n" + '  '*0 +'headings:'
            end
          when /^#{Mx[:lv_o]}1:/; l[1] +=1
            '  '*0 +':A'
          when /^#{Mx[:lv_o]}2:/; l[2] +=1
            '  '*1 +':B'
          when /^#{Mx[:lv_o]}3:/; l[3] +=1
            '  '*2 +':C'
          when /^#{Mx[:lv_o]}4:/; l[4] +=1
            '  '*3 +'1'
          when /^#{Mx[:lv_o]}5:/; l[5] +=1
            '  '*4 +'2'
          when /^#{Mx[:lv_o]}6:/; l[6] +=1
            '  '*5 +'3'
          else nil
          end
          if para =~/#{Mx[:id_o]}~(\d+);(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}[0-9a-f]{#@dl}:[0-9a-f]{#@dl}#{Mx[:id_c]}/
            ocn=$1 unless $1.to_i == 0
          end
          if para =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+).+?#{Mx[:id_o]}[0-9a-f]{#@dl}#{Mx[:id_c]}(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/
            endnotes=$1 unless $1.to_i == 0
          end
          dal_structure_tree("#{x}\n") if x and not x.empty?
        end
        dal_structure_tree("  [*] heading levels\n")
        dal_structure_summary("------------\n")
        dal_structure_summary("document structure[*]\n")
        [0,1,2,3,4,5,6].each do |y|
          v=case y.to_s
          when /0/; '@ '
          when /1/; ':A'
          when /2/; ':B'
          when /3/; ':C'
          when /4/; '1 '
          when /5/; '2 '
          when /6/; '3 '
          end
          dal_structure_summary("#{v}            = #{l[y]}\n") if l[y] > 0
        end
        dal_structure_summary("objects (ocn) = #{ocn}\n")
        dal_structure_summary("endnotes      = #{endnotes}\n")
        dal_structure_summary("  [*] number of headers (@) and of each heading level (:A to :C and 1 to 3)\n")
      end
      def supplementary
        if defined? @md.sc_number \
        and @md.sc_number
          rcinfo("------------\n")
          rcinfo("source control information\n")
          rcinfo("  (the following information while not important for document content certification\n   may help the publisher in locating the version referred to)\n")
          rcinfo("  rcs version number:            #{@md.sc_number}\n")
          if defined? @md.sc_date \
          and @md.sc_date
            rcinfo("  rcs date:                      #{@md.sc_date}\n")
          end
          if defined? @md.sc_time \
          and @md.sc_time
            rcinfo("  rcs time:                      #{@md.sc_time}\n")
          end
        end
        rcinfo("------------\n")
        rcinfo("Note: the time generated related fields (text and digests) will vary between otherwise identical document outputs\n")
      end
    end
  end
end
__END__

