/*
 * __BEGIN_COPYRIGHT
 * SimpleDB API
 * 
 * Copyright (C) 2005 Eminence Technology Pty Ltd
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can view the GNU Lesser General Public Licence at
 * http://www.gnu.org/licenses/lgpl.html or you can write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Eminence Technology Pty Ltd can be contacted by writing to
 * Eminence Technology, PO Box 118, Moorooka QLD 4105, Australia.
 * Alternatively, you may email opensource [at] eminence [dot] com [dot] au
 * __END_COPYRIGHT
 */

/** \mainpage
 *
 * The SimpleDB API is a C++ API designed to encapsulate the ODBC API 
 * functionality in an object oriented manner.
 * The API has been tested to work with both MySql and PostGreSQL on
 * a Debian Linux platform.
 *
 * \version
 * __BEGIN_VERSION
 * 1.5
 * __END_VERSION
 *
 * $Date: 2006/01/05 00:31:15 $
 *
 * <h2>Download</h2>
 * The API can be downloaded from our
 * <a target="sourceforge" href="http://sourceforge.net/projects/simpledb/">sourceforge project page</a>.
 *
 * <h2>API Description</h2>
 *
 * The SimpleDB API is a C++ API designed to encapsulate
 * the ODBC API functionality in an object oriented manner.
 *
 * The API was created due to an absence of any other such
 * API that was database independent. The database
 * independence is achieved using the ODBC (Open DataBase
 * Connectivity) API.
 *
 * The API provides a Database object that can be used to
 * create instances of Query objects. The Query objects
 * are used to query a database and allow columns to be
 * bound for the query.
 *
 * The flowing column objects are currently available (as
 * of Jan 2005): a boolean column, a long column and a
 * string column. The string column makes use of the
 * libstdc++ string class so you don't have to mess around
 * with malloc.
 *
 * The Database object also has some convenience member
 * functions that allow queries that return a single
 * integer or string to be executed without having to
 * create a query object or bind columns. 
 *
 * The API has been tested to work with both MySql and
 * PostGreSQL on a Debian Linux platform.
 *
 * Example usage: see simple.cpp
 *
 * <h2>Further Info</h2>
 * Have a look at the \ref faq. For any queries or to contact the
 * developers, please go to
 * our <a href="http://sourceforge.net/projects/simpledb/">project page</a>.
 *
 * \todo Make the query object inherit from stringstream so queries can be streamed into a query.
 * When the query is executed, it will execute it's internal string.  The stream could have io stream modifiers
 * which tell the stream to escape what comes after.(e.g instead of calling db->escapeString())
 * Additionally you could make the stream convert boolean values to the right ones for a given database.
 * Almost a locale for database, could use facets on the stream.
 *  
 * \todo Make the query.execute() thread safe to ensure that threads with the same database handle
 * cannot execute queries simultaneously (ODBC querying is NOT thread safe).  
 * Investigate where the mutex needs to happen.  Look at fetchRow() - it
 * calls the ODBC world for its information (but this may have a unique Id which is thread safe 
 * - as in the data is stored in ODBC world and other queries can be executed around it).
 *
 */

/** \namespace SimpleDB
 * The namespace for the Simple %Database API
 */

/** \example complete.cpp 
 * This is an example of how to use the Simple %Database API.
 * This example makes use of just about all of the functionality. 
 * The test consists of the following steps:
 *
 * \li Create the columns that will be bound to the query.
 * \li Connect to the data source.
 * \li Create a query object from the database.
 * \li Bind the columns to the query.
 * \li Execute the query.
 * \li Fetch the results of the query.
 */ 

/** \example simple.cpp 
 * This is a simple example of how to use the Simple %Database API. 
 * The test consists of the following steps:
 *
 * \li Connect to the data source.
 * \li Create a query object from the database.
 * \li Create the columns that will be bound to the query.
 * \li Bind the columns to the query.
 * \li Execute the query.
 * \li Fetch the result of the query.
 */

/** \example factory.cpp
 * This is a simple example of how to instantiate and then interface to the handle factory.
 * \li Instantiate the factory
 * \li Retrieve a handle from it.
 * \li Perform a query on the handle returned
 * \li deallocate memory created by factory when finished with handle.
 * 
 */


/** \page faq Frequently Asked Questions
 * \section Q1 Will libSimpleDB run on Linux distribution X with database Y?
 * libSimpleDB makes use of the ODBC API. Therefore, libSimpleDB should run
 * on any platform providing this. We have used libSimpleDB on Debian Linux
 * with both unixodbc and iodbc.
 *
 * Any database that has an ODBC driver should be useable. All
 * of the popular databases that we know of do provide ODBC drivers.
 * Check your distribution's packages or go to your database's website.
 */


#include "Column.h"
#include "Query.h"
#include "Database.h"
#include "SimpleDBFactory.h"
#include "Exception.h"
