/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_lsa.h"

struct rpccli_lsa_Close_state {
	struct lsa_Close orig;
	struct lsa_Close tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_Close_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_Close_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct rpc_pipe_client *cli,
					 struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_Close_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_Close_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Close, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_Close_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CLOSE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_Close_done, req);
	return req;
}

static void rpccli_lsa_Close_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_Close_state *state = tevent_req_data(
		req, struct rpccli_lsa_Close_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Close, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_Close_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       NTSTATUS *result)
{
	struct rpccli_lsa_Close_state *state = tevent_req_data(
		req, struct rpccli_lsa_Close_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_Close(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct policy_handle *handle /* [in,out] [ref] */)
{
	struct lsa_Close r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Close, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CLOSE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Close, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_Delete_state {
	struct lsa_Delete orig;
	struct lsa_Delete tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_Delete_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_Delete_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_Delete_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_Delete_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Delete, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_DELETE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_Delete_done, req);
	return req;
}

static void rpccli_lsa_Delete_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_Delete_state *state = tevent_req_data(
		req, struct rpccli_lsa_Delete_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Delete, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_Delete_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				NTSTATUS *result)
{
	struct rpccli_lsa_Delete_state *state = tevent_req_data(
		req, struct rpccli_lsa_Delete_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_Delete(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct policy_handle *handle /* [in] [ref] */)
{
	struct lsa_Delete r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Delete, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_DELETE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Delete, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumPrivs_state {
	struct lsa_EnumPrivs orig;
	struct lsa_EnumPrivs tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumPrivs_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumPrivs_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t *_resume_handle /* [in,out] [ref] */,
					     struct lsa_PrivArray *_privs /* [out] [ref] */,
					     uint32_t _max_count /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumPrivs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumPrivs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_count = _max_count;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.privs = _privs;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivs, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumPrivs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMPRIVS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumPrivs_done, req);
	return req;
}

static void rpccli_lsa_EnumPrivs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumPrivs_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumPrivs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.privs = *state->tmp.out.privs;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivs, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumPrivs_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_lsa_EnumPrivs_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumPrivs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumPrivs(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *handle /* [in] [ref] */,
			      uint32_t *resume_handle /* [in,out] [ref] */,
			      struct lsa_PrivArray *privs /* [out] [ref] */,
			      uint32_t max_count /* [in]  */)
{
	struct lsa_EnumPrivs r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.max_count = max_count;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivs, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMPRIVS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivs, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*privs = *r.out.privs;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QuerySecurity_state {
	struct lsa_QuerySecurity orig;
	struct lsa_QuerySecurity tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QuerySecurity_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QuerySecurity_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_handle /* [in] [ref] */,
						 uint32_t _sec_info /* [in]  */,
						 struct sec_desc_buf **_sdbuf /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QuerySecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QuerySecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;

	/* Out parameters */
	state->orig.out.sdbuf = _sdbuf;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecurity, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QuerySecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYSECURITY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QuerySecurity_done, req);
	return req;
}

static void rpccli_lsa_QuerySecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QuerySecurity_state *state = tevent_req_data(
		req, struct rpccli_lsa_QuerySecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sdbuf = *state->tmp.out.sdbuf;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecurity, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QuerySecurity_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_lsa_QuerySecurity_state *state = tevent_req_data(
		req, struct rpccli_lsa_QuerySecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QuerySecurity(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  uint32_t sec_info /* [in]  */,
				  struct sec_desc_buf **sdbuf /* [out] [ref] */)
{
	struct lsa_QuerySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sec_info = sec_info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecurity, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYSECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sdbuf = *r.out.sdbuf;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetSecObj_state {
	struct lsa_SetSecObj orig;
	struct lsa_SetSecObj tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetSecObj_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetSecObj_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _sec_info /* [in]  */,
					     struct sec_desc_buf *_sdbuf /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetSecObj_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetSecObj_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sec_info = _sec_info;
	state->orig.in.sdbuf = _sdbuf;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecObj, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETSECOBJ,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetSecObj_done, req);
	return req;
}

static void rpccli_lsa_SetSecObj_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetSecObj_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetSecObj_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecObj, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetSecObj_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_lsa_SetSecObj_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetSecObj_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetSecObj(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *handle /* [in] [ref] */,
			      uint32_t sec_info /* [in]  */,
			      struct sec_desc_buf *sdbuf /* [in] [ref] */)
{
	struct lsa_SetSecObj r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sec_info = sec_info;
	r.in.sdbuf = sdbuf;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecObj, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETSECOBJ,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecObj, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_ChangePassword_state {
	struct lsa_ChangePassword orig;
	struct lsa_ChangePassword tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_ChangePassword_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_ChangePassword_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_ChangePassword_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_ChangePassword_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ChangePassword, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CHANGEPASSWORD,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_ChangePassword_done, req);
	return req;
}

static void rpccli_lsa_ChangePassword_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_ChangePassword_state *state = tevent_req_data(
		req, struct rpccli_lsa_ChangePassword_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ChangePassword, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_ChangePassword_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_lsa_ChangePassword_state *state = tevent_req_data(
		req, struct rpccli_lsa_ChangePassword_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_ChangePassword(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx)
{
	struct lsa_ChangePassword r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ChangePassword, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CHANGEPASSWORD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ChangePassword, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_OpenPolicy_state {
	struct lsa_OpenPolicy orig;
	struct lsa_OpenPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_OpenPolicy_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_OpenPolicy_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      uint16_t *_system_name /* [in] [unique] */,
					      struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_OpenPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_OpenPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.attr = _attr;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_OpenPolicy_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_OPENPOLICY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_OpenPolicy_done, req);
	return req;
}

static void rpccli_lsa_OpenPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_OpenPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_OpenPolicy_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct rpccli_lsa_OpenPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_OpenPolicy(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *system_name /* [in] [unique] */,
			       struct lsa_ObjectAttribute *attr /* [in] [ref] */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *handle /* [out] [ref] */)
{
	struct lsa_OpenPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.attr = attr;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QueryInfoPolicy_state {
	struct lsa_QueryInfoPolicy orig;
	struct lsa_QueryInfoPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QueryInfoPolicy_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QueryInfoPolicy_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct policy_handle *_handle /* [in] [ref] */,
						   enum lsa_PolicyInfo _level /* [in]  */,
						   union lsa_PolicyInformation **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QueryInfoPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QueryInfoPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QueryInfoPolicy_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYINFOPOLICY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QueryInfoPolicy_done, req);
	return req;
}

static void rpccli_lsa_QueryInfoPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QueryInfoPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryInfoPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QueryInfoPolicy_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct rpccli_lsa_QueryInfoPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryInfoPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QueryInfoPolicy(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    enum lsa_PolicyInfo level /* [in]  */,
				    union lsa_PolicyInformation **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryInfoPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYINFOPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetInfoPolicy_state {
	struct lsa_SetInfoPolicy orig;
	struct lsa_SetInfoPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetInfoPolicy_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetInfoPolicy_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_handle /* [in] [ref] */,
						 enum lsa_PolicyInfo _level /* [in]  */,
						 union lsa_PolicyInformation *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetInfoPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetInfoPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETINFOPOLICY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetInfoPolicy_done, req);
	return req;
}

static void rpccli_lsa_SetInfoPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetInfoPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetInfoPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetInfoPolicy_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_lsa_SetInfoPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetInfoPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetInfoPolicy(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  enum lsa_PolicyInfo level /* [in]  */,
				  union lsa_PolicyInformation *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetInfoPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETINFOPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_ClearAuditLog_state {
	struct lsa_ClearAuditLog orig;
	struct lsa_ClearAuditLog tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_ClearAuditLog_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_ClearAuditLog_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_ClearAuditLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_ClearAuditLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ClearAuditLog, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CLEARAUDITLOG,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_ClearAuditLog_done, req);
	return req;
}

static void rpccli_lsa_ClearAuditLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_ClearAuditLog_state *state = tevent_req_data(
		req, struct rpccli_lsa_ClearAuditLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ClearAuditLog, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_ClearAuditLog_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_lsa_ClearAuditLog_state *state = tevent_req_data(
		req, struct rpccli_lsa_ClearAuditLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_ClearAuditLog(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx)
{
	struct lsa_ClearAuditLog r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ClearAuditLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CLEARAUDITLOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ClearAuditLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CreateAccount_state {
	struct lsa_CreateAccount orig;
	struct lsa_CreateAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CreateAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CreateAccount_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct policy_handle *_handle /* [in] [ref] */,
						 struct dom_sid2 *_sid /* [in] [ref] */,
						 uint32_t _access_mask /* [in]  */,
						 struct policy_handle *_acct_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_CreateAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CreateAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.acct_handle = _acct_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateAccount, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_CreateAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREATEACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CreateAccount_done, req);
	return req;
}

static void rpccli_lsa_CreateAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CreateAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.acct_handle = *state->tmp.out.acct_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CreateAccount_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_lsa_CreateAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CreateAccount(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  struct dom_sid2 *sid /* [in] [ref] */,
				  uint32_t access_mask /* [in]  */,
				  struct policy_handle *acct_handle /* [out] [ref] */)
{
	struct lsa_CreateAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATEACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*acct_handle = *r.out.acct_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumAccounts_state {
	struct lsa_EnumAccounts orig;
	struct lsa_EnumAccounts tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumAccounts_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumAccounts_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t *_resume_handle /* [in,out] [ref] */,
						struct lsa_SidArray *_sids /* [out] [ref] */,
						uint32_t _num_entries /* [in] [range(0,8192)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumAccounts_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumAccounts_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.num_entries = _num_entries;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.sids = _sids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccounts, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumAccounts_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMACCOUNTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumAccounts_done, req);
	return req;
}

static void rpccli_lsa_EnumAccounts_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumAccounts_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumAccounts_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccounts, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumAccounts_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_EnumAccounts_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumAccounts_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumAccounts(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t *resume_handle /* [in,out] [ref] */,
				 struct lsa_SidArray *sids /* [out] [ref] */,
				 uint32_t num_entries /* [in] [range(0,8192)] */)
{
	struct lsa_EnumAccounts r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.num_entries = num_entries;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccounts, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMACCOUNTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccounts, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*sids = *r.out.sids;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CreateTrustedDomain_state {
	struct lsa_CreateTrustedDomain orig;
	struct lsa_CreateTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CreateTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CreateTrustedDomain_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct policy_handle *_policy_handle /* [in] [ref] */,
						       struct lsa_DomainInfo *_info /* [in] [ref] */,
						       uint32_t _access_mask /* [in]  */,
						       struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_CreateTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CreateTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomain, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_CreateTrustedDomain_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREATETRUSTEDDOMAIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CreateTrustedDomain_done, req);
	return req;
}

static void rpccli_lsa_CreateTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CreateTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomain, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CreateTrustedDomain_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_lsa_CreateTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CreateTrustedDomain(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *policy_handle /* [in] [ref] */,
					struct lsa_DomainInfo *info /* [in] [ref] */,
					uint32_t access_mask /* [in]  */,
					struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_CreateTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = policy_handle;
	r.in.info = info;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATETRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumTrustDom_state {
	struct lsa_EnumTrustDom orig;
	struct lsa_EnumTrustDom tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumTrustDom_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumTrustDom_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t *_resume_handle /* [in,out] [ref] */,
						struct lsa_DomainList *_domains /* [out] [ref] */,
						uint32_t _max_size /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumTrustDom_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumTrustDom_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.domains = _domains;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustDom, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumTrustDom_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMTRUSTDOM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumTrustDom_done, req);
	return req;
}

static void rpccli_lsa_EnumTrustDom_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumTrustDom_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumTrustDom_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.domains = *state->tmp.out.domains;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustDom, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumTrustDom_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_EnumTrustDom_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumTrustDom_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumTrustDom(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t *resume_handle /* [in,out] [ref] */,
				 struct lsa_DomainList *domains /* [out] [ref] */,
				 uint32_t max_size /* [in]  */)
{
	struct lsa_EnumTrustDom r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.max_size = max_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustDom, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMTRUSTDOM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustDom, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*domains = *r.out.domains;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupNames_state {
	struct lsa_LookupNames orig;
	struct lsa_LookupNames tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupNames_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupNames_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _num_names /* [in] [range(0,1000)] */,
					       struct lsa_String *_names /* [in] [size_is(num_names)] */,
					       struct lsa_RefDomainList **_domains /* [out] [ref] */,
					       struct lsa_TransSidArray *_sids /* [in,out] [ref] */,
					       enum lsa_LookupNamesLevel _level /* [in]  */,
					       uint32_t *_count /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPNAMES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupNames_done, req);
	return req;
}

static void rpccli_lsa_LookupNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupNames_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupNames_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_LookupNames_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupNames(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				uint32_t num_names /* [in] [range(0,1000)] */,
				struct lsa_String *names /* [in] [size_is(num_names)] */,
				struct lsa_RefDomainList **domains /* [out] [ref] */,
				struct lsa_TransSidArray *sids /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel level /* [in]  */,
				uint32_t *count /* [in,out] [ref] */)
{
	struct lsa_LookupNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupSids_state {
	struct lsa_LookupSids orig;
	struct lsa_LookupSids tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupSids_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupSids_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct lsa_SidArray *_sids /* [in] [ref] */,
					      struct lsa_RefDomainList **_domains /* [out] [ref] */,
					      struct lsa_TransNameArray *_names /* [in,out] [ref] */,
					      enum lsa_LookupNamesLevel _level /* [in]  */,
					      uint32_t *_count /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupSids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupSids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sids = _sids;
	state->orig.in.names = _names;
	state->orig.in.level = _level;
	state->orig.in.count = _count;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupSids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPSIDS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupSids_done, req);
	return req;
}

static void rpccli_lsa_LookupSids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupSids_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupSids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupSids_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct rpccli_lsa_LookupSids_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupSids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupSids(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct lsa_SidArray *sids /* [in] [ref] */,
			       struct lsa_RefDomainList **domains /* [out] [ref] */,
			       struct lsa_TransNameArray *names /* [in,out] [ref] */,
			       enum lsa_LookupNamesLevel level /* [in]  */,
			       uint32_t *count /* [in,out] [ref] */)
{
	struct lsa_LookupSids r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sids = sids;
	r.in.names = names;
	r.in.level = level;
	r.in.count = count;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPSIDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*names = *r.out.names;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CreateSecret_state {
	struct lsa_CreateSecret orig;
	struct lsa_CreateSecret tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CreateSecret_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CreateSecret_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						struct lsa_String _name /* [in]  */,
						uint32_t _access_mask /* [in]  */,
						struct policy_handle *_sec_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_CreateSecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CreateSecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.sec_handle = _sec_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateSecret, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_CreateSecret_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREATESECRET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CreateSecret_done, req);
	return req;
}

static void rpccli_lsa_CreateSecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CreateSecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateSecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sec_handle = *state->tmp.out.sec_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateSecret, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CreateSecret_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_CreateSecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateSecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CreateSecret(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 struct lsa_String name /* [in]  */,
				 uint32_t access_mask /* [in]  */,
				 struct policy_handle *sec_handle /* [out] [ref] */)
{
	struct lsa_CreateSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateSecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATESECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateSecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sec_handle = *r.out.sec_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_OpenAccount_state {
	struct lsa_OpenAccount orig;
	struct lsa_OpenAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_OpenAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_OpenAccount_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct dom_sid2 *_sid /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_acct_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_OpenAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_OpenAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.acct_handle = _acct_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenAccount, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_OpenAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_OPENACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_OpenAccount_done, req);
	return req;
}

static void rpccli_lsa_OpenAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_OpenAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.acct_handle = *state->tmp.out.acct_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_OpenAccount_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_OpenAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_OpenAccount(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				struct dom_sid2 *sid /* [in] [ref] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *acct_handle /* [out] [ref] */)
{
	struct lsa_OpenAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*acct_handle = *r.out.acct_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumPrivsAccount_state {
	struct lsa_EnumPrivsAccount orig;
	struct lsa_EnumPrivsAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumPrivsAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumPrivsAccount_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct lsa_PrivilegeSet **_privs /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumPrivsAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumPrivsAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.privs = _privs;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivsAccount, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumPrivsAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMPRIVSACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumPrivsAccount_done, req);
	return req;
}

static void rpccli_lsa_EnumPrivsAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumPrivsAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumPrivsAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.privs = *state->tmp.out.privs;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivsAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumPrivsAccount_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct rpccli_lsa_EnumPrivsAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumPrivsAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumPrivsAccount(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     struct lsa_PrivilegeSet **privs /* [out] [ref] */)
{
	struct lsa_EnumPrivsAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivsAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMPRIVSACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivsAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*privs = *r.out.privs;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_AddPrivilegesToAccount_state {
	struct lsa_AddPrivilegesToAccount orig;
	struct lsa_AddPrivilegesToAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_AddPrivilegesToAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_AddPrivilegesToAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct lsa_PrivilegeSet *_privs /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_AddPrivilegesToAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_AddPrivilegesToAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.privs = _privs;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddPrivilegesToAccount, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ADDPRIVILEGESTOACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_AddPrivilegesToAccount_done, req);
	return req;
}

static void rpccli_lsa_AddPrivilegesToAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_AddPrivilegesToAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_AddPrivilegesToAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddPrivilegesToAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_AddPrivilegesToAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_lsa_AddPrivilegesToAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_AddPrivilegesToAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_AddPrivilegesToAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   struct lsa_PrivilegeSet *privs /* [in] [ref] */)
{
	struct lsa_AddPrivilegesToAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.privs = privs;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddPrivilegesToAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ADDPRIVILEGESTOACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddPrivilegesToAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_RemovePrivilegesFromAccount_state {
	struct lsa_RemovePrivilegesFromAccount orig;
	struct lsa_RemovePrivilegesFromAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_RemovePrivilegesFromAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_RemovePrivilegesFromAccount_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct rpc_pipe_client *cli,
							       struct policy_handle *_handle /* [in] [ref] */,
							       uint8_t _remove_all /* [in]  */,
							       struct lsa_PrivilegeSet *_privs /* [in] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_RemovePrivilegesFromAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_RemovePrivilegesFromAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.remove_all = _remove_all;
	state->orig.in.privs = _privs;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemovePrivilegesFromAccount, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_RemovePrivilegesFromAccount_done, req);
	return req;
}

static void rpccli_lsa_RemovePrivilegesFromAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_RemovePrivilegesFromAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_RemovePrivilegesFromAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemovePrivilegesFromAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_RemovePrivilegesFromAccount_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct rpccli_lsa_RemovePrivilegesFromAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_RemovePrivilegesFromAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_RemovePrivilegesFromAccount(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *handle /* [in] [ref] */,
						uint8_t remove_all /* [in]  */,
						struct lsa_PrivilegeSet *privs /* [in] [unique] */)
{
	struct lsa_RemovePrivilegesFromAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.remove_all = remove_all;
	r.in.privs = privs;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemovePrivilegesFromAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemovePrivilegesFromAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_GetQuotasForAccount_state {
	struct lsa_GetQuotasForAccount orig;
	struct lsa_GetQuotasForAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_GetQuotasForAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_GetQuotasForAccount_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_GetQuotasForAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_GetQuotasForAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetQuotasForAccount, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_GETQUOTASFORACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_GetQuotasForAccount_done, req);
	return req;
}

static void rpccli_lsa_GetQuotasForAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_GetQuotasForAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_GetQuotasForAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetQuotasForAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_GetQuotasForAccount_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_lsa_GetQuotasForAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_GetQuotasForAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_GetQuotasForAccount(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct lsa_GetQuotasForAccount r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetQuotasForAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_GETQUOTASFORACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetQuotasForAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetQuotasForAccount_state {
	struct lsa_SetQuotasForAccount orig;
	struct lsa_SetQuotasForAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetQuotasForAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetQuotasForAccount_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetQuotasForAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetQuotasForAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetQuotasForAccount, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETQUOTASFORACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetQuotasForAccount_done, req);
	return req;
}

static void rpccli_lsa_SetQuotasForAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetQuotasForAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetQuotasForAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetQuotasForAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetQuotasForAccount_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_lsa_SetQuotasForAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetQuotasForAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetQuotasForAccount(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct lsa_SetQuotasForAccount r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetQuotasForAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETQUOTASFORACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetQuotasForAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_GetSystemAccessAccount_state {
	struct lsa_GetSystemAccessAccount orig;
	struct lsa_GetSystemAccessAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_GetSystemAccessAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_GetSystemAccessAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t *_access_mask /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_GetSystemAccessAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_GetSystemAccessAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.access_mask = _access_mask;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetSystemAccessAccount, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_GetSystemAccessAccount_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_GETSYSTEMACCESSACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_GetSystemAccessAccount_done, req);
	return req;
}

static void rpccli_lsa_GetSystemAccessAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_GetSystemAccessAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_GetSystemAccessAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.access_mask = *state->tmp.out.access_mask;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetSystemAccessAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_GetSystemAccessAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_lsa_GetSystemAccessAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_GetSystemAccessAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_GetSystemAccessAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t *access_mask /* [out] [ref] */)
{
	struct lsa_GetSystemAccessAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetSystemAccessAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_GETSYSTEMACCESSACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetSystemAccessAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*access_mask = *r.out.access_mask;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetSystemAccessAccount_state {
	struct lsa_SetSystemAccessAccount orig;
	struct lsa_SetSystemAccessAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetSystemAccessAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetSystemAccessAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _access_mask /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetSystemAccessAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetSystemAccessAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSystemAccessAccount, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETSYSTEMACCESSACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetSystemAccessAccount_done, req);
	return req;
}

static void rpccli_lsa_SetSystemAccessAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetSystemAccessAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetSystemAccessAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSystemAccessAccount, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetSystemAccessAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_lsa_SetSystemAccessAccount_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetSystemAccessAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetSystemAccessAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t access_mask /* [in]  */)
{
	struct lsa_SetSystemAccessAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSystemAccessAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETSYSTEMACCESSACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSystemAccessAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_OpenTrustedDomain_state {
	struct lsa_OpenTrustedDomain orig;
	struct lsa_OpenTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_OpenTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_OpenTrustedDomain_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     struct dom_sid2 *_sid /* [in] [ref] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_OpenTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_OpenTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomain, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_OpenTrustedDomain_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_OPENTRUSTEDDOMAIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_OpenTrustedDomain_done, req);
	return req;
}

static void rpccli_lsa_OpenTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_OpenTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomain, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_OpenTrustedDomain_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_lsa_OpenTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_OpenTrustedDomain(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      struct dom_sid2 *sid /* [in] [ref] */,
				      uint32_t access_mask /* [in]  */,
				      struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_OpenTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENTRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QueryTrustedDomainInfo_state {
	struct lsa_QueryTrustedDomainInfo orig;
	struct lsa_QueryTrustedDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QueryTrustedDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QueryTrustedDomainInfo_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_trustdom_handle /* [in] [ref] */,
							  enum lsa_TrustDomInfoEnum _level /* [in]  */,
							  union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QueryTrustedDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QueryTrustedDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.trustdom_handle = _trustdom_handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfo, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QueryTrustedDomainInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYTRUSTEDDOMAININFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QueryTrustedDomainInfo_done, req);
	return req;
}

static void rpccli_lsa_QueryTrustedDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QueryTrustedDomainInfo_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryTrustedDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfo, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfo_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_lsa_QueryTrustedDomainInfo_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryTrustedDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfo(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *trustdom_handle /* [in] [ref] */,
					   enum lsa_TrustDomInfoEnum level /* [in]  */,
					   union lsa_TrustedDomainInfo **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryTrustedDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.trustdom_handle = trustdom_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYTRUSTEDDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetInformationTrustedDomain_state {
	struct lsa_SetInformationTrustedDomain orig;
	struct lsa_SetInformationTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetInformationTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetInformationTrustedDomain_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct rpc_pipe_client *cli,
							       struct policy_handle *_trustdom_handle /* [in] [ref] */,
							       enum lsa_TrustDomInfoEnum _level /* [in]  */,
							       union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetInformationTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetInformationTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.trustdom_handle = _trustdom_handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInformationTrustedDomain, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetInformationTrustedDomain_done, req);
	return req;
}

static void rpccli_lsa_SetInformationTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetInformationTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetInformationTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInformationTrustedDomain, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetInformationTrustedDomain_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct rpccli_lsa_SetInformationTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetInformationTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetInformationTrustedDomain(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *trustdom_handle /* [in] [ref] */,
						enum lsa_TrustDomInfoEnum level /* [in]  */,
						union lsa_TrustedDomainInfo *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetInformationTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.trustdom_handle = trustdom_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInformationTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInformationTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_OpenSecret_state {
	struct lsa_OpenSecret orig;
	struct lsa_OpenSecret tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_OpenSecret_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_OpenSecret_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      struct policy_handle *_handle /* [in] [ref] */,
					      struct lsa_String _name /* [in]  */,
					      uint32_t _access_mask /* [in]  */,
					      struct policy_handle *_sec_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_OpenSecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_OpenSecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.sec_handle = _sec_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenSecret, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_OpenSecret_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_OPENSECRET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_OpenSecret_done, req);
	return req;
}

static void rpccli_lsa_OpenSecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_OpenSecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenSecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sec_handle = *state->tmp.out.sec_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenSecret, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_OpenSecret_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct rpccli_lsa_OpenSecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenSecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_OpenSecret(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct lsa_String name /* [in]  */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *sec_handle /* [out] [ref] */)
{
	struct lsa_OpenSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenSecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENSECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenSecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sec_handle = *r.out.sec_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetSecret_state {
	struct lsa_SetSecret orig;
	struct lsa_SetSecret tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetSecret_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetSecret_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     struct policy_handle *_sec_handle /* [in] [ref] */,
					     struct lsa_DATA_BUF *_new_val /* [in] [unique] */,
					     struct lsa_DATA_BUF *_old_val /* [in] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetSecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetSecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sec_handle = _sec_handle;
	state->orig.in.new_val = _new_val;
	state->orig.in.old_val = _old_val;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecret, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETSECRET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetSecret_done, req);
	return req;
}

static void rpccli_lsa_SetSecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetSecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetSecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecret, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetSecret_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_lsa_SetSecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetSecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetSecret(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *sec_handle /* [in] [ref] */,
			      struct lsa_DATA_BUF *new_val /* [in] [unique] */,
			      struct lsa_DATA_BUF *old_val /* [in] [unique] */)
{
	struct lsa_SetSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.sec_handle = sec_handle;
	r.in.new_val = new_val;
	r.in.old_val = old_val;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETSECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QuerySecret_state {
	struct lsa_QuerySecret orig;
	struct lsa_QuerySecret tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QuerySecret_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QuerySecret_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_sec_handle /* [in] [ref] */,
					       struct lsa_DATA_BUF_PTR *_new_val /* [in,out] [unique] */,
					       NTTIME *_new_mtime /* [in,out] [unique] */,
					       struct lsa_DATA_BUF_PTR *_old_val /* [in,out] [unique] */,
					       NTTIME *_old_mtime /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QuerySecret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QuerySecret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sec_handle = _sec_handle;
	state->orig.in.new_val = _new_val;
	state->orig.in.new_mtime = _new_mtime;
	state->orig.in.old_val = _old_val;
	state->orig.in.old_mtime = _old_mtime;

	/* Out parameters */
	state->orig.out.new_val = _new_val;
	state->orig.out.new_mtime = _new_mtime;
	state->orig.out.old_val = _old_val;
	state->orig.out.old_mtime = _old_mtime;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecret, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QuerySecret_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYSECRET,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QuerySecret_done, req);
	return req;
}

static void rpccli_lsa_QuerySecret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QuerySecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_QuerySecret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.new_val && state->tmp.out.new_val) {
		*state->orig.out.new_val = *state->tmp.out.new_val;
	}
	if (state->orig.out.new_mtime && state->tmp.out.new_mtime) {
		*state->orig.out.new_mtime = *state->tmp.out.new_mtime;
	}
	if (state->orig.out.old_val && state->tmp.out.old_val) {
		*state->orig.out.old_val = *state->tmp.out.old_val;
	}
	if (state->orig.out.old_mtime && state->tmp.out.old_mtime) {
		*state->orig.out.old_mtime = *state->tmp.out.old_mtime;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecret, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QuerySecret_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_QuerySecret_state *state = tevent_req_data(
		req, struct rpccli_lsa_QuerySecret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QuerySecret(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *sec_handle /* [in] [ref] */,
				struct lsa_DATA_BUF_PTR *new_val /* [in,out] [unique] */,
				NTTIME *new_mtime /* [in,out] [unique] */,
				struct lsa_DATA_BUF_PTR *old_val /* [in,out] [unique] */,
				NTTIME *old_mtime /* [in,out] [unique] */)
{
	struct lsa_QuerySecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.sec_handle = sec_handle;
	r.in.new_val = new_val;
	r.in.new_mtime = new_mtime;
	r.in.old_val = old_val;
	r.in.old_mtime = old_mtime;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYSECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (new_val && r.out.new_val) {
		*new_val = *r.out.new_val;
	}
	if (new_mtime && r.out.new_mtime) {
		*new_mtime = *r.out.new_mtime;
	}
	if (old_val && r.out.old_val) {
		*old_val = *r.out.old_val;
	}
	if (old_mtime && r.out.old_mtime) {
		*old_mtime = *r.out.old_mtime;
	}

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupPrivValue_state {
	struct lsa_LookupPrivValue orig;
	struct lsa_LookupPrivValue tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupPrivValue_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupPrivValue_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct policy_handle *_handle /* [in] [ref] */,
						   struct lsa_String *_name /* [in] [ref] */,
						   struct lsa_LUID *_luid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupPrivValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupPrivValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.luid = _luid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivValue, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupPrivValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPPRIVVALUE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupPrivValue_done, req);
	return req;
}

static void rpccli_lsa_LookupPrivValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupPrivValue_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupPrivValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.luid = *state->tmp.out.luid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivValue, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupPrivValue_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct rpccli_lsa_LookupPrivValue_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupPrivValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupPrivValue(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    struct lsa_String *name /* [in] [ref] */,
				    struct lsa_LUID *luid /* [out] [ref] */)
{
	struct lsa_LookupPrivValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivValue, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPPRIVVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivValue, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*luid = *r.out.luid;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupPrivName_state {
	struct lsa_LookupPrivName orig;
	struct lsa_LookupPrivName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupPrivName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupPrivName_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct lsa_LUID *_luid /* [in] [ref] */,
						  struct lsa_StringLarge **_name /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupPrivName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupPrivName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.luid = _luid;

	/* Out parameters */
	state->orig.out.name = _name;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivName, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupPrivName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPPRIVNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupPrivName_done, req);
	return req;
}

static void rpccli_lsa_LookupPrivName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupPrivName_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupPrivName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name = *state->tmp.out.name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivName, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupPrivName_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_lsa_LookupPrivName_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupPrivName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupPrivName(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   struct lsa_LUID *luid /* [in] [ref] */,
				   struct lsa_StringLarge **name /* [out] [ref] */)
{
	struct lsa_LookupPrivName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.luid = luid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPPRIVNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*name = *r.out.name;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupPrivDisplayName_state {
	struct lsa_LookupPrivDisplayName orig;
	struct lsa_LookupPrivDisplayName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupPrivDisplayName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupPrivDisplayName_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct policy_handle *_handle /* [in] [ref] */,
							 struct lsa_String *_name /* [in] [ref] */,
							 uint16_t _language_id /* [in]  */,
							 uint16_t _language_id_sys /* [in]  */,
							 struct lsa_StringLarge **_disp_name /* [out] [ref] */,
							 uint16_t *_returned_language_id /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupPrivDisplayName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupPrivDisplayName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.language_id = _language_id;
	state->orig.in.language_id_sys = _language_id_sys;

	/* Out parameters */
	state->orig.out.disp_name = _disp_name;
	state->orig.out.returned_language_id = _returned_language_id;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivDisplayName, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupPrivDisplayName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPPRIVDISPLAYNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupPrivDisplayName_done, req);
	return req;
}

static void rpccli_lsa_LookupPrivDisplayName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupPrivDisplayName_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupPrivDisplayName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.disp_name = *state->tmp.out.disp_name;
	*state->orig.out.returned_language_id = *state->tmp.out.returned_language_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivDisplayName, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupPrivDisplayName_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct rpccli_lsa_LookupPrivDisplayName_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupPrivDisplayName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupPrivDisplayName(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  struct lsa_String *name /* [in] [ref] */,
					  uint16_t language_id /* [in]  */,
					  uint16_t language_id_sys /* [in]  */,
					  struct lsa_StringLarge **disp_name /* [out] [ref] */,
					  uint16_t *returned_language_id /* [out] [ref] */)
{
	struct lsa_LookupPrivDisplayName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.language_id = language_id;
	r.in.language_id_sys = language_id_sys;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivDisplayName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPPRIVDISPLAYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivDisplayName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*disp_name = *r.out.disp_name;
	*returned_language_id = *r.out.returned_language_id;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_DeleteObject_state {
	struct lsa_DeleteObject orig;
	struct lsa_DeleteObject tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_DeleteObject_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_DeleteObject_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_DeleteObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_DeleteObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteObject, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_DeleteObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_DELETEOBJECT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_DeleteObject_done, req);
	return req;
}

static void rpccli_lsa_DeleteObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_DeleteObject_state *state = tevent_req_data(
		req, struct rpccli_lsa_DeleteObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteObject, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_DeleteObject_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_DeleteObject_state *state = tevent_req_data(
		req, struct rpccli_lsa_DeleteObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_DeleteObject(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in,out] [ref] */)
{
	struct lsa_DeleteObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteObject, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_DELETEOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteObject, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumAccountsWithUserRight_state {
	struct lsa_EnumAccountsWithUserRight orig;
	struct lsa_EnumAccountsWithUserRight tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumAccountsWithUserRight_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumAccountsWithUserRight_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     struct policy_handle *_handle /* [in] [ref] */,
							     struct lsa_String *_name /* [in] [unique] */,
							     struct lsa_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumAccountsWithUserRight_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumAccountsWithUserRight_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountsWithUserRight, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumAccountsWithUserRight_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumAccountsWithUserRight_done, req);
	return req;
}

static void rpccli_lsa_EnumAccountsWithUserRight_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumAccountsWithUserRight_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumAccountsWithUserRight_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountsWithUserRight, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumAccountsWithUserRight_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct rpccli_lsa_EnumAccountsWithUserRight_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumAccountsWithUserRight_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumAccountsWithUserRight(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *handle /* [in] [ref] */,
					      struct lsa_String *name /* [in] [unique] */,
					      struct lsa_SidArray *sids /* [out] [ref] */)
{
	struct lsa_EnumAccountsWithUserRight r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountsWithUserRight, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountsWithUserRight, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sids = *r.out.sids;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumAccountRights_state {
	struct lsa_EnumAccountRights orig;
	struct lsa_EnumAccountRights tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumAccountRights_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumAccountRights_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     struct dom_sid2 *_sid /* [in] [ref] */,
						     struct lsa_RightSet *_rights /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumAccountRights_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumAccountRights_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.rights = _rights;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountRights, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumAccountRights_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMACCOUNTRIGHTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumAccountRights_done, req);
	return req;
}

static void rpccli_lsa_EnumAccountRights_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumAccountRights_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumAccountRights_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rights = *state->tmp.out.rights;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountRights, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumAccountRights_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_lsa_EnumAccountRights_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumAccountRights_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumAccountRights(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      struct dom_sid2 *sid /* [in] [ref] */,
				      struct lsa_RightSet *rights /* [out] [ref] */)
{
	struct lsa_EnumAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountRights, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMACCOUNTRIGHTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountRights, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rights = *r.out.rights;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_AddAccountRights_state {
	struct lsa_AddAccountRights orig;
	struct lsa_AddAccountRights tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_AddAccountRights_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_AddAccountRights_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct dom_sid2 *_sid /* [in] [ref] */,
						    struct lsa_RightSet *_rights /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_AddAccountRights_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_AddAccountRights_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.rights = _rights;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddAccountRights, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ADDACCOUNTRIGHTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_AddAccountRights_done, req);
	return req;
}

static void rpccli_lsa_AddAccountRights_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_AddAccountRights_state *state = tevent_req_data(
		req, struct rpccli_lsa_AddAccountRights_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddAccountRights, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_AddAccountRights_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct rpccli_lsa_AddAccountRights_state *state = tevent_req_data(
		req, struct rpccli_lsa_AddAccountRights_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_AddAccountRights(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     struct dom_sid2 *sid /* [in] [ref] */,
				     struct lsa_RightSet *rights /* [in] [ref] */)
{
	struct lsa_AddAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.rights = rights;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddAccountRights, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ADDACCOUNTRIGHTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddAccountRights, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_RemoveAccountRights_state {
	struct lsa_RemoveAccountRights orig;
	struct lsa_RemoveAccountRights tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_RemoveAccountRights_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_RemoveAccountRights_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct dom_sid2 *_sid /* [in] [ref] */,
						       uint8_t _remove_all /* [in]  */,
						       struct lsa_RightSet *_rights /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_RemoveAccountRights_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_RemoveAccountRights_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sid = _sid;
	state->orig.in.remove_all = _remove_all;
	state->orig.in.rights = _rights;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemoveAccountRights, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_REMOVEACCOUNTRIGHTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_RemoveAccountRights_done, req);
	return req;
}

static void rpccli_lsa_RemoveAccountRights_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_RemoveAccountRights_state *state = tevent_req_data(
		req, struct rpccli_lsa_RemoveAccountRights_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemoveAccountRights, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_RemoveAccountRights_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_lsa_RemoveAccountRights_state *state = tevent_req_data(
		req, struct rpccli_lsa_RemoveAccountRights_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_RemoveAccountRights(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct dom_sid2 *sid /* [in] [ref] */,
					uint8_t remove_all /* [in]  */,
					struct lsa_RightSet *rights /* [in] [ref] */)
{
	struct lsa_RemoveAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.remove_all = remove_all;
	r.in.rights = rights;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemoveAccountRights, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_REMOVEACCOUNTRIGHTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemoveAccountRights, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QueryTrustedDomainInfoBySid_state {
	struct lsa_QueryTrustedDomainInfoBySid orig;
	struct lsa_QueryTrustedDomainInfoBySid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QueryTrustedDomainInfoBySid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QueryTrustedDomainInfoBySid_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct rpc_pipe_client *cli,
							       struct policy_handle *_handle /* [in] [ref] */,
							       struct dom_sid2 *_dom_sid /* [in] [ref] */,
							       enum lsa_TrustDomInfoEnum _level /* [in]  */,
							       union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QueryTrustedDomainInfoBySid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QueryTrustedDomainInfoBySid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.dom_sid = _dom_sid;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoBySid, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QueryTrustedDomainInfoBySid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QueryTrustedDomainInfoBySid_done, req);
	return req;
}

static void rpccli_lsa_QueryTrustedDomainInfoBySid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QueryTrustedDomainInfoBySid_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryTrustedDomainInfoBySid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoBySid, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfoBySid_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct rpccli_lsa_QueryTrustedDomainInfoBySid_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryTrustedDomainInfoBySid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfoBySid(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *handle /* [in] [ref] */,
						struct dom_sid2 *dom_sid /* [in] [ref] */,
						enum lsa_TrustDomInfoEnum level /* [in]  */,
						union lsa_TrustedDomainInfo **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryTrustedDomainInfoBySid r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.dom_sid = dom_sid;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoBySid, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoBySid, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetTrustedDomainInfo_state {
	struct lsa_SetTrustedDomainInfo orig;
	struct lsa_SetTrustedDomainInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetTrustedDomainInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetTrustedDomainInfo_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in] [ref] */,
							struct dom_sid2 *_dom_sid /* [in] [ref] */,
							enum lsa_TrustDomInfoEnum _level /* [in]  */,
							union lsa_TrustedDomainInfo *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetTrustedDomainInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetTrustedDomainInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.dom_sid = _dom_sid;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfo, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETTRUSTEDDOMAININFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetTrustedDomainInfo_done, req);
	return req;
}

static void rpccli_lsa_SetTrustedDomainInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetTrustedDomainInfo_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetTrustedDomainInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfo, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetTrustedDomainInfo_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_lsa_SetTrustedDomainInfo_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetTrustedDomainInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetTrustedDomainInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 struct dom_sid2 *dom_sid /* [in] [ref] */,
					 enum lsa_TrustDomInfoEnum level /* [in]  */,
					 union lsa_TrustedDomainInfo *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetTrustedDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.dom_sid = dom_sid;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETTRUSTEDDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_DeleteTrustedDomain_state {
	struct lsa_DeleteTrustedDomain orig;
	struct lsa_DeleteTrustedDomain tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_DeleteTrustedDomain_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_DeleteTrustedDomain_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct dom_sid2 *_dom_sid /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_DeleteTrustedDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_DeleteTrustedDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.dom_sid = _dom_sid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteTrustedDomain, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_DELETETRUSTEDDOMAIN,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_DeleteTrustedDomain_done, req);
	return req;
}

static void rpccli_lsa_DeleteTrustedDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_DeleteTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_DeleteTrustedDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteTrustedDomain, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_DeleteTrustedDomain_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_lsa_DeleteTrustedDomain_state *state = tevent_req_data(
		req, struct rpccli_lsa_DeleteTrustedDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_DeleteTrustedDomain(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct dom_sid2 *dom_sid /* [in] [ref] */)
{
	struct lsa_DeleteTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.dom_sid = dom_sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_DELETETRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_StorePrivateData_state {
	struct lsa_StorePrivateData orig;
	struct lsa_StorePrivateData tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_StorePrivateData_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_StorePrivateData_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */,
						    struct lsa_String *_name /* [in] [ref] */,
						    struct lsa_DATA_BUF *_val /* [in] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_StorePrivateData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_StorePrivateData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.val = _val;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_StorePrivateData, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_STOREPRIVATEDATA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_StorePrivateData_done, req);
	return req;
}

static void rpccli_lsa_StorePrivateData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_StorePrivateData_state *state = tevent_req_data(
		req, struct rpccli_lsa_StorePrivateData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_StorePrivateData, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_StorePrivateData_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct rpccli_lsa_StorePrivateData_state *state = tevent_req_data(
		req, struct rpccli_lsa_StorePrivateData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_StorePrivateData(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     struct lsa_String *name /* [in] [ref] */,
				     struct lsa_DATA_BUF *val /* [in] [unique] */)
{
	struct lsa_StorePrivateData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.val = val;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_StorePrivateData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_STOREPRIVATEDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_StorePrivateData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_RetrievePrivateData_state {
	struct lsa_RetrievePrivateData orig;
	struct lsa_RetrievePrivateData tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_RetrievePrivateData_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_RetrievePrivateData_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct lsa_String *_name /* [in] [ref] */,
						       struct lsa_DATA_BUF **_val /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_RetrievePrivateData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_RetrievePrivateData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.val = _val;

	/* Out parameters */
	state->orig.out.val = _val;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RetrievePrivateData, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_RetrievePrivateData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_RETRIEVEPRIVATEDATA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_RetrievePrivateData_done, req);
	return req;
}

static void rpccli_lsa_RetrievePrivateData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_RetrievePrivateData_state *state = tevent_req_data(
		req, struct rpccli_lsa_RetrievePrivateData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.val = *state->tmp.out.val;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RetrievePrivateData, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_RetrievePrivateData_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_lsa_RetrievePrivateData_state *state = tevent_req_data(
		req, struct rpccli_lsa_RetrievePrivateData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_RetrievePrivateData(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct lsa_String *name /* [in] [ref] */,
					struct lsa_DATA_BUF **val /* [in,out] [ref] */)
{
	struct lsa_RetrievePrivateData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.val = val;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RetrievePrivateData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_RETRIEVEPRIVATEDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RetrievePrivateData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*val = *r.out.val;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_OpenPolicy2_state {
	struct lsa_OpenPolicy2 orig;
	struct lsa_OpenPolicy2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_OpenPolicy2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_OpenPolicy2_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       const char *_system_name /* [in] [unique,charset(UTF16)] */,
					       struct lsa_ObjectAttribute *_attr /* [in] [ref] */,
					       uint32_t _access_mask /* [in]  */,
					       struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_OpenPolicy2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_OpenPolicy2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.attr = _attr;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy2, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_OpenPolicy2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_OPENPOLICY2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_OpenPolicy2_done, req);
	return req;
}

static void rpccli_lsa_OpenPolicy2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_OpenPolicy2_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenPolicy2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy2, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_OpenPolicy2_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_OpenPolicy2_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenPolicy2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_OpenPolicy2(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				const char *system_name /* [in] [unique,charset(UTF16)] */,
				struct lsa_ObjectAttribute *attr /* [in] [ref] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */)
{
	struct lsa_OpenPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.attr = attr;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENPOLICY2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_GetUserName_state {
	struct lsa_GetUserName orig;
	struct lsa_GetUserName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_GetUserName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_GetUserName_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       const char *_system_name /* [in] [unique,charset(UTF16)] */,
					       struct lsa_String **_account_name /* [in,out] [ref] */,
					       struct lsa_String **_authority_name /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_GetUserName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_GetUserName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.system_name = _system_name;
	state->orig.in.account_name = _account_name;
	state->orig.in.authority_name = _authority_name;

	/* Out parameters */
	state->orig.out.account_name = _account_name;
	state->orig.out.authority_name = _authority_name;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetUserName, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_GetUserName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_GETUSERNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_GetUserName_done, req);
	return req;
}

static void rpccli_lsa_GetUserName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_GetUserName_state *state = tevent_req_data(
		req, struct rpccli_lsa_GetUserName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.account_name = *state->tmp.out.account_name;
	if (state->orig.out.authority_name && state->tmp.out.authority_name) {
		*state->orig.out.authority_name = *state->tmp.out.authority_name;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetUserName, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_GetUserName_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_GetUserName_state *state = tevent_req_data(
		req, struct rpccli_lsa_GetUserName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_GetUserName(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				const char *system_name /* [in] [unique,charset(UTF16)] */,
				struct lsa_String **account_name /* [in,out] [ref] */,
				struct lsa_String **authority_name /* [in,out] [unique] */)
{
	struct lsa_GetUserName r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.account_name = account_name;
	r.in.authority_name = authority_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetUserName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_GETUSERNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetUserName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*account_name = *r.out.account_name;
	if (authority_name && r.out.authority_name) {
		*authority_name = *r.out.authority_name;
	}

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QueryInfoPolicy2_state {
	struct lsa_QueryInfoPolicy2 orig;
	struct lsa_QueryInfoPolicy2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QueryInfoPolicy2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QueryInfoPolicy2_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */,
						    enum lsa_PolicyInfo _level /* [in]  */,
						    union lsa_PolicyInformation **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QueryInfoPolicy2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QueryInfoPolicy2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy2, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QueryInfoPolicy2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYINFOPOLICY2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QueryInfoPolicy2_done, req);
	return req;
}

static void rpccli_lsa_QueryInfoPolicy2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QueryInfoPolicy2_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryInfoPolicy2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy2, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QueryInfoPolicy2_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct rpccli_lsa_QueryInfoPolicy2_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryInfoPolicy2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QueryInfoPolicy2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     enum lsa_PolicyInfo level /* [in]  */,
				     union lsa_PolicyInformation **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryInfoPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYINFOPOLICY2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetInfoPolicy2_state {
	struct lsa_SetInfoPolicy2 orig;
	struct lsa_SetInfoPolicy2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetInfoPolicy2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetInfoPolicy2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct policy_handle *_handle /* [in] [ref] */,
						  enum lsa_PolicyInfo _level /* [in]  */,
						  union lsa_PolicyInformation *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetInfoPolicy2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetInfoPolicy2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy2, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETINFOPOLICY2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetInfoPolicy2_done, req);
	return req;
}

static void rpccli_lsa_SetInfoPolicy2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetInfoPolicy2_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetInfoPolicy2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy2, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetInfoPolicy2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_lsa_SetInfoPolicy2_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetInfoPolicy2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetInfoPolicy2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   enum lsa_PolicyInfo level /* [in]  */,
				   union lsa_PolicyInformation *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetInfoPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETINFOPOLICY2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QueryTrustedDomainInfoByName_state {
	struct lsa_QueryTrustedDomainInfoByName orig;
	struct lsa_QueryTrustedDomainInfoByName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QueryTrustedDomainInfoByName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QueryTrustedDomainInfoByName_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli,
								struct policy_handle *_handle /* [in] [ref] */,
								struct lsa_String *_trusted_domain /* [in] [ref] */,
								enum lsa_TrustDomInfoEnum _level /* [in]  */,
								union lsa_TrustedDomainInfo **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QueryTrustedDomainInfoByName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QueryTrustedDomainInfoByName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain = _trusted_domain;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoByName, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QueryTrustedDomainInfoByName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QueryTrustedDomainInfoByName_done, req);
	return req;
}

static void rpccli_lsa_QueryTrustedDomainInfoByName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QueryTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryTrustedDomainInfoByName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoByName, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfoByName_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      NTSTATUS *result)
{
	struct rpccli_lsa_QueryTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryTrustedDomainInfoByName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfoByName(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *handle /* [in] [ref] */,
						 struct lsa_String *trusted_domain /* [in] [ref] */,
						 enum lsa_TrustDomInfoEnum level /* [in]  */,
						 union lsa_TrustedDomainInfo **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryTrustedDomainInfoByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.trusted_domain = trusted_domain;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoByName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoByName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetTrustedDomainInfoByName_state {
	struct lsa_SetTrustedDomainInfoByName orig;
	struct lsa_SetTrustedDomainInfoByName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetTrustedDomainInfoByName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetTrustedDomainInfoByName_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      struct policy_handle *_handle /* [in] [ref] */,
							      struct lsa_String _trusted_domain /* [in]  */,
							      enum lsa_TrustDomInfoEnum _level /* [in]  */,
							      union lsa_TrustedDomainInfo *_info /* [in] [unique,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetTrustedDomainInfoByName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetTrustedDomainInfoByName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain = _trusted_domain;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfoByName, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETTRUSTEDDOMAININFOBYNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetTrustedDomainInfoByName_done, req);
	return req;
}

static void rpccli_lsa_SetTrustedDomainInfoByName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetTrustedDomainInfoByName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfoByName, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetTrustedDomainInfoByName_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct rpccli_lsa_SetTrustedDomainInfoByName_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetTrustedDomainInfoByName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetTrustedDomainInfoByName(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       struct lsa_String trusted_domain /* [in]  */,
					       enum lsa_TrustDomInfoEnum level /* [in]  */,
					       union lsa_TrustedDomainInfo *info /* [in] [unique,switch_is(level)] */)
{
	struct lsa_SetTrustedDomainInfoByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.trusted_domain = trusted_domain;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfoByName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETTRUSTEDDOMAININFOBYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfoByName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_EnumTrustedDomainsEx_state {
	struct lsa_EnumTrustedDomainsEx orig;
	struct lsa_EnumTrustedDomainsEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_EnumTrustedDomainsEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_EnumTrustedDomainsEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t *_resume_handle /* [in,out] [ref] */,
							struct lsa_DomainListEx *_domains /* [out] [ref] */,
							uint32_t _max_size /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_EnumTrustedDomainsEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_EnumTrustedDomainsEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.max_size = _max_size;

	/* Out parameters */
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.domains = _domains;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustedDomainsEx, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_EnumTrustedDomainsEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_ENUMTRUSTEDDOMAINSEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_EnumTrustedDomainsEx_done, req);
	return req;
}

static void rpccli_lsa_EnumTrustedDomainsEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_EnumTrustedDomainsEx_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumTrustedDomainsEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	*state->orig.out.domains = *state->tmp.out.domains;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustedDomainsEx, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_EnumTrustedDomainsEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_lsa_EnumTrustedDomainsEx_state *state = tevent_req_data(
		req, struct rpccli_lsa_EnumTrustedDomainsEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_EnumTrustedDomainsEx(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 uint32_t *resume_handle /* [in,out] [ref] */,
					 struct lsa_DomainListEx *domains /* [out] [ref] */,
					 uint32_t max_size /* [in]  */)
{
	struct lsa_EnumTrustedDomainsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.max_size = max_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustedDomainsEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMTRUSTEDDOMAINSEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustedDomainsEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*domains = *r.out.domains;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CreateTrustedDomainEx_state {
	struct lsa_CreateTrustedDomainEx orig;
	struct lsa_CreateTrustedDomainEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CreateTrustedDomainEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CreateTrustedDomainEx_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct policy_handle *_policy_handle /* [in] [ref] */,
							 struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
							 struct lsa_TrustDomainInfoAuthInfoInternal *_auth_info /* [in] [ref] */,
							 uint32_t _access_mask /* [in]  */,
							 struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_CreateTrustedDomainEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CreateTrustedDomainEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.auth_info = _auth_info;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_CreateTrustedDomainEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREATETRUSTEDDOMAINEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CreateTrustedDomainEx_done, req);
	return req;
}

static void rpccli_lsa_CreateTrustedDomainEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CreateTrustedDomainEx_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateTrustedDomainEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CreateTrustedDomainEx_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct rpccli_lsa_CreateTrustedDomainEx_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateTrustedDomainEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CreateTrustedDomainEx(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *policy_handle /* [in] [ref] */,
					  struct lsa_TrustDomainInfoInfoEx *info /* [in] [ref] */,
					  struct lsa_TrustDomainInfoAuthInfoInternal *auth_info /* [in] [ref] */,
					  uint32_t access_mask /* [in]  */,
					  struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_CreateTrustedDomainEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = policy_handle;
	r.in.info = info;
	r.in.auth_info = auth_info;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATETRUSTEDDOMAINEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CloseTrustedDomainEx_state {
	struct lsa_CloseTrustedDomainEx orig;
	struct lsa_CloseTrustedDomainEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CloseTrustedDomainEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CloseTrustedDomainEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_CloseTrustedDomainEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CloseTrustedDomainEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CloseTrustedDomainEx, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_CloseTrustedDomainEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CLOSETRUSTEDDOMAINEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CloseTrustedDomainEx_done, req);
	return req;
}

static void rpccli_lsa_CloseTrustedDomainEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CloseTrustedDomainEx_state *state = tevent_req_data(
		req, struct rpccli_lsa_CloseTrustedDomainEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CloseTrustedDomainEx, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CloseTrustedDomainEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_lsa_CloseTrustedDomainEx_state *state = tevent_req_data(
		req, struct rpccli_lsa_CloseTrustedDomainEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CloseTrustedDomainEx(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in,out] [ref] */)
{
	struct lsa_CloseTrustedDomainEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CloseTrustedDomainEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CLOSETRUSTEDDOMAINEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CloseTrustedDomainEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_QueryDomainInformationPolicy_state {
	struct lsa_QueryDomainInformationPolicy orig;
	struct lsa_QueryDomainInformationPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_QueryDomainInformationPolicy_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_QueryDomainInformationPolicy_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli,
								struct policy_handle *_handle /* [in] [ref] */,
								uint16_t _level /* [in]  */,
								union lsa_DomainInformationPolicy **_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_QueryDomainInformationPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_QueryDomainInformationPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryDomainInformationPolicy, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_QueryDomainInformationPolicy_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_QUERYDOMAININFORMATIONPOLICY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_QueryDomainInformationPolicy_done, req);
	return req;
}

static void rpccli_lsa_QueryDomainInformationPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_QueryDomainInformationPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryDomainInformationPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryDomainInformationPolicy, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_QueryDomainInformationPolicy_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      NTSTATUS *result)
{
	struct rpccli_lsa_QueryDomainInformationPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_QueryDomainInformationPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_QueryDomainInformationPolicy(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *handle /* [in] [ref] */,
						 uint16_t level /* [in]  */,
						 union lsa_DomainInformationPolicy **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryDomainInformationPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryDomainInformationPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYDOMAININFORMATIONPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryDomainInformationPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_SetDomainInformationPolicy_state {
	struct lsa_SetDomainInformationPolicy orig;
	struct lsa_SetDomainInformationPolicy tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_SetDomainInformationPolicy_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_SetDomainInformationPolicy_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint16_t _level /* [in]  */,
							      union lsa_DomainInformationPolicy *_info /* [in] [unique,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_SetDomainInformationPolicy_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_SetDomainInformationPolicy_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetDomainInformationPolicy, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_SETDOMAININFORMATIONPOLICY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_SetDomainInformationPolicy_done, req);
	return req;
}

static void rpccli_lsa_SetDomainInformationPolicy_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_SetDomainInformationPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetDomainInformationPolicy_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetDomainInformationPolicy, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_SetDomainInformationPolicy_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct rpccli_lsa_SetDomainInformationPolicy_state *state = tevent_req_data(
		req, struct rpccli_lsa_SetDomainInformationPolicy_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_SetDomainInformationPolicy(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       uint16_t level /* [in]  */,
					       union lsa_DomainInformationPolicy *info /* [in] [unique,switch_is(level)] */)
{
	struct lsa_SetDomainInformationPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetDomainInformationPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETDOMAININFORMATIONPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetDomainInformationPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_OpenTrustedDomainByName_state {
	struct lsa_OpenTrustedDomainByName orig;
	struct lsa_OpenTrustedDomainByName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_OpenTrustedDomainByName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_OpenTrustedDomainByName_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   struct lsa_String _name /* [in]  */,
							   uint32_t _access_mask /* [in]  */,
							   struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_OpenTrustedDomainByName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_OpenTrustedDomainByName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.name = _name;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomainByName, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_OpenTrustedDomainByName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_OPENTRUSTEDDOMAINBYNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_OpenTrustedDomainByName_done, req);
	return req;
}

static void rpccli_lsa_OpenTrustedDomainByName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_OpenTrustedDomainByName_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenTrustedDomainByName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomainByName, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_OpenTrustedDomainByName_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct rpccli_lsa_OpenTrustedDomainByName_state *state = tevent_req_data(
		req, struct rpccli_lsa_OpenTrustedDomainByName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_OpenTrustedDomainByName(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    struct lsa_String name /* [in]  */,
					    uint32_t access_mask /* [in]  */,
					    struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_OpenTrustedDomainByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomainByName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENTRUSTEDDOMAINBYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomainByName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_TestCall_state {
	struct lsa_TestCall orig;
	struct lsa_TestCall tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_TestCall_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_TestCall_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_TestCall_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_TestCall_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_TestCall, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_TESTCALL,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_TestCall_done, req);
	return req;
}

static void rpccli_lsa_TestCall_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_TestCall_state *state = tevent_req_data(
		req, struct rpccli_lsa_TestCall_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_TestCall, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_TestCall_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct rpccli_lsa_TestCall_state *state = tevent_req_data(
		req, struct rpccli_lsa_TestCall_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_TestCall(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx)
{
	struct lsa_TestCall r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_TestCall, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_TESTCALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_TestCall, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupSids2_state {
	struct lsa_LookupSids2 orig;
	struct lsa_LookupSids2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupSids2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupSids2_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct policy_handle *_handle /* [in] [ref] */,
					       struct lsa_SidArray *_sids /* [in] [ref] */,
					       struct lsa_RefDomainList **_domains /* [out] [ref] */,
					       struct lsa_TransNameArray2 *_names /* [in,out] [ref] */,
					       enum lsa_LookupNamesLevel _level /* [in]  */,
					       uint32_t *_count /* [in,out] [ref] */,
					       enum lsa_LookupOptions _lookup_options /* [in]  */,
					       enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupSids2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupSids2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.sids = _sids;
	state->orig.in.names = _names;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids2, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupSids2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPSIDS2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupSids2_done, req);
	return req;
}

static void rpccli_lsa_LookupSids2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupSids2_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupSids2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids2, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupSids2_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_LookupSids2_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupSids2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupSids2(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				struct lsa_SidArray *sids /* [in] [ref] */,
				struct lsa_RefDomainList **domains /* [out] [ref] */,
				struct lsa_TransNameArray2 *names /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel level /* [in]  */,
				uint32_t *count /* [in,out] [ref] */,
				enum lsa_LookupOptions lookup_options /* [in]  */,
				enum lsa_ClientRevision client_revision /* [in]  */)
{
	struct lsa_LookupSids2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sids = sids;
	r.in.names = names;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPSIDS2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*names = *r.out.names;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupNames2_state {
	struct lsa_LookupNames2 orig;
	struct lsa_LookupNames2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupNames2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupNames2_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [size_is(num_names)] */,
						struct lsa_RefDomainList **_domains /* [out] [ref] */,
						struct lsa_TransSidArray2 *_sids /* [in,out] [ref] */,
						enum lsa_LookupNamesLevel _level /* [in]  */,
						uint32_t *_count /* [in,out] [ref] */,
						enum lsa_LookupOptions _lookup_options /* [in]  */,
						enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupNames2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupNames2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames2, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupNames2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPNAMES2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupNames2_done, req);
	return req;
}

static void rpccli_lsa_LookupNames2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupNames2_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames2, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupNames2_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_LookupNames2_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupNames2(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **domains /* [out] [ref] */,
				 struct lsa_TransSidArray2 *sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel level /* [in]  */,
				 uint32_t *count /* [in,out] [ref] */,
				 enum lsa_LookupOptions lookup_options /* [in]  */,
				 enum lsa_ClientRevision client_revision /* [in]  */)
{
	struct lsa_LookupNames2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CreateTrustedDomainEx2_state {
	struct lsa_CreateTrustedDomainEx2 orig;
	struct lsa_CreateTrustedDomainEx2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CreateTrustedDomainEx2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CreateTrustedDomainEx2_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_policy_handle /* [in] [ref] */,
							  struct lsa_TrustDomainInfoInfoEx *_info /* [in] [ref] */,
							  struct lsa_TrustDomainInfoAuthInfoInternal *_auth_info /* [in] [ref] */,
							  uint32_t _access_mask /* [in]  */,
							  struct policy_handle *_trustdom_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_CreateTrustedDomainEx2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CreateTrustedDomainEx2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.policy_handle = _policy_handle;
	state->orig.in.info = _info;
	state->orig.in.auth_info = _auth_info;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.trustdom_handle = _trustdom_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx2, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_CreateTrustedDomainEx2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREATETRUSTEDDOMAINEX2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CreateTrustedDomainEx2_done, req);
	return req;
}

static void rpccli_lsa_CreateTrustedDomainEx2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CreateTrustedDomainEx2_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateTrustedDomainEx2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.trustdom_handle = *state->tmp.out.trustdom_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx2, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CreateTrustedDomainEx2_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_lsa_CreateTrustedDomainEx2_state *state = tevent_req_data(
		req, struct rpccli_lsa_CreateTrustedDomainEx2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CreateTrustedDomainEx2(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *policy_handle /* [in] [ref] */,
					   struct lsa_TrustDomainInfoInfoEx *info /* [in] [ref] */,
					   struct lsa_TrustDomainInfoAuthInfoInternal *auth_info /* [in] [ref] */,
					   uint32_t access_mask /* [in]  */,
					   struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_CreateTrustedDomainEx2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = policy_handle;
	r.in.info = info;
	r.in.auth_info = auth_info;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATETRUSTEDDOMAINEX2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRWRITE_state {
	struct lsa_CREDRWRITE orig;
	struct lsa_CREDRWRITE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRWRITE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRWRITE_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRWRITE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRWRITE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITE, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRWRITE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRWRITE_done, req);
	return req;
}

static void rpccli_lsa_CREDRWRITE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRWRITE_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRWRITE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITE, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRWRITE_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct rpccli_lsa_CREDRWRITE_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRWRITE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRWRITE(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRWRITE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRWRITE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRREAD_state {
	struct lsa_CREDRREAD orig;
	struct lsa_CREDRREAD tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRREAD_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRREAD_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRREAD_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRREAD_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREAD, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRREAD,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRREAD_done, req);
	return req;
}

static void rpccli_lsa_CREDRREAD_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRREAD_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRREAD_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREAD, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRREAD_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_lsa_CREDRREAD_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRREAD_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRREAD(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRREAD r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREAD, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRREAD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREAD, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRENUMERATE_state {
	struct lsa_CREDRENUMERATE orig;
	struct lsa_CREDRENUMERATE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRENUMERATE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRENUMERATE_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRENUMERATE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRENUMERATE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRENUMERATE, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRENUMERATE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRENUMERATE_done, req);
	return req;
}

static void rpccli_lsa_CREDRENUMERATE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRENUMERATE_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRENUMERATE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRENUMERATE, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRENUMERATE_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct rpccli_lsa_CREDRENUMERATE_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRENUMERATE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRENUMERATE(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRENUMERATE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRENUMERATE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRENUMERATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRENUMERATE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state {
	struct lsa_CREDRWRITEDOMAINCREDENTIALS orig;
	struct lsa_CREDRWRITEDOMAINCREDENTIALS tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRWRITEDOMAINCREDENTIALS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_done, req);
	return req;
}

static void rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     NTSTATUS *result)
{
	struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRWRITEDOMAINCREDENTIALS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRWRITEDOMAINCREDENTIALS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state {
	struct lsa_CREDRREADDOMAINCREDENTIALS orig;
	struct lsa_CREDRREADDOMAINCREDENTIALS tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRREADDOMAINCREDENTIALS_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRREADDOMAINCREDENTIALS_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRREADDOMAINCREDENTIALS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRREADDOMAINCREDENTIALS_done, req);
	return req;
}

static void rpccli_lsa_CREDRREADDOMAINCREDENTIALS_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRREADDOMAINCREDENTIALS_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRREADDOMAINCREDENTIALS_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRREADDOMAINCREDENTIALS(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRREADDOMAINCREDENTIALS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRREADDOMAINCREDENTIALS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRDELETE_state {
	struct lsa_CREDRDELETE orig;
	struct lsa_CREDRDELETE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRDELETE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRDELETE_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRDELETE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRDELETE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRDELETE, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRDELETE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRDELETE_done, req);
	return req;
}

static void rpccli_lsa_CREDRDELETE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRDELETE_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRDELETE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRDELETE, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRDELETE_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_CREDRDELETE_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRDELETE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRDELETE(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRDELETE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRDELETE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRDELETE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRDELETE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRGETTARGETINFO_state {
	struct lsa_CREDRGETTARGETINFO orig;
	struct lsa_CREDRGETTARGETINFO tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRGETTARGETINFO_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRGETTARGETINFO_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRGETTARGETINFO_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRGETTARGETINFO_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETTARGETINFO, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRGETTARGETINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRGETTARGETINFO_done, req);
	return req;
}

static void rpccli_lsa_CREDRGETTARGETINFO_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRGETTARGETINFO_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRGETTARGETINFO_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETTARGETINFO, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRGETTARGETINFO_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_lsa_CREDRGETTARGETINFO_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRGETTARGETINFO_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRGETTARGETINFO(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRGETTARGETINFO r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETTARGETINFO, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRGETTARGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETTARGETINFO, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRPROFILELOADED_state {
	struct lsa_CREDRPROFILELOADED orig;
	struct lsa_CREDRPROFILELOADED tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRPROFILELOADED_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRPROFILELOADED_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRPROFILELOADED_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRPROFILELOADED_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRPROFILELOADED, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRPROFILELOADED,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRPROFILELOADED_done, req);
	return req;
}

static void rpccli_lsa_CREDRPROFILELOADED_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRPROFILELOADED_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRPROFILELOADED_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRPROFILELOADED, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRPROFILELOADED_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_lsa_CREDRPROFILELOADED_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRPROFILELOADED_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRPROFILELOADED(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRPROFILELOADED r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRPROFILELOADED, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRPROFILELOADED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRPROFILELOADED, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupNames3_state {
	struct lsa_LookupNames3 orig;
	struct lsa_LookupNames3 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupNames3_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupNames3_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [size_is(num_names)] */,
						struct lsa_RefDomainList **_domains /* [out] [ref] */,
						struct lsa_TransSidArray3 *_sids /* [in,out] [ref] */,
						enum lsa_LookupNamesLevel _level /* [in]  */,
						uint32_t *_count /* [in,out] [ref] */,
						enum lsa_LookupOptions _lookup_options /* [in]  */,
						enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupNames3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupNames3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames3, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupNames3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPNAMES3,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupNames3_done, req);
	return req;
}

static void rpccli_lsa_LookupNames3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupNames3_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames3, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupNames3_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_LookupNames3_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupNames3(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **domains /* [out] [ref] */,
				 struct lsa_TransSidArray3 *sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel level /* [in]  */,
				 uint32_t *count /* [in,out] [ref] */,
				 enum lsa_LookupOptions lookup_options /* [in]  */,
				 enum lsa_ClientRevision client_revision /* [in]  */)
{
	struct lsa_LookupNames3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames3, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRGETSESSIONTYPES_state {
	struct lsa_CREDRGETSESSIONTYPES orig;
	struct lsa_CREDRGETSESSIONTYPES tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRGETSESSIONTYPES_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRGETSESSIONTYPES_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRGETSESSIONTYPES_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRGETSESSIONTYPES_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETSESSIONTYPES, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRGETSESSIONTYPES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRGETSESSIONTYPES_done, req);
	return req;
}

static void rpccli_lsa_CREDRGETSESSIONTYPES_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRGETSESSIONTYPES_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRGETSESSIONTYPES_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETSESSIONTYPES, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRGETSESSIONTYPES_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_lsa_CREDRGETSESSIONTYPES_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRGETSESSIONTYPES_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRGETSESSIONTYPES(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRGETSESSIONTYPES r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETSESSIONTYPES, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRGETSESSIONTYPES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETSESSIONTYPES, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARREGISTERAUDITEVENT_state {
	struct lsa_LSARREGISTERAUDITEVENT orig;
	struct lsa_LSARREGISTERAUDITEVENT tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARREGISTERAUDITEVENT_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARREGISTERAUDITEVENT_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARREGISTERAUDITEVENT_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARREGISTERAUDITEVENT_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARREGISTERAUDITEVENT, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARREGISTERAUDITEVENT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARREGISTERAUDITEVENT_done, req);
	return req;
}

static void rpccli_lsa_LSARREGISTERAUDITEVENT_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARREGISTERAUDITEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARREGISTERAUDITEVENT_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARREGISTERAUDITEVENT, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARREGISTERAUDITEVENT_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_lsa_LSARREGISTERAUDITEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARREGISTERAUDITEVENT_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARREGISTERAUDITEVENT(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARREGISTERAUDITEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARREGISTERAUDITEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARREGISTERAUDITEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARREGISTERAUDITEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARGENAUDITEVENT_state {
	struct lsa_LSARGENAUDITEVENT orig;
	struct lsa_LSARGENAUDITEVENT tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARGENAUDITEVENT_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARGENAUDITEVENT_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARGENAUDITEVENT_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARGENAUDITEVENT_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARGENAUDITEVENT, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARGENAUDITEVENT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARGENAUDITEVENT_done, req);
	return req;
}

static void rpccli_lsa_LSARGENAUDITEVENT_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARGENAUDITEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARGENAUDITEVENT_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARGENAUDITEVENT, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARGENAUDITEVENT_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_lsa_LSARGENAUDITEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARGENAUDITEVENT_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARGENAUDITEVENT(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARGENAUDITEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARGENAUDITEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARGENAUDITEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARGENAUDITEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state {
	struct lsa_LSARUNREGISTERAUDITEVENT orig;
	struct lsa_LSARUNREGISTERAUDITEVENT tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARUNREGISTERAUDITEVENT_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARUNREGISTERAUDITEVENT_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARUNREGISTERAUDITEVENT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARUNREGISTERAUDITEVENT_done, req);
	return req;
}

static void rpccli_lsa_LSARUNREGISTERAUDITEVENT_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARUNREGISTERAUDITEVENT_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result)
{
	struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARUNREGISTERAUDITEVENT_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARUNREGISTERAUDITEVENT(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARUNREGISTERAUDITEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARUNREGISTERAUDITEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_lsaRQueryForestTrustInformation_state {
	struct lsa_lsaRQueryForestTrustInformation orig;
	struct lsa_lsaRQueryForestTrustInformation tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_lsaRQueryForestTrustInformation_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_lsaRQueryForestTrustInformation_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct rpc_pipe_client *cli,
								   struct policy_handle *_handle /* [in] [ref] */,
								   struct lsa_String *_trusted_domain_name /* [in] [ref] */,
								   uint16_t _unknown /* [in]  */,
								   struct lsa_ForestTrustInformation **_forest_trust_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_lsa_lsaRQueryForestTrustInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_lsaRQueryForestTrustInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.trusted_domain_name = _trusted_domain_name;
	state->orig.in.unknown = _unknown;

	/* Out parameters */
	state->orig.out.forest_trust_info = _forest_trust_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_lsaRQueryForestTrustInformation, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_lsaRQueryForestTrustInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_lsaRQueryForestTrustInformation_done, req);
	return req;
}

static void rpccli_lsa_lsaRQueryForestTrustInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_lsaRQueryForestTrustInformation_state *state = tevent_req_data(
		req, struct rpccli_lsa_lsaRQueryForestTrustInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.forest_trust_info = *state->tmp.out.forest_trust_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_lsaRQueryForestTrustInformation, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_lsaRQueryForestTrustInformation_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 NTSTATUS *result)
{
	struct rpccli_lsa_lsaRQueryForestTrustInformation_state *state = tevent_req_data(
		req, struct rpccli_lsa_lsaRQueryForestTrustInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_lsaRQueryForestTrustInformation(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    struct policy_handle *handle /* [in] [ref] */,
						    struct lsa_String *trusted_domain_name /* [in] [ref] */,
						    uint16_t unknown /* [in]  */,
						    struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */)
{
	struct lsa_lsaRQueryForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.trusted_domain_name = trusted_domain_name;
	r.in.unknown = unknown;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_lsaRQueryForestTrustInformation, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_lsaRQueryForestTrustInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state {
	struct lsa_LSARSETFORESTTRUSTINFORMATION orig;
	struct lsa_LSARSETFORESTTRUSTINFORMATION tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARSETFORESTTRUSTINFORMATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_done, req);
	return req;
}

static void rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       NTSTATUS *result)
{
	struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARSETFORESTTRUSTINFORMATION_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARSETFORESTTRUSTINFORMATION(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARSETFORESTTRUSTINFORMATION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARSETFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_CREDRRENAME_state {
	struct lsa_CREDRRENAME orig;
	struct lsa_CREDRRENAME tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_CREDRRENAME_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_CREDRRENAME_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_CREDRRENAME_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_CREDRRENAME_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRRENAME, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_CREDRRENAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_CREDRRENAME_done, req);
	return req;
}

static void rpccli_lsa_CREDRRENAME_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_CREDRRENAME_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRRENAME_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRRENAME, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_CREDRRENAME_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_CREDRRENAME_state *state = tevent_req_data(
		req, struct rpccli_lsa_CREDRRENAME_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_CREDRRENAME(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRRENAME r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRRENAME, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRRENAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRRENAME, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupSids3_state {
	struct lsa_LookupSids3 orig;
	struct lsa_LookupSids3 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupSids3_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupSids3_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct lsa_SidArray *_sids /* [in] [ref] */,
					       struct lsa_RefDomainList **_domains /* [out] [ref] */,
					       struct lsa_TransNameArray2 *_names /* [in,out] [ref] */,
					       enum lsa_LookupNamesLevel _level /* [in]  */,
					       uint32_t *_count /* [in,out] [ref] */,
					       enum lsa_LookupOptions _lookup_options /* [in]  */,
					       enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupSids3_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupSids3_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sids = _sids;
	state->orig.in.names = _names;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids3, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupSids3_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPSIDS3,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupSids3_done, req);
	return req;
}

static void rpccli_lsa_LookupSids3_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupSids3_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupSids3_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids3, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupSids3_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_lsa_LookupSids3_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupSids3_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupSids3(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct lsa_SidArray *sids /* [in] [ref] */,
				struct lsa_RefDomainList **domains /* [out] [ref] */,
				struct lsa_TransNameArray2 *names /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel level /* [in]  */,
				uint32_t *count /* [in,out] [ref] */,
				enum lsa_LookupOptions lookup_options /* [in]  */,
				enum lsa_ClientRevision client_revision /* [in]  */)
{
	struct lsa_LookupSids3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = sids;
	r.in.names = names;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids3, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPSIDS3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*names = *r.out.names;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LookupNames4_state {
	struct lsa_LookupNames4 orig;
	struct lsa_LookupNames4 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LookupNames4_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LookupNames4_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						uint32_t _num_names /* [in] [range(0,1000)] */,
						struct lsa_String *_names /* [in] [size_is(num_names)] */,
						struct lsa_RefDomainList **_domains /* [out] [ref] */,
						struct lsa_TransSidArray3 *_sids /* [in,out] [ref] */,
						enum lsa_LookupNamesLevel _level /* [in]  */,
						uint32_t *_count /* [in,out] [ref] */,
						enum lsa_LookupOptions _lookup_options /* [in]  */,
						enum lsa_ClientRevision _client_revision /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_lsa_LookupNames4_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LookupNames4_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.num_names = _num_names;
	state->orig.in.names = _names;
	state->orig.in.sids = _sids;
	state->orig.in.level = _level;
	state->orig.in.count = _count;
	state->orig.in.lookup_options = _lookup_options;
	state->orig.in.client_revision = _client_revision;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.sids = _sids;
	state->orig.out.count = _count;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames4, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_lsa_LookupNames4_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LOOKUPNAMES4,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LookupNames4_done, req);
	return req;
}

static void rpccli_lsa_LookupNames4_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LookupNames4_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames4_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.sids = *state->tmp.out.sids;
	*state->orig.out.count = *state->tmp.out.count;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames4, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LookupNames4_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_lsa_LookupNames4_state *state = tevent_req_data(
		req, struct rpccli_lsa_LookupNames4_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LookupNames4(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 uint32_t num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **domains /* [out] [ref] */,
				 struct lsa_TransSidArray3 *sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel level /* [in]  */,
				 uint32_t *count /* [in,out] [ref] */,
				 enum lsa_LookupOptions lookup_options /* [in]  */,
				 enum lsa_ClientRevision client_revision /* [in]  */)
{
	struct lsa_LookupNames4 r;
	NTSTATUS status;

	/* In parameters */
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames4, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES4,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames4, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSAROPENPOLICYSCE_state {
	struct lsa_LSAROPENPOLICYSCE orig;
	struct lsa_LSAROPENPOLICYSCE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSAROPENPOLICYSCE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSAROPENPOLICYSCE_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSAROPENPOLICYSCE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSAROPENPOLICYSCE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSAROPENPOLICYSCE, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSAROPENPOLICYSCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSAROPENPOLICYSCE_done, req);
	return req;
}

static void rpccli_lsa_LSAROPENPOLICYSCE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSAROPENPOLICYSCE_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSAROPENPOLICYSCE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSAROPENPOLICYSCE, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSAROPENPOLICYSCE_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_lsa_LSAROPENPOLICYSCE_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSAROPENPOLICYSCE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSAROPENPOLICYSCE(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct lsa_LSAROPENPOLICYSCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSAROPENPOLICYSCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSAROPENPOLICYSCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSAROPENPOLICYSCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state {
	struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE orig;
	struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARADTREGISTERSECURITYEVENTSOURCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_done, req);
	return req;
}

static void rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx,
							    NTSTATUS *result)
{
	struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct rpc_pipe_client *cli,
						       TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARADTREGISTERSECURITYEVENTSOURCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state {
	struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE orig;
	struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_done, req);
	return req;
}

static void rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      NTSTATUS *result)
{
	struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state {
	struct lsa_LSARADTREPORTSECURITYEVENT orig;
	struct lsa_LSARADTREPORTSECURITYEVENT tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_lsa_LSARADTREPORTSECURITYEVENT_done(struct tevent_req *subreq);

struct tevent_req *rpccli_lsa_LSARADTREPORTSECURITYEVENT_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_lsarpc,
				    NDR_LSA_LSARADTREPORTSECURITYEVENT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_lsa_LSARADTREPORTSECURITYEVENT_done, req);
	return req;
}

static void rpccli_lsa_LSARADTREPORTSECURITYEVENT_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_lsa_LSARADTREPORTSECURITYEVENT_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state *state = tevent_req_data(
		req, struct rpccli_lsa_LSARADTREPORTSECURITYEVENT_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_lsa_LSARADTREPORTSECURITYEVENT(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARADTREPORTSECURITYEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARADTREPORTSECURITYEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

