/*
   Unix SMB/CIFS implementation.
   User/Group specific flags

   Copyright (C) Andrew Tridgell 2001-2003

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* UserFlags for userAccountControl */
#define UF_SCRIPT	 			0x00000001  /* NT or Lan Manager Login script must be executed */
#define UF_ACCOUNTDISABLE			0x00000002
#define UF_00000004				0x00000004
#define UF_HOMEDIR_REQUIRED			0x00000008

#define UF_LOCKOUT				0x00000010
#define UF_PASSWD_NOTREQD			0x00000020
#define UF_PASSWD_CANT_CHANGE			0x00000040
#define UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED	0x00000080

#define UF_TEMP_DUPLICATE_ACCOUNT		0x00000100 /* Local user account in usrmgr */
#define UF_NORMAL_ACCOUNT			0x00000200
#define UF_00000400				0x00000400
#define UF_INTERDOMAIN_TRUST_ACCOUNT		0x00000800

#define UF_WORKSTATION_TRUST_ACCOUNT		0x00001000
#define UF_SERVER_TRUST_ACCOUNT			0x00002000
#define UF_00004000				0x00004000
#define UF_00008000				0x00008000

#define UF_DONT_EXPIRE_PASSWD			0x00010000
#define UF_MNS_LOGON_ACCOUNT			0x00020000
#define UF_SMARTCARD_REQUIRED			0x00040000
#define UF_TRUSTED_FOR_DELEGATION		0x00080000

#define UF_NOT_DELEGATED			0x00100000
#define UF_USE_DES_KEY_ONLY			0x00200000
#define UF_DONT_REQUIRE_PREAUTH			0x00400000
#define UF_PASSWORD_EXPIRED			0x00800000

#define UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION 0x01000000
#define UF_NO_AUTH_DATA_REQUIRED		0x02000000

#define UF_MACHINE_ACCOUNT_MASK (\
		UF_INTERDOMAIN_TRUST_ACCOUNT |\
		UF_WORKSTATION_TRUST_ACCOUNT |\
		UF_SERVER_TRUST_ACCOUNT \
		)

#define UF_ACCOUNT_TYPE_MASK (\
		UF_TEMP_DUPLICATE_ACCOUNT |\
		UF_NORMAL_ACCOUNT |\
		UF_INTERDOMAIN_TRUST_ACCOUNT |\
		UF_WORKSTATION_TRUST_ACCOUNT |\
		UF_SERVER_TRUST_ACCOUNT \
                )

#define UF_SETTABLE_BITS (\
		UF_SCRIPT |\
		UF_ACCOUNTDISABLE |\
		UF_HOMEDIR_REQUIRED  |\
		UF_LOCKOUT |\
		UF_PASSWD_NOTREQD |\
		UF_PASSWD_CANT_CHANGE |\
		UF_ACCOUNT_TYPE_MASK | \
		UF_DONT_EXPIRE_PASSWD | \
		UF_MNS_LOGON_ACCOUNT |\
		UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED |\
		UF_SMARTCARD_REQUIRED |\
		UF_TRUSTED_FOR_DELEGATION |\
		UF_NOT_DELEGATED |\
		UF_USE_DES_KEY_ONLY  |\
		UF_DONT_REQUIRE_PREAUTH \
		)

/* sAMAccountType */
#define ATYPE_NORMAL_ACCOUNT			0x30000000 /* 805306368 */
#define ATYPE_WORKSTATION_TRUST			0x30000001 /* 805306369 */
#define ATYPE_INTERDOMAIN_TRUST			0x30000002 /* 805306370 */
#define ATYPE_SECURITY_GLOBAL_GROUP		0x10000000 /* 268435456 */
#define ATYPE_DISTRIBUTION_GLOBAL_GROUP		0x10000001 /* 268435457 */
#define ATYPE_DISTRIBUTION_UNIVERSAL_GROUP	ATYPE_DISTRIBUTION_GLOBAL_GROUP
#define ATYPE_SECURITY_LOCAL_GROUP		0x20000000 /* 536870912 */
#define ATYPE_DISTRIBUTION_LOCAL_GROUP		0x20000001 /* 536870913 */

#define ATYPE_ACCOUNT		ATYPE_NORMAL_ACCOUNT		/* 0x30000000 805306368 */
#define ATYPE_GLOBAL_GROUP	ATYPE_SECURITY_GLOBAL_GROUP	/* 0x10000000 268435456 */
#define ATYPE_LOCAL_GROUP	ATYPE_SECURITY_LOCAL_GROUP	/* 0x20000000 536870912 */

/* groupType */
#define GROUP_TYPE_BUILTIN_LOCAL_GROUP		0x00000001
#define GROUP_TYPE_ACCOUNT_GROUP		0x00000002
#define GROUP_TYPE_RESOURCE_GROUP		0x00000004
#define GROUP_TYPE_UNIVERSAL_GROUP		0x00000008
#define GROUP_TYPE_APP_BASIC_GROUP		0x00000010
#define GROUP_TYPE_APP_QUERY_GROUP		0x00000020
#define GROUP_TYPE_SECURITY_ENABLED		0x80000000

#define GTYPE_SECURITY_BUILTIN_LOCAL_GROUP ( \
		/* 0x80000005 -2147483643 */ \
		GROUP_TYPE_BUILTIN_LOCAL_GROUP| \
		GROUP_TYPE_RESOURCE_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_SECURITY_DOMAIN_LOCAL_GROUP ( \
		/* 0x80000004 -2147483644 */ \
		GROUP_TYPE_RESOURCE_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_SECURITY_GLOBAL_GROUP ( \
		/* 0x80000002 -2147483646 */ \
		GROUP_TYPE_ACCOUNT_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_SECURITY_UNIVERSAL_GROUP ( \
		/* 0x80000008 -2147483656 */ \
		GROUP_TYPE_UNIVERSAL_GROUP| \
		GROUP_TYPE_SECURITY_ENABLED \
		)
#define GTYPE_DISTRIBUTION_GLOBAL_GROUP		0x00000002	/* 2 */
#define GTYPE_DISTRIBUTION_DOMAIN_LOCAL_GROUP	0x00000004	/* 4 */
#define GTYPE_DISTRIBUTION_UNIVERSAL_GROUP	0x00000008	/* 8 */

#define INSTANCE_TYPE_IS_NC_HEAD	0x00000001
#define INSTANCE_TYPE_UNINSTANT		0x00000002
#define INSTANCE_TYPE_WRITE		0x00000004
#define INSTANCE_TYPE_NC_ABOVE		0x00000008
#define INSTANCE_TYPE_NC_COMING		0x00000010
#define INSTANCE_TYPE_NC_GOING		0x00000020

#define SYSTEM_FLAG_CR_NTDS_NC			0x00000001
#define SYSTEM_FLAG_CR_NTDS_DOMAIN		0x00000002
#define SYSTEM_FLAG_CR_NTDS_NOT_GC_REPLICATED	0x00000004
#define SYSTEM_FLAG_SCHEMA_BASE_OBJECT		0x00000010
#define SYSTEM_FLAG_ATTR_IS_RDN			0x00000020
#define SYSTEM_FLAG_DISALLOW_MOVE_ON_DELETE	0x02000000
#define SYSTEM_FLAG_DOMAIN_DISALLOW_MOVE	0x04000000
#define SYSTEM_FLAG_DOMAIN_DISALLOW_RENAME	0x08000000
#define SYSTEM_FLAG_CONFIG_ALLOW_LIMITED_MOVE	0x10000000
#define SYSTEM_FLAG_CONFIG_ALLOW_MOVE		0x20000000
#define SYSTEM_FLAG_CONFIG_ALLOW_RENAME		0x40000000
#define SYSTEM_FLAG_DISALLOW_DELTE		0x80000000

#define SEARCH_FLAG_ATTINDEX		0x0000001
#define SEARCH_FLAG_PDNTATTINDEX	0x0000002
#define SEARCH_FLAG_ANR			0x0000004
#define SEARCH_FLAG_PRESERVEONDELETE	0x0000008
#define SEARCH_FLAG_COPY		0x0000010
#define SEARCH_FLAG_TUPLEINDEX		0x0000020
#define SEARCH_FLAG_SUBTREEATTRINDEX	0x0000040
#define SEARCH_FLAG_CONFIDENTIAL	0x0000080
#define SEARCH_FLAG_NEVERVALUEAUDIT	0x0000100
#define SEARCH_FLAG_RODC_ATTRIBUTE	0x0000200

#define DS_BEHAVIOR_WIN2000		0
#define DS_BEHAVIOR_WIN2003_INTERIM	1
#define DS_BEHAVIOR_WIN2003		2
#define DS_BEHAVIOR_WIN2008		3

/* Settings for the domainFunctionality attribute in the rootDSE */

#define DS_DOMAIN_FUNCTION_2000		0
#define DS_DOMAIN_FUCNTION_2003_MIXED	1
#define DS_DOMAIN_FUNCTION_2003		2
#define DS_DOMAIN_FUNCTION_2008		3

