//
//  PRCMedian.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Mar 25 2004.
//  Copyright (c) 2004 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.


#import "PRCMedian.h"
#import "PRMedian.h"
#import "MyDocument.h"


@implementation PRCMedian

- (IBAction)showMedian:(id)sender
{
    if (!medianWindow)
        [NSBundle loadNibNamed:@"Median" owner:self];
    [medianWindow makeKeyAndOrderFront:nil];
}

- (IBAction)medianOK:(id)sender
{
    enum medianForms theForm;
    BOOL isSeparable;
    int theSize;
    PRCProgress *filterProgr;
    
    filterProgr = [[PRCProgress alloc] init];
    [filterProgr showProgress:self];
    [filterProgr setTitle: @"Median"];
    
    if ([separableCheck state] == NSOnState)
        isSeparable = YES;
    else
        isSeparable = NO;
    
    switch ([[formSelect selectedItem] tag])
    {
        case 1: theForm = HORIZONTAL_F;
            break;
        case 2: theForm = VERTICAL_F;
            break;
        case 3: theForm = CROSS_F;
            break;
        case 4: theForm = BOX_F;
            break;
        default: NSLog(@"Unrecognized form selected");
            theForm = BOX_F;
    }
    
    theSize = [sizeSlider intValue];
    
    [[[NSDocumentController sharedDocumentController] currentDocument] makeMedian :theForm :theSize :isSeparable :filterProgr];
    [filterProgr release];
    
    if ([[NSApp delegate] prefClosePanels])
        [medianWindow performClose:nil];
}

- (IBAction)medianCancel:(id)sender
{
    [medianWindow performClose:nil];
}

- (IBAction)changeSize:(id)sender
{
    [sizeField setIntValue :[sizeSlider intValue] * 2 + 1];
}

@end
