/*
 Copyright (C) 2011 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

namespace Postler {
    public class FlowBox : Gtk.Container {
        List<Gtk.Widget> children;
        int last_row_count;
        int last_row_height;

        public FlowBox () {
            set_has_window (false);
        }

        public override void add (Gtk.Widget widget) {
            children.append (widget);
            widget.set_parent (this);
            if (get_realized ())
                widget.realize ();
        }

        public override void remove (Gtk.Widget widget) {
            children.remove (widget);
            widget.unparent ();
            if (widget.get_realized ())
                widget.unrealize ();
            queue_resize ();
        }

        public override void forall_internal (bool internal, Gtk.Callback callback) {
            foreach (var child in children)
                callback (child);
        }

        public void reorder_child (Gtk.Widget widget, int position) {
            children.remove (widget);
            children.insert (widget, position);
        }

        public override void map () {
            set_mapped (true);
            foreach (var child in children) {
                if (child.visible && !child.get_mapped ())
                    child.map ();
            }
        }

        public override void size_allocate (Gdk.Rectangle allocation) {
            int width = 0;
            int row_count = 1;
            int row_height = 1;

            foreach (var child in children) {
                if (child.visible) {
                    Gtk.Requisition child_size;
                    child.size_request (out child_size);
                    width += child_size.width;

                    if (width > allocation.width && width != child_size.width) {
                        row_count++;
                        width = child_size.width;
                    }
                    row_height = int.max (row_height, child_size.height);
                }
            }

            if (last_row_count != row_count || last_row_height != row_height) {
                last_row_count = row_count;
                last_row_height = row_height;
                set_size_request (-1, row_height * row_count);
            }

            width = 0;
            int row = 1;
            foreach (var child in children) {
                if (child.visible) {
                    Gtk.Requisition child_size;
                    child.size_request (out child_size);
                    width += child_size.width;
                    if (width > allocation.width && width != child_size.width) {
                        row++;
                        width = child_size.width;
                    }

                    var child_allocation = new Gdk.Rectangle ();
                    child_allocation.width = child_size.width;
                    child_allocation.height = row_height;
                    child_allocation.x = allocation.x + width - child_size.width;
                    child_allocation.y = allocation.y + row_height * (row - 1);
                    child.size_allocate (child_allocation);
                }
            }
        }
    }
}
