// This file is generated by doc/docbook/src/api2swigdoc.pl from
// doc/docbook/src/api.xml.  Do not modify by hand since this file
// will be overwritten.  Edit doc/docbook/src/api.xml instead.

%feature( "docstring", "Set format of numerical label for contours

DESCRIPTION:

    Set format of numerical label for contours. 

    Redacted form: pl_setcontlabelformat(lexp, sigdig)

    This function is used example 9. 



SYNOPSIS:

pl_setcontlabelformat(lexp, sigdig)

ARGUMENTS:

    lexp (PLINT, input) :    If the contour numerical label is greater
    than 10^(lexp) or less than 10^(-lexp), then the exponential
    format is used.  Default value of lexp is 4. 

    sigdig (PLINT, input) :    Number of significant digits.  Default
    value is 2. 
")
pl_setcontlabelformat;

%feature( "docstring", "Set parameters of contour labelling other than format of numerical label

DESCRIPTION:

    Set parameters of contour labelling other than those handled by
    pl_setcontlabelformat. 

    Redacted form: pl_setcontlabelparam(offset, size, spacing, active)

    This function is used in example 9. 



SYNOPSIS:

pl_setcontlabelparam(offset, size, spacing, active)

ARGUMENTS:

    offset (PLFLT, input) :    Offset of label from contour line (if set
    to 0.0, labels are printed on the lines).  Default value is 0.006. 

    size (PLFLT, input) :    Font height for contour labels (normalized). 
    Default value is 0.3. 

    spacing (PLFLT, input) :    Spacing parameter for contour labels. 
    Default value is 0.1. 

    active (PLINT, input) :    Activate labels.  Set to 1 if you want
    contour labels on. Default is off (0). 
")
pl_setcontlabelparam;

%feature( "docstring", "Advance the (sub-)page

DESCRIPTION:

    Advances to the next subpage if sub=0, performing a page advance if
    there are no remaining subpages on the current page.  If subpages
    aren't being used, pladv(0) will always advance the page.  If sub>0,
    PLplot switches to the specified subpage.  Note that this allows you
    to overwrite a plot on the specified subpage; if this is not what you
    intended, use pleop followed by plbop to first advance the page.  This
    routine is called automatically (with sub=0) by plenv, but if plenv is
    not used, pladv must be called after initializing PLplot but before
    defining the viewport. 

    Redacted form: pladv(sub)

    This function is used in examples 1,2,4,6-12,14-18,20,21,23-27,29,31. 



SYNOPSIS:

pladv(sub)

ARGUMENTS:

    sub (PLINT, input) :    Specifies the subpage number (starting from 1
    in the top left corner and increasing along the rows) to which to
    advance.  Set to zero to advance to the next subpage. 
")
pladv;

%feature( "docstring", "Draw a circular or elliptical arc 

DESCRIPTION:

    Draw a possible filled arc centered at x, y with semimajor axis  a and
    semiminor axis  b, starting at  angle1 and ending at  angle2. 

    Redacted form:  General: plarc(x, y, a, b, angle1, angle2, rotate, fill)


    This function is used in example 3. 



SYNOPSIS:

plarc(x, y, a, b, angle1, angle2, rotate, fill)

ARGUMENTS:

    x (PLFLT, input) :      X coordinate of arc center. 

    y (PLFLT, input) :      Y coordinate of arc center. 

    a (PLFLT, input) :      Length of the semimajor axis of the arc. 

    b (PLFLT, input) :      Length of the semiminor axis of the arc. 

    angle1 (PLFLT, input) :    Starting angle of the arc. 

    angle2 (PLFLT, input) :    Ending angle of the arc. 

    rotate (PLFLT, input) :    Rotation of arc

    fill (PLBOOL, input) :    Draw a filled arc. 
")
plarc;

%feature( "docstring", "Draw a box with axes, etc. with arbitrary origin 

DESCRIPTION:

    Draws a box around the currently defined viewport with arbitrary
    world-coordinate origin specified by x0 and y0 and labels it with
    world coordinate values appropriate to the window.	Thus plaxes should
    only be called after defining both viewport and window.  The character
    strings xopt and yopt specify how the box should be drawn as described
    below.  If ticks and/or subticks are to be drawn for a particular
    axis, the tick intervals and number of subintervals may be specified
    explicitly, or they may be defaulted by setting the appropriate
    arguments to zero. 

    Redacted form:  General: plaxes(x0, y0, xopt, xtick, nxsub, yopt,
    ytick, nysub)
	    Perl/PDL: plaxes(x0, y0, xtick, nxsub, ytick, nysub, xopt,
    yopt)


    This function is not used in any examples. 



SYNOPSIS:

plaxes(x0, y0, xopt, xtick, nxsub, yopt, ytick, nysub)

ARGUMENTS:

    x0 (PLFLT, input) :    World X coordinate of origin. 

    y0 (PLFLT, input) :    World Y coordinate of origin. 

    xopt (const char *, input) :    Pointer to character string specifying
    options for horizontal axis.  The string can include any
    combination of the following letters (upper or lower case) in any
    order: a: Draws axis, X-axis is horizontal line (y=0), and Y-axis
    is vertical line (x=0). 
        b: Draws bottom (X) or left (Y) edge of frame. 
        c: Draws top (X) or right (Y) edge of frame. 
        d: Plot labels as date / time.  Values are assumed to be
        seconds since the epoch  (as used by gmtime). 
        f:    Always use fixed point numeric labels. 
        g: Draws a grid at the major tick interval. 
        h: Draws a grid at the minor tick interval. 
        i: Inverts tick marks, so they are drawn outwards, rather than
        inwards. 
        l: Labels axis logarithmically.  This only affects the labels,
        not the data, and so it is necessary to compute the logarithms
        of data points before passing them to any of the drawing
        routines. 
        m: Writes numeric labels at major tick intervals in the
        unconventional location (above box for X, right of box for Y). 
        n: Writes numeric labels at major tick intervals in the
        conventional location (below box for X, left of box for Y). 
        o: Use custom labeling function to generate axis label text. 
        The custom labeling function can be defined with the
        plslabelfuncplslabelfunc; command. 
        s: Enables subticks between major ticks, only valid if t is
        also specified. 
        t: Draws major ticks. 


    xtick (PLFLT, input) :    World coordinate interval between major
    ticks on the x axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nxsub (PLINT, input) :    Number of subintervals between major x axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 

    yopt (const char *, input) :    Pointer to character string specifying
    options for vertical axis.  The string can include any combination
    of the letters defined above for xopt, and in addition may
    contain: v: Write numeric labels for vertical axis parallel to the
    base of the graph, rather than parallel to the axis. 


    ytick (PLFLT, input) :    World coordinate interval between major
    ticks on the y axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nysub (PLINT, input) :    Number of subintervals between major y axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 
")
plaxes;

%feature( "docstring", "Plot a histogram from binned data 

DESCRIPTION:

    Plots a histogram consisting of nbin bins.	The value associated with
    the i'th bin is placed in x[i], and the number of points in the bin is
    placed in y[i].  For proper operation, the values in x[i] must form a
    strictly increasing sequence.  By default, x[i] is the left-hand edge
    of the i'th bin. If opt=PL_BIN_CENTRED is used, the bin boundaries are
    placed midway between the values in the x array.  Also see plhist for
    drawing histograms from unbinned data. 

    Redacted form:  General: plbin(x, y, opt)
	    Perl/PDL: plbin(nbin, x, y, opt)
	    Python: plbin(nbin, x, y, opt)


    This function is not used in any examples. 



SYNOPSIS:

plbin(nbin, x, y, opt)

ARGUMENTS:

    nbin (PLINT, input) :    Number of bins (i.e., number of values in x
    and y arrays.) 

    x (PLFLT *, input) :    Pointer to array containing values associated
    with bins.  These must form a strictly increasing sequence. 

    y (PLFLT *, input) :    Pointer to array containing number of points
    in bin.  This is a PLFLT (instead of PLINT) array so as to allow
    histograms of probabilities, etc. 

    opt (PLINT, input) :    Is a combination of several flags:
    opt=PL_BIN_DEFAULT: The x represent the lower bin boundaries, the
    outer bins are expanded to fill up the entire x-axis and bins of
    zero height are simply drawn. 
        opt=PL_BIN_CENTRED|...: The bin boundaries are to be midway
        between the x values. If the values in x are equally spaced,
        the values are the center values of the bins. 
        opt=PL_BIN_NOEXPAND|...: The outer bins are drawn with equal
        size as the ones inside. 
        opt=PL_BIN_NOEMPTY|...: Bins with zero height are not drawn
        (there is a gap for such bins). 
")
plbin;

%feature( "docstring", "Begin a new page

DESCRIPTION:

    Begins a new page.	For a file driver, the output file is opened if
    necessary.	Advancing the page via pleop and plbop is useful when a
    page break is desired at a particular point when plotting to subpages.
     Another use for pleop and plbop is when plotting pages to different
    files, since you can manually set the file name by calling plsfnam
    after the call to pleop. (In fact some drivers may only support a
    single page per file, making this a necessity.)  One way to handle
    this case automatically is to page advance via pladv, but enable
    familying (see plsfam) with a small limit on the file size so that a
    new family member file will be created on each page break. 

    Redacted form: plbop()

    This function is used in examples 2,20. 



SYNOPSIS:

plbop()
")
plbop;

%feature( "docstring", "Draw a box with axes, etc

DESCRIPTION:

    Draws a box around the currently defined viewport, and labels it with
    world coordinate values appropriate to the window.	Thus plbox should
    only be called after defining both viewport and window.  The character
    strings xopt and yopt specify how the box should be drawn as described
    below.  If ticks and/or subticks are to be drawn for a particular
    axis, the tick intervals and number of subintervals may be specified
    explicitly, or they may be defaulted by setting the appropriate
    arguments to zero. 

    Redacted form:  General: plbox(xopt, xtick, nxsub, yopt, ytick, nysub)
	    Perl/PDL: plbox(xtick, nxsub, ytick, nysub, xopt, yopt)


    This function is used in examples 1,2,4,6,6-12,14-18,21,23-26,29. 



SYNOPSIS:

plbox(xopt, xtick, nxsub, yopt, ytick, nysub)

ARGUMENTS:

    xopt (const char *, input) :    Pointer to character string specifying
    options for horizontal axis.  The string can include any
    combination of the following letters (upper or lower case) in any
    order: a: Draws axis, X-axis is horizontal line (y=0), and Y-axis
    is vertical line (x=0). 
        b: Draws bottom (X) or left (Y) edge of frame. 
        c: Draws top (X) or right (Y) edge of frame. 
        d: Plot labels as date / time.  Values are assumed to be
        seconds since the epoch  (as used by gmtime). 
        f:    Always use fixed point numeric labels. 
        g: Draws a grid at the major tick interval. 
        h: Draws a grid at the minor tick interval. 
        i: Inverts tick marks, so they are drawn outwards, rather than
        inwards. 
        l: Labels axis logarithmically.  This only affects the labels,
        not the data, and so it is necessary to compute the logarithms
        of data points before passing them to any of the drawing
        routines. 
        m: Writes numeric labels at major tick intervals in the
        unconventional location (above box for X, right of box for Y). 
        n: Writes numeric labels at major tick intervals in the
        conventional location (below box for X, left of box for Y). 
        o: Use custom labeling function to generate axis label text. 
        The custom labeling function can be defined with the
        plslabelfuncplslabelfunc; command. 
        s: Enables subticks between major ticks, only valid if t is
        also specified. 
        t: Draws major ticks. 


    xtick (PLFLT, input) :    World coordinate interval between major
    ticks on the x axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nxsub (PLINT, input) :    Number of subintervals between major x axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 

    yopt (const char *, input) :    Pointer to character string specifying
    options for vertical axis.  The string can include any combination
    of the letters defined above for xopt, and in addition may
    contain: v: Write numeric labels for vertical axis parallel to the
    base of the graph, rather than parallel to the axis. 


    ytick (PLFLT, input) :    World coordinate interval between major
    ticks on the y axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nysub (PLINT, input) :    Number of subintervals between major y axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 
")
plbox;

%feature( "docstring", "Draw a box with axes, etc, in 3-d 

DESCRIPTION:

    Draws axes, numeric and text labels for a three-dimensional surface
    plot.  For a more complete description of three-dimensional plotting
    see the PLplot documentation. 

    Redacted form:  General: plbox3(xopt, xlabel, xtick, nxsub, yopt,
    ylabel, ytick, nysub, zopt, zlabel, ztick, nzsub)
	    Perl/PDL: plbox3(xtick, nxsub, ytick, nysub, ztick, nzsub,
    xopt, xlabel, yopt, ylabel, zopt, zlabel)


    This function is used in examples 8,11,18,21. 



SYNOPSIS:

plbox3(xopt, xlabel, xtick, nxsub, yopt, ylabel, ytick, nysub, zopt, zlabel, ztick, nzsub)

ARGUMENTS:

    xopt (const char *, input) :    Pointer to character string specifying
    options for the x axis. The string can include any combination of
    the following letters (upper or lower case) in any order: b: Draws
    axis at base, at height z=
    zmin where zmin is defined by call to plw3d.  This character must be
    specified in order to use any of the other options. 
        f: Always use fixed point numeric labels. 
        i: Inverts tick marks, so they are drawn downwards, rather
        than upwards. 
        l: Labels axis logarithmically.  This only affects the labels,
        not the data, and so it is necessary to compute the logarithms
        of data points before passing them to any of the drawing
        routines. 
        n: Writes numeric labels at major tick intervals. 
        o: Use custom labeling function to generate axis label text. 
        The custom labeling function can be defined with the
        plslabelfuncplslabelfunc; command. 
        s: Enables subticks between major ticks, only valid if t is
        also specified. 
        t: Draws major ticks. 
        u: If this is specified, the text label for the axis is
        written under the axis. 


    xlabel (const char *, input) :    Pointer to character string
    specifying text label for the x axis.  It is only drawn if u is in
    the xopt string. 

    xtick (PLFLT, input) :    World coordinate interval between major
    ticks on the x axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nxsub (PLINT, input) :    Number of subintervals between major x axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 

    yopt (const char *, input) :    Pointer to character string specifying
    options for the y axis. The string is interpreted in the same way
    as xopt. 

    ylabel (const char *, input) :    Pointer to character string
    specifying text label for the y axis.  It is only drawn if u is in
    the yopt string. 

    ytick (PLFLT, input) :    World coordinate interval between major
    ticks on the y axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nysub (PLINT, input) :    Number of subintervals between major y axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 

    zopt (const char *, input) :    Pointer to character string specifying
    options for the z axis. The string can include any combination of
    the following letters (upper or lower case) in any order: b: Draws
    z axis to the left of the surface plot. 
        c: Draws z axis to the right of the surface plot. 
        d: Draws grid lines parallel to the x-y plane behind the
        figure.  These lines are not drawn until after plot3d or
        plmesh are called because of the need for hidden line removal. 
        f: Always use fixed point numeric labels. 
        i: Inverts tick marks, so they are drawn away from the center. 
        l: Labels axis logarithmically.  This only affects the labels,
        not the data, and so it is necessary to compute the logarithms
        of data points before passing them to any of the drawing
        routines. 
        m: Writes numeric labels at major tick intervals on the
        right-hand vertical axis. 
        n: Writes numeric labels at major tick intervals on the
        left-hand vertical axis. 
        o: Use custom labeling function to generate axis label text. 
        The custom labeling function can be defined with the
        plslabelfuncplslabelfunc; command. 
        s: Enables subticks between major ticks, only valid if t is
        also specified. 
        t: Draws major ticks. 
        u: If this is specified, the text label is written beside the
        left-hand axis. 
        v: If this is specified, the text label is written beside the
        right-hand axis. 


    zlabel (const char *, input) :    Pointer to character string
    specifying text label for the z axis.  It is only drawn if u or v
    are in the zopt string. 

    ztick (PLFLT, input) :    World coordinate interval between major
    ticks on the z axis. If it is set to zero, PLplot automatically
    generates a suitable tick interval. 

    nzsub (PLINT, input) :    Number of subintervals between major z axis
    ticks for minor ticks.    If it is set to zero, PLplot automatically
    generates a suitable minor tick interval. 
")
plbox3;

%feature( "docstring", "Calculate world coordinates and corresponding window index from relative device coordinates 

DESCRIPTION:

    Calculate world coordinates, wx and wy, and corresponding window index
    from relative device coordinates, rx and ry. 

    Redacted form:  General: plcalc_world(rx, ry, wx, wy, window)
	    Perl/PDL: Not available? 


    This function is used in example 31. 



SYNOPSIS:

plcalc_world(rx, ry, wx, wy, window)

ARGUMENTS:

    rx (PLFLT, input) :    Input relative device coordinate (ranging from
    0. to 1.) for the x coordinate. 

    ry (PLFLT, input) :    Input relative device coordinate (ranging from
    0. to 1.) for the y coordinate. 

    wx (PLFLT *, output) :    Pointer to the returned world coordinate for
    x corresponding to the relative device coordinates rx and ry. 

    wy (PLFLT *, output) :    Pointer to the returned world coordinate for
    y corresponding to the relative device coordinates rx and ry. 

    window (PLINT *, output) :      Pointer to the returned last defined
    window index that corresponds to the input relative device
    coordinates (and the returned world coordinates).  To give some
    background on the window index, for each page the initial window
    index is set to zero, and each time plwind is called within the
    page, world and device coordinates are stored for the window and
    the window index is incremented.  Thus, for a simple page layout
    with non-overlapping viewports and one window per viewport, window
    corresponds to the viewport index (in the order which the
    viewport/windows were created) of the only viewport/window
    corresponding to rx and ry.  However, for more complicated layouts
    with potentially overlapping viewports and possibly more than one
    window (set of world coordinates) per viewport, window and the
    corresponding output world coordinates corresponds to the last
    window created that fulfils the criterion that the relative device
    coordinates are inside it.  Finally, in all cases where the input
    relative device coordinates are not inside any viewport/window,
    then window is set to -1. 
")
plcalc_world;

%feature( "docstring", "Clear current (sub)page 

DESCRIPTION:

    Clears the current page, effectively erasing everything that have been
    drawn.  This command only works with interactive drivers; if the
    driver does not support this, the page is filled with the background
    color in use. If the current page is divided into subpages, only the
    current subpage is erased.	The nth subpage can be selected with
    pladv(n). 

    Redacted form:  General: plclear()
	    Perl/PDL: Not available? 


    This function is not used in any examples. 



SYNOPSIS:

plclear()
")
plclear;

%feature( "docstring", "Set color, map0 

DESCRIPTION:

    Sets the color for color map0 (see the PLplot documentation). 

    Redacted form: plcol0(color)

    This function is used in examples 1-9,11-16,18-27,29. 



SYNOPSIS:

plcol0(color)

ARGUMENTS:

    color (PLINT, input) :    Integer representing the color.  The
    defaults at present are (these may change): 
    0       black (default background) 
    1       red (default foreground) 
    2       yellow 
    3       green 
    4       aquamarine 
    5       pink 
    6       wheat 
    7       grey 
    8       brown 
    9       blue 
    10        BlueViolet 
    11        cyan 
    12        turquoise 
    13        magenta 
    14        salmon 
    15        white 
      Use plscmap0 to change the entire map0 color palette and plscol0 to
     change an individual color in the map0 color palette. 
")
plcol0;

%feature( "docstring", "Set color, map1 

DESCRIPTION:

    Sets the color for color map1 (see the PLplot documentation).  

    Redacted form: plcol1(col1)

    This function is used in example 12. 



SYNOPSIS:

plcol1(col1)

ARGUMENTS:

    col1 (PLFLT, input) :    This value must be in the range from 0. to 1.
    and is mapped to color using the continuous map1 color palette
    which by default ranges from blue to the background color to red. 
    The map1 palette can also be straightforwardly changed by the user
    with plscmap1 or plscmap1l. 
")
plcol1;

%feature( "docstring", "Contour plot 

DESCRIPTION:

    Draws a contour plot of the data in z[
    nx][
    ny], using the nlevel contour levels specified by clevel. Only the
    region of the array from kx to lx and from ky to ly is plotted out.  A
    transformation routine pointed to by pltr with a pointer pltr_data for
    additional data required by the transformation routine is used to map
    indices within the array to the world coordinates.	See the following
    discussion of the arguments and the PLplot documentation for more
    information. 

    Redacted form: [PLEASE UPDATE! ONLY PERL INFO IS LIKELY CORRECT!] F95:
    plcont(z, kx, lx, ky, ly, clevel, tr?) or plcont(z, kx, lx, ky, ly,
    clevel, xgrid, ygrid)
	    Java: pls.cont(z, kx, lx, ky, ly, clevel, xgrid, ygrid)
	    Perl/PDL: plcont(z, kx, lx, ky, ly, clevel, pltr, pltr_data)
	    Python: plcont2(z, kx, lx, ky, ly, clevel)


    This function is used in examples 9,14,16,22. 



SYNOPSIS:

plcont(z, nx, ny, kx, lx, ky, ly, clevel, nlevel, pltr, pltr_data)

ARGUMENTS:

    z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
    containing data to be contoured. 

    nx, ny (PLINT, input) :    Physical dimensions of array z. 

    kx, lx (PLINT, input) :    Range of x indices to consider. 

    ky, ly (PLINT, input) :    Range of y indices to consider. 

    clevel (PLFLT *, input) :     Pointer to array specifying levels at
    which to draw contours. 

    nlevel (PLINT, input) :    Number of contour levels to draw. 

    pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
      Pointer to function that defines transformation between indices
    in array z and the world coordinates (C only).    Transformation
    functions are provided in the PLplot library: pltr0 for identity
    mapping, and pltr1 and pltr2 for arbitrary mappings respectively
    defined by one- and two-dimensional arrays.  In addition,
    user-supplied routines for the transformation can be used as well.
     Examples of all of these approaches are given in the PLplot
    documentation. The transformation function should have the form
    given by any of pltr0, pltr1, or pltr2. Note that unlike plshades
    and similar PLplot functions which have a pltr argument, plcont
    requires that a transformation function be provided in the C
    interface.  Leaving  pltr NULL will result in an error. 

    pltr_data (PLPointer, input) :    Extra parameter to help pass
    information to pltr0, pltr1, pltr2, or whatever routine that is
    externally supplied. 
")
plcont;

%feature( "docstring", "Copy state parameters from the reference stream to the current stream 

DESCRIPTION:

    Copies state parameters from the reference stream to the current
    stream. Tell driver interface to map device coordinates unless flags
    == 1. 

    This function is used for making save files of selected plots (e.g.
    from the TK driver).  After initializing, you can get a copy of the
    current plot to the specified device by switching to this stream and
    issuing a plcpstrm and a plreplot, with calls to plbop and pleop as
    appropriate.  The plot buffer must have previously been enabled (done
    automatically by some display drivers, such as X). 

    Redacted form: plcpstrm(iplsr, flags)

    This function is used in example 1,20. 



SYNOPSIS:

plcpstrm(iplsr, flags)

ARGUMENTS:

    iplsr (PLINT, input) :    Number of reference stream. 

    flags (PLBOOL, input) :    If flags is set to true the device
    coordinates are not copied from the reference to current stream. 
")
plcpstrm;

%feature( "docstring", "End plotting session 

DESCRIPTION:

    Ends a plotting session, tidies up all the output files, switches
    interactive devices back into text mode and frees up any memory that
    was allocated.  Must be called before end of program. 

    By default, PLplot's interactive devices (Xwin, TK, etc.)  go into a
    wait state after a call to plend or other functions which trigger the
    end of a plot page. To avoid this, use the plspause function. 

    Redacted form: plend()

    This function is used in all of the examples. 



SYNOPSIS:

plend()
")
plend;

%feature( "docstring", "End plotting session for current stream 

DESCRIPTION:

    Ends a plotting session for the current output stream only.  See
    plsstrm for more info. 

    Redacted form: plend1()

    This function is used in examples 1,20. 



SYNOPSIS:

plend1()
")
plend1;

%feature( "docstring", "Same as plenv but if in multiplot mode does not advance the subpage, instead clears it. 

DESCRIPTION:

    Sets up plotter environment for simple graphs by calling pladv and
    setting up viewport and window to sensible default values.	plenv0
    leaves enough room around most graphs for axis labels and a title.
    When these defaults are not suitable, use the individual routines
    plvpas, plvpor, or plvasp for setting up the viewport, plwind for
    defining the window, and plbox for drawing the box. 

    Redacted form: plenv0(xmin, xmax, ymin, ymax, just, axis)

    This function is used in example 21. 



SYNOPSIS:

plenv0(xmin, xmax, ymin, ymax, just, axis)

ARGUMENTS:

    xmin (PLFLT, input) :    Value of x at left-hand edge of window (in
    world coordinates). 

    xmax (PLFLT, input) :    Value of x at right-hand edge of window (in
    world coordinates). 

    ymin (PLFLT, input) :    Value of y at bottom edge of window (in world
    coordinates). 

    ymax (PLFLT, input) :    Value of y at top edge of window (in world
    coordinates). 

    just (PLINT, input) :    Controls how the axes will be scaled: -1: the
    scales will not be set, the user must set up the scale before
    calling plenv0 using plsvpa, plvasp or other. 
        0: the x and y axes are scaled independently to use as much of
        the screen as possible. 
        1: the scales of the x and y axes are made equal. 
        2: the axis of the x and y axes are made equal, and the plot
        box will be square. 


    axis (PLINT, input) :    Controls drawing of the box around the plot:
    -2: draw no box, no tick marks, no numeric tick labels, no axes. 
        -1: draw box only. 
        0: draw box, ticks, and numeric tick labels. 
        1: also draw coordinate axes at x=0 and y=0. 
        2: also draw a grid at major tick positions in both
        coordinates. 
        3: also draw a grid at minor tick positions in both
        coordinates. 
        10: same as 0 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        11: same as 1 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        12: same as 2 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        13: same as 3 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        20: same as 0 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        21: same as 1 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        22: same as 2 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        23: same as 3 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        30: same as 0 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        31: same as 1 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        32: same as 2 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        33: same as 3 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        40: same as 0 except date / time x labels.    
        41: same as 1 except date / time x labels.    
        42: same as 2 except date / time x labels.    
        43: same as 3 except date / time x labels.    
        50: same as 0 except date / time y labels.    
        51: same as 1 except date / time y labels.    
        52: same as 2 except date / time y labels. 
        53: same as 3 except date / time y labels.    
        60: same as 0 except date / time x and y labels.  
        61: same as 1 except date / time x and y labels.  
        62: same as 2 except date / time x and y labels.  
        63: same as 3 except date / time x and y labels. 
        70: same as 0 except custom x and y labels. 
        71: same as 1 except custom x and y labels. 
        72: same as 2 except custom x and y labels. 
        73: same as 3 except custom x and y labels. 
")
plenv0;

%feature( "docstring", "Set up standard window and draw box 

DESCRIPTION:

    Sets up plotter environment for simple graphs by calling pladv and
    setting up viewport and window to sensible default values.	plenv
    leaves enough room around most graphs for axis labels and a title.
    When these defaults are not suitable, use the individual routines
    plvpas, plvpor, or plvasp for setting up the viewport, plwind for
    defining the window, and plbox for drawing the box. 

    Redacted form: plenv(xmin, xmax, ymin, ymax, just, axis)

    This function is used in example 1,3,9,13,14,19-22,29. 



SYNOPSIS:

plenv(xmin, xmax, ymin, ymax, just, axis)

ARGUMENTS:

    xmin (PLFLT, input) :    Value of x at left-hand edge of window (in
    world coordinates). 

    xmax (PLFLT, input) :    Value of x at right-hand edge of window (in
    world coordinates). 

    ymin (PLFLT, input) :    Value of y at bottom edge of window (in world
    coordinates). 

    ymax (PLFLT, input) :    Value of y at top edge of window (in world
    coordinates). 

    just (PLINT, input) :    Controls how the axes will be scaled: -1: the
    scales will not be set, the user must set up the scale before
    calling plenv using plsvpa, plvasp or other. 
        0: the x and y axes are scaled independently to use as much of
        the screen as possible. 
        1: the scales of the x and y axes are made equal. 
        2: the axis of the x and y axes are made equal, and the plot
        box will be square. 


    axis (PLINT, input) :    Controls drawing of the box around the plot:
    -2: draw no box, no tick marks, no numeric tick labels, no axes. 
        -1: draw box only. 
        0: draw box, ticks, and numeric tick labels. 
        1: also draw coordinate axes at x=0 and y=0. 
        2: also draw a grid at major tick positions in both
        coordinates. 
        3: also draw a grid at minor tick positions in both
        coordinates. 
        10: same as 0 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        11: same as 1 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        12: same as 2 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        13: same as 3 except logarithmic x tick marks. (The x data
        have to be converted to logarithms separately.) 
        20: same as 0 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        21: same as 1 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        22: same as 2 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        23: same as 3 except logarithmic y tick marks. (The y data
        have to be converted to logarithms separately.) 
        30: same as 0 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        31: same as 1 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        32: same as 2 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        33: same as 3 except logarithmic x and y tick marks. (The x
        and y data have to be converted to logarithms separately.) 
        40: same as 0 except date / time x labels.    
        41: same as 1 except date / time x labels.    
        42: same as 2 except date / time x labels.    
        43: same as 3 except date / time x labels.    
        50: same as 0 except date / time y labels.    
        51: same as 1 except date / time y labels.    
        52: same as 2 except date / time y labels. 
        53: same as 3 except date / time y labels.    
        60: same as 0 except date / time x and y labels.  
        61: same as 1 except date / time x and y labels.  
        62: same as 2 except date / time x and y labels.  
        63: same as 3 except date / time x and y labels. 
        70: same as 0 except custom x and y labels. 
        71: same as 1 except custom x and y labels. 
        72: same as 2 except custom x and y labels. 
        73: same as 3 except custom x and y labels. 
")
plenv;

%feature( "docstring", "Eject current page 

DESCRIPTION:

    Clears the graphics screen of an interactive device, or ejects a page
    on a plotter.  See plbop for more information. 

    Redacted form: pleop()

    This function is used in example 2,14. 



SYNOPSIS:

pleop()
")
pleop;

%feature( "docstring", "Draw x error bar 

DESCRIPTION:

    Draws a set of n horizontal error bars, the i'th error bar extending
    from xmin[i] to xmax[i] at y coordinate y[i].  The terminals of the
    error bar are of length equal to the minor tick length (settable using
    plsmin). 

    Redacted form:  General: plerrx(xmin, ymax, y)
	    Perl/PDL: plerrx(n, xmin, xmax, y)


    This function is used in example 29. 



SYNOPSIS:

plerrx(n, xmin, xmax, y)

ARGUMENTS:

    n (PLINT, input) :      Number of error bars to draw. 

    xmin (PLFLT *, input) :    Pointer to array with x coordinates of
    left-hand endpoint of error bars. 

    xmax (PLFLT *, input) :    Pointer to array with x coordinates of
    right-hand endpoint of error bars. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of error
    bar. 
")
plerrx;

%feature( "docstring", "Draw y error bar 

DESCRIPTION:

    Draws a set of n vertical error bars, the i'th error bar extending
    from ymin[i] to ymax[i] at x coordinate x[i].  The terminals of the
    error bar are of length equal to the minor tick length (settable using
    plsmin). 

    Redacted form:  General: plerry(x, ymin, ymax)
	    Perl/PDL: plerry(n, x, ymin, ymax)


    This function is used in example 29. 



SYNOPSIS:

plerry(n, x, ymin, ymax)

ARGUMENTS:

    n (PLINT, input) :      Number of error bars to draw. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of error
    bars. 

    ymin (PLFLT *, input) :    Pointer to array with y coordinates of
    lower endpoint of error bars. 

    ymax (PLFLT *, input) :    Pointer to array with y coordinate of upper
    endpoint of error bar. 
")
plerry;

%feature( "docstring", "Advance to the next family file on the next new page 

DESCRIPTION:

    Advance to the next family file on the next new page. 

    Redacted form: plfamadv()

    This function is not used in any examples. 



SYNOPSIS:

plfamadv()
")
plfamadv;

%feature( "docstring", "Draw filled polygon 

DESCRIPTION:

    Fills the polygon defined by the n points (
    x[i], 
    y[i]) using the pattern defined by plpsty or plpat.  The routine will
    automatically close the polygon between the last and first vertices. 
    If multiple closed polygons are passed in x and y then plfill will
    fill in between them. 

    Redacted form: plfill(x,y)

    This function is used in examples 12,13,15,16,21,24,25. 



SYNOPSIS:

plfill(n, x, y)

ARGUMENTS:

    n (PLINT, input) :      Number of vertices in polygon. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of
    vertices. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of
    vertices. 
")
plfill;

%feature( "docstring", "Draw filled polygon in 3D 

DESCRIPTION:

    Fills the 3D polygon defined by the n points in the x, y, and z arrays
    using the pattern defined by plpsty or plpat.  The routine will
    automatically close the polygon between the last and first vertices. 
    If multiple closed polygons are passed in x, y, and z then plfill3
    will fill in between them. 

    Redacted form:  General: plfill3(x, y, z)
	    Perl/PDL: plfill3(n, x, y, z)


    This function is used in example 15. 



SYNOPSIS:

plfill3(n, x, y, z)

ARGUMENTS:

    n (PLINT, input) :      Number of vertices in polygon. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of
    vertices. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of
    vertices. 

    z (PLFLT *, input) :    Pointer to array with z coordinates of
    vertices. 
")
plfill3;

%feature( "docstring", "Flushes the output stream 

DESCRIPTION:

    Flushes the output stream. Use sparingly, if at all. 

    Redacted form: plflush()

    This function is used in examples 1,14. 



SYNOPSIS:

plflush()
")
plflush;

%feature( "docstring", "Set character font 

DESCRIPTION:

    Sets the default character font for subsequent character drawing. Also
    affects symbols produced by plpoin.  This routine has no effect unless
    the extended character set is loaded (see plfontld). 

    Redacted form: plfont(font)

    This function is used in examples 1,2,4,7,13,24,26. 



SYNOPSIS:

plfont(font)

ARGUMENTS:

    font (PLINT, input) :    Specifies the font: 1: Normal font (simplest
    and fastest) 
        2: Roman font 
        3: Italic font 
        4: Script font 
")
plfont;

%feature( "docstring", "Load character font 

DESCRIPTION:

    Sets the character set to use for subsequent character drawing.  May
    be called before initializing PLplot. 

    Redacted form: plfontld(set)

    This function is used in examples 1,7. 



SYNOPSIS:

plfontld(set)

ARGUMENTS:

    set (PLINT, input) :    Specifies the character set to load: 0:
    Standard character set 
        1: Extended character set 
")
plfontld;

%feature( "docstring", "Get character default height and current (scaled) height 

DESCRIPTION:

    Get character default height and current (scaled) height. 

    Redacted form: plgchr(p_def, p_ht)

    This function is used in example 23. 



SYNOPSIS:

plgchr(p_def, p_ht)

ARGUMENTS:

    p_def (PLFLT *, output) :     Pointer to default character height (mm). 

    p_ht (PLFLT *, output) :    Pointer to current (scaled) character
    height (mm). 
")
plgchr;

%feature( "docstring", "Returns 8-bit RGB values for given color from color map0 

DESCRIPTION:

    Returns 8-bit RGB values (0-255) for given color from color map0 (see
    the PLplot documentation).	Values are negative if an invalid color id
    is given. 

    Redacted form: plgcol0(icol0, r, g, b)

    This function is used in example 2. 



SYNOPSIS:

plgcol0(icol0, r, g, b)

ARGUMENTS:

    icol0 (PLINT, input) :    Index of desired cmap0 color. 

    r (PLINT *, output) :    Pointer to 8-bit red value. 

    g (PLINT *, output) :    Pointer to 8-bit green value. 

    b (PLINT *, output) :    Pointer to 8-bit blue value. 
")
plgcol0;

%feature( "docstring", "Returns 8-bit RGB values and double alpha value for given color from color map0. 

DESCRIPTION:

    Returns 8-bit RGB values (0-255) and double alpha value (0.0 - 1.0)
    for  given color from color map0 (see the PLplot documentation). 
    Values  are negative if an invalid color id is given. 

    This function is used in example 30. 



SYNOPSIS:

plgcol0a(icol0, r, g, b, a)

ARGUMENTS:

    icol0 (PLINT, input) :    Index of desired cmap0 color. 

    r (PLINT *, output) :    Pointer to 8-bit red value. 

    g (PLINT *, output) :    Pointer to 8-bit green value. 

    b (PLINT *, output) :    Pointer to 8-bit blue value. 

    a (PLFLT *, output) :    Pointer to PLFLT alpha value. 
")
plgcol0a;

%feature( "docstring", " Returns the background color (cmap0[0]) by 8-bit RGB value 

DESCRIPTION:

    Returns the background color (cmap0[0]) by 8-bit RGB value. 

    Redacted form: plgcolbg(r, g, b)

    This function is used in example 31. 



SYNOPSIS:

plgcolbg(r, g, b)

ARGUMENTS:

    r (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
    representing the degree of red in the color. 

    g (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
    representing the degree of green in the color. 

    b (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
    representing the degree of blue in the color. 
")
plgcolbg;

%feature( "docstring", " Returns the background color (cmap0[0])  by 8-bit RGB value and double alpha value. 

DESCRIPTION:

    Returns the background color (cmap0[0]) by 8-bit RGB value and double
    alpha value. 

    This function is used in example 31. 



SYNOPSIS:

plgcolbga(r, g, b, a)

ARGUMENTS:

    r (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
    representing the degree of red in the color. 

    g (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
    representing the degree of green in the color. 

    b (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
    representing the degree of blue in the color. 

    a (PLFLT *, output) :    Pointer to PLFLT alpha value. 
")
plgcolbga;

%feature( "docstring", "Get the current device-compression setting 

DESCRIPTION:

    Get the current device-compression setting.  This parameter is only
    used for drivers that provide compression. 

    Redacted form: plgcompression(compression)

    This function is used in example 31. 



SYNOPSIS:

plgcompression(compression)

ARGUMENTS:

    compression (PLINT *, output) :    Pointer to a variable to be filled
    with the current device-compression setting. 
")
plgcompression;

%feature( "docstring", "Get the current device (keyword) name 

DESCRIPTION:

    Get the current device (keyword) name.  Note: you must have allocated
    space for this (80 characters is safe). 

    Redacted form: plgdev(p_dev)

    This function is used in example 14. 



SYNOPSIS:

plgdev(p_dev)

ARGUMENTS:

    p_dev (char *, output) :    Pointer to device (keyword) name string. 
")
plgdev;

%feature( "docstring", "Get parameters that define current device-space window 

DESCRIPTION:

    Get relative margin width, aspect ratio, and relative justification
    that define current device-space window. If plsdidev has not been
    called the default values pointed to by p_mar, p_aspect, p_jx, and
    p_jy will all be 0. 

    Redacted form: plgdidev(p_mar, p_aspect, p_jx, p_jy)

    This function is used in example 31. 



SYNOPSIS:

plgdidev(p_mar, p_aspect, p_jx, p_jy)

ARGUMENTS:

    p_mar (PLFLT *, output) :     Pointer to relative margin width. 

    p_aspect (PLFLT *, output) :    Pointer to aspect ratio. 

    p_jx (PLFLT *, output) :    Pointer to relative justification in x. 

    p_jy (PLFLT *, output) :    Pointer to relative justification in y. 
")
plgdidev;

%feature( "docstring", "Get plot orientation 

DESCRIPTION:

    Get plot orientation parameter which is multiplied by 90 degrees to
    obtain the angle of rotation.  Note, arbitrary rotation parameters
    such as 0.2 (corresponding to 18 degrees) are possible, but the usual
    values for the rotation parameter are 0., 1., 2., and 3. corresponding
    to 0 degrees (landscape mode), 90 degrees (portrait mode), 180 degrees
    (seascape mode), and 270 degrees (upside-down mode). If plsdiori has
    not been called the default value pointed to by p_rot will be 0. 

    Redacted form: plgdiori(p_rot)

    This function is not used in any examples. 



SYNOPSIS:

plgdiori(p_rot)

ARGUMENTS:

    p_rot (PLFLT *, output) :     Pointer to orientation parameter. 
")
plgdiori;

%feature( "docstring", "Get parameters that define current plot-space window 

DESCRIPTION:

    Get relative minima and maxima that define current plot-space window.
    If plsdiplt has not been called the default values pointed to by
    p_xmin, p_ymin, p_xmax, and p_ymax will be 0., 0., 1., and 1. 

    Redacted form: plgdiplt(p_xmin, p_ymin, p_xmax, p_ymax)

    This function is used in example 31. 



SYNOPSIS:

plgdiplt(p_xmin, p_ymin, p_xmax, p_ymax)

ARGUMENTS:

    p_xmin (PLFLT *, output) :      Pointer to relative minimum in x. 

    p_ymin (PLFLT *, output) :      Pointer to relative minimum in y. 

    p_xmax (PLFLT *, output) :      Pointer to relative maximum in x. 

    p_ymax (PLFLT *, output) :      Pointer to relative maximum in y. 
")
plgdiplt;

%feature( "docstring", "Get family file parameters 

DESCRIPTION:

    Gets information about current family file, if familying is enabled. 
    See the PLplot documentation for more information. 

    Redacted form: plgfam(fam, num, bmax)

    This function is used in examples 14,31. 



SYNOPSIS:

plgfam(fam, num, bmax)

ARGUMENTS:

    fam (PLINT *, output) :    Pointer to variable with the Boolean family
    flag value.  If nonzero, familying is enabled. 

    num (PLINT *, output) :    Pointer to variable with the current family
    file number. 

    bmax (PLINT *, output) :    Pointer to variable with the maximum file
    size (in bytes) for a family file. 
")
plgfam;

%feature( "docstring", "Get FCI (font characterization integer) 

DESCRIPTION:

    Gets information about the current font using the FCI approach. See
    the PLplot documentation for more information. 

    Redacted form: plgfci(fci)

    This function is used in example 23. 



SYNOPSIS:

plgfci(fci)

ARGUMENTS:

    fci (PLUNICODE *, output) :    Pointer to PLUNICODE (unsigned 32-bit
    integer) variable which is updated with current FCI value. 
")
plgfci;

%feature( "docstring", "Get output file name 

DESCRIPTION:

    Gets the current output file name, if applicable. 

    Redacted form: plgfnam(fnam)

    This function is used in example 31. 



SYNOPSIS:

plgfnam(fnam)

ARGUMENTS:

    fnam (char *, output) :    Pointer to file name string (a preallocated
    string of 80 characters or more). 
")
plgfnam;

%feature( "docstring", "Get family, style and weight of the current font 

DESCRIPTION:

    Gets information about current font.  See the PLplot documentation for
    more information on font selection. 

    Redacted form: plgfont(p_family, p_style, p_weight)

    This function is used in example 23. 



SYNOPSIS:

plgfont(p_family, p_style, p_weight)

ARGUMENTS:

    p_family (PLINT *, output) :    Pointer to variable with the current
    font family. The available values are given by the PL_FCI_*
    constants in plplot.h. Current options are PL_FCI_SANS,
    PL_FCI_SERIF, PL_FCI_MONO, PL_FCI_SCRIPT and PL_FCI_SYMBOL. If
    p_family is NULL then the font family is not returned. 

    p_style (PLINT *, output) :    Pointer to variable with the current
    font style. The available values are given by the PL_FCI_*
    constants in plplot.h. Current options are PL_FCI_UPRIGHT,
    PL_FCI_ITALIC  and PL_FCI_OBLIQUE. If p_style is NULL then the
    font style is not returned. 

    p_weight (PLINT *, output) :    Pointer to variable with the current
    font weight. The available values are given by the PL_FCI_*
    constants in plplot.h. Current options are PL_FCI_MEDIUM and
    PL_FCI_BOLD. If p_weight is NULL then the font weight is not
    returned. 
")
plgfont;

%feature( "docstring", "Get the (current) run level 

DESCRIPTION:

    Get the (current) run level. Valid settings are: 0,  uninitialized 
	    1,	initialized 
	    2,	viewport defined 
	    3,	world coordinates defined 


    Redacted form: plglevel(p_level)

    This function is used in example 31. 



SYNOPSIS:

plglevel(p_level)

ARGUMENTS:

    p_level (PLINT *, output) :    Pointer to the run level. 
")
plglevel;

%feature( "docstring", "Get page parameters 

DESCRIPTION:

    Gets the current page configuration. The length and offset values are
    expressed in units that are specific to the current driver. For
    instance: screen drivers will usually interpret them as number of
    pixels, whereas printer drivers will usually use mm. 

    Redacted form: plgpage(xp, yp, xleng, yleng, xoff, yoff)

    This function is used in example 31. 



SYNOPSIS:

plgpage(xp, yp, xleng, yleng, xoff, yoff)

ARGUMENTS:

    xp (PLFLT *, output) :    Pointer to number of pixels/inch (DPI), x. 

    yp (PLFLT *, output) :    Pointer to number of pixels/inch (DPI) in y. 

    xleng (PLINT *, output) :     Pointer to x page length value. 

    yleng (PLINT *, output) :     Pointer to y page length value. 

    xoff (PLINT *, output) :    Pointer to x page offset. 

    yoff (PLINT *, output) :    Pointer to y page offset. 
")
plgpage;

%feature( "docstring", "Switch to graphics screen 

DESCRIPTION:

    Sets an interactive device to graphics mode, used in conjunction with
    pltext to allow graphics and text to be interspersed.  On a device
    which supports separate text and graphics windows, this command causes
    control to be switched to the graphics window.  If already in graphics
    mode, this command is ignored.  It is also ignored on devices which
    only support a single window or use a different method for shifting
    focus.  See also pltext. 

    Redacted form: plgra()

    This function is used in example 1. 



SYNOPSIS:

plgra()
")
plgra;

%feature( "docstring", "Draw linear gradient inside polygon 

DESCRIPTION:

    Draw a linear gradient using colour map 1 inside the polygon defined
    by the n points (
    x[i], 
    y[i]).  Interpretation of the polygon is the same as for plfill.  The
    polygon coordinates and the gradient angle are all expressed in world
    coordinates.  The angle from the x axis for both the rotated
    coordinate system and the gradient vector is specified by angle.  The
    magnitude of the gradient vector is the difference between the maximum
    and minimum values of x for the vertices in the rotated coordinate
    system.  The origin of the gradient vector can be interpreted as being
    anywhere on the line corresponding to the minimum x value for the
    vertices in the rotated coordinate system.	The distance along the
    gradient vector is linearly transformed to the independent variable of
    colour map 1 which ranges from 0. at the tail of the gradient vector
    to 1. at the head of the gradient vector.  What is drawn is the RGBA
    colour corresponding to the independent variable of colour map 1.  For
    more information about colour map 1 (see the PLplot documentation). 

    Redacted form: plgradient(x,y,angle)

    This function is used in examples 25,30. 



SYNOPSIS:

plgradient(n, x, y, angle)

ARGUMENTS:

    n (PLINT, input) :      Number of vertices in polygon. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of
    vertices. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of
    vertices. 

    angle (PLFLT, input) :    Angle (degrees) of gradient vector from x
    axis. 
")
plgradient;

%feature( "docstring", "Grid data from irregularly sampled data 

DESCRIPTION:

    Real world data is frequently irregularly sampled, but all PLplot 3D
    plots require data placed in a uniform grid. This function takes
    irregularly sampled data from three input arrays x[npts], y[npts], and
    z[npts], reads the desired grid location from input arrays xg[nptsx]
    and yg[nptsy], and returns the gridded data into output array
    zg[nptsx][nptsy].  The algorithm used to grid the data is specified
    with the argument type which can have one parameter specified in
    argument data. 

    Redacted form:  General: plgriddata(x, y, z, xg, yg, zg, type, data)
	    Perl/PDL: Not available? 


    This function is used in example 21. 



SYNOPSIS:

plggriddata(x, y, z, npts, xg, nptsx, yg, nptsy, zg, type, data)

ARGUMENTS:

    x (PLFLT *, input) :    The input x array. 

    y (PLFLT *, input) :    The input y array. 

    z (PLFLT *, input) :    The input z array. Each triple x[i], y[i],
    z[i] represents one data sample coordinate. 

    npts (PLINT, input) :    The number of data samples in the x, y and z
    arrays. 

    xg (PLFLT *, input) :    The input array that specifies the grid
    spacing in the x direction. Usually xg has nptsx equally spaced
    values from the minimum to the maximum values of the x input
    array. 

    nptsx (PLINT, input) :    The number of points in the xg array. 

    yg (PLFLT *, input) :    The input array that specifies the grid
    spacing in the y direction. Similar to the xg parameter. 

    nptsy (PLINT, input) :    The number of points in the yg array. 

    zg (PLFLT **, output) :    The output array, where data lies in the
    regular grid specified by xg and yg. the zg array must exist or be
    allocated by the user prior to the call, and must have dimension
    zg[nptsx][nptsy]. 

    type (PLINT, input) :    The type of gridding algorithm to use, which
    can be: GRID_CSA: Bivariate Cubic Spline approximation 
        GRID_DTLI: Delaunay Triangulation Linear Interpolation 
        GRID_NNI: Natural Neighbors Interpolation 
        GRID_NNIDW: Nearest Neighbors Inverse Distance Weighted 
        GRID_NNLI: Nearest Neighbors Linear Interpolation 
        GRID_NNAIDW:  Nearest Neighbors Around Inverse Distance
        Weighted 
    For details of the algorithms read the source file plgridd.c. 

    data (PLFLT, input) :    Some gridding algorithms require extra data,
    which can be specified through this argument. Currently, for
    algorithm: GRID_NNIDW, data specifies the number of neighbors to
    use, the lower the value, the noisier (more local) the
    approximation is. 
        GRID_NNLI, data specifies what a thin triangle is, in the
        range [1. .. 2.]. High values enable the usage of very thin
        triangles for interpolation, possibly resulting in error in
        the approximation. 
        GRID_NNI, only weights greater than data will be accepted. If
        0, all weights will be accepted. 
")
plgriddata;

%feature( "docstring", "Get current subpage parameters 

DESCRIPTION:

    Gets the size of the current subpage in millimeters measured from the
    bottom left hand corner of the output device page or screen.  Can be
    used in conjunction with plsvpa for setting the size of a viewport in
    absolute coordinates (millimeters). 

    Redacted form: plgspa(xmin, xmax, ymin, ymax)

    This function is used in example 23. 



SYNOPSIS:

plgspa(xmin, xmax, ymin, ymax)

ARGUMENTS:

    xmin (PLFLT *, output) :    Pointer to variable with position of left
    hand edge of subpage in millimeters. 

    xmax (PLFLT *, output) :    Pointer to variable with position of right
    hand edge of subpage in millimeters. 

    ymin (PLFLT *, output) :    Pointer to variable with position of
    bottom edge of subpage in millimeters. 

    ymax (PLFLT *, output) :    Pointer to variable with position of top
    edge of subpage in millimeters. 
")
plgspa;

%feature( "docstring", "Get current stream number 

DESCRIPTION:

    Gets the number of the current output stream. See also plsstrm. 

    Redacted form: plgstrm(strm)

    This function is used in example 1,20. 



SYNOPSIS:

plgstrm(strm)

ARGUMENTS:

    strm (PLINT *, output) :    Pointer to current stream value. 
")
plgstrm;

%feature( "docstring", "Get the current library version number 

DESCRIPTION:

    Get the current library version number.  Note: you must have allocated
    space for this (80 characters is safe). 

    Redacted form: plgver(p_ver)

    This function is used in example 1. 



SYNOPSIS:

plgver(p_ver)

ARGUMENTS:

    p_ver (char *, output) :    Pointer to the current library version
    number. 
")
plgver;

%feature( "docstring", "Get viewport limits in normalized device coordinates 

DESCRIPTION:

    Get viewport limits in normalized device coordinates. 

    Redacted form:  General: plgvpd(p_xmin, p_xmax, p_ymin, p_ymax)
	    Perl/PDL: Not available? 


    This function is used in example 31. 



SYNOPSIS:

plgvpd(p_xmin, p_xmax, p_ymin, p_ymax)

ARGUMENTS:

    p_xmin (PLFLT *, output) :      Lower viewport limit of the normalized
    device coordinate in x. 

    p_xmax (PLFLT *, output) :      Upper viewport limit of the normalized
    device coordinate in x. 

    p_ymin (PLFLT *, output) :      Lower viewport limit of the normalized
    device coordinate in y. 

    p_ymax (PLFLT *, output) :      Upper viewport limit of the normalized
    device coordinate in y. 
")
plgvpd;

%feature( "docstring", "Get viewport limits in world coordinates 

DESCRIPTION:

    Get viewport limits in world coordinates. 

    Redacted form:  General: plgvpw(p_xmin, p_xmax, p_ymin, p_ymax)
	    Perl/PDL: Not available? 


    This function is used in example 31. 



SYNOPSIS:

plgvpw(p_xmin, p_xmax, p_ymin, p_ymax)

ARGUMENTS:

    p_xmin (PLFLT *, output) :      Lower viewport limit of the world
    coordinate in x. 

    p_xmax (PLFLT *, output) :      Upper viewport limit of the world
    coordinate in x. 

    p_ymin (PLFLT *, output) :      Lower viewport limit of the world
    coordinate in y. 

    p_ymax (PLFLT *, output) :      Upper viewport limit of the world
    coordinate in y. 
")
plgvpw;

%feature( "docstring", "Get x axis parameters 

DESCRIPTION:

    Returns current values of the digmax and digits flags for the x axis. 
    digits is updated after the plot is drawn, so this routine should only
    be called after the call to plbox (or plbox3) is complete.	See the
    PLplot documentation for more information. 

    Redacted form: plgxax(digmax, digits)

    This function is used in example 31. 



SYNOPSIS:

plgxax(digmax, digits)

ARGUMENTS:

    digmax (PLINT *, output) :      Pointer to variable with the maximum
    number of digits for the x axis.  If nonzero, the printed label
    has been switched to a floating point representation when the
    number of digits exceeds digmax. 

    digits (PLINT *, output) :      Pointer to variable with the actual
    number of digits for the numeric labels (x axis) from the last
    plot. 
")
plgxax;

%feature( "docstring", "Get y axis parameters 

DESCRIPTION:

    Identical to plgxax, except that arguments are flags for y axis. See
    the description of plgxax for more detail. 

    Redacted form: plgyax(digmax, digits)

    This function is used in example 31. 



SYNOPSIS:

plgyax(digmax, digits)

ARGUMENTS:

    digmax (PLINT *, output) :      Pointer to variable with the maximum
    number of digits for the y axis.  If nonzero, the printed label
    has been switched to a floating point representation when the
    number of digits exceeds digmax. 

    digits (PLINT *, output) :      Pointer to variable with the actual
    number of digits for the numeric labels (y axis) from the last
    plot. 
")
plgyax;

%feature( "docstring", "Get z axis parameters 

DESCRIPTION:

    Identical to plgxax, except that arguments are flags for z axis. See
    the description of plgxax for more detail. 

    Redacted form: plgzax(digmax, digits)

    This function is used in example 31. 



SYNOPSIS:

plgzax(digmax, digits)

ARGUMENTS:

    digmax (PLINT *, output) :      Pointer to variable with the maximum
    number of digits for the z axis.  If nonzero, the printed label
    has been switched to a floating point representation when the
    number of digits exceeds digmax. 

    digits (PLINT *, output) :      Pointer to variable with the actual
    number of digits for the numeric labels (z axis) from the last
    plot. 
")
plgzax;

%feature( "docstring", "Plot a histogram from unbinned data 

DESCRIPTION:

    Plots a histogram from n data points stored in the array data.  This
    routine bins the data into nbin bins equally spaced between datmin and
    datmax, and calls plbin to draw the resulting histogram.  Parameter
    opt allows, among other things, the histogram either to be plotted in
    an existing window or causes plhist to call plenv with suitable limits
    before plotting the histogram. 

    Redacted form: plhist(data, datmin, datmax, nbin, opt)

    This function is used in example 5. 



SYNOPSIS:

plhist(n, data, datmin, datmax, nbin, opt)

ARGUMENTS:

    n (PLINT, input) :      Number of data points. 

    data (PLFLT *, input) :    Pointer to array with values of the n data
    points. 

    datmin (PLFLT, input) :    Left-hand edge of lowest-valued bin. 

    datmax (PLFLT, input) :    Right-hand edge of highest-valued bin. 

    nbin (PLINT, input) :    Number of (equal-sized) bins into which to
    divide the interval xmin to xmax. 

    opt (PLINT, input) :    Is a combination of several flags:
    opt=PL_HIST_DEFAULT: The axes are automatically rescaled to fit
    the histogram data, the outer bins are expanded to fill up the
    entire x-axis, data outside the given extremes are assigned to the
    outer bins and bins of zero height are simply drawn. 
        opt=PL_HIST_NOSCALING|...: The existing axes are not rescaled
        to fit the histogram data, without this flag, plenv is called
        to set the world coordinates. 
        opt=PL_HIST_IGNORE_OUTLIERS|...: Data outside the given
        extremes are not taken into account. This option should
        probably be combined with opt=PL_HIST_NOEXPAND|..., so as to
        properly present the data. 
        opt=PL_HIST_NOEXPAND|...: The outer bins are drawn with equal
        size as the ones inside. 
        opt=PL_HIST_NOEMPTY|...: Bins with zero height are not drawn
        (there is a gap for such bins). 
")
plhist;

%feature( "docstring", "Convert HLS color to RGB 

DESCRIPTION:

    Convert HLS color coordinates to RGB. 

    Redacted form:  General: plhlsrgb(h, l, s, p_r, p_g, p_b)
	    Perl/PDL: Not available? Implemented as plhls? 


    This function is used in example 2. 



SYNOPSIS:

plhlsrgb(h, l, s, p_r, p_g, p_b)

ARGUMENTS:

    h (PLFLT, input) :      Hue, in degrees on the colour cone (0.0-360.0) 

    l (PLFLT, input) :      Lightness, expressed as a fraction of the axis
    of the colour cone (0.0-1.0) 

    s (PLFLT, input) :      Saturation, expressed as a fraction of the
    radius of the colour cone (0.0-1.0) 

    p_r (PLFLT *, output) :    Pointer to red intensity (0.0-1.0) of the
    colour 

    p_g (PLFLT *, output) :    Pointer to green intensity (0.0-1.0) of the
    colour 

    p_b (PLFLT *, output) :    Pointer to blue intensity (0.0-1.0) of the
    colour 
")
plhlsrgb;

%feature( "docstring", "Plot a 2D matrix using color map1 

DESCRIPTION:

    Plot a 2D matrix using color map1. 

    Redacted form:  General: plimagefr(idata, xmin, xmax, ymin, ymax,
    zmin, zmax, valuemin, valuemax, pltr, pltr_data) 


    This function is used in example 20. 



SYNOPSIS:

plimagefr(idata, nx, ny, xmin, xmax, ymin, ymax, zmin, zmax, valuemin, valuemax, pltr, pltr_data)

ARGUMENTS:

    idata (PLFLT**, input) :    A 2D array of values (intensities) to
    plot.  Should have dimensions idata[nx][ny]. 

    nx, ny (PLINT, input) :    Dimensions of idata 

    xmin, xmax, ymin, ymax (PLFLT, input) :    Plot coordinates to strecth
    the image data to.  idata[0][0] corresponds to (xmin, ymin) and
    idata[nx - 1][ny - 1] corresponds to (xmax, ymax). 

    zmin, zmax (PLFLT, input) :    Only data between zmin and zmax
    (inclusive) will be plotted. 

    valuemin, valuemax (PLFLT, input) :    The minimum and maximum data
    values to use for value to color mappings.  A datum equal to or
    less than valuemin will be plotted with color 0.0, while a datum
    equal to or greater than valuemax will be plotted with color 1.0. 
    Data between valuemin and valuemax map linearly to colors between
    0.0 and 1.0. 

    pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
      Pointer to function that defines a transformation between the
    data in the array idata and world coordinates.    An input
    coordinate of (0, 0) corresponds to the \"top-left\" corner of idata
    while (nx, ny) corresponds to the \"bottom-right\" corner of idata. 
    Some transformation functions are provided in the PLplot library:
    pltr0 for identity mapping, and pltr1 and pltr2 for arbitrary
    mappings respectively defined by one- and two-dimensional arrays. 
    In addition, user-supplied routines for the transformation can be
    used as well.  Examples of all of these approaches are given in
    the PLplot documentation.  The transformation function should have
    the form given by any of pltr0, pltr1, or pltr2. 

    pltr_data (PLPointer, input) :    Extra parameter to help pass
    information to pltr0, pltr1, pltr2, or whatever routine is
    externally supplied. 
")
plimagefr;

%feature( "docstring", "Plot a 2D matrix using color map1 with automatic colour adjustment 

DESCRIPTION:

    Plot a 2D matrix using color palette 1.  The color scale is
    automatically adjusted to use the maximum and minimum values in idata
    as valuemin and valuemax in a call to plimagefr. 

    Redacted form:  General: plimage(idata, xmin, xmax, ymin, ymax, zmin,
    zmax, Dxmin, Dxmax, Dymin, Dymax) 


    This function is used in example 20. 



SYNOPSIS:

plimage(idata, nx, ny, xmin, xmax, ymin, ymax, zmin, zmax, Dxmin, Dxmax, Dymin, Dymax)

ARGUMENTS:

    idata (PLFLT**, input) :    A 2D array of values (intensities) to
    plot.  Should have dimensions idata[nx][ny]. 

    nx, ny (PLINT, input) :    Dimensions of idata 

    xmin, xmax, ymin, ymax (PLFLT, input) :    Plot coordinates to strecth
    the image data to.  idata[0][0] corresponds to (xmin, ymin) and
    idata[nx - 1][ny - 1] corresponds to (xmax, ymax). 

    zmin, zmax (PLFLT, input) :    Only data between zmin and zmax
    (inclusive) will be plotted. 

    Dxmin, Dxmax, Dymin, Dymax (PLFLT, input) :    Plot only the window of
    points whose plot coordinates fall inside the window of (Dxmin,
    Dymin) to (Dxmax, Dymax). 
")
plimage;

%feature( "docstring", "Initialize PLplot 

DESCRIPTION:

    Initializing the plotting package.	The program prompts for the device
    keyword or number of the desired output device.  Hitting a RETURN in
    response to the prompt is the same as selecting the first device. 
    plinit will issue no prompt if either the device was specified
    previously (via command line flag, the plsetopt function, or the
    plsdev function), or if only one device is enabled when PLplot is
    installed.	If subpages have been specified, the output device is
    divided into nx by ny subpages, each of which may be used
    independently.  If plinit is called again during a program, the
    previously opened file will be closed.  The subroutine pladv is used
    to advance from one subpage to the next. 

    Redacted form: plinit()

    This function is used in all of the examples. 



SYNOPSIS:

plinit()
")
plinit;

%feature( "docstring", "Draw a line between two points 

DESCRIPTION:

    Joins the point (
    x1, 
    y1) to (
    x2, 
    y2). 

    Redacted form: pljoin(x1,y1,x2,y2)

    This function is used in examples 3,14. 



SYNOPSIS:

pljoin(x1, y1, x2, y2)

ARGUMENTS:

    x1 (PLFLT, input) :    x coordinate of first point. 

    y1 (PLFLT, input) :    y coordinate of first point. 

    x2 (PLFLT, input) :    x coordinate of second point. 

    y2 (PLFLT, input) :    y coordinate of second point. 
")
pljoin;

%feature( "docstring", "Simple routine to write labels 

DESCRIPTION:

    Routine for writing simple labels. Use plmtex for more complex labels. 

    Redacted form: pllab(xlabel, ylabel, tlabel)

    This function is used in examples 1,5,9,12,14-16,20-22,29. 



SYNOPSIS:

pllab(xlabel, ylabel, tlabel)

ARGUMENTS:

    xlabel (const char *, input) :    Label for horizontal axis. 

    ylabel (const char *, input) :    Label for vertical axis. 

    tlabel (const char *, input) :    Title of graph. 
")
pllab;

%feature( "docstring", "Create a discrete annotated legend using boxes, lines, and/or lines of symbols 

DESCRIPTION:

    (N.B. This is an experimental API that may be subject to further
    change as we gain more experience with it.)  Routine for creating a
    discrete plot legend with a plotted box, line, and/or line of symbols
    for each annotated legend entry.  The arguments of pllegend provide
    control over the location and size of the legend within the current
    subpage as well as the location and characteristics of the elements
    (most of which are optional) within that legend.  The resulting legend
    is clipped at the boundaries of the current subpage 

    Redacted form: pllegend(opt, x, y, plot_width, bg_color, opt_array,
    text_offset, text_scale, text_spacing, test_justification,
    text_colors, text, box_colors, box_patterns, box_scales, line_colors,
    line_styles, line_widths, symbol_colors, symbol_scales,
    symbol_numbers, symbols)

    This function is used in examples 4 and 26. 



SYNOPSIS:

pllegend(opt, x, y, plot_width, bg_color, nlegend, opt_array, text_offset, text_scale, text_spacing, test_justification, text_colors, text, box_colors, box_patterns, box_scales, line_colors, line_styles, line_widths, symbol_colors, symbol_scales, symbol_numbers, symbols)

ARGUMENTS:

    opt (PLINT, input) :    opt contains bits controlling the overall
    legend.  If the 
    PL_LEGEND_BACKGROUND bit is set, plot a (semi-transparent) background
    for the legend.  If the 
    PL_LEGEND_TEXT_LEFT bit is set, put the text area on the left of the
    legend and the plotted area on the right. Otherwise, put the text
    area on the right of the legend and the plotted area on the left. 

    x (PLFLT, input) :      Normalized sub-page X position of the upper-left
    corner of the legend. 

    y (PLFLT, input) :      Normalized sub-page Y position of the upper-left
    corner of the legend. 

    plot_width (PLFLT, input) :    Horizontal width in normalized subpage
    units of the plot area (where the rectangular boxes, lines, and/or
    lines of symbols are drawn) of the legend.  N.B.  The total
    horizontal width of the legend in normalized subpage coordinates
    is calculated internally from 
    plot_width, 
    text_offset (see below), and length (calculated internally) of the
    longest text string. 

    bg_color (PLINT, input) :     The cmap0 index of the background color
    for the legend (
    PL_LEGEND_BACKGROUND). 

    nlegend (PLINT, input) :    Number of legend entries.  N.B.  The total
    vertical height of the legend in normalized subpage coordinates is
    calculated internally from 
    nlegend, 
    text_scale (see below), and  
    text_spacing (see below). 

    opt_array (const PLINT *, input) :      Array of nlegend values of
    options to control each individual plotted area corresponding to a
    legend entry.  If the 
    PL_LEGEND_NONE bit is set, then nothing is plotted in the plotted
    area.  If the 
    PL_LEGEND_COLOR_BOX, 
    PL_LEGEND_LINE, and/or 
    PL_LEGEND_SYMBOL bits are set, the area corresponding to a legend
    entry is plotted with a colored box; a line; and/or a line of
    symbols. 

    text_offset (PLFLT, input) :    Offset of the text area from the plot
    area in units of character width.  N.B.  The total horizontal
    width of the legend in normalized subpage coordinates is
    calculated internally from 
    plot_width (see above), 
    text_offset, and length (calculated internally) of the longest text
    string. 

    text_scale (PLFLT, input) :    Character height scale for text
    annotations.  N.B.  The total vertical height of the legend in
    normalized subpage coordinates is calculated internally from 
    nlegend (see above), 
    text_scale, and 
    text_spacing (see below). 

    text_spacing (PLFLT, input) :    Vertical spacing in units of the
    character height from one legend entry to the next.  N.B.  The
    total vertical height of the legend in normalized subpage
    coordinates is calculated internally from 
    nlegend (see above), 
    text_scale (see above), and 
    text_spacing. 

    text_justification (PLFLT, input) :    Justification parameter used
    for text justification.  The most common values of
    text_justification are 0., 0.5, or 1. corresponding to a text that
    is left justified, centred, or right justified within the text
    area, but other values are allowed as well. 

    text_colors (const PLINT *, input) :    Array of nlegend text colors
    (cmap0 indices). 

    text (const char **, input) :    Array of nlegend text string
    annotations. 

    box_colors (const PLINT *, input) :    Array of nlegend colors (cmap0
    indices) for the discrete colored boxes (
    PL_LEGEND_COLOR_BOX). 

    box_patterns (const PLINT *, input) :    Array of nlegend patterns
    (plpsty indices) for the discrete colored boxes (
    PL_LEGEND_COLOR_BOX). 

    box_scales (const PLFLT *, input) :    Array of nlegend scales (units
    of fraction of character height) for the height of the discrete
    colored boxes  (
    PL_LEGEND_COLOR_BOX). 

    line_colors (const PLINT *, input) :    Array of nlegend line colors
    (cmap0 indices) (
    PL_LEGEND_LINE). 

    line_styles (const PLINT *, input) :    Array of nlegend line styles
    (plsty indices)  (
    PL_LEGEND_LINE). 

    line_widths (const PLINT *, input) :    Array of nlegend line widths (
    PL_LEGEND_LINE). 

    symbol_colors (const PLINT *, input) :    Array of nlegend symbol
    colors (cmap0 indices)    (
    PL_LEGEND_SYMBOL). 

    symbol_scales (const PLFLT *, input) :    Array of nlegend scale
    values for the symbol height  (
    PL_LEGEND_SYMBOL). 

    symbol_numbers (const PLINT *, input) :    Array of nlegend numbers of
    symbols to be drawn across the width of the plotted area (
    PL_LEGEND_SYMBOL). 

    symbols (const PLINT *, input) :    Array of nlegend symbols (plpoin
    indices)  (
    PL_LEGEND_SYMBOL). 
")
pllegend;

%feature( "docstring", "Sets the 3D position of the light source 

DESCRIPTION:

    Sets the 3D position of the light source for use with plsurf3d. 

    Redacted form: pllightsource(x, y, z)

    This function is used in example 8. 



SYNOPSIS:

pllightsource(x, y, z)

ARGUMENTS:

    x (PLFLT, input) :      X-coordinate of the light source. 

    y (PLFLT, input) :      Y-coordinate of the light source. 

    z (PLFLT, input) :      Z-coordinate of the light source. 
")
pllightsource;

%feature( "docstring", "Draw a line 

DESCRIPTION:

    Draws line defined by n points in x and y. 

    Redacted form: plline(x, y)

    This function is used in examples 1,3,4,9,12-14,16,18,20,22,25-27,29. 



SYNOPSIS:

plline(n, x, y)

ARGUMENTS:

    n (PLINT, input) :      Number of points defining line. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of points. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of points. 
")
plline;

%feature( "docstring", "Draw a line in 3 space 

DESCRIPTION:

    Draws line in 3 space defined by n points in x, y, and z. You must
    first set up the viewport, the 2d viewing window (in world
    coordinates), and the 3d normalized coordinate box.  See x18c.c for
    more info. 

    Redacted form: plline3(x, y, z)

    This function is used in example 18. 



SYNOPSIS:

plline3(n, x, y, z)

ARGUMENTS:

    n (PLINT, input) :      Number of points defining line. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of points. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of points. 

    z (PLFLT *, input) :    Pointer to array with z coordinates of points. 
")
plline3;

%feature( "docstring", "Select line style 

DESCRIPTION:

    This sets the line style according to one of eight predefined patterns
    (also see plstyl). 

    Redacted form: pllsty(n)

    This function is used in examples 9,12,22,25. 



SYNOPSIS:

pllsty(n)

ARGUMENTS:

    n (PLINT, input) :      Integer value between 1 and 8. Line style 1 is a
    continuous line, line style 2 is a line with short dashes and
    gaps, line style 3 is a line with long dashes and gaps, line style
    4 has long dashes and short gaps and so on. 
")
pllsty;

%feature( "docstring", "Plot continental outline in world coordinates. 

DESCRIPTION:

    Plots continental outlines in world coordinates. examples/c/x19c
    demonstrates how to use this  function to create different
    projections. 

    Redacted form:  General: plmap(mapform, type, minlong, maxlong,
    minlat, maxlat)
	    F95, Java, Perl/PDL, Python: Not implemented? 


    This function is used in example 19. 



SYNOPSIS:

plmap(mapform, type, minlong, maxlong, minlat, maxlat)

ARGUMENTS:

    mapform (void (*) (PLINT, PLFLT *, PLFLT *), input) :    A user
    supplied function to transform the coordinate  longitudes and
    latitudes to a plot coordinate system.     By using this transform,
    we can change from a longitude,  latitude coordinate to a polar
    stereographic project, for  example.  Initially, x[0]..[n-1] are
    the longitudes and y[0]..y[n-1]  are the corresponding latitudes. 
    After the call to mapform(), x[]  and y[] should be replaced by
    the corresponding plot coordinates.   If no transform is desired,
    mapform can be replaced by NULL. 

    type (char *, input) :    type is a character string. The value of
    this parameter determines the type of background. The possible
    values are: \"globe\" -- continental outlines 
        \"usa\" -- USA and state boundaries 
        \"cglobe\" -- continental outlines and countries 
        \"usaglobe\" -- USA, state boundaries and continental outlines 


    minlong (PLFLT, input) :    The value of the longitude on the left
    side of the plot.  The value of minlong must be less than the
    value of maxlong, and the  quantity maxlong-minlong must be less
    than or equal to 360. 

    maxlong (PLFLT, input) :    The value of the longitude on the right
    side of the plot. 

    minlat (PLFLT, input) :    The minimum latitude to be plotted on the
    background.   One can always use -90.0 as the boundary outside the
    plot window  will be automatically eliminated.    However, the
    program will be  faster if one can reduce the size of the
    background plotted. 

    maxlat (PLFLT, input) :    The maximum latitudes to be plotted on the
    background.   One can always use 90.0 as the boundary outside the
    plot window  will be automatically eliminated. 
")
plmap;

%feature( "docstring", "Plot latitude and longitude lines. 

DESCRIPTION:

    Displays latitude and longitude on the current plot.  The lines are
    plotted in the current color and line style. 

    Redacted form:  General: plmeridians(mapform, dlong, dlat, minlong,
    maxlong, minlat, maxlat)
	    F95, Java, Perl/PDL, Python: Not implemented? 


    This function is used in example 19. 



SYNOPSIS:

plmeridians(mapform, dlong, dlat, minlong, maxlong, minlat, maxlat)

ARGUMENTS:

    mapform (void (*) (PLINT, PLFLT *, PLFLT *), input) :    A user
    supplied function to transform the coordinate  longitudes and
    latitudes to a plot coordinate system.     By using this transform,
    we can change from a longitude,  latitude coordinate to a polar
    stereographic project, for  example.  Initially, x[0]..[n-1] are
    the longitudes and y[0]..y[n-1]  are the corresponding latitudes. 
    After the call to mapform(), x[]  and y[] should be replaced by
    the corresponding plot coordinates.   If no transform is desired,
    mapform can be replaced by NULL. 

    dlong (PLFLT, input) :    The interval in degrees at which the
    longitude lines are to be plotted. 

    dlat (PLFLT, input) :    The interval in degrees at which the latitude
    lines are to be plotted. 

    minlong (PLFLT, input) :    The value of the longitude on the left
    side of the plot.  The value of minlong must be less than the
    value of maxlong, and the  quantity maxlong-minlong must be less
    than or equal to 360. 

    maxlong (PLFLT, input) :    The value of the longitude on the right
    side of the plot. 

    minlat (PLFLT, input) :    The minimum latitude to be plotted on the
    background.   One can always use -90.0 as the boundary outside the
    plot window  will be automatically eliminated.    However, the
    program will be  faster if one can reduce the size of the
    background plotted. 

    maxlat (PLFLT, input) :    The maximum latitudes to be plotted on the
    background.   One can always use 90.0 as the boundary outside the
    plot window  will be automatically eliminated. 
")
plmeridians;

%feature( "docstring", "Plot surface mesh 

DESCRIPTION:

    Plots a surface mesh within the environment set up by plw3d.  The
    surface is defined by the two-dimensional array z[
    nx][
    ny], the point z[i][j] being the value of the function at (
    x[i], 
    y[j]).  Note that the points in arrays x and y do not need to be
    equally spaced, but must be stored in ascending order.  The parameter
    opt controls the way in which the surface is displayed.  For further
    details see the PLplot documentation. 

    Redacted form: plmesh(x, y, z, opt)

    This function is used in example 11. 



SYNOPSIS:

plmesh(x, y, z, nx, ny, opt)

ARGUMENTS:

    x (PLFLT *, input) :    Pointer to set of x coordinate values at which
    the function is evaluated. 

    y (PLFLT *, input) :    Pointer to set of y coordinate values at which
    the function is evaluated. 

    z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
    with set of function values. 

    nx (PLINT, input) :    Number of x values at which function is
    evaluated. 

    ny (PLINT, input) :    Number of y values at which function is
    evaluated. 

    opt (PLINT, input) :    Determines the way in which the surface is
    represented: opt=DRAW_LINEX: Lines are drawn showing z as a
    function of x for each value of y[j]. 
        opt=DRAW_LINEY: Lines are drawn showing z as a function of y
        for each value of x[i]. 
        opt=DRAW_LINEXY: Network of lines is drawn connecting points
        at which function is defined. 
")
plmesh;

%feature( "docstring", "Magnitude colored plot surface mesh with contour. 

DESCRIPTION:

    Identical to plmesh but with extra functionalities: the surface mesh
    can be colored accordingly to the current z value being plotted, a
    contour plot can be drawn at the base XY plane, and a curtain can be
    drawn between the plotted function border and the base XY plane. 

    Redacted form: plmeshc(x, y, z, opt, clevel)

    This function is used in example 11. 



SYNOPSIS:

plmeshc(x, y, z, nx, ny, opt, clevel, nlevel)

ARGUMENTS:

    x (PLFLT *, input) :    Pointer to set of x coordinate values at which
    the function is evaluated. 

    y (PLFLT *, input) :    Pointer to set of y coordinate values at which
    the function is evaluated. 

    z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
    with set of function values. 

    nx (PLINT, input) :    Number of x values at which function is
    evaluated. 

    ny (PLINT, input) :    Number of y values at which function is
    evaluated. 

    opt (PLINT, input) :    Determines the way in which the surface is
    represented. To specify more than one option just add the options,
    e.g. DRAW_LINEXY + MAG_COLOR opt=DRAW_LINEX: Lines are drawn
    showing z as a function of x for each value of y[j]. 
        opt=DRAW_LINEY: Lines are drawn showing z as a function of y
        for each value of x[i]. 
        opt=DRAW_LINEXY: Network of lines is drawn connecting points
        at which function is defined. 
        opt=MAG_COLOR: Each line in the mesh is colored according to
        the z value being plotted. The color is used from the current
        colormap 1. 
        opt=BASE_CONT: A contour plot is drawn at the base XY plane
        using parameters 
    nlevel and 
    clevel. 
        opt=DRAW_SIDES: draws a curtain between the base XY plane and
        the borders of the plotted function. 


    clevel (PLFLT *, input) :     Pointer to the array that defines the
    contour level spacing. 

    nlevel (PLINT, input) :    Number of elements in the clevel array. 
")
plmeshc;

%feature( "docstring", "Creates a new stream and makes it the default 

DESCRIPTION:

    Creates a new stream and makes it the default.  Differs from using
    plsstrm, in that a free stream number is found, and returned.
    Unfortunately, I have to start at stream 1 and work upward, since
    stream 0 is preallocated.  One of the big flaws in the PLplot API is
    that no initial, library-opening call is required.	So stream 0 must
    be preallocated, and there is no simple way of determining whether it
    is already in use or not. 

    Redacted form: plmkstrm(p_strm)

    This function is used in examples 1,20. 



SYNOPSIS:

plmkstrm(p_strm)

ARGUMENTS:

    p_strm (PLINT *, output) :      Pointer to stream number of the created
    stream. 
")
plmkstrm;

%feature( "docstring", "Write text relative to viewport boundaries 

DESCRIPTION:

    Writes text at a specified position relative to the viewport
    boundaries.  Text may be written inside or outside the viewport, but
    is clipped at the subpage boundaries.  The reference point of a string
    lies along a line passing through the string at half the height of a
    capital letter.  The position of the reference point along this line
    is determined by just, and the position of the reference point
    relative to the viewport is set by disp and pos. 

    Redacted form:  General: plmtex(side, disp, pos, just, text)
	    Perl/PDL: plmtex(disp, pos, just, side, text)


    This function is used in examples 3,4,6-8,11,12,14,18,23,26. 



SYNOPSIS:

plmtex(side, disp, pos, just, text)

ARGUMENTS:

    side (const char *, input) :    Specifies the side of the viewport
    along which the text is to be written. The string must be one of:
    b: Bottom of viewport, text written parallel to edge. 
        bv: Bottom of viewport, text written at right angles to edge. 
        l: Left of viewport, text written parallel to edge. 
        lv: Left of viewport, text written at right angles to edge. 
        r: Right of viewport, text written parallel to edge. 
        rv: Right of viewport, text written at right angles to edge. 
        t: Top of viewport, text written parallel to edge. 
        tv: Top of viewport, text written at right angles to edge. 


    disp (PLFLT, input) :    Position of the reference point of string,
    measured outwards from the specified viewport edge in units of the
    current character height.  Use negative disp to write within the
    viewport. 

    pos (PLFLT, input) :    Position of the reference point of string
    along the specified edge, expressed as a fraction of the length of
    the edge. 

    just (PLFLT, input) :    Specifies the position of the string relative
    to its reference point.  If just=0., the reference point is at the
    left and if just=1., it is at the right of the string.    Other
    values of just give intermediate justifications. 

    text (const char *, input) :    The string to be written out. 
")
plmtex;

%feature( "docstring", "Write text relative to viewport boundaries in 3D plots. 

DESCRIPTION:

    Writes text at a specified position relative to the viewport
    boundaries.  Text may be written inside or outside the viewport, but
    is clipped at the subpage boundaries.  The reference point of a string
    lies along a line passing through the string at half the height of a
    capital letter.  The position of the reference point along this line
    is determined by just, and the position of the reference point
    relative to the viewport is set by disp and pos. 

    Redacted form: plmtex3(side, disp, pos, just, text)

    This function is used in example 28. 



SYNOPSIS:

plmtex3(side, disp, pos, just, text)

ARGUMENTS:

    side (const char *, input) :    Specifies the side of the viewport
    along which the text is to be written. The string should contain
    one or more of the following characters: [xyz][ps][v].    Only one
    label is drawn at a time, i.e. xyp will only label the X axis, not
    both the X and Y axes. x: Label the X axis. 
        y: Label the Y axis. 
        z: Label the Z axis. 
        p: Label the primary axis. For Z this is the leftmost Z axis.
        For X it is the axis that starts at y-min. For Y it is the
        axis that starts at x-min. 
        s: Label the secondary axis. 
        v: Draw the text perpendicular to the axis. 


    disp (PLFLT, input) :    Position of the reference point of string,
    measured outwards from the specified viewport edge in units of the
    current character height.  Use negative disp to write within the
    viewport. 

    pos (PLFLT, input) :    Position of the reference point of string
    along the specified edge, expressed as a fraction of the length of
    the edge. 

    just (PLFLT, input) :    Specifies the position of the string relative
    to its reference point.  If just=0., the reference point is at the
    left and if just=1., it is at the right of the string.    Other
    values of just give intermediate justifications. 

    text (const char *, input) :    The string to be written out. 
")
plmtex3;

%feature( "docstring", "Plot 3-d surface plot 

DESCRIPTION:

    Plots a three dimensional surface plot within the environment set up
    by plw3d.  The surface is defined by the two-dimensional array z[
    nx][
    ny], the point z[i][j] being the value of the function at (
    x[i], 
    y[j]).  Note that the points in arrays x and y do not need to be
    equally spaced, but must be stored in ascending order.  The parameter
    opt controls the way in which the surface is displayed.  For further
    details see the PLplot documentation. The only difference between
    plmesh and plot3d is that plmesh draws the bottom side of the surface,
    while plot3d only draws the surface as viewed from the top. 

    Redacted form: plot3d(x, y, z, opt, side)

    This function is used in examples 11,21. 



SYNOPSIS:

plot3d(x, y, z, nx, ny, opt, side)

ARGUMENTS:

    x (PLFLT *, input) :    Pointer to set of x coordinate values at which
    the function is evaluated. 

    y (PLFLT *, input) :    Pointer to set of y coordinate values at which
    the function is evaluated. 

    z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
    with set of function values. 

    nx (PLINT, input) :    Number of x values at which function is
    evaluated. 

    ny (PLINT, input) :    Number of y values at which function is
    evaluated. 

    opt (PLINT, input) :    Determines the way in which the surface is
    represented: opt=DRAW_LINEX: Lines are drawn showing z as a
    function of x for each value of y[j]. 
        opt=DRAW_LINEY: Lines are drawn showing z as a function of y
        for each value of x[i]. 
        opt=DRAW_LINEXY: Network of lines is drawn connecting points
        at which function is defined. 


    side (PLBOOL, input) :    Flag to indicate whether or not ``sides''
    should be draw on the figure.  If side is true sides are drawn,
    otherwise no sides are drawn. 
")
plot3d;

%feature( "docstring", "Magnitude colored plot surface with contour. 

DESCRIPTION:

    Identical to plot3d but with extra functionalities: the surface mesh
    can be colored accordingly to the current z value being plotted, a
    contour plot can be drawn at the base XY plane, and a curtain can be
    drawn between the plotted function border and the base XY plane. The
    arguments are identical to plmeshc. The only difference between
    plmeshc and plot3dc is that plmeshc draws the bottom side of the
    surface, while plot3dc only draws the surface as viewed from the top. 

    Redacted form:  General: plot3dc(x, y, z, opt, clevel)
	    Perl/PDL: Not available? 


    This function is used in example 21. 



SYNOPSIS:

plot3dc(x, y, z, nx, ny, opt, clevel, nlevel)
")
plot3dc;

%feature( "docstring", "Parse command-line arguments 

DESCRIPTION:

    Parse command-line arguments. 

    plparseopts removes all recognized flags (decreasing argc
    accordingly), so that invalid input may be readily detected.  It can
    also be used to process user command line flags.  The user can merge
    an option table of type PLOptionTable into the internal option table
    info structure using plMergeOpts.  Or, the user can specify that ONLY
    the external table(s) be parsed by calling plClearOpts before
    plMergeOpts. 

    The default action taken by plparseopts is as follows: 
    Returns with an error if an unrecognized option or badly formed
    option-value pair are encountered.	
    Returns immediately (return code 0) when the first non-option command
    line argument is found.  
    Returns with the return code of the option handler, if one was called.
     
    Deletes command line arguments from argv list as they are found, and
    decrements argc accordingly.  
    Does not show \"invisible\" options in usage or help messages.  
    Assumes the program name is contained in argv[0].  


    These behaviors may be controlled through the  
    mode argument. 

    Redacted form:  General: plparseopts(argv, mode)
	    Perl/PDL: Not available? 


    This function is used in all of the examples. 



SYNOPSIS:

int plparseopts(p_argc, argv, mode)

ARGUMENTS:

    p_argc (int *, input) :    pointer to number of arguments. 

    argv (char **, input) :    Pointer to character array containing
    *p_argc command-line arguments. 

    mode (PLINT, input) :    Parsing mode with the following
    possibilities: PL_PARSE_FULL (1) -- Full parsing of command line
    and all error messages enabled, including program exit when an
    error occurs.  Anything on the command line that isn't recognized
    as a valid option or option argument is flagged as an error. 
        PL_PARSE_QUIET (2) -- Turns off all output except in the case
        of errors. 
        PL_PARSE_NODELETE (4) -- Turns off deletion of processed
        arguments. 
        PL_PARSE_SHOWALL (8) -- Show invisible options 
        PL_PARSE_NOPROGRAM (32) -- Specified if argv[0] is NOT a
        pointer to the program name. 
        PL_PARSE_NODASH (64) -- Set if leading dash is NOT required. 
        PL_PARSE_SKIP (128) -- Set to quietly skip over any
        unrecognized arguments. 
")
plparseopts;

%feature( "docstring", "Set area fill pattern 

DESCRIPTION:

    Sets the area fill pattern.  The pattern consists of 1 or 2 sets of
    parallel lines with specified inclinations and spacings.  The
    arguments to this routine are the number of sets to use (1 or 2)
    followed by two pointers to integer arrays (of 1 or 2 elements)
    specifying the inclinations in tenths of a degree and the spacing in
    micrometers.  (also see plpsty) 

    Redacted form:  General: plpat(inc, del)
	    Perl/PDL: plpat(nlin, inc, del)


    This function is used in example 15. 



SYNOPSIS:

plpat(nlin, inc, del)

ARGUMENTS:

    nlin (PLINT, input) :    Number of sets of lines making up the
    pattern, either 1 or 2. 

    inc (PLINT *, input) :    Pointer to array with nlin elements.
    Specifies the line inclination in tenths of a degree.  (Should be
    between -900 and 900). 

    del (PLINT *, input) :    Pointer to array with nlin elements.
    Specifies the spacing in micrometers between the lines making up
    the pattern. 
")
plpat;

%feature( "docstring", "Draw a line between two points, accounting for coordinate transforms. 

DESCRIPTION:

    Joins the point (
    x1, 
    y1) to (
    x2, 
    y2).  If a global coordinate transform is defined then the line is
    broken in to n segments to approximate the path.  If no transform is
    defined then this simply acts like a call to pljoin. 

    Redacted form: plpath(n,x1,y1,x2,y2)

    This function is not used in any examples. 



SYNOPSIS:

plpath(n, x1, y1, x2, y2)

ARGUMENTS:

    n (PLINT, input) :      number of points to use to approximate the path. 

    x1 (PLFLT, input) :    x coordinate of first point. 

    y1 (PLFLT, input) :    y coordinate of first point. 

    x2 (PLFLT, input) :    x coordinate of second point. 

    y2 (PLFLT, input) :    y coordinate of second point. 
")
plpath;

%feature( "docstring", "Plots a character at the specified points 

DESCRIPTION:

    Marks a set of n points in x and y using the symbol defined by code.
    If code is between 32 and 127, the symbol is simply the corresponding
    printable ASCII character in the default font. 

    Redacted form: plpoin(x, y, code)

    This function is used in examples 1,6,14,18,21,29. 



SYNOPSIS:

plpoin(n, x, y, code)

ARGUMENTS:

    n (PLINT, input) :      Number of points to be marked. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of the
    points. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of the
    points. 

    code (PLINT, input) :    Code number for the symbol to be plotted. 
")
plpoin;

%feature( "docstring", " Plots a character at the specified points in 3 space 

DESCRIPTION:

    Marks a set of n points in x, y, and z using the symbol defined by
    code. If code is between 32 and 127, the symbol is simply the
    corresponding printable ASCII character in the default font. Setup
    similar to plline3. 

    Redacted form: plpoin3(x, y, z, code)

    This function is used in example 18. 



SYNOPSIS:

plpoin3(n, x, y, z, code)

ARGUMENTS:

    n (PLINT, input) :      Number of points to be marked. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of the
    points. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of the
    points. 

    z (PLFLT *, input) :    Pointer to array with z coordinates of the
    points. 

    code (PLINT, input) :    Code number for the symbol to be plotted. 
")
plpoin3;

%feature( "docstring", "Draw a polygon in 3 space 

DESCRIPTION:

    Draws a polygon in 3 space defined by n points in x, y, and z. Setup
    like plline3, but differs from that function in that plpoly3 attempts
    to determine if the polygon is viewable depending on the order of the
    points within the arrays and the value of ifcc.  If the back of
    polygon is facing the viewer, then it isn't drawn.	If this isn't what
    you want, then use plline3 instead. 

    The points are assumed to be in a plane, and the directionality of the
    plane is determined from the first three points.  Additional points do
    not have to lie on the plane defined by the first three, but if they
    do not, then the determination of visibility obviously can't be 100%
    accurate... So if you're 3 space polygons are too far from planar,
    consider breaking them into smaller polygons.  3 points define a plane
    :-). 

    Bugs:  If one of the first two segments is of zero length, or if they
    are co-linear, the calculation of visibility has a 50/50 chance of
    being correct.  Avoid such situations :-).	See x18c.c for an example
    of this problem. (Search for 20.1). 

    Redacted form: plpoly3(x, y, z, code)

    This function is used in example 18. 



SYNOPSIS:

plpoly3(n, x, y, z, draw, ifcc)

ARGUMENTS:

    n (PLINT, input) :      Number of points defining line. 

    x (PLFLT *, input) :    Pointer to array with x coordinates of points. 

    y (PLFLT *, input) :    Pointer to array with y coordinates of points. 

    z (PLFLT *, input) :    Pointer to array with z coordinates of points. 

    draw (PLBOOL *, input) :    Pointer to array which controls drawing
    the segments of the polygon.  If draw[i] is true, then the polygon
    segment from index [i] to [i+1] is drawn, otherwise, not. 

    ifcc (PLBOOL, input) :    If ifcc is true the directionality of the
    polygon is determined by assuming the points are laid out in a
    counter-clockwise order.  Otherwise, the directionality of the
    polygon is determined by assuming the points are laid out in a
    clockwise order. 
")
plpoly3;

%feature( "docstring", "Set precision in numeric labels 

DESCRIPTION:

    Sets the number of places after the decimal point in numeric labels. 

    Redacted form: plprec(set, prec)

    This function is used in example 29. 



SYNOPSIS:

plprec(set, prec)

ARGUMENTS:

    set (PLINT, input) :    If set is equal to 0 then PLplot automatically
    determines the number of places to use after the decimal point in
    numeric labels (like those used to label axes).  If set is 1 then
    prec sets the number of places. 

    prec (PLINT, input) :    The number of characters to draw after the
    decimal point in numeric labels. 
")
plprec;

%feature( "docstring", "Select area fill pattern 

DESCRIPTION:

    Select one of eight predefined area fill patterns to use (also see
    plpat). 

    Redacted form: plpsty(n)

    This function is used in examples 12,13,15,16,25. 



SYNOPSIS:

plpsty(n)

ARGUMENTS:

    n (PLINT, input) :      The desired pattern. Pattern 1 consists of
    horizontal lines, pattern 2 consists of vertical lines, pattern 3
    consists of lines at 45 degrees angle (upward), and so on. 
")
plpsty;

%feature( "docstring", "Write text inside the viewport 

DESCRIPTION:

    Writes text at a specified position and inclination within the
    viewport.  Text is clipped at the viewport boundaries.  The reference
    point of a string lies along a line passing through the string at half
    the height of a capital letter.  The position of the reference point
    along this line is determined by just, the reference point is placed
    at world coordinates (
    x, 
    y) within the viewport.  The inclination of the string is specified in
    terms of differences of world coordinates making it easy to write text
    parallel to a line in a graph. 

    Redacted form: plptex(x, y, dx, dy, just, text)

    This function is used in example 2-4,10,12-14,20,23,24,26. 



SYNOPSIS:

plptex(x, y, dx, dy, just, text)

ARGUMENTS:

    x (PLFLT, input) :      x coordinate of reference point of string. 

    y (PLFLT, input) :      y coordinate of reference point of string. 

    dx (PLFLT, input) :    Together with dy, this specifies the
    inclination of the string.  The baseline of the string is parallel
    to a line joining (
    x, 
    y) to (
    x+
    dx, 
    y+
    dy). 

    dy (PLFLT, input) :    Together with dx, this specifies the
    inclination of the string. 

    just (PLFLT, input) :    Specifies the position of the string relative
    to its reference point.  If just=0., the reference point is at the
    left and if just=1., it is at the right of the string.    Other
    values of just give intermediate justifications. 

    text (const char *, input) :    The string to be written out. 
")
plptex;

%feature( "docstring", "Write text inside the viewport of a 3D plot. 

DESCRIPTION:

    Writes text at a specified position and inclination and with a
    specified shear within the viewport.  Text is clipped at the viewport
    boundaries.  The reference point of a string lies along a line passing
    through the string at half the height of a capital letter.	The
    position of the reference point along this line is determined by just,
    and the reference point is placed at world coordinates (
    x, 
    y, 
    z) within the viewport. The inclination and shear of the string is
    specified in terms of differences of world coordinates making it easy
    to write text parallel to a line in a graph. 

    Redacted form: plptex3(x, y, z, dx, dy, dz, sx, sy, sz,  just, text)

    This function is used in example 28. 



SYNOPSIS:

plptex3(x, y, z, dx, dy, dz, sx, sy, sz, just, text)

ARGUMENTS:

    x (PLFLT, input) :      x coordinate of reference point of string. 

    y (PLFLT, input) :      y coordinate of reference point of string. 

    z (PLFLT, input) :      z coordinate of reference point of string. 

    dx (PLFLT, input) :    Together with dy and 
    dz, this specifies the inclination of  the string.    The baseline of
    the string is parallel to a line  joining (
    x, 
    y, 
    z) to (
    x+
    dx, 
    y+
    dy, 
    z+
    dz). 

    dy (PLFLT, input) :    Together with dx and 
    dz, this specifies the inclination of the string. 

    dz (PLFLT, input) :    Together with dx and 
    dy, this specifies the inclination of the string. 

    sx (PLFLT, input) :    Together with sy and 
    sz, this specifies the shear of  the string.  The string is sheared so
    that the characters are  vertically parallel to a line joining (
    x, 
    y, 
    z) to (
    x+
    sx, 
    y+
    sy, 
    z+
    sz). If sx = 
    sy = 
    sz = 0.) then the text is not sheared. 

    sy (PLFLT, input) :    Together with sx and 
    sz, this specifies shear of the string. 

    sz (PLFLT, input) :    Together with sx and 
    sy, this specifies shear of the string. 

    just (PLFLT, input) :    Specifies the position of the string relative
    to its reference point.  If just=0., the reference point is at the
    left and if just=1., it is at the right of the string.    Other
    values of just give intermediate justifications. 

    text (const char *, input) :    The string to be written out. 
")
plptex3;

%feature( "docstring", "Random number generator  returning a real random number in the range [0,1]. 

DESCRIPTION:

    Random number generator returning a real random number in the  range
    [0,1]. The generator is based on the Mersenne Twister.  Most languages
    / compilers provide their own random number generator,  and so this is
    provided purely for convenience and to give a consistent random number
    generator across all languages supported  by PLplot. This is
    particularly useful for comparing results  from the test suite of
    examples. 

    Redacted form: plrandd()

    This function is used in examples 17,21. 



SYNOPSIS:

plrandd()
")
plrandd;

%feature( "docstring", "Replays contents of plot buffer to current device/file 

DESCRIPTION:

    Replays contents of plot buffer to current device/file. 

    Redacted form: plreplot()

    This function is used in example 1,20. 



SYNOPSIS:

plreplot()
")
plreplot;

%feature( "docstring", "Convert RGB color to HLS 

DESCRIPTION:

    Convert RGB color coordinates to HLS 

    Redacted form:  General: plrgbhls(r, g, b, p_h, p_l, p_s)
	    Perl/PDL: Not available? Implemented as plrgb/plrgb1? 


    This function is used in example 2. 



SYNOPSIS:

plrgbhls(r, g, b, p_h, p_l, p_s)

ARGUMENTS:

    r (PLFLT, input) :      Red intensity (0.0-1.0) of the colour 

    g (PLFLT, input) :      Green intensity (0.0-1.0) of the colour 

    b (PLFLT, input) :      Blue intensity (0.0-1.0) of the colour 

    p_h (PLFLT *, output) :    Pointer to hue, in degrees on the colour
    cone (0.0-360.0) 

    p_l (PLFLT *, output) :    Pointer to lightness, expressed as a
    fraction of the axis of the colour cone (0.0-1.0) 

    p_s (PLFLT *, output) :    Pointer to saturation, expressed as a
    fraction of the radius of the colour cone (0.0-1.0) 
")
plrgbhls;

%feature( "docstring", "Set character size 

DESCRIPTION:

    This sets up the size of all subsequent characters drawn.  The actual
    height of a character is the product of the default character size and
    a scaling factor. 

    Redacted form: plschr(def, scale)

    This function is used in example 2,13,23,24. 



SYNOPSIS:

plschr(def, scale)

ARGUMENTS:

    def (PLFLT, input) :    The default height of a character in
    millimeters, should be set to zero if the default height is to
    remain unchanged. 

    scale (PLFLT, input) :    Scale factor to be applied to default to get
    actual character height. 
")
plschr;

%feature( "docstring", "Set color map0 colors by 8-bit RGB values 

DESCRIPTION:

    Set color map0 colors using 8-bit RGB values (see the PLplot
    documentation).  This sets the entire color map -- only as many colors
    as specified will be allocated. 

    Redacted form: plscmap0(r, g, b, ncol0)

    This function is used in examples 2,24. 



SYNOPSIS:

plscmap0(r, g, b, ncol0)

ARGUMENTS:

    r (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of red in the color. 

    g (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of green in the color. 

    b (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of blue in the color. 

    ncol0 (PLINT, input) :    Number of items in the r, g, and b arrays. 
")
plscmap0;

%feature( "docstring", "Set color map0 colors by 8-bit RGB values and  double alpha value. 

DESCRIPTION:

    Set color map0 colors using 8-bit RGB values (see the PLplot
    documentation)  and floating point alpha value.  This sets the entire
    color map -- only as many colors as specified will be allocated. 

    This function is used in examples 30. 



SYNOPSIS:

plscmap0a(r, g, b, a, ncol0)

ARGUMENTS:

    r (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of red in the color. 

    g (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of green in the color. 

    b (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of blue in the color. 

    a (PLFLT *, input) :    Pointer to array with set of PLFLT values (0.0
    - 1.0) representing the transparency of the color. 

    ncol0 (PLINT, input) :    Number of items in the r, g, b, and a
    arrays. 
")
plscmap0a;

%feature( "docstring", "Set number of colors in color map0 

DESCRIPTION:

    Set number of colors in color map0 (see the PLplot documentation).
    Allocate (or reallocate) color map0, and fill with default values for
    those colors not previously allocated. The first 16 default colors are
    given in the plcol0 documentation. For larger indices the default
    color is red. 

    The drivers are not guaranteed to support more than 16 colors. 

    Redacted form: plscmap0n(ncol0)

    This function is used in examples 15,16,24. 



SYNOPSIS:

plscmap0n(ncol0)

ARGUMENTS:

    ncol0 (PLINT, input) :    Number of colors that will be allocated in
    the map0 palette. If this number is zero or less, then the value
    from the previous call to plscmap0n is used and if there is no
    previous call, then a default value is used. 
")
plscmap0n;

%feature( "docstring", "Set color map1 colors using 8-bit RGB values 

DESCRIPTION:

    Set color map1 colors using 8-bit RGB values (see the PLplot
    documentation).  This also sets the number of colors. 

    Redacted form: plscmap1(r, g, b, ncol1)

    This function is used in example 31. 



SYNOPSIS:

plscmap1(r, g, b, ncol1)

ARGUMENTS:

    r (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of red in the color. 

    g (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of green in the color. 

    b (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of blue in the color. 

    ncol1 (PLINT, input) :    Number of items in the r, g, and b arrays. 
")
plscmap1;

%feature( "docstring", "Set color map1 colors using 8-bit RGB values and double alpha values. 

DESCRIPTION:

    Set color map1 colors using 8-bit RGB values (see the PLplot
    documentation) and double alpha values. This also sets  the number of
    colors.

    This function is used in example 31. 



SYNOPSIS:

plscmap1a(r, g, b, a, ncol1)

ARGUMENTS:

    r (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of red in the color. 

    g (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of green in the color. 

    b (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
    integers (0-255) representing the degree of blue in the color. 

    a (PLFLT *, input) :    Pointer to array with set of double values
    (0.0-1.0) representing the alpha value of the color. 

    ncol1 (PLINT, input) :    Number of items in the r, g, b, and a
    arrays. 
")
plscmap1a;

%feature( "docstring", "Set color map1 colors using a piece-wise linear relationship 

DESCRIPTION:

    Set color map1 colors using a piece-wise linear relationship between
    position in the color map (from 0 to 1) and position in HLS or RGB
    color space (see the PLplot documentation).  May be called at any
    time. 

    The idea here is to specify a number of control points that define the
    mapping between palette 1 input positions (intensities) and HLS (or
    RGB).  Between these points, linear interpolation is used which gives
    a smooth variation of color with input position.  Any number of
    control points may be specified, located at arbitrary positions,
    although typically 2 - 4 are enough. Another way of stating this is
    that we are traversing a given number of lines through HLS (or RGB)
    space as we move through color map1 entries.  The control points at
    the minimum and maximum position (0 and 1) must always be specified. 
    By adding more control points you can get more variation.  One good
    technique for plotting functions that vary about some expected average
    is to use an additional 2 control points in the center (position ~=
    0.5) that are the same lightness as the background (typically white
    for paper output, black for crt), and same hue as the boundary control
    points.  This allows the highs and lows to be very easily
    distinguished. 

    Each control point must specify the position in color map1 as well as
    three coordinates in HLS or RGB space.  The first point must
    correspond to position = 0, and the last to position = 1. 

    The hue is interpolated around the \"front\" of the color wheel
    (red<->green<->blue<->red) unless the \"rev\" flag is set to true, in
    which case interpolation (between the i and i + 1 control point for
    rev[i]) proceeds around the back (reverse) side.  Specifying rev=NULL
    is equivalent to setting rev[]= false for every control point. 

    Bounds on coordinatesRGBR[0, 1]magnitudeRGBG[0, 1]magnitudeRGBB[0,
    1]magnitudeHLShue[0, 360]degreesHLSlightness[0,
    1]magnitudeHLSsaturation[0, 1]magnitude

    Redacted form: plscmap1l(itype, pos, coord1, coord2, coord3, rev)

    This function is used in examples 8,11,12,15,20,21. 



SYNOPSIS:

plscmap1l(itype, npts, pos, coord1, coord2, coord3, rev)

ARGUMENTS:

    itype (PLBOOL, input) :    true: RGB, false: HLS. 

    npts (PLINT, input) :    number of control points 

    pos (PLFLT *, input) :    position for each control point (between 0.0
    and 1.0, in ascending order) 

    coord1 (PLFLT *, input) :     first coordinate (H or R) for each
    control point 

    coord2 (PLFLT *, input) :     second coordinate (L or G) for each
    control point 

    coord3 (PLFLT *, input) :     third coordinate (S or B) for each
    control point 

    rev (PLBOOL: *, input) :    reverse flag for each control point.
    (rev[i] refers to the interpolation interval between the i and i +
    1 control points). 
")
plscmap1l;

%feature( "docstring", "Set color map1 colors using a piece-wise linear relationship 

DESCRIPTION:

    This is a version of plscmap1l that supports alpha transparency. It
    sets color map1 colors using a piece-wise linear relationship between
    position in the color map (from 0 to 1) and position in HLS or RGB
    color space (see the PLplot documentation) with alpha value (0.0 -
    1.0). It may be called at any time. 

    This function is used in example 30. 



SYNOPSIS:

plscmap1la(itype, npts, pos, coord1, coord2, coord3, coord4, rev)

ARGUMENTS:

    itype (PLBOOL, input) :    true: RGB, false: HLS. 

    npts (PLINT, input) :    number of control points 

    pos (PLFLT *, input) :    position for each control point (between 0.0
    and 1.0, in ascending order) 

    coord1 (PLFLT *, input) :     first coordinate (H or R) for each
    control point 

    coord2 (PLFLT *, input) :     second coordinate (L or G) for each
    control point 

    coord3 (PLFLT *, input) :     third coordinate (S or B) for each
    control point 

    coord4 (PLFLT *, input) :     fourth coordinate, the alpha value for
    each control point 

    rev (PLBOOL: *, input) :    reverse flag for each control point.
    (rev[i] refers to the interpolation interval between the i and i +
    1 control points). 
")
plscmap1la;

%feature( "docstring", "Set number of colors in color map1 

DESCRIPTION:

    Set number of colors in color map1, (re-)allocate color map1, and set
    default values if this is the first allocation (see the PLplot
    documentation). 

    Redacted form: plscmap1n(ncol1)

    This function is used in examples 8,11,20,21. 



SYNOPSIS:

plscmap1n(ncol1)

ARGUMENTS:

    ncol1 (PLINT, input) :    Number of colors that will be allocated in
    the map1 palette. If this number is zero or less, then the value
    from the previous call to plscmap1n is used and if there is no
    previous call, then a default value is used. 
")
plscmap1n;

%feature( "docstring", " Set a given color from color map0 by 8 bit RGB value 

DESCRIPTION:

    Set a given color by 8-bit RGB value for color map0 (see the PLplot
    documentation).  Overwrites the previous color value for the given
    index and, thus, does not result in any additional allocation of space
    for colors. 

    Redacted form: plscol0(icol0, r, g, b)

    This function is not used in any examples. 



SYNOPSIS:

plscol0(icol0, r, g, b)

ARGUMENTS:

    icol0 (PLINT, input) :    Color index.  Must be less than the maximum
    number of colors (which is set by default, by plscmap0n, or even
    by plscmap0). 

    r (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of red in the color. 

    g (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of green in the color. 

    b (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of blue in the color. 
")
plscol0;

%feature( "docstring", " Set a given color from color map0 by 8 bit RGB value and double alpha value. 

DESCRIPTION:

    Set a given color by 8-bit RGB value and double alpha value for color 
    map0 (see the PLplot documentation).  Overwrites the previous color
    value  for the given index and, thus, does not result in any
    additional allocation  of space for colors. 

    This function is used in example 30. 



SYNOPSIS:

plscol0a(icol0, r, g, b, a)

ARGUMENTS:

    icol0 (PLINT, input) :    Color index.  Must be less than the maximum
    number of colors (which is set by default, by plscmap0n, or even
    by plscmap0). 

    r (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of red in the color. 

    g (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of green in the color. 

    b (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of blue in the color. 

    a (PLFLT, input) :      double value (0.0-1.0) representing the alpha
    value of the color. 
")
plscol0a;

%feature( "docstring", "Set the background color by 8-bit RGB value 

DESCRIPTION:

    Set the background color (color 0 in color map 0) by 8-bit RGB value
    (see the PLplot documentation). 

    Redacted form: plscolbg(r, g, b)

    This function is used in examples 15,31. 



SYNOPSIS:

plscolbg(r, g, b)

ARGUMENTS:

    r (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of red in the color. 

    g (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of green in the color. 

    b (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of blue in the color. 
")
plscolbg;

%feature( "docstring", "Set the background color by 8-bit RGB value and double alpha value. 

DESCRIPTION:

    Set the background color (color 0 in color map 0) by 8-bit RGB value
    (see the PLplot documentation) and double alpha value. 

    This function is used in example 31. 



SYNOPSIS:

plscolbga(r, g, b, a)

ARGUMENTS:

    r (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of red in the color. 

    g (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of green in the color. 

    b (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
    degree of blue in the color. 

    a (PLFLT, input) :      double value (0.0-1.0) representing the alpha
    value of the color. 
")
plscolbga;

%feature( "docstring", "Used to globally turn color output on/off 

DESCRIPTION:

    Used to globally turn color output on/off for those drivers/devices
    that support it. 

    Redacted form: plscolor(color)

    This function is used in example 31. 



SYNOPSIS:

plscolor(color)

ARGUMENTS:

    color (PLINT, input) :    Color flag (Boolean).  If zero, color is
    turned off.  If non-zero, color is turned on. 
")
plscolor;

%feature( "docstring", "Set device-compression level 

DESCRIPTION:

    Set device-compression level.  Only used for drivers that provide
    compression.  This function, if used, should be invoked before a call
    to plinit.	

    Redacted form: plscompression(compression)

    This function is used in example 31. 



SYNOPSIS:

plscompression(compression)

ARGUMENTS:

    compression (PLINT, input) :    The desired compression level. This is
    a device-dependent value. Currently only the jpeg and png devices
    use these values. For jpeg  value is the jpeg quality which should
    normally be in the range 0-95. Higher values denote higher quality
    and hence larger image sizes. For png values are in the range -1
    to 99. Values of 0-9 are taken as the  compression level for zlib.
    A value of -1 denotes the default zlib    compression level. Values
    in the range 10-99 are divided by 10 and  then used as the zlib
    compression level. Higher compression levels correspond to greater
    compression and small file sizes at the expense of more
    computation. 
")
plscompression;

%feature( "docstring", "Set the device (keyword) name 

DESCRIPTION:

    Set the device (keyword) name. 

    Redacted form: plsdev(devname)

    This function is used in examples 1,14,20. 



SYNOPSIS:

plsdev(devname)

ARGUMENTS:

    devname (const char *, input) :    Pointer to device (keyword) name
    string. 
")
plsdev;

%feature( "docstring", "Set parameters that define current device-space window 

DESCRIPTION:

    Set relative margin width, aspect ratio, and relative justification
    that define current device-space window.  If you want to just use the
    previous value for any of these, just pass in the magic value
    PL_NOTSET. It is unlikely that one should ever need to change the
    aspect ratio but it's in there for completeness. If plsdidev is not
    called the default values of mar, jx, and jy are all 0. aspect is set
    to a device-specific value. 

    Redacted form: plsdidev(mar, aspect, jx, jy)

    This function is used in example 31. 



SYNOPSIS:

plsdidev(mar, aspect, jx, jy)

ARGUMENTS:

    mar (PLFLT, input) :    Relative margin width. 

    aspect (PLFLT, input) :    Aspect ratio. 

    jx (PLFLT, input) :    Relative justification in x. Value must lie in
    the range -0.5 to 0.5. 

    jy (PLFLT, input) :    Relative justification in y. Value must lie in
    the range -0.5 to 0.5. 
")
plsdidev;

%feature( "docstring", "Set up transformation from metafile coordinates 

DESCRIPTION:

    Set up transformation from metafile coordinates.  The size of the plot
    is scaled so as to preserve aspect ratio.  This isn't intended to be a
    general-purpose facility just yet (not sure why the user would need
    it, for one). 

    Redacted form: plsdimap(dimxmin, dimxmax, dimymin, dimymax, dimxpmm,
    dimypmm)

    This function is not used in any examples. 



SYNOPSIS:

plsdimap(dimxmin, dimxmax, dimymin, dimymax, dimxpmm, dimypmm)

ARGUMENTS:

    dimxmin (PLINT, input) :    NEEDS DOCUMENTATION 

    dimxmax (PLINT, input) :    NEEDS DOCUMENTATION 

    dimymin (PLINT, input) :    NEEDS DOCUMENTATION 

    dimymax (PLINT, input) :    NEEDS DOCUMENTATION 

    dimxpmm (PLFLT, input) :    NEEDS DOCUMENTATION 

    dimypmm (PLFLT, input) :    NEEDS DOCUMENTATION 
")
plsdimap;

%feature( "docstring", "Set plot orientation 

DESCRIPTION:

    Set plot orientation parameter which is multiplied by 90 degrees to
    obtain the angle of rotation.  Note, arbitrary rotation parameters
    such as 0.2 (corresponding to 18 degrees) are possible, but the usual
    values for the rotation parameter are 0., 1., 2., and 3. corresponding
    to 0 degrees (landscape mode), 90 degrees (portrait mode), 180 degrees
    (seascape mode), and 270 degrees (upside-down mode).  If plsdiori is
    not called the default value of rot is 0. 

    N.B. aspect ratio is unaffected by calls to plsdiori.  So you will
    probably want to change the aspect ratio to a value suitable for the
    plot orientation using a call to plsdidev or the command-line options
    -a or -freeaspect.	For more documentation of those options see the
    PLplot documentation.  Such command-line options can be set internally
    using plsetopt or set directly using the command line and parsed using
    a call to  plparseopts. 

    Redacted form: plsdiori(rot)

    This function is not used in any examples. 



SYNOPSIS:

plsdiori(rot)

ARGUMENTS:

    rot (PLFLT, input) :    Plot orientation parameter. 
")
plsdiori;

%feature( "docstring", "Set parameters that define current plot-space window 

DESCRIPTION:

    Set relative minima and maxima that define the current plot-space
    window.  If plsdiplt is not called the default values of xmin, ymin,
    xmax, and ymax are 0., 0., 1., and 1. 

    Redacted form: plsdiplt(xmin, ymin, xmax, ymax)

    This function is used in example 31. 



SYNOPSIS:

plsdiplt(xmin, ymin, xmax, ymax)

ARGUMENTS:

    xmin (PLFLT, input) :    Relative minimum in x. 

    ymin (PLFLT, input) :    Relative minimum in y. 

    xmax (PLFLT, input) :    Relative maximum in x. 

    ymax (PLFLT, input) :    Relative maximum in y. 
")
plsdiplt;

%feature( "docstring", "Set parameters incrementally (zoom mode) that define current plot-space window 

DESCRIPTION:

    Set relative minima and maxima incrementally (zoom mode) that define
    the current plot-space window.  This function has the same effect as
    plsdiplt if that function has not been previously called.  Otherwise,
    this function implements zoom mode using the transformation min_used =
    old_min + old_length*min  and max_used = old_min + old_length*max  for
    each axis.	For example, if min = 0.05 and max = 0.95 for each axis,
    repeated calls to plsdiplz will zoom in by 10 per cent for each call. 

    Redacted form: plsdiplz(xmin, ymin, xmax, ymax)

    This function is used in example 31. 



SYNOPSIS:

plsdiplz(xmin, ymin, xmax, ymax)

ARGUMENTS:

    xmin (PLFLT, input) :    Relative (incremental) minimum in x. 

    ymin (PLFLT, input) :    Relative (incremental) minimum in y. 

    xmax (PLFLT, input) :    Relative (incremental) maximum in x. 

    ymax (PLFLT, input) :    Relative (incremental) maximum in y. 
")
plsdiplz;

%feature( "docstring", "Set seed for internal random  number generator. 

DESCRIPTION:

    Set the seed for the internal random number generator. See plrandd for
    further details. 

    Redacted form: plseed(seed)

    This function is used in example 21. 



SYNOPSIS:

plseed(seed)

ARGUMENTS:

    seed (unsigned int, input) :    Seed for random number generator. 
")
plseed;

%feature( "docstring", "Set the escape character for text strings 

DESCRIPTION:

    Set the escape character for text strings.	From C (in contrast to
    Fortran 77, see plsescfortran77) you pass esc as a character. Only
    selected characters are allowed to prevent the user from shooting
    himself in the foot (For example, a \ isn't allowed since it conflicts
    with C's use of backslash as a character escape).  Here are the
    allowed escape characters and their corresponding decimal ASCII
    values: !, ASCII 33 
	    #, ASCII 35 
	    $, ASCII 36 
	    %, ASCII 37 
	    &, ASCII 38 
	    *, ASCII 42 
	    @, ASCII 64 
	    ^, ASCII 94 
	    ~, ASCII 126 


    Redacted form:  General: plsesc(esc)
	    Perl/PDL: Not available? 


    This function is used in example 29. 



SYNOPSIS:

plsesc(esc)

ARGUMENTS:

    esc (char, input) :    Escape character. 
")
plsesc;

%feature( "docstring", "Set any command-line option 

DESCRIPTION:

    Set any command-line option internally from a program before it
    invokes plinit. opt is the name of the command-line option and optarg
    is the corresponding command-line option argument.	

    This function returns 0 on success. 

    Redacted form: plsetopt(opt, optarg)

    This function is used in example 14. 



SYNOPSIS:

int plsetopt(opt, optarg)

ARGUMENTS:

    opt (const char *, input) :    Pointer to string containing the
    command-line option. 

    optarg (const char *, input) :    Pointer to string containing the
    argument of the command-line option. 
")
plsetopt;

%feature( "docstring", "Set family file parameters 

DESCRIPTION:

    Sets variables dealing with output file familying.	Does nothing if
    familying not supported by the driver.  This routine, if used, must be
    called before initializing PLplot.	See the PLplot documentation for
    more information. 

    Redacted form: plsfam(fam, num, bmax)

    This function is used in examples 14,31. 



SYNOPSIS:

plsfam(fam, num, bmax)

ARGUMENTS:

    fam (PLINT, input) :    Family flag (Boolean).  If nonzero, familying
    is enabled. 

    num (PLINT, input) :    Current family file number. 

    bmax (PLINT, input) :    Maximum file size (in bytes) for a family
    file. 
")
plsfam;

%feature( "docstring", "Set FCI (font characterization integer) 

DESCRIPTION:

    Sets font characteristics to be used at the start of the next string
    using the FCI approach. See the PLplot documentation for more
    information. 

    Redacted form:  General: plsfci(fci)
	    Perl/PDL: Not available? 


    This function is used in example 23. 



SYNOPSIS:

plsfci(fci)

ARGUMENTS:

    fci (PLUNICODE, input) :    PLUNICODE (unsigned 32-bit integer) value
    of FCI. 
")
plsfci;

%feature( "docstring", "Set output file name 

DESCRIPTION:

    Sets the current output file name, if applicable.  If the file name
    has not been specified and is required by the driver, the user will be
    prompted for it.  If using the X-windows output driver, this sets the
    display name.  This routine, if used, must be called before
    initializing PLplot. 

    Redacted form: plsfnam(fnam)

    This function is used in examples 1,20. 



SYNOPSIS:

plsfnam(fnam)

ARGUMENTS:

    fnam (const char *, input) :    Pointer to file name string. 
")
plsfnam;

%feature( "docstring", "Set family, style and weight of the current font 

DESCRIPTION:

    Sets the current font.  See the PLplot documentation for more
    information on font selection. 

    Redacted form: plsfont(family, style, weight)

    This function is used in example 23. 



SYNOPSIS:

plsfont(family, style, weight)

ARGUMENTS:

    family (PLINT, input) :    Font family to select for the current font.
    The available values are given by the PL_FCI_* constants in
    plplot.h. Current options are PL_FCI_SANS, PL_FCI_SERIF, 
    PL_FCI_MONO, PL_FCI_SCRIPT and PL_FCI_SYMBOL. A negative value
    signifies that the font family should not be altered.  

    style (PLINT, input) :    Font style to select for the current font.
    The available values are given by the PL_FCI_* constants in
    plplot.h. Current options are PL_FCI_UPRIGHT, PL_FCI_ITALIC and
    PL_FCI_OBLIQUE. A negative value signifies that the font style
    should not be altered.    

    weight (PLINT, input) :    Font weight to select for the current font.
    The available values are given by the PL_FCI_* constants in
    plplot.h. Current options are PL_FCI_MEDIUM and PL_FCI_BOLD. A
    negative value signifies that the font weight should not be
    altered.  
")
plsfont;

%feature( "docstring", "Shade regions on the basis of value 

DESCRIPTION:

    Shade regions on the basis of value.  This is the high-level routine
    for making continuous color shaded plots with cmap1 while plshade (or
    plshade1) are used for individual shaded regions using either cmap0 or
    cmap1. examples/c/x16c.c shows a number of examples for using this
    function. See the following discussion of the arguments and the PLplot
    documentation for more information.    

    Redacted form:  General: plshades(a, defined, xmin, xmax, ymin, ymax,
    clevel, fill_width, cont_color, cont_width, fill, rectangular, pltr,
    pltr_data)
	    Perl/PDL: plshades(a, xmin, xmax, ymin, ymax, clevel,
    fill_width, cont_color, cont_width, fill, rectangular, defined, pltr,
    pltr_data)


    This function is used in examples 16,21. 



SYNOPSIS:

plshades(a, nx, ny, defined, xmin, xmax, ymin, ymax, clevel, nlevel, fill_width, cont_color, cont_width, fill, rectangular, pltr, pltr_data)

ARGUMENTS:

    a (PLFLT **, input) :    Contains ** pointer to array to be plotted.
    The array must have been declared as PLFLT a[nx][ny]. 

    nx (PLINT, input) :    First dimension of array \"a\". 

    ny (PLINT, input) :    Second dimension of array \"a\". 

    defined (PLINT (*) (PLFLT, PLFLT), input) :    User function
    specifying regions excluded from the shading plot.  This function
    accepts x and y coordinates as input arguments and must return 0
    if the point is in the excluded region or 1 otherwise. This
    argument can be NULL if all the values are valid. 

    xmin (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    xmax (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    ymin (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    ymax (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    clevel (PLFLT *, input) :     Pointer to array containing the data
    levels corresponding to the edges of each shaded region that will
    be plotted by this function.  To work properly the levels should
    be monotonic. 

    nlevel (PLINT, input) :    Number of shades plus 1 (i.e., the number
    of shade edge values in clevel). 

    fill_width (PLINT, input) :    Defines width used by the fill pattern. 

    cont_color (PLINT, input) :    Defines pen color used for contours
    defining edges of shaded regions.  The pen color is only temporary
    set for the contour drawing.  Set this value to zero or less if no
    shade edge contours are wanted. 

    cont_width (PLINT, input) :    Defines pen width used for contours
    defining edges of shaded regions.  This value may not be honored
    by all drivers. The pen width is only temporary set for the
    contour drawing.  Set this value to zero or less if no shade edge
    contours are wanted. 

    fill (void (*) (PLINT, PLFLT *, PLFLT *), input) :      Routine used to
    fill the region.  Use plfill.  Future version of PLplot may have
    other fill routines. 

    rectangular (PLBOOL, input) :    Set rectangular to true if rectangles
    map to rectangles after coordinate transformation with pltrl. 
    Otherwise, set rectangular to false. If rectangular is set to
    true, plshade tries to save time by filling large rectangles. 
    This optimization fails if the coordinate transformation distorts
    the shape of rectangles. For example a plot in polar coordinates
    has to have  rectangular set to false. 

    pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
      Pointer to function that defines transformation between indices
    in array z and the world coordinates (C only).    Transformation
    functions are provided in the PLplot library: pltr0 for identity
    mapping, and pltr1 and pltr2 for arbitrary mappings respectively
    defined by one- and two-dimensional arrays.  In addition,
    user-supplied routines for the transformation can be used as well.
     Examples of all of these approaches are given in the PLplot
    documentation. The transformation function should have the form
    given by any of pltr0, pltr1, or pltr2. 

    pltr_data (PLPointer, input) :    Extra parameter to help pass
    information to pltr0, pltr1, pltr2, or whatever routine that is
    externally supplied. 
")
plshades;

%feature( "docstring", " Shade individual region on the basis of value 

DESCRIPTION:

    Shade individual region on the basis of value.  Use plshades if you
    want to shade a number of regions using continuous colors. plshade is
    identical to plshade1 except for the type of the first parameter. See
    plshade1 for further discussion. 

    Redacted form:  General: plshade(a, defined, xmin, xmax, ymin, ymax,
    shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color,
    min_width, max_color, max_width, fill, rectangular, pltr, pltr_data)
	    Perl/PDL: Not available? 


    This function is used in example 15. 



SYNOPSIS:

plshade(a, nx, ny, defined, xmin, xmax, ymin, ymax, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, fill, rectangular, pltr, pltr_data)

ARGUMENTS:

    a (PLFLT **, input) :    

    nx (PLINT, input) :    

    ny (PLINT, input) :    

    defined (PLINT (*) (PLFLT, PLFLT), input) :    

    xmin (PLFLT, input) :    

    xmax (PLFLT, input) :    

    ymin (PLFLT, input) :    

    ymax (PLFLT, input) :    

    shade_min (PLFLT, input) :      

    shade_max (PLFLT, input) :      

    sh_cmap (PLINT, input) :    

    sh_color (PLFLT, input) :     

    sh_width (PLINT, input) :     

    min_color (PLINT, input) :      

    min_width (PLINT, input) :      

    max_color (PLINT, input) :      

    max_width (PLINT, input) :      

    fill (void (*) (PLINT, PLFLT *, PLFLT *), input) :      

    rectangular (PLBOOL, input) :    

    pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) :  

    pltr_data (PLPointer, input) :    
")
plshade;

%feature( "docstring", "Shade individual region on the basis of value 

DESCRIPTION:

    Shade individual region on the basis of value.  Use plshades if you
    want to shade a number of contiguous regions using continuous colors. 
    In particular the edge contours are treated properly in plshades. If
    you attempt to do contiguous regions with plshade1 (or plshade) the
    contours at the edge of the shade are partially obliterated by
    subsequent plots of contiguous shaded regions. plshade1 differs from
    plshade by the type of the first argument.	Look at the argument list
    below, plcont and the PLplot documentation for more information about
    the transformation from grid to world coordinates.	Shading NEEDS
    DOCUMENTATION, but as a stopgap look at how plshade is used in
    examples/c/x15c.c

    Redacted form:  General: plshade1(a, defined, xmin, xmax, ymin, ymax,
    shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color,
    min_width, max_color, max_width, fill, rectangular, pltr, pltr_data)
	    Perl/PDL: plshade1(a, xmin, xmax, ymin, ymax, shade_min,
    shade_max, sh_cmap, sh_color, sh_width, min_color, min_width,
    max_color, max_width, fill, rectangular, defined, pltr, pltr_data)


    This function is used in example 15. 



SYNOPSIS:

plshade1(a, nx, ny, defined, xmin, xmax, ymin, ymax, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, fill, rectangular, pltr, pltr_data)

ARGUMENTS:

    a (PLFLT *, input) :    Contains array to be plotted. The array must
    have been declared as PLFLT a[nx][ny]. 

    nx (PLINT, input) :    First dimension of array \"a\". 

    ny (PLINT, input) :    Second dimension of array \"a\". 

    defined (PLINT (*) (PLFLT, PLFLT), input) :    User function
    specifying regions excluded from the shading plot.  This function
    accepts x and y coordinates as input arguments and must return 0
    if the point is in the excluded region or 1 otherwise. This
    argument can be NULL if all the values are valid. 

    xmin (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    xmax (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    ymin (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    ymax (PLFLT, input) :    Defines the \"grid\" coordinates.  The data
    a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
    at (xmax,ymin) and so on. 

    shade_min (PLFLT, input) :      Defines the lower end of the interval to
    be shaded. If shade_max <= shade_min, plshade1 does nothing. 

    shade_max (PLFLT, input) :      Defines the upper end of the interval to
    be shaded. If shade_max <= shade_min, plshade1 does nothing. 

    sh_cmap (PLINT, input) :    Defines color map. 

    sh_color (PLFLT, input) :     Defines color map index if cmap0 or color
    map input value (ranging from 0. to 1.) if cmap1. 

    sh_width (PLINT, input) :     Defines width used by the fill pattern. 

    min_color (PLINT, input) :      Defines pen color, width used by the
    boundary of shaded region. The min values are used for the
    shade_min boundary, and the max values are used on the shade_max
    boundary.  Set color and width to zero for no plotted boundaries. 

    min_width (PLINT, input) :      Defines pen color, width used by the
    boundary of shaded region. The min values are used for the
    shade_min boundary, and the max values are used on the shade_max
    boundary.  Set color and width to zero for no plotted boundaries. 

    max_color (PLINT, input) :      Defines pen color, width used by the
    boundary of shaded region. The min values are used for the
    shade_min boundary, and the max values are used on the shade_max
    boundary.  Set color and width to zero for no plotted boundaries. 

    max_width (PLINT, input) :      Defines pen color, width used by the
    boundary of shaded region. The min values are used for the
    shade_min boundary, and the max values are used on the shade_max
    boundary.  Set color and width to zero for no plotted boundaries. 

    fill (void (*) (PLINT, PLFLT *, PLFLT *), input) :      Routine used to
    fill the region.  Use plfill.  Future version of plplot may have
    other fill routines. 

    rectangular (PLBOOL, input) :    Set rectangular to true if rectangles
    map to rectangles after coordinate transformation with pltrl. 
    Otherwise, set rectangular to false. If rectangular is set to
    true, plshade tries to save time by filling large rectangles. 
    This optimization fails if the coordinate transformation distorts
    the shape of rectangles. For example a plot in polar coordinates
    has to have rectangular set to false. 

    pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
      Pointer to function that defines transformation between indices
    in array z and the world coordinates (C only).    Transformation
    functions are provided in the PLplot library: pltr0 for identity
    mapping, and pltr1 and pltr2 for arbitrary mappings respectively
    defined by one- and two-dimensional arrays.  In addition,
    user-supplied routines for the transformation can be used as well.
     Examples of all of these approaches are given in the PLplot
    documentation. The transformation function should have the form
    given by any of pltr0, pltr1, or pltr2. 

    pltr_data (PLPointer, input) :    Extra parameter to help pass
    information to pltr0, pltr1, pltr2, or whatever routine that is
    externally supplied. 
")
plshade1;

%feature( "docstring", "Assign a function to use for generating custom axis labels 

DESCRIPTION:

    This function allows a user to provide their own function to provide
    axis label text.  The user function is given the numeric value for a
    point on an axis and returns a string label to correspond with that
    value.  Custom axis labels can be enabled by passing appropriate
    arguments to plenv, plbox, plbox3 and similar functions. 

    This function is used in example 19. 



SYNOPSIS:

plslabelfunc(label_func, label_data)

ARGUMENTS:

    label_func (void (*) (PLINT, PLFLT, char *, PLINT, void *), input) :  
     This is the custom label function.  In order to reset to the
    default labeling, set this to NULL. The labeling function
    parameters are, in order: axis:    This indicates which axis a
    label is being requested for. The value will be one of PL_X_AXIS,
    PL_Y_AXIS or PL_Z_AXIS. 

    value:    This is the value along the axis which is being labeled. 

    label_text:    The string representation of the label value. 

    length:    The maximum length in characters allowed for label_text. 


    label_data (void *, input) :    This parameter may be used to pass
    data to the label_func function. 
")
plslabelfunc;

%feature( "docstring", "Set length of major ticks 

DESCRIPTION:

    This sets up the length of the major ticks.  The actual length is the
    product of the default length and a scaling factor as for character
    height. 

    Redacted form: plsmaj(def, scale)

    This function is used in example 29. 



SYNOPSIS:

plsmaj(def, scale)

ARGUMENTS:

    def (PLFLT, input) :    The default length of a major tick in
    millimeters, should be set to zero if the default length is to
    remain unchanged. 

    scale (PLFLT, input) :    Scale factor to be applied to default to get
    actual tick length. 
")
plsmaj;

%feature( "docstring", "Set the memory area to be plotted (RGB) 

DESCRIPTION:

    Set the memory area to be plotted (with the mem or memcairo driver) as
    the dev member of the stream structure.  Also set the number of pixels
    in the memory passed in 
    plotmem, which is a block of memory 
    maxy by 
    maxx by 3 bytes long, say: 480 x 640 x 3 (Y, X, RGB) 

    This memory will have to be freed by the user! 

    Redacted form: plsmem(maxx, maxy, plotmem)

    This function is not used in any examples. 



SYNOPSIS:

plsmem(maxx, maxy, plotmem)

ARGUMENTS:

    maxx (PLINT, input) :    Size of memory area in the X coordinate. 

    maxy (PLINT, input) :    Size of memory area in the Y coordinate. 

    plotmem (void *, input) :     Pointer to the beginning of the
    user-supplied memory area. 
")
plsmem;

%feature( "docstring", "Set the memory area to be plotted (RGBA) 

DESCRIPTION:

    Set the memory area to be plotted (with the memcairo driver) as the
    dev member of the stream structure. Also set the number of pixels in
    the memory passed in 
    plotmem, which is a block of memory 
    maxy by 
    maxx by 4 bytes long, say: 480 x 640 x 4 (Y, X, RGBA) 

    This memory will have to be freed by the user! 

    Redacted form: plsmema(maxx, maxy, plotmem)

    This function is not used in any examples. 



SYNOPSIS:

plsmema(maxx, maxy, plotmem)

ARGUMENTS:

    maxx (PLINT, input) :    Size of memory area in the X coordinate. 

    maxy (PLINT, input) :    Size of memory area in the Y coordinate. 

    plotmem (void *, input) :     Pointer to the beginning of the
    user-supplied memory area. 
")
plsmema;

%feature( "docstring", "Set length of minor ticks 

DESCRIPTION:

    This sets up the length of the minor ticks and the length of the
    terminals on error bars.  The actual length is the product of the
    default length and a scaling factor as for character height. 

    Redacted form: plsmin(def, scale)

    This function is used in example 29. 



SYNOPSIS:

plsmin(def, scale)

ARGUMENTS:

    def (PLFLT, input) :    The default length of a minor tick in
    millimeters, should be set to zero if the default length is to
    remain unchanged. 

    scale (PLFLT, input) :    Scale factor to be applied to default to get
    actual tick length. 
")
plsmin;

%feature( "docstring", "Set orientation 

DESCRIPTION:

    Set integer plot orientation parameter.  This function is identical to
    plsdiori except for the type of the argument, and should be used in
    the same way.  See the PLplot documentation for details. 

    Redacted form: plsori(ori)

    This function is used in example 3. 



SYNOPSIS:

plsori(ori)

ARGUMENTS:

    ori (PLINT, input) :    Orientation value (0 for landscape, 1 for
    portrait, etc.) The value is multiplied by 90 degrees to get the
    angle. 
")
plsori;

%feature( "docstring", "Set page parameters 

DESCRIPTION:

    Sets the page configuration (optional).  If an individual parameter is
    zero then that parameter value is not updated.  Not all parameters are
    recognized by all drivers and the interpretation is device-dependent.
    The X-window driver uses the length and offset parameters to determine
    the window size and location.  The length and offset values are
    expressed in units that are specific to the current driver. For
    instance: screen drivers will usually interpret them as number of
    pixels, whereas printer drivers will usually use mm. This routine, if
    used, must be called before initializing PLplot. 

    Redacted form: plspage(xp, yp, xleng, yleng, xoff, yoff)

    This function is used in example 31. 



SYNOPSIS:

plspage(xp, yp, xleng, yleng, xoff, yoff)

ARGUMENTS:

    xp (PLFLT, input) :    Number of pixels/inch (DPI), x. 

    yp (PLFLT, input) :    Number of pixels/inch (DPI), y. 

    xleng (PLINT , input) :    Page length, x. 

    yleng (PLINT, input) :    Page length, y. 

    xoff (PLINT, input) :    Page offset, x. 

    yoff (PLINT, input) :    Page offset, y. 
")
plspage;

%feature( "docstring", "Set the colors for color table 0 from a cmap0 file 

DESCRIPTION:

    Set the colors for color table 0 from a cmap0 file 

    Redacted form: plspal0(filename)

    This function is in example 16. 



SYNOPSIS:

plspal0(filename)

ARGUMENTS:

    filename (const char *, input) :    The name of the cmap0 file, or a
    empty to string to specify the default cmap0 file. 
")
plspal0;

%feature( "docstring", "Set the colors for color table 1 from a cmap1 file 

DESCRIPTION:

    Set the colors for color table 1 from a cmap1 file 

    Redacted form: plspal1(filename)

    This function is in example 16. 



SYNOPSIS:

plspal1(filename)

ARGUMENTS:

    filename (const char *, input) :    The name of the cmap1 file, or a
    empty to string to specify the default cmap1 file. 
")
plspal1;

%feature( "docstring", "Set the pause (on end-of-page) status 

DESCRIPTION:

    Set the pause (on end-of-page) status. 

    Redacted form: plspause(pause)

    This function is in examples 14,20. 



SYNOPSIS:

plspause(pause)

ARGUMENTS:

    pause (PLBOOL, input) :    If pause is true there will be a pause on
    end-of-page for those drivers which support this.  Otherwise there
    is no pause. 
")
plspause;

%feature( "docstring", "Set current output stream 

DESCRIPTION:

    Sets the number of the current output stream.  The stream number
    defaults to 0 unless changed by this routine.  The first use of this
    routine must be followed by a call initializing PLplot (e.g. plstar). 

    Redacted form: plsstrm(strm)

    This function is examples 1,14,20. 



SYNOPSIS:

plsstrm(strm)

ARGUMENTS:

    strm (PLINT, input) :    The current stream number. 
")
plsstrm;

%feature( "docstring", "Set the number of subpages in x and y 

DESCRIPTION:

    Set the number of subpages in x and y. 

    Redacted form: plssub(nx, ny)

    This function is examples 1,2,14,21,25,27. 



SYNOPSIS:

plssub(nx, ny)

ARGUMENTS:

    nx (PLINT, input) :    Number of windows in x direction (i.e., number
    of window columns). 

    ny (PLINT, input) :    Number of windows in y direction (i.e., number
    of window rows). 
")
plssub;

%feature( "docstring", "Set symbol size 

DESCRIPTION:

    This sets up the size of all subsequent symbols drawn by plpoin and
    plsym.  The actual height of a symbol is the product of the default
    symbol size and a scaling factor as for the character height. 

    Redacted form: plssym(def, scale)

    This function is used in example 29. 



SYNOPSIS:

plssym(def, scale)

ARGUMENTS:

    def (PLFLT, input) :    The default height of a symbol in millimeters,
    should be set to zero if the default height is to remain
    unchanged. 

    scale (PLFLT, input) :    Scale factor to be applied to default to get
    actual symbol height. 
")
plssym;

%feature( "docstring", "Initialization 

DESCRIPTION:

    Initializing the plotting package.	The program prompts for the device
    keyword or number of the desired output device.  Hitting a RETURN in
    response to the prompt is the same as selecting the first device.  If
    only one device is enabled when PLplot is installed, plstar will issue
    no prompt.	The output device is divided into nx by ny subpages, each
    of which may be used independently.  The subroutine pladv is used to
    advance from one subpage to the next. 

    Redacted form: plstar(nx, ny)

    This function is used in example 1. 



SYNOPSIS:

plstar(nx, ny)

ARGUMENTS:

    nx (PLINT, input) :    Number of subpages to divide output page in the
    horizontal direction. 

    ny (PLINT, input) :    Number of subpages to divide output page in the
    vertical direction. 
")
plstar;

%feature( "docstring", "Initialization 

DESCRIPTION:

    Alternative to plstar for initializing the plotting package.  The
    device name keyword for the desired output device must be supplied as
    an argument.  The device keywords are the same as those printed out by
    plstar.  If the requested device is not available, or if the input
    string is empty or begins with ``?'', the prompted startup of plstar
    is used.  This routine also divides the output device into nx by ny
    subpages, each of which may be used independently.	The subroutine
    pladv is used to advance from one subpage to the next. 

    Redacted form:  General: plstart(device, nx, ny)
	    Perl/PDL: plstart(nx, ny, device)


    This function is not used in any examples. 



SYNOPSIS:

plstart(device, nx, ny)

ARGUMENTS:

    device (const char *, input) :    Device name (keyword) of the
    required output device.  If NULL or if the first character is a
    ``?'', the normal (prompted) startup is used. 

    nx (PLINT, input) :    Number of subpages to divide output page in the
    horizontal direction. 

    ny (PLINT, input) :    Number of subpages to divide output page in the
    vertical direction. 
")
plstart;

%feature( "docstring", "Set a global coordinate transform function 

DESCRIPTION:

    This function can be used to define a coordinate transformation which
    affects all elements drawn within the current plot window.	The
    transformation function is similar to that provided for the plmap and
    plmeridians functions.  The data parameter may be used to pass extra
    data to transform_fun. 

    Redacted form:  General: plstransform(transform_fun, data)


    This function is used in example 19. 



SYNOPSIS:

plstransform(transform_fun, data)

ARGUMENTS:

    transform_fun (void (*) (PLFLT, PLFLT, PLFLT*, PLFLT*, PLPointer) ,
    input) :    Pointer to a function that defines a transformation
    from the input (x, y) coordinate to a new plot world coordiante. 

    data (PLPointer, input) :     Optional extra data for 
    transform_fun. 
")
plstransform;

%feature( "docstring", "Add a point to a stripchart 

DESCRIPTION:

    Add a point to a given pen of a given stripchart. There is no need for
    all pens to have the same number of points or to be equally sampled in
    the x coordinate. Allocates memory and rescales as necessary. 

    Redacted form: plstripa(id, p, x, y)

    This function is used in example 17. 



SYNOPSIS:

plstripa(id, p, x, y)

ARGUMENTS:

    id (PLINT, input) :    Identification number (set up in plstripc) of
    the stripchart. 

    p (PLINT, input) :      Pen number (ranges from 0 to 3). 

    x (PLFLT, input) :      X coordinate of point to plot. 

    y (PLFLT, input) :      Y coordinate of point to plot. 
")
plstripa;

%feature( "docstring", "Create a 4-pen stripchart 

DESCRIPTION:

    Create a 4-pen stripchart, to be used afterwards by plstripa

    Redacted form:  General: plstripc(id, xspec, yspec, xmin, xmax, xjump,
    ymin, ymax, xlpos, ylpos, y_ascl, acc, colbox, collab, colline,
    styline, legline, labx, laby, labz)
	    Perl/PDL: plstripc(xmin, xmax, xjump, ymin, ymax, xlpos,
    ylpos, y_ascl, acc, colbox, collab, colline, styline, id, xspec,
    ypsec, legline, labx, laby, labtop)


    This function is used in example 17. 



SYNOPSIS:

plstripc(id, xspec, yspec, xmin, xmax, xjump, ymin, ymax, xlpos, ylpos, y_ascl, acc, colbox, collab, colline, styline, legline[], labx, laby, labtop)

ARGUMENTS:

    id (PLINT *, output) :    Identification number of stripchart to use
    on plstripa and plstripd. 

    xspec (char *, input) :    X-axis specification as in plbox. 

    yspec (char *, input) :    Y-axis specification as in plbox. 

    xmin (PLFLT, input) :    Initial coordinates of plot box; they will
    change as data are added. 

    xmax (PLFLT, input) :    Initial coordinates of plot box; they will
    change as data are added. 

    xjump (PLFLT, input) :    When x attains xmax, the length of the plot
    is multiplied by the factor (1 + 
    xjump). 

    ymin (PLFLT, input) :    Initial coordinates of plot box; they will
    change as data are added. 

    ymax (PLFLT, input) :    Initial coordinates of plot box; they will
    change as data are added. 

    xlpos (PLFLT, input) :    X legend box position (range from 0 to 1). 

    ylpos (PLFLT, input) :    Y legend box position (range from 0 to 1). 

    y_ascl (PLBOOL, input) :    Autoscale y between x jumps if y_ascl is
    true, otherwise not. 

    acc (PLBOOL, input) :    Accumulate strip plot if acc is true,
    otherwise slide display. 

    colbox (PLINT, input) :    Plot box color index (cmap0). 

    collab (PLINT, input) :    Legend color index (cmap0). 

    colline (PLINT *, input) :      Pointer to array with color indices
    (cmap0) for the 4 pens. 

    styline (PLINT *, input) :      Pointer to array with line styles for
    the 4 pens. 

    legline (char **, input) :      Pointer to character array containing
    legends for the 4 pens. 

    labx (char *, input) :    X-axis label. 

    laby (char *, input) :    Y-axis label. 

    labtop (char *, input) :    Plot title. 
")
plstripc;

%feature( "docstring", "Deletes and releases memory used by a stripchart 

DESCRIPTION:

    Deletes and releases memory used by a stripchart. 

    Redacted form: plstripd(id)

    This function is used in example 17. 



SYNOPSIS:

plstripd(id)

ARGUMENTS:

    id (PLINT, input) :    Identification number of stripchart to delete. 
")
plstripd;

%feature( "docstring", "Set line style 

DESCRIPTION:

    This sets up the line style for all lines subsequently drawn.  A line
    consists of segments in which the pen is alternately down and up. The
    lengths of these segments are passed in the arrays mark and space
    respectively.  The number of mark-space pairs is specified by nels. 
    In order to return the line style to the default continuous line,
    plstyl should be called with nels=0.(see also pllsty) 

    Redacted form: plstyl(mark, space)

    This function is used in examples 1,9,14. 



SYNOPSIS:

plstyl(nels, mark, space)

ARGUMENTS:

    nels (PLINT, input) :    The number of mark and space elements in a
    line.  Thus a simple broken line can be obtained by setting
    nels=1.  A continuous line is specified by setting nels=0. 

    mark (PLINT *, input) :    Pointer to array with the lengths of the
    segments during which the pen is down, measured in micrometers. 

    space (PLINT *, input) :    Pointer to array with the lengths of the
    segments during which the pen is up, measured in micrometers. 
")
plstyl;

%feature( "docstring", "Plot shaded 3-d surface plot 

DESCRIPTION:

    Plots a three dimensional shaded surface plot within the environment
    set up by plw3d.  The surface is defined by the two-dimensional array
    z[
    nx][
    ny], the point z[i][j] being the value of the function at (
    x[i], 
    y[j]).  Note that the points in arrays x and y do not need to be
    equally spaced, but must be stored in ascending order. For further
    details see the PLplot documentation. 

    Redacted form: plsurf3d(x, y, z, opt, clevel)

    This function is not used in any examples. 



SYNOPSIS:

plsurf3d(x, y, z, nx, ny, opt, clevel, nlevel)

ARGUMENTS:

    x (PLFLT *, input) :    Pointer to set of x coordinate values at which
    the function is evaluated. 

    y (PLFLT *, input) :    Pointer to set of y coordinate values at which
    the function is evaluated. 

    z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
    with set of function values. 

    nx (PLINT, input) :    Number of x values at which function is
    evaluated. 

    ny (PLINT, input) :    Number of y values at which function is
    evaluated. 

    opt (PLINT, input) :    Determines the way in which the surface is
    represented. To specify more than one option just add the options,
    e.g. FACETED + SURF_CONT opt=FACETED: Network of lines is drawn
    connecting points at which function is defined. 
        opt=BASE_CONT: A contour plot is drawn at the base XY plane
        using parameters 
    nlevel and 
    clevel. 
        opt=SURF_CONT: A contour plot is drawn at the surface plane
        using parameters 
    nlevel and 
    clevel. 
        opt=DRAW_SIDES: draws a curtain between the base XY plane and
        the borders of the plotted function. 
        opt=MAG_COLOR: the surface is colored according to the value
        of Z; if MAG_COLOR is not used, then the default the surface
        is colored according to the intensity of the reflected light
        in the surface from a light source whose position is set using
        pllightsource. 


    clevel (PLFLT *, input) :     Pointer to the array that defines the
    contour level spacing. 

    nlevel (PLINT, input) :    Number of elements in the clevel array. 
")
plsurf3d;

%feature( "docstring", "Plot shaded 3-d surface plot 

DESCRIPTION:

    Plots a three dimensional shaded surface plot within the environment
    set up by plw3d. The surface is defined by the data contained in the
    2D	PLFLT ** matrix or the PLfGrid2 structure zp. How the data in  zp
    is rendered is determined by the  zops parameter. zops is a pointer to
    a function that reads the data out of the grid structure. The
    following functions in PLplot core will return an appropriate function
    pointer:  plf2ops_c() (use when  zp is of type  PLFLT **),
    plf2ops_grid_c() (use when	zp is a pointer to a row-major PLfGrid2
    structure),  plf2ops_grid_row_major() (same as plf2ops_grid_c()?) and 
    plf2ops_grid_col_major() (use when zp is a pointer to a  column-major
    PLfGrid2 structure).  nx, nyoptclevel and nlevel are the same as in
    for example plsurf3d. 

    Redacted form? plfsurf3d(x, y, zops, zp, opt, clevel)

    This function is used in example 8. 



SYNOPSIS:

plsurf3d(x, y, zops, zp, nx, ny, opt, clevel, nlevel)

ARGUMENTS:

    x (PLFLT *, input) :    Pointer to set of x coordinate values at which
    the function is evaluated. 

    y (PLFLT *, input) :    Pointer to set of y coordinate values at which
    the function is evaluated. 

    zops (void (*) (?), input) :    Pointer to a function for processing
    the data contained in zp. 

    zp (PLFLT ** or PLfGrid2 *, input) :    Pointer to the data to be
    plotted, either as a vectored  two-dimensional array with set of
    function values, or as PLfGrid2 structure. 

    nx (PLINT, input) :    Number of x values at which function is
    evaluated. 

    ny (PLINT, input) :    Number of y values at which function is
    evaluated. 

    opt (PLINT, input) :    Determines the way in which the surface is
    represented. To specify more than one option just add the options,
    e.g. FACETED + SURF_CONT opt=FACETED: Network of lines is drawn
    connecting points at which function is defined. 
        opt=BASE_CONT: A contour plot is drawn at the base XY plane
        using parameters 
    nlevel and 
    clevel. 
        opt=SURF_CONT: A contour plot is drawn at the surface plane
        using parameters 
    nlevel and 
    clevel. 
        opt=DRAW_SIDES: draws a curtain between the base XY plane and
        the borders of the plotted function. 
        opt=MAG_COLOR: the surface is colored according to the value
        of Z; if MAG_COLOR is not used, then the default the surface
        is colored according to the intensity of the reflected light
        in the surface from a light source whose position is set using
        pllightsource. 


    clevel (PLFLT *, input) :     Pointer to the array that defines the
    contour level spacing. 

    nlevel (PLINT, input) :    Number of elements in the clevel array. 
")
plfsurf3d;

%feature( "docstring", "Set arrow style for vector plots 

DESCRIPTION:

    Set the style for the arrow used by plvect to plot vectors. 

    Redacted form: plsvect(arrowx, arrowy, fill)

    This function is used in example 22. 



SYNOPSIS:

plsvect(arrowx, arrowy, npts, fill)

ARGUMENTS:

    arrowx, arrowy (PLFLT *,input) :    Pointers to a pair of arrays
    containing the x and y points which make up the arrow. The arrow
    is plotted by joining these points to form a polygon. The scaling
    assumes that the x and y points in the arrow lie in the range -0.5
    <= x,y <= 0.5. 

    npts (PLINT,input) :    Number of points in the arrays arrowx and
    arrowy. 

    fill (PLBOOL,input) :    If fill is true then the arrow is closed, if
    fill is false then the arrow is open. 
")
plsvect;

%feature( "docstring", "Specify viewport in absolute coordinates 

DESCRIPTION:

    Alternate routine to plvpor for setting up the viewport.  This routine
    should be used only if the viewport is required to have a definite
    size in millimeters.  The routine plgspa is useful for finding out the
    size of the current subpage. 

    Redacted form: plsvpa(xmin, xmax, ymin, ymax)

    This function is used in example 10. 



SYNOPSIS:

plsvpa(xmin, xmax, ymin, ymax)

ARGUMENTS:

    xmin (PLFLT, input) :    The distance of the left-hand edge of the
    viewport from the left-hand edge of the subpage in millimeters. 

    xmax (PLFLT, input) :    The distance of the right-hand edge of the
    viewport from the left-hand edge of the subpage in millimeters. 

    ymin (PLFLT, input) :    The distance of the bottom edge of the
    viewport from the bottom edge of the subpage in millimeters. 

    ymax (PLFLT, input) :    The distance of the top edge of the viewport
    from the bottom edge of the subpage in millimeters. 
")
plsvpa;

%feature( "docstring", "Set x axis parameters 

DESCRIPTION:

    Sets values of the digmax and digits flags for the x axis.	See the
    PLplot documentation for more information. 

    Redacted form: plsxax(digmax, digits)

    This function is used in example 31. 



SYNOPSIS:

plsxax(digmax, digits)

ARGUMENTS:

    digmax (PLINT, input) :    Variable to set the maximum number of
    digits for the x axis.    If nonzero, the printed label will be
    switched to a floating point representation when the number of
    digits exceeds digmax. 

    digits (PLINT, input) :    Field digits value.  Currently, changing
    its value here has no effect since it is set only by plbox or
    plbox3.  However, the user may obtain its value after a call to
    either of these functions by calling plgxax. 
")
plsxax;

%feature( "docstring", "Set y axis parameters 

DESCRIPTION:

    Identical to plsxax, except that arguments are flags for y axis. See
    the description of plsxax for more detail. 

    Redacted form: plsyax(digmax, digits)

    This function is used in examples 1,14,31. 



SYNOPSIS:

plsyax(digmax, digits)

ARGUMENTS:

    digmax (PLINT, input) :    Variable to set the maximum number of
    digits for the y axis.    If nonzero, the printed label will be
    switched to a floating point representation when the number of
    digits exceeds digmax. 

    digits (PLINT, input) :    Field digits value.  Currently, changing
    its value here has no effect since it is set only by plbox or
    plbox3.  However, the user may obtain its value after a call to
    either of these functions by calling plgyax. 
")
plsyax;

%feature( "docstring", "Plots a symbol at the specified points 

DESCRIPTION:

    Marks out a set of n points at positions (
    x[i], 
    y[i]), using the symbol defined by code.  The code is interpreted as
    an index in the Hershey font tables. 

    Redacted form: plsym(x, y, code)

    This function is used in example 7. 



SYNOPSIS:

plsym(n, x, y, code)

ARGUMENTS:

    n (PLINT, input) :      Number of points to be marked. 

    x (PLFLT *, input) :    Pointer to array with set of x coordinate
    values for the points. 

    y (PLFLT *, input) :    Pointer to array with set of y coordinate
    values for the points. 

    code (PLINT, input) :    Code number for the symbol to be plotted. 
")
plsym;

%feature( "docstring", "Set z axis parameters 

DESCRIPTION:

    Identical to plsxax, except that arguments are flags for z axis. See
    the description of plsxax for more detail. 

    Redacted form: plszax(digmax, digits)

    This function is used in example 31. 



SYNOPSIS:

plszax(digmax, digits)

ARGUMENTS:

    digmax (PLINT, input) :    Variable to set the maximum number of
    digits for the z axis.    If nonzero, the printed label will be
    switched to a floating point representation when the number of
    digits exceeds digmax. 

    digits (PLINT, input) :    Field digits value.  Currently, changing
    its value here has no effect since it is set only by plbox or
    plbox3.  However, the user may obtain its value after a call to
    either of these functions by calling plgzax. 
")
plszax;

%feature( "docstring", "Switch to text screen 

DESCRIPTION:

    Sets an interactive device to text mode, used in conjunction with
    plgra to allow graphics and text to be interspersed.  On a device
    which supports separate text and graphics windows, this command causes
    control to be switched to the text window.	This can be useful for
    printing diagnostic messages or getting user input, which would
    otherwise interfere with the plots.  The program must switch back to
    the graphics window before issuing plot commands, as the text (or
    console) device will probably become quite confused otherwise.  If
    already in text mode, this command is ignored.  It is also ignored on
    devices which only support a single window or use a different method
    for shifting focus (see also plgra). 

    Redacted form: pltext()

    This function is used in example 1. 



SYNOPSIS:

pltext()
")
pltext;

%feature( "docstring", "Set format for date / time labels 

DESCRIPTION:

    Sets the format for date / time labels. To enable date / time format
    labels see the options to plbox and plenv.	

    Redacted form: pltimefmt(fmt)

    This function is used in example 29. 



SYNOPSIS:

pltimefmt(fmt)

ARGUMENTS:

    fmt (const char *, fmt) :     This string is passed directly to the
    system strftime. See the system documentation for a full list of
    conversion specifications for your system. All conversion
    specifications take the form of a '%' character followed by
    further conversion specification character. All other text is
    printed as-is. Common options include: %c: The preferred date and
    time representation for the current locale.  
        %d: The day of the month as a decimal number.  
        %H: The hour as a decimal number using a 24-hour clock.  
        %j: The day of the year as a decimal number.  
        %m: The month as a decimal number.    
        %M: The minute as a decimal number.  
        %S: The second as a decimal number.  
        %y: The year as a decimal number without a century.  
        %Y: The year  as a decimal number including a century.  
")
pltimefmt;

%feature( "docstring", "Specify viewport using aspect ratio only 

DESCRIPTION:

    Sets the viewport so that the ratio of the length of the y axis to
    that of the x axis is equal to aspect. 

    Redacted form: plvasp(aspect)

    This function is used in example 13. 



SYNOPSIS:

plvasp(aspect)

ARGUMENTS:

    aspect (PLFLT, input) :    Ratio of length of y axis to length of x
    axis. 
")
plvasp;

%feature( "docstring", "Vector plot 

DESCRIPTION:

    Draws a vector plot of the vector (
    u[
    nx][
    ny],
    v[
    nx][
    ny]). The scaling factor for the vectors is given by scale. A
    transformation routine pointed to by pltr with a pointer pltr_data for
    additional data required by the transformation routine is used to map
    indices within the array to the world coordinates. The style of the
    vector arrow may be set using plsvect. 

    Redacted form: plvect(u, v, scale, pltr, pltr_data)

    This function is used in example 22. 



SYNOPSIS:

plvect(u, v, nx, ny, scale, pltr, pltr_data)

ARGUMENTS:

    u, v (PLFLT **, input) :    Pointers to a pair of vectored
    two-dimensional arrays containing the x and y components of the
    vector data to be plotted. 

    nx, ny (PLINT, input) :    Physical dimensions of the arrays u and v. 

    scale (PLFLT, input) :    Parameter to control the scaling factor of
    the vectors for plotting. If scale = 0 then the scaling factor is
    automatically calculated for the data. If scale < 0 then the
    scaling factor is automatically calculated for the data and then
    multiplied by -
    scale. If scale > 0 then the scaling factor is set to scale. 

    pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
      Pointer to function that defines transformation between indices
    in array z and the world coordinates (C only).    Transformation
    functions are provided in the PLplot library: pltr0 for identity
    mapping, and pltr1 and pltr2 for arbitrary mappings respectively
    defined by one- and two-dimensional arrays.  In addition,
    user-supplied routines for the transformation can be used as well.
     Examples of all of these approaches are given in the PLplot
    documentation. The transformation function should have the form
    given by any of pltr0, pltr1, or pltr2. 

    pltr_data (PLPointer, input) :    Extra parameter to help pass
    information to pltr0, pltr1, pltr2, or whatever routine that is
    externally supplied. 
")
plvect;

%feature( "docstring", "Specify viewport using coordinates and aspect ratio 

DESCRIPTION:

    Device-independent routine for setting up the viewport.  The viewport
    is chosen to be the largest with the given aspect ratio that fits
    within the specified region (in terms of normalized subpage
    coordinates).  This routine is functionally equivalent to plvpor when
    a ``natural'' aspect ratio (0.0) is chosen.  Unlike plvasp, this
    routine reserves no extra space at the edges for labels. 

    Redacted form: plvpas(xmin, xmax, ymin, ymax, aspect)

    This function is used in example 9. 



SYNOPSIS:

plvpas(xmin, xmax, ymin, ymax, aspect)

ARGUMENTS:

    xmin (PLFLT, input) :    The normalized subpage coordinate of the
    left-hand edge of the viewport. 

    xmax (PLFLT, input) :    The normalized subpage coordinate of the
    right-hand edge of the viewport. 

    ymin (PLFLT, input) :    The normalized subpage coordinate of the
    bottom edge of the viewport. 

    ymax (PLFLT, input) :    The normalized subpage coordinate of the top
    edge of the viewport. 

    aspect (PLFLT, input) :    Ratio of length of y axis to length of x
    axis. 
")
plvpas;

%feature( "docstring", "Specify viewport using coordinates 

DESCRIPTION:

    Device-independent routine for setting up the viewport.  This defines
    the viewport in terms of normalized subpage coordinates which run from
    0.0 to 1.0 (left to right and bottom to top) along each edge of the
    current subpage.  Use the alternate routine plsvpa in order to create
    a viewport of a definite size. 

    Redacted form: plvpor(xmin, xmax, ymin, ymax)

    This function is used in examples
    2,6-8,10,11,15,16,18,21,23,24,26,27,31. 



SYNOPSIS:

plvpor(xmin, xmax, ymin, ymax)

ARGUMENTS:

    xmin (PLFLT, input) :    The normalized subpage coordinate of the
    left-hand edge of the viewport. 

    xmax (PLFLT, input) :    The normalized subpage coordinate of the
    right-hand edge of the viewport. 

    ymin (PLFLT, input) :    The normalized subpage coordinate of the
    bottom edge of the viewport. 

    ymax (PLFLT, input) :    The normalized subpage coordinate of the top
    edge of the viewport. 
")
plvpor;

%feature( "docstring", "Select standard viewport 

DESCRIPTION:

    Sets up a standard viewport, leaving a left-hand margin of seven
    character heights, and four character heights around the other three
    sides. 

    Redacted form: plvsta()

    This function is used in examples 1,12,14,17,25,29. 



SYNOPSIS:

plvsta()
")
plvsta;

%feature( "docstring", "Set up window for 3-d plotting 

DESCRIPTION:

    Sets up a window for a three-dimensional surface plot within the
    currently defined two-dimensional window.  The enclosing box for the
    surface plot defined by xmin, xmax, ymin, ymax, zmin and zmax in
    user-coordinate space is mapped into a box of world coordinate size
    basex by basey by height so that xmin maps to -
    basex/2, xmax maps to basex/2, ymin maps to -
    basey/2, ymax maps to basey/2, zmin maps to 0 and zmax maps to height.
     The resulting world-coordinate box is then viewed by an observer at
    altitude alt and azimuth az.  This routine must be called before
    plbox3 or plot3d.  For a more complete description of
    three-dimensional plotting see the PLplot documentation. 

    Redacted form: plw3d(basex, basey, height, xmin, xmax, ymin, ymax,
    zmin, zmax, alt, az)

    This function is examples 8,11,18,21. 



SYNOPSIS:

plw3d(basex, basey, height, xmin, xmax, ymin, ymax, zmin, zmax, alt, az)

ARGUMENTS:

    basex (PLFLT, input) :    The x coordinate size of the
    world-coordinate box. 

    basey (PLFLT, input) :    The y coordinate size of the
    world-coordinate box. 

    height (PLFLT, input) :    The z coordinate size of the
    world-coordinate box. 

    xmin (PLFLT, input) :    The minimum user x coordinate value. 

    xmax (PLFLT, input) :    The maximum user x coordinate value. 

    ymin (PLFLT, input) :    The minimum user y coordinate value. 

    ymax (PLFLT, input) :    The maximum user y coordinate value. 

    zmin (PLFLT, input) :    The minimum user z coordinate value. 

    zmax (PLFLT, input) :    The maximum user z coordinate value. 

    alt (PLFLT, input) :    The viewing altitude in degrees above the XY
    plane. 

    az (PLFLT, input) :    The viewing azimuth in degrees.  When az=0, the
    observer is looking face onto the ZX plane, and as az is
    increased, the observer moves clockwise around the box when viewed
    from above the XY plane. 
")
plw3d;

%feature( "docstring", "Set pen width 

DESCRIPTION:

    Sets the pen width. 

    Redacted form: plwid(width)

    This function is used in examples 1,2. 



SYNOPSIS:

plwid(width)

ARGUMENTS:

    width (PLINT, input) :    The desired pen width.  If width is negative
    or the same as the previous value no action is taken. width = 0
    should be interpreted as as the minimum valid pen width for the
    device.  The interpretation of positive width values is also
    device dependent. 
")
plwid;

%feature( "docstring", "Specify world coordinates of viewport boundaries 

DESCRIPTION:

    Sets up the world coordinates of the edges of the viewport. 

    Redacted form: plwind(xmin, xmax, ymin, ymax)

    This function is used in examples 1,2,4,6-12,14-16,18,21,23-27,29,31. 



SYNOPSIS:

plwind(xmin, xmax, ymin, ymax)

ARGUMENTS:

    xmin (PLFLT, input) :    The world x coordinate of the left-hand edge
    of the viewport. 

    xmax (PLFLT, input) :    The world x coordinate of the right-hand edge
    of the viewport. 

    ymin (PLFLT, input) :    The world y coordinate of the bottom edge of
    the viewport. 

    ymax (PLFLT, input) :    The world y coordinate of the top edge of the
    viewport. 
")
plwind;

%feature( "docstring", "Enter or leave xor mode 

DESCRIPTION:

    Enter (when mode is true)  or leave (when mode is false) xor mode for
    those drivers (e.g., the xwin driver) that support it.  Enables
    erasing plots by drawing twice the same line, symbol, etc.	If driver
    is not capable of xor operation it returns a status of false. 

    Redacted form: plxormod(mode, status)

    This function is used in examples 1,20. 



SYNOPSIS:

plxormod(mode, status)

ARGUMENTS:

    mode (PLBOOL, input) :    mode is true means enter xor mode and  mode
    is false means leave xor mode. 

    status (PLBOOL *, output) :    Pointer to status. Returned    modestatus
    of true (false) means driver is capable (incapable) of xor mode. 
")
plxormod;

