/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file frame.hpp
 * \brief A frame: a box with a border and a background.
 * \author Julien Jorge
 */
#ifndef __GUI_FRAME_HPP__
#define __GUI_FRAME_HPP__

#include "gui/visual_component.hpp"
#include "visual/sprite.hpp"

#include "gui/class_export.hpp"

namespace bear
{
  namespace gui
  {
    /**
     * \brief A frame: a box with a border and a background.
     * \author Julien Jorge
     */
    class GUI_EXPORT frame:
      public visual_component
    {
    public:
      frame( visual_component* owner, visual::sprite* corner,
             visual::sprite* h_border, visual::sprite* v_border,
             visual::sprite* background );
      ~frame();

      void set_background_alpha( double alpha );

    private:
      void on_resized();
      void display( scene_element_list& e ) const;

      void display_background( scene_element_list& e ) const;
      void display_horizontal_borders( scene_element_list& e ) const;
      void display_vertical_borders( scene_element_list& e ) const;
      void display_corners( scene_element_list& e ) const;

      unsigned int corner_width() const;
      unsigned int corner_height() const;

    private:
      /** \brief The sprite used to draw corners. */
      const visual::sprite* m_corner;

      /** \brief The sprite used to draw the horizontal borders. */
      visual::sprite* m_horizontal_border;

      /** \brief The sprite used to draw the vertical borders. */
      visual::sprite* m_vertical_border;

      /** \brief The sprite used to draw the background. */
      visual::sprite* m_background;

      /** \brief The width (height) of the vertical (horizontal) borders. */
      const claw::math::coordinate_2d<unsigned int> m_border_size;

    }; // class frame
  } // namespace gui
} // namespace bear

#endif // __GUI_FRAME_HPP__
