###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_gupnp_detect.nasl 3104 2009-06-24 14:40:29Z jun $
#
# GUPnP Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900681);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("GUPnP Version Detection");
  desc = "

  Overview: The script detects the installed version of GUPnP and sets the
  reuslt into KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Check for GUPnP version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

gupnpPaths = find_file(file_name:"config.status", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach gupnpBin (gupnpPaths)
{
  gupnpVer = get_bin_version(full_prog_name:chomp(gupnpBin), sock:sock,
                             version_argv:"--version",
                             ver_pattern:"gupnp config.status ([0-9.]+)");
  if(gupnpVer[1] != NULL){
    set_kb_item(name:"GUPnP/Ver", value:gupnpVer[1]);
    security_note(data:"GUPnP version " + gupnpVer[1] +
            " running at location " + gupnpBin + " was detected on the host");
  }
}
ssh_close_connection();
