###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_axon_virtual_pbx_detect.nasl 5849 2009-11-24 15:04:22Z nov $
#
# Axon Virtual PBX Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900983);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Axon Virtual PBX Version Detection");
  desc = "
  Overview: This script detects the installed version of Axon Virtual PBX
  and sets the reuslt in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Axon Virtual PBX");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_keys("Services/udp/sip");
  script_require_ports("Services/www", 81);
  exit(0);
}


include("sip.inc");
include("http_func.inc");
include("version_func.inc");

# Check for Axon Virtual PBX on SIP port 5060
axonPort = get_kb_item("Services/udp/sip");
if(!axonPort){
  axonPort = 5060;
}

if(get_udp_port_state(axonPort))
{
  banner = get_sip_banner(port:axonPort);
  if("Axon Virtual PBX" >< banner)
  {
    axonVer = eregmatch(pattern:"Axon Virtual PBX ([0-9.]+)", string:banner);
    if(axonVer[1] == NULL)
    {
      # Check for Axon Virtual PBX on HTTP port 81
      axonPort = get_http_port(default:81);
      if(!axonPort){
        axonPort = 81;
      }

      banner = get_http_banner(port:axonPort);
      if(("NCH Software" >< banner) && ("Axon" >< banner)){
        axonVer = eregmatch(pattern:"v&.+([0-9]\.[0-9]+)", string:banner);
      }
    }
  }
  if(axonVer[1] != NULL){
    set_kb_item(name:"Axon-Virtual-PBX/Ver", value:axonVer[1]);
    security_note(data:"Axon Virtual PBX version " + axonVer[1] +
                                           " was detected on the host");
  }
}
