###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_avahi_detection_lin.nasl 709 2008-12-25 17:40:29Z dec $
#
# Avahi Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900416);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Avahi Version Detection (Linux)");
  desc = "

  Overview: The script detects the version of Avahi Daemon on remote host and
  sets the KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Check for Avahi Daemon version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

avahiName = find_file(file_name:"avahi-daemon", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
foreach binaryName (avahiName)
{
  binaryName = chomp(binaryName);
  avahiVer = get_bin_version(full_prog_name:binaryName, version_argv:"--version",
                              ver_pattern:"[0-9]\.[0-9.]+", sock:sock);
  if(avahiVer[0] != NULL)
  {
    set_kb_item(name:"Avahi/Linux/Ver", value:avahiVer[0]);
    security_note(data:"Avahi Version " + avahiVer[0] + 
        " running at location " + binaryName + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
