# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:030 (amarok)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63283);
 script_cve_id("CVE-2009-0135", "CVE-2009-0136");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Mandrake Security Advisory MDVSA-2009:030 (amarok)";
 script_name(name);

 desc = "The remote host is missing an update to amarok
announced via advisory MDVSA-2009:030.

Data length values in metadata Audible Audio media file (.aa) can lead
to an integer overflow enabling remote attackers use it to trigger an
heap overflow and enabling the possibility to execute arbitrary code
(CVE-2009-0135).

Failure on checking heap allocation on Audible Audio media files
(.aa) allows remote attackers either to cause denial of service or
execute arbitrary code via a crafted media file (CVE-2009-0136).

This update provide the fix for these security issues.

Affected: 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:030

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:030 (amarok)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-engine-void", rpm:"amarok-engine-void~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-engine-xine", rpm:"amarok-engine-xine~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-engine-yauap", rpm:"amarok-engine-yauap~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-scripts", rpm:"amarok-scripts~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarok0", rpm:"libamarok0~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarok0-scripts", rpm:"libamarok0-scripts~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarok-devel", rpm:"libamarok-devel~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarok-scripts-devel", rpm:"libamarok-scripts-devel~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarok0", rpm:"lib64amarok0~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarok0-scripts", rpm:"lib64amarok0-scripts~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarok-devel", rpm:"lib64amarok-devel~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarok-scripts-devel", rpm:"lib64amarok-scripts-devel~1.4.8~12.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok", rpm:"amarok~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-scripts", rpm:"amarok-scripts~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarok-devel", rpm:"libamarok-devel~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamaroklib1", rpm:"libamaroklib1~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarokplasma2", rpm:"libamarokplasma2~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarokpud1", rpm:"libamarokpud1~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libamarok_taglib1", rpm:"libamarok_taglib1~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarok-devel", rpm:"lib64amarok-devel~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amaroklib1", rpm:"lib64amaroklib1~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarokplasma2", rpm:"lib64amarokplasma2~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarokpud1", rpm:"lib64amarokpud1~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64amarok_taglib1", rpm:"lib64amarok_taglib1~2.0~1.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
