###############################################################################
# OpenVAS Vulnerability Test
# $Id: invision_power_board_detect.nasl 7515 2010-05-04 08:18:47Z chandra $
#
# IP.Board Detection
#
# Authors:
# Michael Meyer
#
# Updated to include upload directory and set multiple versions.
#  - By Nikita MR <rnikita@secpod.com> on 2009-11-20 15:25:02Z
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# Updated to detect IPB versions 2.3.3 and 2.3.5
#   -By Sharath S <sharaths@secpod.com> on 2009-04-09
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This host is running IP.Board, an outstanding bulletin board system.

 See also:
  http://www.invisionpower.com/community/board/

 Risk factor : None";

if (description)
{
  script_id(100107);
  script_version ("1.2");
  script_tag(name:"risk_factor", value:"None");

  script_name("IP.Board Detection");

  script_description(desc);
  script_summary("Checks for the presence of IP.Board");
  script_category(ACT_GATHER_INFO);
  script_family("Service detection");
  script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
  script_dependencie("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  script_exclude_keys("Settings/disable_cgi_scanning");
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

if(!can_host_php(port:port)){
  exit(0);
}

dirs = make_list("/forum","/board","/ipb","/community", "/", cgi_dirs());
foreach mdir (dirs)
{
  foreach dir (make_list("/", "/upload/"))
  {
    url = string(mdir, dir, "index.php");
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);

    if("</html>" >!< buf)
    {
      req = string("GET ", mdir, dir, "index.php", "\r\n",
                   "Host: ", get_host_name(), "\r\n\r\n");
      buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    }

    if(egrep(pattern:"Powered [Bb]y (<a [^>]+>)?(Invision Power Board|IP.Board)",
             string: buf, icase: TRUE) )
    {
      if(strlen(mdir) > 0){
        install=mdir;
      }
      else{
        install=string("/");
      }

      vers = string("unknown");

      ### try to get version
      version = eregmatch(pattern:"v*([0-9.]+[a-zA-Z ]*) &copy;.*[0-9]{4}.*IPS.*",
                          string:buf, icase:TRUE);

      if(!isnull(version[1])){
        vers=version[1];
      }

      set_kb_item(name:string("www/", port, "/invision_power_board"),
                  value:string(vers," under ",install));

      info = string("None\n\nIP.Board Version '");
      info += string(vers);
      info += string("' was detected on the remote host in the following" +
                     " directory(s):\n\n");
      info += string(install, "\n");

      desc = ereg_replace(string:desc, pattern:"None$", replace:info);
      if(report_verbosity > 0){
        security_note(port:port,data:desc);
      }
    }
  }
}
