###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_lussumo_vanilla_detect.nasl 2613 1065 2009-06-04 16:25:36Z june $
#
# Vanilla Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c)2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800622);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Vanilla Version Detection");
  desc = "

  Overview: This script finds the installed Vanilla version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the Version of Vanilla in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

vanillaPort = get_http_port(default:80);
if(!vanillaPort){
  exit(0);
}

foreach path (make_list("/", "/Vanilla117", "/Vanilla118", "/Vanilla113rc1", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:vanillaPort);
  rcvRes = http_send_recv(port:vanillaPort, data:sndReq);
  if("Vanilla" >< rcvRes)
  {
    vanillaVer = eregmatch(pattern:">Vanilla ([0-9.a-z]+)",
                           string:rcvRes);
    if(vanillaVer[1] != NULL)
    {
      set_kb_item(name:"www/" + vanillaPort + "/Lussumo/Vanilla",
                  value:vanillaVer[1] + " under " + path);
      security_note(data:"Vanilla version " + vanillaVer[1] + " running at location "
                          + path + " was detected on the host");
    }
  }
}
