###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Java HPSBUX02503
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835225);
  script_version("$Revision: 8164 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "HPSBUX", value: "02503");
  script_cve_id("CVE-2009-3867", "CVE-2009-3868", "CVE-2009-3869", "CVE-2009-3871", "CVE-2009-3872", "CVE-2009-3873", "CVE-2009-3874", "CVE-2009-3875", "CVE-2009-3876", "CVE-2009-3877");
  script_name("HP-UX Update for Java HPSBUX02503");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified in Java Runtime 
  Environment (JRE) and Java Developer Kit (JDK) running on HP-UX. These 
  vulnerabilities could allow remote unauthorized access, privilege 
  escalation, and Denial of Service (DoS) 

  Impact:
  Remote Increase in privilege
  Denial of Service and other vulnerabilities

  Affected Software/OS:
  Java on
  HP-UX B.11.11, B.11.23, B.11.31 running HP JDK and JRE 6.0.05 or earlier 
  HP-UX B.11.11, B.11.23, B.11.31 running HP JDK and JRE 5.0.18 or earlier 
  HP-UX B.11.11, B.11.23, B.11.31 running HP Java SDK and RTE 1.4.2.23 or 
  earlier 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01997760

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Java");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.24.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.19.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-COM", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32-HS", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64-HS", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20-HS", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W-HS", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-COM", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF32", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF64", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20W", revision:"1.6.0.06.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.24.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.19.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-COM", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32-HS", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64-HS", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20-HS", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W-HS", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-COM", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF32", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF64", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20W", revision:"1.6.0.06.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-COM", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA11-HS", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20-HS", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-PA20W-HS", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF32-HS", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre14.JRE14-IPF64-HS", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-COM", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF32", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-IPF64", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA11", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk14.JDK14-PA20W", revision:"1.4.2.24.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-COM", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20-HS", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-PA20W-HS", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF32-HS", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre15.JRE15-IPF64-HS", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-PA20W", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-COM", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF32", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk15.JDK15-IPF64", revision:"1.5.0.19.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-COM", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF32-HS", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-IPF64-HS", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20-HS", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jre60.JRE60-PA20W-HS", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-COM", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF32", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-IPF64", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Jdk60.JDK60-PA20W", revision:"1.6.0.06.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}