###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for VERITAS File System (VRTSvxfs) or VERITAS Oracle Disk Manager (VRTSodm) HPSBUX02409
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835196);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "02409");
  script_cve_id("CVE-2009-0207");
  script_name( "HP-UX Update for VERITAS File System (VRTSvxfs) or VERITAS Oracle Disk Manager (VRTSodm) HPSBUX02409");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  VRTSvxfs and VRTSodm. The vulnerability could be exploited locally to cause 
  an escalation of privilege. VRTSvxfs and VRTSodm are bundled with Storage 
  Management Suite (SMS) and Storage Management for Oracle (SMO). 

  Impact:
  Local escalation of privilege

  Affected Software/OS:
  VERITAS File System (VRTSvxfs) or VERITAS Oracle Disk Manager (VRTSodm) on
  HP-UX B.11.11 running VRTSodm 3.5 HP-UX B.11.23 running VRTSodm 4.1 or 
  VRTSvxfs 4.1 or both HP-UX B.11.23 running VRTSodm 5.0 or VRTSvxfs 5.0 or 
  both HP-UX B.11.31 running VRTSodm 5.0 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01674733-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of VERITAS File System (VRTSvxfs) or VERITAS Oracle Disk Manager (VRTSodm)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-KRN", patch_list:['PHCO_38913', 'PHCO_39132', 'PHKL_39130'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-RUN", patch_list:['PHCO_38913', 'PHCO_39132', 'PHKL_39130'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-MAN", patch_list:['PHCO_38913', 'PHCO_39132', 'PHKL_39130'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-RUN", patch_list:['PHCO_38913', 'PHCO_39132', 'PHKL_39130'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-KRN", patch_list:['PHCO_39027', 'PHKL_39029'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-RUN", patch_list:['PHCO_39027', 'PHKL_39029'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-MAN", patch_list:['PHCO_39027', 'PHKL_39029'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-RUN", patch_list:['PHCO_39027', 'PHKL_39029'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-RUN-PALIB", patch_list:['PHCO_39027', 'PHKL_39029'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-PRG", patch_list:['PHCO_39027', 'PHKL_39029'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-KRN", patch_list:['PHCO_39103', 'PHCO_39104', 'PHKL_38795'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-RUN", patch_list:['PHCO_39103', 'PHCO_39104', 'PHKL_38795'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSodm.ODM-MAN", patch_list:['PHCO_39103', 'PHCO_39104', 'PHKL_38795'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-RUN", patch_list:['PHCO_39103', 'PHCO_39104', 'PHKL_38795'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-RUN-PALIB", patch_list:['PHCO_39103', 'PHCO_39104', 'PHKL_38795'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-PRG", patch_list:['PHCO_39103', 'PHCO_39104', 'PHKL_38795'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"VRTSvxfs.VXFS-RUN", patch_list:['PHCO_39124'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
