###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gizmo5_detect_lin.nasl 3363 2009-07-09 20:38:29Z jul $
#
# Gizmo5 Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800832);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Gizmo5 Version Detection (Linux)");
  desc = "

  Overview: The script is detects the installed version of Gizmo5 and sets
  the version in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set the Version of Gizmo5 Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

gizmo_sock = ssh_login_or_reuse_connection();
if(!gizmo_sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:gizmo_sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m2";
garg[2] = "-a";
garg[3] = string("[0-9]\\+\\.[0-9]\\+\\.[0-9]\\+\\.[0-9]\\+");

gizmoName = find_bin(prog_name:"gizmo", sock:gizmo_sock);

if(gizmoName != NULL)
{
  foreach binaryName (gizmoName)
  {
    binaryName = chomp(binaryName);

    if(islocalhost())
    {
      garg[4] = binaryName;
      arg = garg;
    }
    else
    {
      arg = garg[0]+" "+garg[1]+" "+garg[2]+" "+
            raw_string(0x22)+garg[3]+raw_string(0x22)+" "+binaryName;
    }

    gizmoVer = get_bin_version(full_prog_name:grep, version_argv:arg,
                               sock:gizmo_sock,
                               ver_pattern:"([0-9]\.[0-9]\.[0-9]\.[0-9][0-9]?)");
    if(gizmoVer[1] != NULL)
    {
      set_kb_item(name:"Gizmo5/Linux/Ver", value:gizmoVer[1]);
      security_note(data:"Gizmo5 version " + gizmoVer[1] + " was detected on the host");
      break;
    }
  }
}
ssh_close_connection();
