###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ed FEDORA-2008-9263
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860492);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "FEDORA", value: "2008-9263");
  script_cve_id("CVE-2008-3916");
  script_name( "Fedora Update for ed FEDORA-2008-9263");
  desc = "

  Vulnerability Insight:
  Ed is a line-oriented text editor, used to create, display, and modify
  text files (both interactively and via shell scripts).  For most
  purposes, ed has been replaced in normal usage by full-screen editors
  (emacs and vi, for example).
  
  Ed was the original UNIX editor, and may be used by some programs.  In
  general, however, you probably don't need to install it and you probably
  won't use it.


  Affected Software/OS:
  ed on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00873.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ed");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"ed", rpm:"ed~1.1~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}