##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_roller_detect.nasl 3737 2009-08-07 18:57:24Z aug $
#
# Apache Roller Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800677);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Apache Roller Version Detection");
  desc = "

  Overview: This script detects the installed version of Apache Roller
  and saves the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of Apache Roller in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

rollerPort = get_http_port(default:8080);
if(!rollerPort){
  rollerPort = 8080;
}

if(!get_port_state(rollerPort)){
  exit(0);
}

sndReq = http_get(item:string("/roller/index.jsp \r\n"), port:rollerPort);
rcvRes = http_keepalive_send_recv(port:rollerPort, data:sndReq);
if("Welcome to Roller" >< rcvRes)
{
  rollerVer = eregmatch(pattern:"Version ([0-9.]+)",string:rcvRes);
  if(rollerVer[1] != NULL)
  {
   set_kb_item(name:"www/" + rollerPort + "/ApacheRoller", value:rollerVer[1]);
   security_note(data:"Apache Roller version " + rollerVer[1] + " was detected" + 
                      " on the host");
  }
}
