#
#VID 59e7af2d-8db7-11de-883b-001e3300a30d
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 59e7af2d-8db7-11de-883b-001e3300a30d
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64784);
 script_cve_id("CVE-2009-2694");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: pidgin, libpurple, finch");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   pidgin
   libpurple
   finch

CVE-2009-2694
The msn_slplink_process_msg function in
libpurple/protocols/msn/slplink.c in libpurple, as used in Pidgin
(formerly Gaim) before 2.5.9 and Adium 1.3.5 and earlier, allows
remote attackers to execute arbitrary code or cause a denial of
service (memory corruption and application crash) by sending multiple
crafted SLP (aka MSNSLP) messages to trigger an overwrite of an
arbitrary memory location.  NOTE: this issue reportedly exists because
of an incomplete fix for CVE-2009-1376.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/36384/
http://www.pidgin.im/news/security/?id=34
http://www.vuxml.org/freebsd/59e7af2d-8db7-11de-883b-001e3300a30d.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: pidgin, libpurple, finch");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pidgin");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.9")<0) {
    security_note(0, data:"Package pidgin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"libpurple");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.9")<0) {
    security_note(0, data:"Package libpurple version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"finch");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.9")<0) {
    security_note(0, data:"Package finch version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
