# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8477 (puppet)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64857);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-8477 (puppet)");

 desc = "The remote host is missing an update to puppet
announced via advisory FEDORA-2009-8477.

Update Information:

This update fixes a number of bugs in both the packaging and upstream source.
See the package changelog and bug reports for complete details.

References:

[ 1 ] Bug #475201 - puppetmasterd does not initialize supplementary groups
https://bugzilla.redhat.com/show_bug.cgi?id=475201
[ 2 ] Bug #480600 - puppet initscript: condrestart should call status
https://bugzilla.redhat.com/show_bug.cgi?id=480600
[ 3 ] Bug #495096 - puppet SPEC file defines improper modes for some directories
https://bugzilla.redhat.com/show_bug.cgi?id=495096
[ 4 ] Bug #501577 - `/etc/init.d/puppet status` returns errors
https://bugzilla.redhat.com/show_bug.cgi?id=501577
[ 5 ] Bug #515728 - Storeconfigs broken
https://bugzilla.redhat.com/show_bug.cgi?id=515728

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update puppet' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8477

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8477 (puppet)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"puppet", rpm:"puppet~0.24.8~4.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"puppet-server", rpm:"puppet-server~0.24.8~4.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
