# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 687-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53516);
 script_cve_id("CVE-2005-0158");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 687-1 (bidwatcher)";
 script_name(name);

 desc = "The remote host is missing an update to bidwatcher
announced via advisory DSA 687-1.

Ulf Hrnhammar from the Debian Security Audit Project discovered a
format string vulnerability in bidwatcher, a tool for watching and
bidding on eBay auctions.  This problem can be triggered remotely by a
web server of eBay, or someone pretending to be eBay, sending certain
data back.  As of version 1.3.17 the program uses cURL and is not
vulnerable anymore.

For the stable distribution (woody) this problem has been fixed in
version 1.3.3-1woody1.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your bidwatcher package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20687-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 687-1 (bidwatcher)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bidwatcher", ver:"1.3.3-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
