# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 238-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53314);
 script_bugtraq_id(6462);
 script_cve_id("CVE-2002-1393");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 238-1 (kdepim)";
 script_name(name);

 desc = "The remote host is missing an update to kdepim
announced via advisory DSA 238-1.

The KDE team discovered several vulnerabilities in the K Desktop
Environment.  In some instances KDE fails to properly quote parameters
of instructions passed to a command shell for execution.  These
parameters may incorporate data such as URLs, filenames and e-mail
addresses, and this data may be provided remotely to a victim in an
e-mail, a webpage or files on a network filesystem or other untrusted
source.

By carefully crafting such data an attacker might be able to execute
arbitary commands on a vulnerable sytem using the victim's account and
privileges.  The KDE Project is not aware of any existing exploits of
these vulnerabilities.  The patches also provide better safe guards
and check data from untrusted sources more strictly in multiple
places.

For the current stable distribution (woody), these problems have been fixed
in version 2.2.2-5.2.

The old stable distribution (potato) does not contain KDE packages.

For the unstable distribution (sid), these problems will most probably
not be fixed but new packages for KDE 3.1 for sid are expected for
this year.

We recommend that you upgrade your KDE packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20238-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 238-1 (kdepim)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kandy", ver:"2.2.2-5.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdepim-dev", ver:"2.2.2-5.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdepim-libs", ver:"2.2.2-5.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"korganizer", ver:"2.2.2-5.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpilot", ver:"2.2.2-5.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
