# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 208-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53451);
 script_bugtraq_id(6111);
 script_cve_id("CVE-2002-1323");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 208-1 (perl, perl-5.004, perl-5.005)";
 script_name(name);

 desc = "The remote host is missing an update to perl, perl-5.004, perl-5.005
announced via advisory DSA 208-1.

A security hole has been discovered in Safe.pm which is used in all
versions of Perl.  The Safe extension module allows the creation of
compartments in which perl code can be evaluated in a new namespace
and the code evaluated in the compartment cannot refer to variables
outside this namespace.  However, when a Safe compartment has already
been used, there's no guarantee that it is Safe any longer, because
there's a way for code to be executed within the Safe compartment to
alter its operation mask.  Thus, programs that use a Safe compartment
only once aren't affected by this bug.

This problem has been fixed in version 5.6.1-8.2 for the current
stable distribution (woody), in version 5.004.05-6.2 and 5.005.03-7.2
for the old stable distribution (potato) and in version 5.8.0-14 for
the unstable distribution (sid).

We recommend that you upgrade your Perl packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20208-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 208-1 (perl, perl-5.004, perl-5.005)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"perl-5.004-doc", ver:"5.004.05-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.005-doc", ver:"5.005.03-7.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.004", ver:"5.004.05-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.004-base", ver:"5.004.05-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.004-debug", ver:"5.004.05-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.004-suid", ver:"5.004.05-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.005", ver:"5.005.03-7.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.005-base", ver:"5.005.03-7.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.005-debug", ver:"5.005.03-7.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.005-suid", ver:"5.005.03-7.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-5.005-thread", ver:"5.005.03-7.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.6", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.6.1-8.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
