# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1737-1 (wesnoth)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63534);
 script_cve_id("CVE-2009-0366", "CVE-2009-0367");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1737-1 (wesnoth)";
 script_name(name);

 desc = "The remote host is missing an update to wesnoth
announced via advisory DSA 1737-1.

Several security issues have been discovered in wesnoth, a fantasy
turn-based strategy game. The Common Vulnerabilities and Exposures
project identifies the following problems:


CVE-2009-0366

Daniel Franke discovered that the wesnoth server is prone to a denial of
service attack when receiving special crafted compressed data.

CVE-2009-0367

Daniel Franke discovered that the sandbox implementation for the python
AIs can be used to execute arbitrary python code on wesnoth clients. In
order to prevent this issue, the python support has been disabled. A
compatibility patch was included, so that the affected campagne is still
working properly.


For the stable distribution (lenny), these problems have been fixed in
version 1.4.4-2+lenny1.

For the oldstable distribution (etch), these problems have been fixed
in version 1.2-5.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 1.4.7-4.

We recommend that you upgrade your wesnoth packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201737-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1737-1 (wesnoth)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wesnoth-data", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-music", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-tsg", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-trow", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-ttb", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-ei", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-utbs", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-httt", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-server", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-editor", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-aoi", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-sof", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-thot", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-did", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-sotbe", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-l", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-tools", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-all", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-nr", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-dbg", ver:"1.4.4-2+lenny1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
