# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1536-1 (xine-lib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60658);
 script_cve_id("CVE-2007-1246", "CVE-2007-1387", "CVE-2008-0073", "CVE-2008-0486", "CVE-2008-1161");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1536-1 (xine-lib)";
 script_name(name);

 desc = "The remote host is missing an update to xine-lib
announced via advisory DSA 1536-1.

Several local vulnerabilities have been discovered in Xine, a
media player library, allowed for a denial of service or arbitrary code
execution, which could be exploited through viewing malicious content.
The Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2007-1246 / CVE-2007-1387

The DMO_VideoDecoder_Open function does not set the biSize before use in a
memcpy, which allows user-assisted remote attackers to cause a buffer overflow
and possibly execute arbitrary code (applies to sarge only).

CVE-2008-0073

Array index error in the sdpplin_parse function allows remote RTSP servers
to execute arbitrary code via a large streamid SDP parameter.

CVE-2008-0486

Array index vulnerability in libmpdemux/demux_audio.c might allow remote
attackers to execute arbitrary code via a crafted FLAC tag, which triggers
a buffer overflow (applies to etch only).

CVE-2008-1161

Buffer overflow in the Matroska demuxer allows remote attackers to cause a
denial of service (crash) and possibly execute arbitrary code via a Matroska
file with invalid frame sizes.


For the stable distribution (etch), these problems have been fixed in version
1.1.2+dfsg-6.

For the old stable distribution (sarge), these problems have been fixed in
version 1.0.1-1sarge7.

For the unstable distribution (sid), these problems have been fixed in
version 1.1.11-1.


We recommend that you upgrade your xine-lib package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201536-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1536-1 (xine-lib)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxine-dev", ver:"1.0.1-1sarge7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1", ver:"1.0.1-1sarge7", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.2+dfsg-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1", ver:"1.1.2+dfsg-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.2+dfsg-6", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
