# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#
# References:
# From: "Michal Zalewski" <lcamtuf@echelon.pl>
# To: bugtraq@securityfocus.com
# CC: sendmail-security@sendmail.org
# Subject: RAZOR advisory: multiple Sendmail vulnerabilities

if(description)
{
 script_id(11086);
 script_bugtraq_id(3377);
 script_cve_id("CVE-2001-0713");
 script_version ("$Revision: 8289 $");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "Sendmail custom configuration file";
 script_name(name);
 
 desc = "
The remote sendmail server, according to its version number,
may be vulnerable to a 'Mail System Compromise' when a
user supplies a custom configuration file.
Although the mail server is suppose to run as a lambda user, 
a programming error allows the local attacker to regain the extra 
dropped privileges and run commands as root.

Solution : upgrade to the latest version of Sendmail
Risk factor : High
Note : This vulnerability is _local_ only"; 



 script_description(desc);
		    
 
 summary = "Checks the version number for 'custom config file'"; 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 
 family = "SMTP problems";
 script_family(family);
 script_dependencie("find_service.nes","smtpserver_detect.nasl");
 script_require_keys("SMTP/sendmail");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port) port = 25;

banner = get_smtp_banner(port: port);
if(! banner || "Switch-" >< banner ) exit(0);

if(egrep(pattern:".*Sendmail.*8\.12\.0.*", string:banner))
 	security_hole(port);
