###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_projectbutler_file_inc_vuln.nasl 4059 2009-08-28 14:11:29Z aug $
#
# ProjectButler PHP Remote File Inclusion Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Updated By : Antu Sanadi <santu@secpod.com> on 2010-03-25
#  - Updated check for login.php to confirm the product installation.
#  - Modified the substring check for exploit.
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900928);
  script_version("$Revision$: 1.1");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2791");
  script_bugtraq_id(35919);
  script_name("ProjectButler PHP Remote File Inclusion Vulnerability");
  desc = "
  Overview: This host is installed with ProjectButler and is prone to PHP
  Remote File Inclusion vulnerability.

  Vulnerability Insight:
  The input passed into the 'pda_projects.php' script is not sufficiently
  sanitized before being returned to the user.

  Impact:
  Attacker can exploit this issue to execute remote PHP code by passing the
  mailicious URL into the 'offset' parameter.

  Impact Level: Application

  Affected Software/OS:
  ProjectButler version 1.5.0 and prior.

  Fix:
  No solution or patch is available as on 28th Agusut, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://projectbutler.sourceforge.net/

  References:
  http://www.milw0rm.com/exploits/9331
  http://heapoverflow.com/f0rums/sitemap/t-17452.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check through attack string on ProjectButler");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

pbPort = get_http_port(default:80);
if(!pbPort){
  pbPort = 80;
}

if(!get_port_state(pbPort)){
  exit(0);
}

if(safe_checks()){
 exit(0);
}

foreach dir (make_list("/", "/ProjectButler", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/login.php"), port:pbPort);
  rcvRes = http_send_recv(port:pbPort, data:sndReq);
  if(">ProjectButler<" >< rcvRes)
  {
    sndReq = http_get(item:string(dir, "/pda/pda_projects.php?offset=ATTACK-STRING"),
                                  port:pbPort);
    rcvRes = http_send_recv(port:pbPort, data:sndReq);
    if(("ATTACK-STRING ">< rcvRes) && ("200 OK" >< rcvRes))
    {
      security_hole(pbPort);
      exit(0);
    }
  }
}
