###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-029.nasl 3498 2009-07-15 09:14:35Z jul $
#
# Microsoft Embedded OpenType Font Engine Remote Code Execution Vulnerabilities (961371)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900689);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0231", "CVE-2009-0232");
  script_bugtraq_id(35186, 35187);
  script_name("Microsoft Embedded OpenType Font Engine Remote Code Execution Vulnerabilities (961371))");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-029.

  Vulnerability Insight:
  - A boundary error exists when parsing data records in embedded fonts can be
    exploited to cause a heap-based buffer overflow via a specially crafted
    embedded EOT font.
  - An integer overflow error exists when parsing name tables in embedded fonts
    can be exploited to corrupt memory via a specially crafted embedded EOT
    font.

  Impact:
  Successful exploitation could allow remote attackers to disclose sensitive
  information or compromise a vulnerable system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2000 Service Pack 4 and prior
  Microsoft Windows XP Service Pack 3 and prior
  Microsoft Windows 2003 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-029.mspx

  References:
  http://secunia.com/advisories/35773
  http://www.vupen.com/english/advisories/2009/1887
  http://www.microsoft.com/technet/security/bulletin/ms09-029.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for MS09-029 Hotfix Missing 961371
if(hotfix_missing(name:"961371") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Fontsub.dll");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Fontsub.dll version < 5.0.2195.7263
  if(version_is_less(version:sysVer, test_version:"5.0.2195.7263")){
    security_hole(0);
  }
}
# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Fontsub.dll < 5.1.2600.3589
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3589")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Fontsub.dll < 5.1.2600.5830
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5830")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Fontsub.dll version < 5.2.3790.4530
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4530")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
