###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-001_remote.nasl 846 2010-02-10 10:10:09Z feb $
#
# Vulnerabilities in SMB Could Allow Remote Code Execution (958687) - Remote
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900233);
  script_version("$Revision: 7619 $: 1.0");
  script_tag(name:"cvss_base", value:"7.1");
  script_tag(name:"risk_factor", value:"High");
  script_bugtraq_id(31179);
  script_cve_id("CVE-2008-4114", "CVE-2008-4834", "CVE-2008-4835");
  script_name("Vulnerabilities in SMB Could Allow Remote Code Execution (958687) - Remote");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-001.

  Vulnerability Insight:
  The issue is due to the way Server Message Block (SMB) Protocol software
  handles specially crafted SMB packets.

  Impact: Successful exploitation could allow remote unauthenticated attackers
  to cause denying the service by sending a specially crafted network message
  to a system running the server service.

  Impact Level: System/Network

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-001.mspx

  References:
  http://www.milw0rm.com/exploits/6463
  http://www.microsoft.com/technet/security/bulletin/ms09-001.mspx

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 5.6
  Risk factor : High";

  script_description(desc);
  script_summary("Check for Response for Specially Request Packet");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

name = kb_smb_name();
domain = kb_smb_domain();
port = kb_smb_transport();

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

login = "";
pass = "";

r = smb_session_request(soc:soc, remote:name);
if(!r) { close(soc); exit(0); }

prot = smb_neg_prot(soc:soc);
if(!prot){ close(soc); exit(0); }

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r)
{
  close(soc);
  report = string("MS09-001: Failed to perform anonymous authentication.");
  log_message(data:report, port:port);
  exit(0);
}

uid = session_extract_uid(reply:r);
if(!uid)
{
  close(soc);
  exit(0);
}

r = smb_tconx(soc:soc, uid:uid, share:"IPC$", name:name);
if(!r)
{
  close(soc);
  exit(0);
}

tid = tconx_extract_tid(reply:r);
if(!tid)
{
  close(soc);
  exit(0);
}

## Get Tree ID and Process ID from the response packet
tid_high = tid / 256;
tid_low  = tid % 256;
uid_high = uid / 256;
uid_low  = uid % 256;

## Construct Specially Crafted "\browser" Request
req = raw_string(0xff, 0x53, 0x4d, 0x42, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x08,
                 0x01, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x00, 0x00, 0x00, 0x00, tid_low, tid_high, 0xa2, 0x4d,
                 uid_low, uid_high, 0x0b, 0x00, 0x18, 0xff, 0x00, 0x00,
                 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x00, 0x00, 0x9f, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
                 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x02, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x5c, 0x00,
                 0x62, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x73, 0x00,
                 0x65, 0x00, 0x72, 0x00, 0x00, 0x00 );

req = raw_string(0x00, 0x00, 0x00, (strlen(req)%256)) + req;
send(socket:soc, data:req);
resp = smb_recv(socket:soc, length:4096);
if(strlen(resp) < 107)
{
  close(soc);
  exit(0);
}

## Get FID from the response packet
fid_low = ord(resp[42]);
fid_high = ord(resp[43]);

## Construct Write AndX Request
req = raw_string(0xff, 0x53, 0x4d, 0x42, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x18,
                 0x03, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x00, 0x00, 0x00, 0x00, tid_low, tid_high, 0xdc, 0x54,
                 uid_low, uid_high, 0x40, 0x01,
                 0x0e, 0xff, 0x00, 0x00, 0x00, fid_low,
                 fid_high, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
                 0xff, 0x08, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48,
                 0x00, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49,
                 0x00, 0x00, 0x05, 0x00, 0x0b, 0x03, 0x10, 0x00,
                 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x00, 0x00, 0xb8, 0x10, 0xb8, 0x10, 0x00, 0x00,
                 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
                 0x01, 0x00, 0xc8, 0x4f, 0x32, 0x4b, 0x70, 0x16,
                 0xd3, 0x01, 0x12, 0x78, 0x5a, 0x47, 0xbf, 0x6e,
                 0xe1, 0x88, 0x03, 0x00, 0x00, 0x00, 0x04, 0x5d,
                 0x88, 0x8a, 0xeb, 0x1c, 0xc9, 0x11, 0x9f, 0xe8,
                 0x08, 0x00, 0x2b, 0x10, 0x48, 0x60, 0x02, 0x00,
                 0x00, 0x00 );

req = raw_string(0x00, 0x00, 0x00, (strlen(req)%256)) + req;
send(socket:soc, data:req);
resp = smb_recv(socket:soc, length:4096);
close(soc);

## Check the response and decide OS is vulnerable
if(resp && ord(resp[8]) == 47 && ord(resp[9]) == 0 && ord(resp[10]) == 0
        && ord(resp[11]) == 0 && ord(resp[12]) == 0){
  security_hole(port);
}
